/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.browserlike;

import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u000eH\u0002J\r\u0010\u0010\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0011J\r\u0010\u0012\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0011J\r\u0010\u0013\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0011J\r\u0010\u0014\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0011J\r\u0010\u0015\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0018J\u0006\u0010\u0019\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0003R\u000e\u0010\t\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/conduktor/browserlike/History;", "A", "", "()V", "currentPosition", "", "history", "Ljava/util/LinkedList;", "getHistory$annotations", "max", "canMoveBackward", "", "canMoveForward", "clear", "", "clearFuture", "moveBackward", "()Ljava/lang/Object;", "moveForward", "peek", "pop", "popAndClear", "push", "e", "(Ljava/lang/Object;)V", "size", "desktop"})
public final class History<A> {
    @NotNull
    private final LinkedList<A> history = new LinkedList();
    private final int max;
    private int currentPosition = -1;

    public History() {
        this.max = 30;
    }

    private static /* synthetic */ void getHistory$annotations() {
    }

    public final boolean canMoveBackward() {
        return this.currentPosition > 0;
    }

    public final boolean canMoveForward() {
        return this.currentPosition >= 0 && this.currentPosition < CollectionsKt.getLastIndex((List)this.history);
    }

    public final void push(A e) {
        this.clearFuture();
        this.history.add(e);
        if (this.history.size() > this.max) {
            this.history.remove(0);
        } else {
            ++this.currentPosition;
        }
    }

    private final void clearFuture() {
        while (CollectionsKt.getLastIndex((List)this.history) > this.currentPosition) {
            this.history.removeLast();
        }
    }

    @Nullable
    public final A pop() {
        return this.moveBackward();
    }

    @Nullable
    public final A popAndClear() {
        A e = this.pop();
        this.clearFuture();
        return e;
    }

    @Nullable
    public final A peek() {
        return this.currentPosition >= 0 ? (A)this.history.get(this.currentPosition) : null;
    }

    public final int size() {
        return this.history.size();
    }

    @Nullable
    public final A moveBackward() {
        A a;
        if (this.currentPosition > 0) {
            --this.currentPosition;
            a = this.history.get(this.currentPosition);
        } else {
            a = null;
        }
        return a;
    }

    @Nullable
    public final A moveForward() {
        A a;
        if (this.currentPosition >= 0 && this.currentPosition < this.history.size()) {
            ++this.currentPosition;
            a = this.history.get(this.currentPosition);
        } else {
            a = null;
        }
        return a;
    }

    public final void clear() {
        this.currentPosition = -1;
        this.history.clear();
    }
}

