/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.app;

import io.conduktor.ExtensionsKt;
import io.conduktor.analytics.tracking.AnalyticsTracker;
import io.conduktor.analytics.tracking.ConsoleTracker;
import io.conduktor.analytics.tracking.MultiTrackerSafe;
import io.conduktor.analytics.tracking.NoopTracker;
import io.conduktor.analytics.tracking.SegmentTracker;
import io.conduktor.analytics.tracking.SentryTracker;
import io.conduktor.auth.ConduktorAuth;
import io.conduktor.config.ConfigurationExtension;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tornadofx.ConfigProperties;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0015\u001a\u00020\fH\u0002J\b\u0010\u0016\u001a\u00020\fH\u0002J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0018J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\fH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lio/conduktor/app/ConduktorTracking;", "", "config", "Ltornadofx/ConfigProperties;", "auth", "Lio/conduktor/auth/ConduktorAuth;", "(Ltornadofx/ConfigProperties;Lio/conduktor/auth/ConduktorAuth;)V", "getAuth", "()Lio/conduktor/auth/ConduktorAuth;", "getConfig", "()Ltornadofx/ConfigProperties;", "deviceId", "", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "<set-?>", "Lio/conduktor/analytics/tracking/AnalyticsTracker;", "tracker", "getTracker", "()Lio/conduktor/analytics/tracking/AnalyticsTracker;", "generateRandomDeviceId", "recoverOrCreateDeviceId", "startAnonymizeAnalytics", "", "stop", "updateDeviceId", "did", "Companion", "desktop"})
public final class ConduktorTracking {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConfigProperties config;
    @NotNull
    private final ConduktorAuth auth;
    private final Logger logger;
    @NotNull
    private AnalyticsTracker tracker;
    @NotNull
    private final String deviceId;
    @NotNull
    private static final String DEVICE_ID_CONFIG_KEY = "did";

    public ConduktorTracking(@NotNull ConfigProperties config, @NotNull ConduktorAuth auth2) {
        this.config = config;
        this.auth = auth2;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.tracker = new NoopTracker();
        this.deviceId = this.recoverOrCreateDeviceId();
    }

    @NotNull
    public final ConfigProperties getConfig() {
        return this.config;
    }

    @NotNull
    public final ConduktorAuth getAuth() {
        return this.auth;
    }

    @NotNull
    public final AnalyticsTracker getTracker() {
        return this.tracker;
    }

    public final void stop() {
        this.tracker.stop();
    }

    public final void startAnonymizeAnalytics() {
        AnalyticsTracker analyticsTracker;
        this.stop();
        if (ExtensionsKt.isDev()) {
            if (ExtensionsKt.isAnalyticsDevMode()) {
                AnalyticsTracker[] analyticsTrackerArray = new AnalyticsTracker[]{new ConsoleTracker(), new SegmentTracker(this.deviceId, this.auth)};
                analyticsTracker = new MultiTrackerSafe(analyticsTrackerArray);
            } else {
                analyticsTracker = new ConsoleTracker();
            }
        } else {
            AnalyticsTracker[] analyticsTrackerArray = new AnalyticsTracker[]{new SentryTracker(), new SegmentTracker(this.deviceId, this.auth)};
            analyticsTracker = new MultiTrackerSafe(analyticsTrackerArray);
        }
        this.tracker = analyticsTracker;
        this.tracker.start();
    }

    private final String recoverOrCreateDeviceId() {
        CharSequence charSequence;
        String currentDeviceId = this.config.string(DEVICE_ID_CONFIG_KEY);
        this.logger.debug("Current DeviceId: " + currentDeviceId);
        CharSequence charSequence2 = currentDeviceId;
        if (!(charSequence2 == null || charSequence2.length() == 0)) {
            charSequence = currentDeviceId;
        } else {
            CharSequence it = charSequence2 = this.generateRandomDeviceId();
            boolean bl = false;
            this.updateDeviceId((String)it);
            charSequence = charSequence2;
        }
        return charSequence;
    }

    private final void updateDeviceId(String did) {
        this.config.set(DEVICE_ID_CONFIG_KEY, did);
        ConfigurationExtension.INSTANCE.atomicSave(this.config);
    }

    private final String generateRandomDeviceId() {
        return StringsKt.replace$default((String)UUID.randomUUID().toString(), (String)"-", (String)"", (boolean)false, (int)4, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/conduktor/app/ConduktorTracking$Companion;", "", "()V", "DEVICE_ID_CONFIG_KEY", "", "desktop"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

