/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.app;

import arrow.core.Either;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import com.github.kittinunf.fuel.core.FuelManager;
import com.typesafe.config.Config;
import io.conduktor.ExtensionsKt;
import io.conduktor.analytics.functional.ConduktorAnalytics;
import io.conduktor.analytics.tracking.AnalyticsTracker;
import io.conduktor.app.Conduktor;
import io.conduktor.app.ConduktorTracking;
import io.conduktor.app.ConduktorUI;
import io.conduktor.app.SupportService;
import io.conduktor.auth.AuthConfiguration;
import io.conduktor.auth.ConduktorAuth;
import io.conduktor.browserlike.HistoryFX;
import io.conduktor.common.scala.jumpstart.JumpstartJapi;
import io.conduktor.config.AppVersion;
import io.conduktor.controllers.ManagedClusterController;
import io.conduktor.controllers.NetworkOptions;
import io.conduktor.controllers.NetworkOptionsJson;
import io.conduktor.http.PlatformApi;
import io.conduktor.kjavafx.kDialogs;
import io.conduktor.logging.LoggerStartupListener;
import io.conduktor.plugins.ConduktorPluginsService;
import io.conduktor.security.CertificateConfig;
import io.conduktor.security.CertificateManager;
import io.conduktor.security.CertificateManagerLoader;
import io.conduktor.security.Proxy;
import io.conduktor.security.ProxyJson;
import io.conduktor.security.ProxySetup;
import io.conduktor.styles.ConduktorStyles;
import io.conduktor.upgrade.ConduktorUpgrade;
import io.conduktor.upgrade.ConduktorUpgradeDialogConfig;
import io.conduktor.utils.OS;
import io.conduktor.views.welcome.WelcomeScreenView;
import java.net.http.HttpClient;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javafx.application.Platform;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.stage.Stage;
import javax.json.JsonObject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import net.harawata.appdirs.AppDirsFactory;
import nl.altindag.ssl.SSLFactory;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;
import tornadofx.App;
import tornadofx.AsyncKt;
import tornadofx.ConfigProperties;
import tornadofx.FX;
import tornadofx.FXKt;
import tornadofx.JsonModel;
import tornadofx.LibKt;
import tornadofx.Scope;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 +2\u00020\u0001:\u0001+B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000b0\u000fH\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0012H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u0018\u001a\u00020\u00172\b\u0010\u0015\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u0010H\u0002J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u0010H\u0002J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0004H\u0002J\b\u0010 \u001a\u00020\u0017H\u0002J\b\u0010!\u001a\u00020\u0017H\u0002J\b\u0010\"\u001a\u00020\u0017H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u0017H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lio/conduktor/app/Conduktor;", "Ltornadofx/App;", "()V", "configBasePath", "Ljava/nio/file/Path;", "getConfigBasePath", "()Ljava/nio/file/Path;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "areFirstOrSecondStacktraces", "", "ex", "", "match", "Lkotlin/Function1;", "Ljava/lang/StackTraceElement;", "buildConduktorHttpClientSslFactory", "Lnl/altindag/ssl/SSLFactory;", "buildSharedHttpClient", "Ljava/net/http/HttpClient;", "sslFactory", "checkNativeJfxLibs", "", "fuelHttpClientOverrideSsl", "isJavaFx", "it", "isJavaFxCrap", "isTornadoFx", "isTornadoFxCrap", "loadConduktorTruststore", "truststorePath", "loadCustomJavaSystemProps", "loadProxy", "logConfig", "parseAuthConfig", "Lio/conduktor/auth/AuthConfiguration;", "config", "Lcom/typesafe/config/Config;", "start", "stage", "Ljavafx/stage/Stage;", "stop", "Companion", "desktop"})
public final class Conduktor
extends App {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private org.slf4j.Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @NotNull
    private final Path configBasePath = !ExtensionsKt.isDev() ? Paths.get(AppDirsFactory.getInstance().getUserConfigDir("conduktor", "v1", "conduktor"), new String[0]) : (System.getenv("CONDUKTOR_DEV_NEW_CONFIG") != null ? Files.createTempDirectory("conduktor", new FileAttribute[0]) : Paths.get("conf", new String[0]));
    public static Conduktor conduktor;
    public static ConduktorAuth auth;
    public static PlatformApi platformApi;
    public static ConduktorTracking tracking;
    public static ConduktorAnalytics analytics;
    public static ConduktorUI ui;
    public static SupportService support;
    public static ConduktorUpgradeDialogConfig upgradeConfig;
    public static ConduktorPluginsService pluginsService;
    @NotNull
    private static final HistoryFX history;
    @Nullable
    private static CertificateManager certificateManager;
    public static HttpClient sharedHttpClient;
    @Nullable
    private static Proxy proxy;
    @NotNull
    private static final SimpleBooleanProperty debugEnabled;
    @NotNull
    private static final String kafkaLogPath;
    @NotNull
    private static final String version;
    @NotNull
    private static final Path conduktorTruststorePath;
    @NotNull
    private static final Path conduktorCustomJavaPropsPath;
    @NotNull
    private static final Path certificateBasePath;

    public Conduktor() {
        super(Reflection.getOrCreateKotlinClass(WelcomeScreenView.class), Reflection.getOrCreateKotlinClass(ConduktorStyles.class), null, 4, null);
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        this.logConfig();
        this.loadProxy();
        this.loadCustomJavaSystemProps();
        this.loadConduktorTruststore(conduktorTruststorePath);
        this.checkNativeJfxLibs();
        Companion.setConduktor(this);
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Companion.setPluginsService(ConduktorPluginsService.Companion.new());
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        Config appConfig = ExtensionsKt.applicationConfig();
        AuthConfiguration authConfig = this.parseAuthConfig(appConfig.getConfig("auth0"));
        SSLFactory sslFactory = this.buildConduktorHttpClientSslFactory();
        Companion.setSharedHttpClient(this.buildSharedHttpClient(sslFactory));
        JumpstartJapi.init((HttpClient)Companion.getSharedHttpClient());
        this.fuelHttpClientOverrideSsl(sslFactory);
        Companion.setAnalytics(new ConduktorAnalytics());
        Companion.setAuth(new ConduktorAuth(authConfig, this.getConfig()));
        Companion.setTracking(new ConduktorTracking(this.getConfig(), Companion.getAuth()));
        Companion.getTracking().startAnonymizeAnalytics();
        Companion.setPlatformApi(new PlatformApi(authConfig));
        Companion.setUi(new ConduktorUI(this.getConfig()));
        Companion.setSupport(new SupportService());
        Companion.setUpgradeConfig(ConduktorUpgradeDialogConfig.Companion.fromProperties(appConfig.getConfig("release")));
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = ConduktorUpgrade.INSTANCE.startCheckLoop((Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        if (ExtensionsKt.isDev()) {
            Thread.setDefaultUncaughtExceptionHandler((arg_0, arg_1) -> Conduktor._init_$lambda-0(this, arg_0, arg_1));
        } else {
            Thread.setDefaultUncaughtExceptionHandler((arg_0, arg_1) -> Conduktor._init_$lambda-1(this, arg_0, arg_1));
        }
    }

    @NotNull
    public Path getConfigBasePath() {
        return this.configBasePath;
    }

    private final void checkNativeJfxLibs() {
        if (ExtensionsKt.isDev() && OS.INSTANCE.isLinux()) {
            String javaHome = System.getProperty("java.home");
            String[] stringArray = new String[]{"lib/amd64"};
            Path javaLibs = Paths.get(javaHome, stringArray);
            Path jfxwebkit = javaLibs.resolve("libjfxwebkit.so");
            try {
                if (!Files.exists(jfxwebkit, new LinkOption[0])) {
                    this.logger.debug(jfxwebkit + " does not exist, importing it...");
                }
            }
            catch (Exception e) {
                this.logger.warn("Error checking for native jfx libs presence", (Throwable)e);
            }
        }
    }

    private final SSLFactory buildConduktorHttpClientSslFactory() {
        SSLFactory sSLFactory;
        Either result2;
        CertificateManager certificateManager = Conduktor.certificateManager;
        Either either2 = result2 = certificateManager != null ? CertificateManager.buildSSLFactory$default((CertificateManager)certificateManager, null, null, null, null, (int)15, null) : null;
        if (result2 instanceof Either.Left) {
            this.logger.warn("Error loading Conduktor SSL factory from Network settings: " + ((Throwable)((Either.Left)result2).getValue()).getMessage());
            sSLFactory = null;
        } else if (result2 instanceof Either.Right) {
            sSLFactory = (SSLFactory)((Either.Right)result2).getValue();
        } else if (result2 == null) {
            sSLFactory = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return sSLFactory;
    }

    private final void fuelHttpClientOverrideSsl(SSLFactory sslFactory) {
        if (sslFactory != null) {
            FuelManager.Companion.getInstance().setHostnameVerifier(sslFactory.getHostnameVerifier());
            FuelManager.Companion.getInstance().setSocketFactory(sslFactory.getSslSocketFactory());
        }
    }

    private final HttpClient buildSharedHttpClient(SSLFactory sslFactory) {
        HttpClient.Builder builder;
        HttpClient.Builder builder2 = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS);
        long l = DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS);
        int n = Duration.getNanosecondsComponent-impl((long)l);
        long l2 = Duration.getInWholeSeconds-impl((long)l);
        java.time.Duration duration = java.time.Duration.ofSeconds(l2, n);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"toJavaDuration-LRDsOJo");
        HttpClient.Builder it = builder = builder2.connectTimeout(duration);
        boolean bl = false;
        if (sslFactory != null) {
            it.sslParameters(sslFactory.getSslParameters()).sslContext(sslFactory.getSslContext());
        }
        return builder.build();
    }

    private final AuthConfiguration parseAuthConfig(Config config) {
        return new AuthConfiguration(config.getString("domain"), config.getString("client-id"), config.getString("redirect-url"), config.getString("allowed-logout-url"), config.getString("on-success-url"), config.getString("on-failure-url"));
    }

    public void start(@NotNull Stage stage2) {
        System.setProperty("glass.accessible.force", "false");
        ((Collection)stage2.getIcons()).add(this.getResources().image("/conduktor-icon.png"));
        super.start(stage2);
    }

    private final void logConfig() {
        this.logger.info("Welcome to Conduktor v" + version);
        this.logger.info("System: " + System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") " + System.getProperty("java.vendor") + " " + System.getProperty("java.version"));
        this.logger.info("Timezone: " + ZoneId.systemDefault());
        this.logger.info("Config: " + this.getConfigPath().toAbsolutePath());
        this.logger.info("Kafka Logs: " + kafkaLogPath);
    }

    /*
     * WARNING - void declaration
     */
    private final void loadCustomJavaSystemProps() {
        try {
            if (Files.exists(conduktorCustomJavaPropsPath, new LinkOption[0])) {
                void $this$mapTo$iv$iv;
                String it;
                Iterable $this$filterTo$iv$iv;
                this.logger.info("Found Custom JVM Properties: " + conduktorCustomJavaPropsPath);
                Iterable $this$filter$iv = Files.readAllLines(conduktorCustomJavaPropsPath);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (String)element$iv$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)it, (String)"-D", (boolean)false, (int)2, null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it.substring(2);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                    collection.add(string);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it2 = (String)element$iv;
                    boolean bl = false;
                    String[] stringArray = new String[]{"="};
                    List x2 = StringsKt.split$default((CharSequence)it2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    if (x2.size() > 1) {
                        System.setProperty((String)CollectionsKt.first((List)x2), (String)x2.get(1));
                        continue;
                    }
                    System.setProperty((String)CollectionsKt.first((List)x2), "");
                }
            } else {
                this.logger.info("No Custom JVM Properties found: " + conduktorCustomJavaPropsPath);
            }
        }
        catch (Exception e) {
            this.logger.warn("Error reading " + conduktorCustomJavaPropsPath + " (" + e.getMessage() + "), ignoring...");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void loadProxy() {
        ProxyJson config;
        JsonModel jsonModel2;
        void this_$iv;
        ConfigProperties configProperties = this.getConfig();
        String key$iv = "proxy";
        boolean $i$f$jsonModel = false;
        JsonObject jsonObject = this_$iv.jsonObject(key$iv);
        if (jsonObject != null) {
            JsonObject $this$toModel$iv$iv = jsonObject;
            boolean $i$f$toModel = false;
            JsonModel model$iv$iv = (JsonModel)ProxyJson.class.newInstance();
            model$iv$iv.updateModel($this$toModel$iv$iv);
            JsonModel jsonModel3 = model$iv$iv;
            jsonModel2 = jsonModel3;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonModel3, (String)"model");
        } else {
            jsonModel2 = null;
        }
        ProxyJson proxyJson = config = (ProxyJson)jsonModel2;
        if (proxyJson != null) {
            ProxyJson it = proxyJson;
            boolean bl = false;
            proxy = it.raw();
        }
        ProxyJson proxyJson2 = config;
        ProxySetup.INSTANCE.setupProxy((Proxy)(proxyJson2 != null ? proxyJson2.raw() : null));
    }

    /*
     * WARNING - void declaration
     */
    private final void loadConduktorTruststore(Path truststorePath) {
        Object certificateConfig;
        Either cm;
        Object object;
        JsonModel jsonModel2;
        void this_$iv;
        ConfigProperties configProperties = this.getConfig();
        String key$iv = "networkOptions";
        boolean $i$f$jsonModel = false;
        JsonObject jsonObject = this_$iv.jsonObject(key$iv);
        if (jsonObject != null) {
            JsonObject $this$toModel$iv$iv = jsonObject;
            boolean $i$f$toModel = false;
            JsonModel model$iv$iv = (JsonModel)NetworkOptionsJson.class.newInstance();
            model$iv$iv.updateModel($this$toModel$iv$iv);
            JsonModel jsonModel3 = model$iv$iv;
            jsonModel2 = jsonModel3;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonModel3, (String)"model");
        } else {
            jsonModel2 = null;
        }
        if ((object = (NetworkOptionsJson)jsonModel2) == null || (object = ((NetworkOptionsJson)object).raw()) == null || (object = ((NetworkOptions)object).getCertificateConfig()) == null) {
            object = new CertificateConfig(false, 1, null);
        }
        if ((cm = CertificateManagerLoader.INSTANCE.load(truststorePath, (CertificateConfig)(certificateConfig = object))) instanceof Either.Left) {
            this.logger.warn("Error loading Conduktor truststore: " + ((Throwable)((Either.Left)cm).getValue()).getMessage());
        } else if (cm instanceof Either.Right) {
            certificateManager = (CertificateManager)((Either.Right)cm).getValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public void stop() {
        Companion.getTracking().stop();
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Object>, Object>(null){
            int label;
            private /* synthetic */ Object L$0;

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$runBlocking = (CoroutineScope)this.L$0;
                        BuildersKt.launch$default((CoroutineScope)$this$runBlocking, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($this$runBlocking, null){
                            int label;
                            final /* synthetic */ CoroutineScope $$this$runBlocking;
                            {
                                this.$$this$runBlocking = $$this$runBlocking;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Unable to fully structure code
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        scope$iv = FX.Companion.getDefaultScope();
                                        params$iv = null;
                                        $i$f$find = false;
                                        this.label = 1;
                                        v0 = ((ManagedClusterController)FXKt.find((KClass)Reflection.getOrCreateKotlinClass(ManagedClusterController.class), (Scope)scope$iv, (Map)params$iv)).shutdown((Continuation<? super Unit>)((Continuation)this));
                                        ** if (v0 != var5_2) goto lbl15
lbl14:
                                        // 1 sources

                                        return var5_2;
lbl15:
                                        // 1 sources

                                        ** GOTO lbl25
                                    }
                                    case 1: {
                                        try {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
                                        }
                                        catch (Throwable var2_4) {
                                            AsyncKt.runLater((Function0)((Function0)new Function0<Unit>(this.$$this$runBlocking){
                                                final /* synthetic */ CoroutineScope $$this$runBlocking;
                                                {
                                                    this.$$this$runBlocking = $$this$runBlocking;
                                                    super(0);
                                                }

                                                public final void invoke() {
                                                    Platform.exitNestedEventLoop((Object)this.$$this$runBlocking, null);
                                                }
                                            }));
                                            throw var2_4;
                                        }
lbl25:
                                        // 2 sources

                                        AsyncKt.runLater((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                        return Platform.enterNestedEventLoop((Object)$this$runBlocking);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<Object> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        AsyncKt.runLater((Function0)stop.2.INSTANCE);
    }

    private final boolean areFirstOrSecondStacktraces(Throwable ex, Function1<? super StackTraceElement, Boolean> match) {
        StackTraceElement first = (StackTraceElement)ArraysKt.firstOrNull((Object[])ex.getStackTrace());
        StackTraceElement second = (StackTraceElement)ArraysKt.getOrNull((Object[])ex.getStackTrace(), (int)1);
        return first != null && (Boolean)match.invoke((Object)first) != false ? true : second != null && (Boolean)match.invoke((Object)second) != false;
    }

    private final boolean isJavaFxCrap(Throwable ex) {
        return this.areFirstOrSecondStacktraces(ex, (Function1<? super StackTraceElement, Boolean>)((Function1)new Function1<StackTraceElement, Boolean>(this){
            final /* synthetic */ Conduktor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull StackTraceElement it) {
                return Conduktor.access$isJavaFx(this.this$0, it);
            }
        }));
    }

    private final boolean isTornadoFxCrap(Throwable ex) {
        return this.areFirstOrSecondStacktraces(ex, (Function1<? super StackTraceElement, Boolean>)((Function1)new Function1<StackTraceElement, Boolean>(this){
            final /* synthetic */ Conduktor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull StackTraceElement it) {
                return Conduktor.access$isTornadoFx(this.this$0, it);
            }
        }));
    }

    private final boolean isJavaFx(StackTraceElement it) {
        String cn = it.getClassName();
        return StringsKt.startsWith$default((String)cn, (String)"org.fxmisc", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)cn, (String)"javafx", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)cn, (String)"com.sun.javafx", (boolean)false, (int)2, null);
    }

    private final boolean isTornadoFx(StackTraceElement it) {
        String cn = it.getClassName();
        return StringsKt.startsWith$default((String)cn, (String)"tornadofx", (boolean)false, (int)2, null);
    }

    private static final void _init_$lambda-0(Conduktor this$0, Thread thread, Throwable ex) {
        this$0.logger.warn("Uncaught error", ex);
        String string = ex.getMessage();
        if (string == null) {
            string = ex.getClass().toString();
        }
        kDialogs.showError$default(kDialogs.INSTANCE, "Uncaught error: " + string, ex, null, null, 12, null);
    }

    private static final void _init_$lambda-1(Conduktor this$0, Thread thread, Throwable ex) {
        if (!this$0.isJavaFxCrap(ex) && !this$0.isTornadoFxCrap(ex)) {
            if (!(ex instanceof NullPointerException || ex instanceof NoSuchElementException || ex instanceof ClassCastException || ex instanceof IndexOutOfBoundsException)) {
                String string = ex.getMessage();
                if (string == null) {
                    string = ex.getClass().toString();
                }
                kDialogs.showError$default(kDialogs.INSTANCE, "Unexpected error: " + string, ex, null, null, 12, null);
            }
            if (!(ex instanceof TimeoutException || ex instanceof ConfigException || ex.getCause() instanceof ConfigException)) {
                Companion.getTracker().error(ex);
                this$0.logger.error("unexpected exception", ex);
            }
        }
    }

    public static final /* synthetic */ boolean access$isJavaFx(Conduktor $this, StackTraceElement it) {
        return $this.isJavaFx(it);
    }

    public static final /* synthetic */ boolean access$isTornadoFx(Conduktor $this, StackTraceElement it) {
        return $this.isTornadoFx(it);
    }

    static {
        history = new HistoryFX();
        debugEnabled = new SimpleBooleanProperty(false);
        kafkaLogPath = LoggerStartupListener.Companion.getKafkaLogPath();
        conduktorTruststorePath = Paths.get(AppDirsFactory.getInstance().getUserConfigDir("conduktor", "cacerts", "conduktor"), new String[0]);
        conduktorCustomJavaPropsPath = Paths.get(AppDirsFactory.getInstance().getUserConfigDir("conduktor", "conduktor.vmoptions", "conduktor"), new String[0]);
        certificateBasePath = Paths.get(AppDirsFactory.getInstance().getUserConfigDir("conduktor", "certificates", "conduktor"), new String[0]);
        version = AppVersion.getBuildVersion((String)"conduktor-version.properties");
        LibKt.onChange((ObservableBooleanValue)((ObservableBooleanValue)debugEnabled), (Function1)Companion.1.INSTANCE);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010c\u001a\u00020d2\u0006\u0010e\u001a\u00020fH\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u001a\u00101\u001a\u000202X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001a\u00107\u001a\u000208X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u001c\u0010=\u001a\u0004\u0018\u00010>X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u001a\u0010C\u001a\u00020DX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010F\"\u0004\bG\u0010HR\u001a\u0010I\u001a\u00020JX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR\u001a\u0010O\u001a\u00020PX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010R\"\u0004\bS\u0010TR\u001a\u0010U\u001a\u00020VX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010X\"\u0004\bY\u0010ZR\u001a\u0010[\u001a\u00020\\X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b]\u0010^\"\u0004\b_\u0010`R\u0011\u0010a\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\bb\u00100\u00a8\u0006g"}, d2={"Lio/conduktor/app/Conduktor$Companion;", "", "()V", "Tracker", "Lio/conduktor/analytics/tracking/AnalyticsTracker;", "getTracker", "()Lio/conduktor/analytics/tracking/AnalyticsTracker;", "analytics", "Lio/conduktor/analytics/functional/ConduktorAnalytics;", "getAnalytics", "()Lio/conduktor/analytics/functional/ConduktorAnalytics;", "setAnalytics", "(Lio/conduktor/analytics/functional/ConduktorAnalytics;)V", "auth", "Lio/conduktor/auth/ConduktorAuth;", "getAuth", "()Lio/conduktor/auth/ConduktorAuth;", "setAuth", "(Lio/conduktor/auth/ConduktorAuth;)V", "certificateBasePath", "Ljava/nio/file/Path;", "getCertificateBasePath", "()Ljava/nio/file/Path;", "certificateManager", "Lio/conduktor/security/CertificateManager;", "getCertificateManager", "()Lio/conduktor/security/CertificateManager;", "setCertificateManager", "(Lio/conduktor/security/CertificateManager;)V", "conduktor", "Lio/conduktor/app/Conduktor;", "getConduktor", "()Lio/conduktor/app/Conduktor;", "setConduktor", "(Lio/conduktor/app/Conduktor;)V", "conduktorCustomJavaPropsPath", "conduktorTruststorePath", "debugEnabled", "Ljavafx/beans/property/SimpleBooleanProperty;", "getDebugEnabled", "()Ljavafx/beans/property/SimpleBooleanProperty;", "history", "Lio/conduktor/browserlike/HistoryFX;", "getHistory", "()Lio/conduktor/browserlike/HistoryFX;", "kafkaLogPath", "", "getKafkaLogPath", "()Ljava/lang/String;", "platformApi", "Lio/conduktor/http/PlatformApi;", "getPlatformApi", "()Lio/conduktor/http/PlatformApi;", "setPlatformApi", "(Lio/conduktor/http/PlatformApi;)V", "pluginsService", "Lio/conduktor/plugins/ConduktorPluginsService;", "getPluginsService", "()Lio/conduktor/plugins/ConduktorPluginsService;", "setPluginsService", "(Lio/conduktor/plugins/ConduktorPluginsService;)V", "proxy", "Lio/conduktor/security/Proxy;", "getProxy", "()Lio/conduktor/security/Proxy;", "setProxy", "(Lio/conduktor/security/Proxy;)V", "sharedHttpClient", "Ljava/net/http/HttpClient;", "getSharedHttpClient", "()Ljava/net/http/HttpClient;", "setSharedHttpClient", "(Ljava/net/http/HttpClient;)V", "support", "Lio/conduktor/app/SupportService;", "getSupport", "()Lio/conduktor/app/SupportService;", "setSupport", "(Lio/conduktor/app/SupportService;)V", "tracking", "Lio/conduktor/app/ConduktorTracking;", "getTracking", "()Lio/conduktor/app/ConduktorTracking;", "setTracking", "(Lio/conduktor/app/ConduktorTracking;)V", "ui", "Lio/conduktor/app/ConduktorUI;", "getUi", "()Lio/conduktor/app/ConduktorUI;", "setUi", "(Lio/conduktor/app/ConduktorUI;)V", "upgradeConfig", "Lio/conduktor/upgrade/ConduktorUpgradeDialogConfig;", "getUpgradeConfig", "()Lio/conduktor/upgrade/ConduktorUpgradeDialogConfig;", "setUpgradeConfig", "(Lio/conduktor/upgrade/ConduktorUpgradeDialogConfig;)V", "version", "getVersion", "toggleDebug", "", "enable", "", "desktop"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Conduktor getConduktor() {
            Conduktor conduktor = Conduktor.conduktor;
            if (conduktor != null) {
                return conduktor;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"conduktor");
            return null;
        }

        public final void setConduktor(@NotNull Conduktor conduktor) {
            Conduktor.conduktor = conduktor;
        }

        @NotNull
        public final ConduktorAuth getAuth() {
            ConduktorAuth conduktorAuth = auth;
            if (conduktorAuth != null) {
                return conduktorAuth;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"auth");
            return null;
        }

        public final void setAuth(@NotNull ConduktorAuth conduktorAuth) {
            auth = conduktorAuth;
        }

        @NotNull
        public final PlatformApi getPlatformApi() {
            PlatformApi platformApi = Conduktor.platformApi;
            if (platformApi != null) {
                return platformApi;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"platformApi");
            return null;
        }

        public final void setPlatformApi(@NotNull PlatformApi platformApi) {
            Conduktor.platformApi = platformApi;
        }

        @NotNull
        public final ConduktorTracking getTracking() {
            ConduktorTracking conduktorTracking = tracking;
            if (conduktorTracking != null) {
                return conduktorTracking;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"tracking");
            return null;
        }

        public final void setTracking(@NotNull ConduktorTracking conduktorTracking) {
            tracking = conduktorTracking;
        }

        @NotNull
        public final ConduktorAnalytics getAnalytics() {
            ConduktorAnalytics conduktorAnalytics = analytics;
            if (conduktorAnalytics != null) {
                return conduktorAnalytics;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"analytics");
            return null;
        }

        public final void setAnalytics(@NotNull ConduktorAnalytics conduktorAnalytics) {
            analytics = conduktorAnalytics;
        }

        @NotNull
        public final ConduktorUI getUi() {
            ConduktorUI conduktorUI = ui;
            if (conduktorUI != null) {
                return conduktorUI;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"ui");
            return null;
        }

        public final void setUi(@NotNull ConduktorUI conduktorUI) {
            ui = conduktorUI;
        }

        @NotNull
        public final SupportService getSupport() {
            SupportService supportService = support;
            if (supportService != null) {
                return supportService;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"support");
            return null;
        }

        public final void setSupport(@NotNull SupportService supportService) {
            support = supportService;
        }

        @NotNull
        public final ConduktorUpgradeDialogConfig getUpgradeConfig() {
            ConduktorUpgradeDialogConfig conduktorUpgradeDialogConfig = upgradeConfig;
            if (conduktorUpgradeDialogConfig != null) {
                return conduktorUpgradeDialogConfig;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"upgradeConfig");
            return null;
        }

        public final void setUpgradeConfig(@NotNull ConduktorUpgradeDialogConfig conduktorUpgradeDialogConfig) {
            upgradeConfig = conduktorUpgradeDialogConfig;
        }

        @NotNull
        public final ConduktorPluginsService getPluginsService() {
            ConduktorPluginsService conduktorPluginsService = pluginsService;
            if (conduktorPluginsService != null) {
                return conduktorPluginsService;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"pluginsService");
            return null;
        }

        public final void setPluginsService(@NotNull ConduktorPluginsService conduktorPluginsService) {
            pluginsService = conduktorPluginsService;
        }

        @NotNull
        public final HistoryFX getHistory() {
            return history;
        }

        @Nullable
        public final CertificateManager getCertificateManager() {
            return certificateManager;
        }

        public final void setCertificateManager(@Nullable CertificateManager certificateManager) {
            Conduktor.certificateManager = certificateManager;
        }

        @NotNull
        public final HttpClient getSharedHttpClient() {
            HttpClient httpClient = sharedHttpClient;
            if (httpClient != null) {
                return httpClient;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"sharedHttpClient");
            return null;
        }

        public final void setSharedHttpClient(@NotNull HttpClient httpClient) {
            sharedHttpClient = httpClient;
        }

        @Nullable
        public final Proxy getProxy() {
            return proxy;
        }

        public final void setProxy(@Nullable Proxy proxy) {
            Conduktor.proxy = proxy;
        }

        @NotNull
        public final SimpleBooleanProperty getDebugEnabled() {
            return debugEnabled;
        }

        @NotNull
        public final AnalyticsTracker getTracker() {
            return this.getTracking().getTracker();
        }

        @NotNull
        public final String getKafkaLogPath() {
            return kafkaLogPath;
        }

        @NotNull
        public final String getVersion() {
            return version;
        }

        @NotNull
        public final Path getCertificateBasePath() {
            return certificateBasePath;
        }

        private final void toggleDebug(boolean enable) {
            try {
                org.slf4j.Logger logger = LoggerFactory.getLogger((String)"root");
                Logger l = logger instanceof Logger ? (Logger)logger : null;
                org.slf4j.Logger logger2 = LoggerFactory.getLogger((String)"org.apache.kafka");
                Logger l2 = logger2 instanceof Logger ? (Logger)logger2 : null;
                Logger logger3 = l;
                if (logger3 != null) {
                    logger3.setLevel(enable ? Level.DEBUG : Level.INFO);
                }
                Logger logger4 = l2;
                if (logger4 != null) {
                    logger4.setLevel(enable ? Level.DEBUG : Level.WARN);
                }
            }
            catch (Exception e) {
                this.getConduktor().logger.warn("Couldn't change log level to " + enable, (Throwable)e);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ void access$toggleDebug(Companion $this, boolean enable) {
            $this.toggleDebug(enable);
        }
    }
}

