/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.monitoring.service.local;

import com.netflix.atlas.core.db.AggregateCollector;
import com.netflix.atlas.core.db.AggregateCollector$;
import com.netflix.atlas.core.db.BlockStore;
import com.netflix.atlas.core.db.BlockStoreItem;
import com.netflix.atlas.core.db.BlockStoreItem$;
import com.netflix.atlas.core.db.Database;
import com.netflix.atlas.core.db.MemoryBlockStore;
import com.netflix.atlas.core.db.TimeSeriesBuffer;
import com.netflix.atlas.core.db.TimeSeriesBuffer$;
import com.netflix.atlas.core.index.BatchUpdateTagIndex;
import com.netflix.atlas.core.index.CachingTagIndex;
import com.netflix.atlas.core.index.IndexStats;
import com.netflix.atlas.core.index.RoaringTagIndex;
import com.netflix.atlas.core.index.TagIndex;
import com.netflix.atlas.core.index.TagQuery;
import com.netflix.atlas.core.index.TagQuery$;
import com.netflix.atlas.core.model.Block;
import com.netflix.atlas.core.model.DataExpr;
import com.netflix.atlas.core.model.DataExpr$;
import com.netflix.atlas.core.model.Datapoint;
import com.netflix.atlas.core.model.EvalContext;
import com.netflix.atlas.core.model.Query$;
import com.netflix.atlas.core.model.TaggedItem;
import com.netflix.atlas.core.model.TimeSeries;
import com.netflix.atlas.core.model.TimeSeries$;
import com.netflix.spectator.api.Registry;
import io.conduktor.monitoring.service.local.LocalDatabase$;
import io.conduktor.monitoring.service.local.LocalDatabase$internal$;
import io.conduktor.monitoring.service.local.LocalDatabases$;
import io.conduktor.monitoring.service.local.MetricsDatabaseConfig;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u001db\u0001\u0002\u00180\u0005iB\u0001b\u0016\u0001\u0003\u0002\u0003\u0006I\u0001\u0017\u0005\tA\u0002\u0011\t\u0011)A\u0005C\")Q\r\u0001C\u0001M\"9!\u000e\u0001b\u0001\n\u0003Y\u0007BB8\u0001A\u0003%A\u000eC\u0004q\u0001\t\u0007I\u0011B6\t\rE\u0004\u0001\u0015!\u0003m\u0011\u001d\u0011\bA1A\u0005\nMDaA\u001f\u0001!\u0002\u0013!\bbB<\u0001\u0005\u0004%\te\u001f\u0005\b\u0003\u000b\u0001\u0001\u0015!\u0003}\u000b\u0019\t9\u0001\u0001\u0001\u0002\n!I\u0011Q\u0005\u0001C\u0002\u0013%\u0011q\u0005\u0005\t\u0003\u0007\u0002\u0001\u0015!\u0003\u0002*!1\u0011Q\t\u0001\u0005\n-D\u0001\"a\u0012\u0001\u0001\u0004%Ia\u001b\u0005\n\u0003\u0013\u0002\u0001\u0019!C\u0005\u0003\u0017Bq!a\u0016\u0001A\u0003&A\u000eC\u0004\u0002Z\u0001!\t!a\u0017\t\u0019\u0005u\u0003\u0001%A\u0001\u0004\u0003\u0006I!a\u0018\t\u0013\u0005-\u0004A1A\u0005\u0002\u00055\u0004\u0002CA8\u0001\u0001\u0006I!!\u001a\t\u0013\u0005E\u0004A1A\u0005\u0002\u00055\u0004\u0002CA:\u0001\u0001\u0006I!!\u001a\t\u000f\u0005U\u0004\u0001\"\u0003\u0002x!9\u0011Q\u0010\u0001\u0005\u0002\u0005}\u0004bBA?\u0001\u0011\u0005\u0011\u0011\u0013\u0005\b\u0003S\u0003A\u0011AAV\u0011\u001d\ty\u000b\u0001C\u0005\u0003cCq!a3\u0001\t\u0013\ti\rC\u0004\u0002d\u0002!I!!:\t\u000f\u0005=\b\u0001\"\u0011\u0002r\"9\u0011q\u001f\u0001\u0005B\u0005msaBA}\u0001!\u0005\u00111 \u0004\b\u0003{\u0004\u0001\u0012AA\u0000\u0011\u0019)7\u0005\"\u0001\u0003\u0002!I!1A\u0012C\u0002\u0013\u0005!Q\u0001\u0005\t\u0005\u001f\u0019\u0003\u0015!\u0003\u0003\b!1!\u0011C\u0012\u0005\u0002-DqAa\u0005$\t\u0003\t9\u0003\u0003\u0004\u0003\u0016\r\"\ta[\u0004\b\u0005/y\u0003\u0012\u0001B\r\r\u0019qs\u0006#\u0001\u0003\u001c!1Qm\u000bC\u0001\u0005;AqAa\b,\t\u0003\u0011\tCA\u0007M_\u000e\fG\u000eR1uC\n\f7/\u001a\u0006\u0003aE\nQ\u0001\\8dC2T!AM\u001a\u0002\u000fM,'O^5dK*\u0011A'N\u0001\u000b[>t\u0017\u000e^8sS:<'B\u0001\u001c8\u0003%\u0019wN\u001c3vWR|'OC\u00019\u0003\tIwn\u0001\u0001\u0014\t\u0001Y\u0014i\u0014\t\u0003y}j\u0011!\u0010\u0006\u0002}\u0005)1oY1mC&\u0011\u0001)\u0010\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\tkU\"A\"\u000b\u0005\u0011+\u0015A\u00013c\u0015\t1u)\u0001\u0003d_J,'B\u0001%J\u0003\u0015\tG\u000f\\1t\u0015\tQ5*A\u0004oKR4G.\u001b=\u000b\u00031\u000b1aY8n\u0013\tq5I\u0001\u0005ECR\f'-Y:f!\t\u0001V+D\u0001R\u0015\t\u00116+\u0001\u0003mC:<'\"\u0001+\u0002\t)\fg/Y\u0005\u0003-F\u0013Q\"Q;u_\u000ecwn]3bE2,\u0017\u0001\u0003:fO&\u001cHO]=\u0011\u0005esV\"\u0001.\u000b\u0005mc\u0016aA1qS*\u0011Q,S\u0001\ngB,7\r^1u_JL!a\u0018.\u0003\u0011I+w-[:uef\faaY8oM&<\u0007C\u00012d\u001b\u0005y\u0013B\u000130\u0005UiU\r\u001e:jGN$\u0015\r^1cCN,7i\u001c8gS\u001e\fa\u0001P5oSRtDcA4iSB\u0011!\r\u0001\u0005\u0006/\u000e\u0001\r\u0001\u0017\u0005\u0006A\u000e\u0001\r!Y\u0001\u0005gR,\u0007/F\u0001m!\taT.\u0003\u0002o{\t!Aj\u001c8h\u0003\u0015\u0019H/\u001a9!\u0003\r!H\u000f\\\u0001\u0005iRd\u0007%A\u0003ti\u0006$8/F\u0001u!\t)\b0D\u0001w\u0015\t9X)A\u0003j]\u0012,\u00070\u0003\u0002zm\nQ\u0011J\u001c3fqN#\u0018\r^:\u0002\rM$\u0018\r^:!+\u0005a\bcA;~\u007f&\u0011aP\u001e\u0002\u0014\u0005\u0006$8\r[+qI\u0006$X\rV1h\u0013:$W\r\u001f\t\u0004\u0005\u0006\u0005\u0011bAA\u0002\u0007\nq!\t\\8dWN#xN]3Ji\u0016l\u0017AB5oI\u0016D\bE\u0001\u0004Ji\u0016l\u0017\n\u001a\t\t\u0003\u0017\tI\"a\b\u0002 9!\u0011QBA\u000b!\r\ty!P\u0007\u0003\u0003#Q1!a\u0005:\u0003\u0019a$o\\8u}%\u0019\u0011qC\u001f\u0002\rA\u0013X\rZ3g\u0013\u0011\tY\"!\b\u0003\u00075\u000b\u0007OC\u0002\u0002\u0018u\u0002B!a\u0003\u0002\"%!\u00111EA\u000f\u0005\u0019\u0019FO]5oO\u0006!A-\u0019;b+\t\tI\u0003\u0005\u0005\u0002,\u0005U\u0012\u0011HA\u001f\u001b\t\tiC\u0003\u0003\u00020\u0005E\u0012AC2p]\u000e,(O]3oi*\u0019\u00111G*\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003o\tiCA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u00042!a\u000f\r\u001b\u0005\u0001\u0001c\u0001\"\u0002@%\u0019\u0011\u0011I\"\u0003\u0015\tcwnY6Ti>\u0014X-A\u0003eCR\f\u0007%A\u0002o_^\f!\"\u00199qY&,G\r\u0016;m\u00039\t\u0007\u000f\u001d7jK\u0012$F\u000f\\0%KF$B!!\u0014\u0002TA\u0019A(a\u0014\n\u0007\u0005ESH\u0001\u0003V]&$\b\u0002CA+#\u0005\u0005\t\u0019\u00017\u0002\u0007a$\u0013'A\u0006baBd\u0017.\u001a3Ui2\u0004\u0013a\u0002:fEVLG\u000e\u001a\u000b\u0003\u0003\u001b\n1\u0001\u001f\u00133!\u001da\u0014\u0011MA3\u0003KJ1!a\u0019>\u0005\u0019!V\u000f\u001d7feA\u0019A(a\u001a\n\u0007\u0005%THA\u0002J]R\f\u0011B\u00197pG.\u001c\u0016N_3\u0016\u0005\u0005\u0015\u0014A\u00032m_\u000e\\7+\u001b>fA\u0005Ia.^7CY>\u001c7n]\u0001\u000b]Vl'\t\\8dWN\u0004\u0013!F4fi>\u00138I]3bi\u0016\u0014En\\2l'R|'/\u001a\u000b\u0005\u0003{\tI\bC\u0004\u0002|e\u0001\r!!\u000f\u0002\u0005%$\u0017AB;qI\u0006$X\r\u0006\u0003\u0002N\u0005\u0005\u0005bBAB5\u0001\u0007\u0011QQ\u0001\u0003IB\u0004B!a\"\u0002\u000e6\u0011\u0011\u0011\u0012\u0006\u0004\u0003\u0017+\u0015!B7pI\u0016d\u0017\u0002BAH\u0003\u0013\u0013\u0011\u0002R1uCB|\u0017N\u001c;\u0015\t\u00055\u00131\u0013\u0005\b\u0003+[\u0002\u0019AAL\u0003\t!7\u000f\u0005\u0004\u0002\u001a\u0006\r\u0016Q\u0011\b\u0005\u00037\u000byJ\u0004\u0003\u0002\u0010\u0005u\u0015\"\u0001 \n\u0007\u0005\u0005V(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0015\u0016q\u0015\u0002\u0005\u0019&\u001cHOC\u0002\u0002\"v\naA]8mYV\u0004H\u0003BA'\u0003[Cq!a!\u001d\u0001\u0004\t))A\u0005cY>\u001c7.Q4heR!\u0011QMAZ\u0011\u001d\t),\ba\u0001\u0003o\u000bA!\u001a=qeB!\u0011qQA]\u0013\u0011\tY,!#\u0003\u0011\u0011\u000bG/Y#yaJD3!HA`!\u0011\t\t-a2\u000e\u0005\u0005\r'bAAc{\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005%\u00171\u0019\u0002\bi\u0006LGN]3d\u0003-)\u00070Z2vi\u0016LU\u000e\u001d7\u0015\r\u0005=\u0017q[Aq!\u0019\tI*a)\u0002RB!\u0011qQAj\u0013\u0011\t).!#\u0003\u0015QKW.Z*fe&,7\u000fC\u0004\u0002Zz\u0001\r!a7\u0002\u000f\r|g\u000e^3yiB!\u0011qQAo\u0013\u0011\ty.!#\u0003\u0017\u00153\u0018\r\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003ks\u0002\u0019AA\\\u0003-1\u0017N\\1m-\u0006dW/Z:\u0015\u0011\u0005=\u0017q]Au\u0003WDq!!7 \u0001\u0004\tY\u000eC\u0004\u00026~\u0001\r!a.\t\u000f\u00055x\u00041\u0001\u0002P\u0006\u0011ao]\u0001\bKb,7-\u001e;f)\u0019\ty-a=\u0002v\"9\u0011\u0011\u001c\u0011A\u0002\u0005m\u0007bBA[A\u0001\u0007\u0011qW\u0001\u0006G2|7/Z\u0001\tS:$XM\u001d8bYB\u0019\u00111H\u0012\u0003\u0011%tG/\u001a:oC2\u001c\"aI\u001e\u0015\u0005\u0005m\u0018\u0001\u00023c\u0013\u0012,\"Aa\u0002\u0011\t\t%!1B\u0007\u0003\u0003cIAA!\u0004\u00022\t!Q+V%E\u0003\u0015!'-\u00133!\u0003\u0019!'\rV5nK\u00061AM\u0019#bi\u0006\fa\u0001\u001a2TSj,\u0017!\u0004'pG\u0006dG)\u0019;bE\u0006\u001cX\r\u0005\u0002cWM\u00111f\u000f\u000b\u0003\u00053\tQ!\u00199qYf$2a\u001aB\u0012\u0011\u0019\u0011)#\fa\u0001C\u0006\u00191MZ4")
public final class LocalDatabase
implements Database,
AutoCloseable {
    private volatile LocalDatabase$internal$ internal$module;
    private final Registry registry;
    private final long step;
    private final long ttl;
    private final IndexStats stats;
    private final BatchUpdateTagIndex<BlockStoreItem> index;
    private final ConcurrentHashMap<Map<String, String>, BlockStore> io$conduktor$monitoring$service$local$LocalDatabase$$data;
    private long appliedTtl;
    private final /* synthetic */ Tuple2 x$2;
    private final int blockSize;
    private final int numBlocks;
    private volatile int bitmap$init$0;

    public static LocalDatabase apply(MetricsDatabaseConfig cfg) {
        return LocalDatabase$.MODULE$.apply(cfg);
    }

    public LocalDatabase$internal$ internal() {
        if (this.internal$module == null) {
            this.internal$lzycompute$1();
        }
        return this.internal$module;
    }

    public long step() {
        if ((this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/builds/builds/conduktor-desktop/monitoring-scala/src/main/scala/io/conduktor/monitoring/service/local/LocalDatabase.scala: 41");
        }
        return this.step;
    }

    private long ttl() {
        if ((this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/builds/builds/conduktor-desktop/monitoring-scala/src/main/scala/io/conduktor/monitoring/service/local/LocalDatabase.scala: 42");
        }
        return this.ttl;
    }

    private IndexStats stats() {
        if ((this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/builds/builds/conduktor-desktop/monitoring-scala/src/main/scala/io/conduktor/monitoring/service/local/LocalDatabase.scala: 44");
        }
        return this.stats;
    }

    public BatchUpdateTagIndex<BlockStoreItem> index() {
        if ((this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/builds/builds/conduktor-desktop/monitoring-scala/src/main/scala/io/conduktor/monitoring/service/local/LocalDatabase.scala: 46");
        }
        return this.index;
    }

    public ConcurrentHashMap<Map<String, String>, BlockStore> io$conduktor$monitoring$service$local$LocalDatabase$$data() {
        if ((this.bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/builds/builds/conduktor-desktop/monitoring-scala/src/main/scala/io/conduktor/monitoring/service/local/LocalDatabase.scala: 50");
        }
        return this.io$conduktor$monitoring$service$local$LocalDatabase$$data;
    }

    public long io$conduktor$monitoring$service$local$LocalDatabase$$now() {
        return this.registry.clock().wallTime();
    }

    private long appliedTtl() {
        if ((this.bitmap$init$0 & 0x40) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/builds/builds/conduktor-desktop/monitoring-scala/src/main/scala/io/conduktor/monitoring/service/local/LocalDatabase.scala: 54");
        }
        return this.appliedTtl;
    }

    private void appliedTtl_$eq(long x$1) {
        this.appliedTtl = x$1;
        this.bitmap$init$0 |= 0x40;
    }

    public void rebuild() {
        this.index().rebuildIndex();
        long maxMemory = Runtime.getRuntime().maxMemory();
        long currentSize = this.internal().dbSize();
        if ((double)currentSize > 0.1 * (double)maxMemory) {
            this.appliedTtl_$eq((long)((double)this.appliedTtl() * 0.95));
        } else {
            this.appliedTtl_$eq(this.ttl());
        }
        long cutoff = this.io$conduktor$monitoring$service$local$LocalDatabase$$now() - this.appliedTtl();
        Iterator<Map.Entry<Map<String, String>, BlockStore>> iter = this.io$conduktor$monitoring$service$local$LocalDatabase$$data().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Map<String, String>, BlockStore> entry = iter.next();
            entry.getValue().cleanup(cutoff);
            if (entry.getValue().hasData()) continue;
            iter.remove();
        }
        BlockStoreItem$.MODULE$.retain((Function1)(JFunction1.mcZJ.sp & Serializable)x$1 -> x$1 > cutoff);
        LocalDatabases$.MODULE$.acc(this);
    }

    public int blockSize() {
        if ((this.bitmap$init$0 & 0x100) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/builds/builds/conduktor-desktop/monitoring-scala/src/main/scala/io/conduktor/monitoring/service/local/LocalDatabase.scala: 86");
        }
        return this.blockSize;
    }

    public int numBlocks() {
        if ((this.bitmap$init$0 & 0x200) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/builds/builds/conduktor-desktop/monitoring-scala/src/main/scala/io/conduktor/monitoring/service/local/LocalDatabase.scala: 86");
        }
        return this.numBlocks;
    }

    private BlockStore getOrCreateBlockStore(Map<String, String> id) {
        return (BlockStore)this.io$conduktor$monitoring$service$local$LocalDatabase$$data().computeIfAbsent(id, x$3 -> new MemoryBlockStore(this.step(), this.blockSize(), this.numBlocks()));
    }

    public void update(Datapoint dp) {
        BlockStore blkStore = this.getOrCreateBlockStore((Map<String, String>)dp.tags());
        blkStore.update(dp.timestamp(), dp.value(), blkStore.update$default$3());
        this.index().update((TaggedItem)BlockStoreItem$.MODULE$.create(dp.tags(), blkStore));
    }

    public void update(List<Datapoint> ds) {
        ds.foreach((Function1 & Serializable)dp -> {
            this.update(dp);
            return BoxedUnit.UNIT;
        });
    }

    public void rollup(Datapoint dp) {
        BlockStore blkStore = this.getOrCreateBlockStore((Map<String, String>)dp.tags());
        blkStore.update(dp.timestamp(), dp.value(), true);
        this.index().update((TaggedItem)BlockStoreItem$.MODULE$.create(dp.tags(), blkStore));
    }

    private int blockAggr(DataExpr expr) {
        int n;
        block7: {
            DataExpr dataExpr;
            while (true) {
                if ((dataExpr = expr) instanceof DataExpr.GroupBy) {
                    DataExpr.GroupBy groupBy = (DataExpr.GroupBy)dataExpr;
                    expr = groupBy.af();
                    continue;
                }
                if (dataExpr instanceof DataExpr.All) {
                    n = 0;
                    break block7;
                }
                if (dataExpr instanceof DataExpr.Sum) {
                    n = 0;
                    break block7;
                }
                if (dataExpr instanceof DataExpr.Count) {
                    n = 1;
                    break block7;
                }
                if (dataExpr instanceof DataExpr.Min) {
                    n = 2;
                    break block7;
                }
                if (dataExpr instanceof DataExpr.Max) {
                    n = 3;
                    break block7;
                }
                if (!(dataExpr instanceof DataExpr.Consolidation)) break;
                DataExpr.Consolidation consolidation = (DataExpr.Consolidation)dataExpr;
                DataExpr.AggregateFunction af = consolidation.af();
                expr = af;
            }
            throw new MatchError((Object)dataExpr);
        }
        return n;
    }

    private List<TimeSeries> executeImpl(EvalContext context, DataExpr expr) {
        long cfStep = context.step();
        Predef$.MODULE$.require(cfStep >= this.step(), (Function0 & Serializable)() -> "step for query must be >= step for the database");
        Predef$.MODULE$.require(cfStep % this.step() == 0L, (Function0 & Serializable)() -> "consolidated step must be multiple of db step");
        TagQuery query = new TagQuery((Option)new Some((Object)expr.query()), TagQuery$.MODULE$.apply$default$2(), TagQuery$.MODULE$.apply$default$3(), TagQuery$.MODULE$.apply$default$4());
        int aggr = this.blockAggr(expr);
        AggregateCollector collector = AggregateCollector$.MODULE$.apply(expr);
        long end = context.end();
        int multiple = (int)(cfStep / this.step());
        long s = context.start() / cfStep;
        long e = end / cfStep;
        long bs = s * (long)multiple;
        long be = e * (long)multiple;
        long stepLength = be - bs + 1L;
        long cfStepLength = stepLength / (long)multiple;
        long bufStart = bs * this.step();
        long bufEnd = bufStart + cfStepLength * cfStep - cfStep;
        this.index().findItems(query).foreach((Function1 & Serializable)item -> {
            LocalDatabase.$anonfun$executeImpl$4(this, be, bs, collector, aggr, expr, multiple, cfStep, bufStart, bufEnd, item);
            return BoxedUnit.UNIT;
        });
        List vs = (List)collector.result().map((Function1 & Serializable)t -> DataExpr$.MODULE$.withDefaultLabel(expr, (TimeSeries)t)).sortWith((Function2 & Serializable)(x$4, x$5) -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.$less$extension(Predef$.MODULE$.augmentString(x$4.label()), x$5.label())));
        return this.finalValues(context, expr, (List<TimeSeries>)vs);
    }

    private List<TimeSeries> finalValues(EvalContext context, DataExpr expr, List<TimeSeries> vs) {
        DataExpr dataExpr = expr;
        List list = dataExpr instanceof DataExpr.AggregateFunction && vs.isEmpty() ? (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TimeSeries[]{TimeSeries$.MODULE$.noData(context.step())})) : vs;
        return list;
    }

    public List<TimeSeries> execute(EvalContext context, DataExpr expr) {
        List list;
        long offset = expr.offset().toMillis();
        if (offset == 0L) {
            list = this.executeImpl(context, expr);
        } else {
            EvalContext offsetContext = context.withOffset(expr.offset().toMillis());
            list = this.executeImpl(offsetContext, expr).map((Function1 & Serializable)t -> t.offset(offset));
        }
        List timeSeries = list;
        return timeSeries.groupMapReduce((Function1 & Serializable)x$6 -> x$6.id(), (Function1 & Serializable)x -> (TimeSeries)Predef$.MODULE$.identity(x), (Function2 & Serializable)(a, b) -> a.blend(b)).values().toList();
    }

    @Override
    public void close() {
        Iterator<Map.Entry<Map<String, String>, BlockStore>> iter = this.io$conduktor$monitoring$service$local$LocalDatabase$$data().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Map<String, String>, BlockStore> entry = iter.next();
            entry.getValue().cleanup(Long.MAX_VALUE);
            if (entry.getValue().hasData()) continue;
            iter.remove();
        }
        BlockStoreItem$.MODULE$.retain((Function1)(JFunction1.mcZJ.sp & Serializable)x$7 -> false);
        this.index().rebuildIndex();
        LocalDatabases$.MODULE$.acc(this);
    }

    private final void internal$lzycompute$1() {
        LocalDatabase localDatabase = this;
        synchronized (localDatabase) {
            if (this.internal$module == null) {
                this.internal$module = new LocalDatabase$internal$(this);
            }
        }
    }

    private static final TimeSeriesBuffer newBuffer$1(Map tags, DataExpr expr$1, long cfStep$1, long bufStart$1, long bufEnd$1) {
        Map map;
        DataExpr dataExpr = expr$1;
        if (dataExpr instanceof DataExpr.All) {
            map = tags;
        } else {
            Set resultKeys = (Set)Query$.MODULE$.exactKeys(expr$1.query()).$plus$plus((IterableOnce)expr$1.finalGrouping());
            map = tags.view().filterKeys((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)resultKeys.contains((Object)elem))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        Map resultTags = map;
        return TimeSeriesBuffer$.MODULE$.apply(resultTags, cfStep$1, bufStart$1, bufEnd$1);
    }

    public static final /* synthetic */ void $anonfun$executeImpl$4(LocalDatabase $this, long be$1, long bs$1, AggregateCollector collector$1, int aggr$1, DataExpr expr$1, int multiple$1, long cfStep$1, long bufStart$1, long bufEnd$1, BlockStoreItem item) {
        item.blocks().blockList().foreach((Function1 & Serializable)b -> {
            long blockEnd = b.start() + (long)(b.size() + 1) * $this.step();
            return b.start() <= be$1 * $this.step() && blockEnd >= bs$1 * $this.step() ? BoxesRunTime.boxToInteger((int)collector$1.add(item.tags(), (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Block[]{b})), aggr$1, expr$1.cf(), multiple$1, (Function1 & Serializable)tags -> LocalDatabase.newBuffer$1(tags, expr$1, cfStep$1, bufStart$1, bufEnd$1))) : BoxedUnit.UNIT;
        });
    }

    public LocalDatabase(Registry registry, MetricsDatabaseConfig config) {
        Tuple2.mcII.sp sp2;
        this.registry = registry;
        this.step = config.step().toMillis();
        this.bitmap$init$0 |= 2;
        this.ttl = config.ttl().toMillis();
        this.bitmap$init$0 |= 4;
        this.stats = new IndexStats(registry);
        this.bitmap$init$0 |= 8;
        this.index = new BatchUpdateTagIndex(registry, (Function1 & Serializable)items -> new CachingTagIndex((TagIndex)new RoaringTagIndex((TaggedItem[])items, this.stats())), ClassTag$.MODULE$.apply(BlockStoreItem.class));
        this.bitmap$init$0 |= 0x10;
        this.io$conduktor$monitoring$service$local$LocalDatabase$$data = new ConcurrentHashMap();
        this.bitmap$init$0 |= 0x20;
        this.appliedTtl = this.ttl();
        this.bitmap$init$0 |= 0x40;
        Tuple2.mcII.sp sp3 = sp2 = (double)this.step() < 0.1 * (double)this.ttl() ? new Tuple2.mcII.sp((int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)this.ttl() / (double)(this.step() * 10L))), 10) : new Tuple2.mcII.sp(1, (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)this.ttl() / (double)this.step())));
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int blockSize = sp2._1$mcI$sp();
        int numBlocks = sp2._2$mcI$sp();
        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(blockSize, numBlocks);
        this.x$2 = sp4;
        this.bitmap$init$0 |= 0x80;
        this.blockSize = this.x$2._1$mcI$sp();
        this.bitmap$init$0 |= 0x100;
        this.numBlocks = this.x$2._2$mcI$sp();
        this.bitmap$init$0 |= 0x200;
    }
}

