/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.util;

import cats.data.NonEmptyList;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.http4s.Header;
import org.http4s.Header$Raw$;
import org.http4s.util.Renderer;
import org.http4s.util.StringWriter;
import org.http4s.util.StringWriter$;
import org.http4s.util.Writer;
import org.typelevel.ci.CIString;
import scala.MatchError;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.concurrent.duration.FiniteDuration;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Renderer$ {
    public static final Renderer$ MODULE$ = new Renderer$();
    private static final Renderer<Instant> RFC7231InstantRenderer = new Renderer<Instant>(){
        private final DateTimeFormatter dateFormat;

        private DateTimeFormatter dateFormat() {
            return this.dateFormat;
        }

        public Writer render(Writer writer, Instant t) {
            return writer.$less$less(this.dateFormat().format(t));
        }
        {
            this.dateFormat = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz").withLocale(Locale.US).withZone(ZoneId.of("GMT"));
        }
    };
    private static final Renderer<String> stringRenderer = new Renderer<String>(){

        public Writer render(Writer writer, String string) {
            return writer.$less$less(string);
        }
    };
    private static final Renderer<FiniteDuration> finiteDurationRenderer = new Renderer<FiniteDuration>(){

        public Writer render(Writer writer, FiniteDuration d) {
            return writer.$less$less(Long.toString(d.toSeconds()));
        }
    };
    private static final Renderer<Object> longRenderer = new Renderer<Object>(){

        public Writer render(Writer writer, long d) {
            return writer.$less$less(Long.toString(d));
        }
    };
    private static final Renderer<CIString> ciStringRenderer = new Renderer<CIString>(){

        public Writer render(Writer writer, CIString ciString) {
            return writer.$less$less(ciString);
        }
    };

    public <A> Renderer<A> apply(Renderer<A> ev) {
        return ev;
    }

    public <T> String renderString(T t, Renderer<T> evidence$1) {
        return ((StringWriter)new StringWriter(StringWriter$.MODULE$.$lessinit$greater$default$1()).append(t, evidence$1)).result();
    }

    public Renderer<Instant> RFC7231InstantRenderer() {
        return RFC7231InstantRenderer;
    }

    public Renderer<String> stringRenderer() {
        return stringRenderer;
    }

    public Renderer<FiniteDuration> finiteDurationRenderer() {
        return finiteDurationRenderer;
    }

    public Renderer<Object> longRenderer() {
        return longRenderer;
    }

    public <A, B> Renderer<Either<A, B>> eitherRenderer(Renderer<A> ra, Renderer<B> rb) {
        return new Renderer<Either<A, B>>(ra, rb){
            private final Renderer ra$1;
            private final Renderer rb$1;

            public Writer render(Writer writer, Either<A, B> e) {
                Writer writer2;
                Either<A, B> either = e;
                if (either instanceof Left) {
                    Left left = (Left)either;
                    Object a = left.value();
                    writer2 = this.ra$1.render(writer, a);
                } else if (either instanceof Right) {
                    Right right = (Right)either;
                    Object b = right.value();
                    writer2 = this.rb$1.render(writer, b);
                } else {
                    throw new MatchError(either);
                }
                return writer2;
            }
            {
                this.ra$1 = ra$1;
                this.rb$1 = rb$1;
            }
        };
    }

    public Renderer<CIString> ciStringRenderer() {
        return ciStringRenderer;
    }

    public <T> Renderer<NonEmptyList<T>> nelRenderer(Renderer<T> evidence$2) {
        return new Renderer<NonEmptyList<T>>(evidence$2){
            private final Renderer evidence$2$1;

            public Writer render(Writer writer, NonEmptyList<T> values) {
                return writer.addNel(values, writer.addNel$default$2(), writer.addNel$default$3(), writer.addNel$default$4(), this.evidence$2$1);
            }
            {
                this.evidence$2$1 = evidence$2$1;
            }
        };
    }

    public <T> Renderer<List<T>> listRenderer(Renderer<T> evidence$3) {
        return new Renderer<List<T>>(evidence$3){
            private final Renderer evidence$3$1;

            public Writer render(Writer writer, List<T> values) {
                return writer.addList(values, writer.addList$default$2(), writer.addList$default$3(), writer.addList$default$4(), this.evidence$3$1);
            }
            {
                this.evidence$3$1 = evidence$3$1;
            }
        };
    }

    public <T> Renderer<Set<T>> setRenderer(Renderer<T> evidence$4) {
        return new Renderer<Set<T>>(evidence$4){
            private final Renderer evidence$4$1;

            public Writer render(Writer writer, Set<T> values) {
                return writer.addSet(values, writer.addSet$default$2(), writer.addSet$default$3(), writer.addSet$default$4(), this.evidence$4$1);
            }
            {
                this.evidence$4$1 = evidence$4$1;
            }
        };
    }

    public <A> Renderer<A> headerSelectRenderer(Header.Select<A> select) {
        return new Renderer<A>(select){
            private final Header.Select select$1;

            public Writer render(Writer writer, A t) {
                return writer.$less$less(this.select$1.toRaw1(t), (Renderer)Header$Raw$.MODULE$.catsInstancesForHttp4sHeaderRaw());
            }
            {
                this.select$1 = select$1;
            }
        };
    }

    private Renderer$() {
    }
}

