/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.internal;

import java.io.Serializable;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.Method;
import org.http4s.Request;
import org.http4s.Uri;
import org.typelevel.ci.CIString;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ScalaRunTime$;

public final class CurlConverter$ {
    public static final CurlConverter$ MODULE$ = new CurlConverter$();

    private String escapeQuotationMarks(String s2) {
        return s2.replaceAll("'", "'\\\\''");
    }

    private String newline() {
        return " \\\n  ";
    }

    private String prepareMethodName(Method method) {
        return new StringBuilder(10).append(this.newline()).append("--request ").append(method.name()).toString();
    }

    private String prepareUri(Uri uri) {
        return new StringBuilder(8).append(this.newline()).append("--url '").append(this.escapeQuotationMarks(uri.renderString())).append("'").toString();
    }

    private String prepareHeaders(List<Header.Raw> headers, Function1<CIString, Object> redactHeadersWhen) {
        String preparedHeaders = Headers$.MODULE$.redactSensitive$extension(headers, redactHeadersWhen).map((Function1 & Serializable)header -> new StringBuilder(11).append("--header '").append(MODULE$.escapeQuotationMarks(new StringBuilder(2).append(header.name()).append(": ").append(header.value()).toString())).append("'").toString()).mkString(this.newline());
        return preparedHeaders.isEmpty() ? "" : new StringBuilder(0).append(this.newline()).append(preparedHeaders).toString();
    }

    public <F> String requestToCurlWithoutBody(Request<F> request, Function1<CIString, Object> redactHeadersWhen) {
        String params = ((IterableOnceOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.prepareMethodName(request.method()), this.prepareUri(request.uri()), this.prepareHeaders((List<Header.Raw>)request.headers(), redactHeadersWhen)}))).mkString();
        return new StringBuilder(4).append("curl").append(params).toString();
    }

    private CurlConverter$() {
    }
}

