/*
 * Decompiled with CFR 0.152.
 */
package zio.logging;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import zio.ZIO;
import zio.logging.LogAnnotation$;
import zio.logging.LogContext;
import zio.logging.LogFiltering;
import zio.logging.LogLevel;
import zio.stm.TMap;
import zio.stm.ZSTM;
import zio.stm.ZSTM$;

public final class LogFiltering$ {
    public static final LogFiltering$ MODULE$ = new LogFiltering$();

    public <A> Function2<LogContext, Function0<A>, Object> filterBy(LogLevel rootLevel, Seq<Tuple2<String, LogLevel>> mappings) {
        return this.filterByTree(this.buildLogFilterTree(rootLevel, mappings));
    }

    public <A> Function2<LogContext, Function0<A>, Object> filterByTree(LogFiltering.LogFilterNode root) {
        return (Function2 & Serializable)(ctx, x$1) -> BoxesRunTime.boxToBoolean((boolean)LogFiltering$.$anonfun$filterByTree$1(root, ctx, x$1));
    }

    public <A> Function2<LogContext, Function0<A>, ZIO<Object, Nothing$, Object>> cachedFilterBy(TMap<Tuple2<List<String>, LogLevel>, Object> cache, LogLevel rootLevel, Seq<Tuple2<String, LogLevel>> mappings) {
        return this.cachedFilterByTree(cache, this.buildLogFilterTree(rootLevel, mappings));
    }

    public <A> Function2<LogContext, Function0<A>, ZIO<Object, Nothing$, Object>> cachedFilterByTree(TMap<Tuple2<List<String>, LogLevel>, Object> cache, LogFiltering.LogFilterNode root) {
        return (Function2 & Serializable)(ctx, x$2) -> {
            List<String> loggerName = ctx.get(LogAnnotation$.MODULE$.Name());
            LogLevel level = ctx.get(LogAnnotation$.MODULE$.Level());
            Tuple2 key = new Tuple2(loggerName, (Object)level);
            Function4 stm = ZSTM$.MODULE$.flatMap$extension(cache.get((Object)key), (Function1 & Serializable)cached -> new ZSTM(LogFiltering$.$anonfun$cachedFilterByTree$2(loggerName, root, level, cache, key, cached)));
            return ZSTM$.MODULE$.commit$extension(stm);
        };
    }

    private LogFiltering.LogFilterNode buildLogFilterTree(LogLevel rootLevel, Seq<Tuple2<String, LogLevel>> mappings) {
        return (LogFiltering.LogFilterNode)mappings.foldLeft((Object)new LogFiltering.LogFilterNode(rootLevel, (Map<String, LogFiltering.LogFilterNode>)Predef$.MODULE$.Map().empty()), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (x1$1 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)x1$1._1();
            LogLevel logLevel = (LogLevel)x1$1._2();
            List nameList = Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(name), '.')).toList();
            LogFiltering.LogFilterNode logFilterNode = LogFiltering$.add$1(x0$1, nameList, logLevel);
            return logFilterNode;
        });
    }

    private LogLevel findMostSpecificLogLevel(List<String> names, LogFiltering.LogFilterNode currentNode) {
        LogLevel logLevel;
        block5: {
            while (names instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)names;
                String next = (String)colon2.head();
                List remaining = colon2.next$access$1();
                Option option = currentNode.children().get((Object)next);
                if (option instanceof Some) {
                    LogFiltering.LogFilterNode nextNode;
                    currentNode = nextNode = (LogFiltering.LogFilterNode)((Some)option).value();
                    names = remaining;
                    continue;
                }
                if (!None$.MODULE$.equals(option)) {
                    throw new MatchError((Object)option);
                }
                LogLevel logLevel2 = currentNode.logLevel();
                logLevel = logLevel2;
                break block5;
            }
            Nil$ nil$ = package$.MODULE$.Nil();
            if (!(nil$ != null ? !nil$.equals(names) : names != null)) {
                logLevel = currentNode.logLevel();
            } else {
                throw new MatchError(names);
            }
        }
        return logLevel;
    }

    public static final /* synthetic */ boolean $anonfun$filterByTree$1(LogFiltering.LogFilterNode root$1, LogContext ctx, Function0 x$1) {
        List<String> loggerName = ctx.get(LogAnnotation$.MODULE$.Name());
        LogLevel logLevel = MODULE$.findMostSpecificLogLevel(loggerName, root$1);
        return ctx.get(LogAnnotation$.MODULE$.Level()).$greater$eq(logLevel);
    }

    public static final /* synthetic */ Function4 $anonfun$cachedFilterByTree$2(List loggerName$1, LogFiltering.LogFilterNode root$2, LogLevel level$1, TMap cache$1, Tuple2 key$1, Option cached) {
        Function4 function4;
        if (cached instanceof Some) {
            boolean value = BoxesRunTime.unboxToBoolean((Object)((Some)cached).value());
            function4 = ZSTM$.MODULE$.succeed((Function0)(JFunction0.mcZ.sp & Serializable)() -> value);
        } else if (None$.MODULE$.equals(cached)) {
            LogLevel mostSpecificLogLevel = MODULE$.findMostSpecificLogLevel((List<String>)loggerName$1, root$2);
            boolean answer = level$1.$greater$eq(mostSpecificLogLevel);
            function4 = ZSTM$.MODULE$.as$extension(cache$1.put((Object)key$1, (Object)BoxesRunTime.boxToBoolean((boolean)answer)), (Function0)(JFunction0.mcZ.sp & Serializable)() -> answer);
        } else {
            throw new MatchError((Object)cached);
        }
        return ZSTM$.MODULE$.map$extension(function4, (Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)result)));
    }

    private static final LogFiltering.LogFilterNode add$1(LogFiltering.LogFilterNode tree, List names, LogLevel level) {
        LogFiltering.LogFilterNode logFilterNode;
        Nil$ nil$ = package$.MODULE$.Nil();
        if (!(nil$ != null ? !nil$.equals(names) : names != null)) {
            logFilterNode = tree.copy(level, tree.copy$default$2());
        } else if (names instanceof .colon.colon) {
            LogFiltering.LogFilterNode logFilterNode2;
            .colon.colon colon2 = (.colon.colon)names;
            String name = (String)colon2.head();
            List remaining = colon2.next$access$1();
            Option option = tree.children().get((Object)name);
            if (option instanceof Some) {
                LogFiltering.LogFilterNode subtree = (LogFiltering.LogFilterNode)((Some)option).value();
                Map x$1 = (Map)tree.children().updated((Object)name, (Object)LogFiltering$.add$1(subtree, remaining, level));
                LogLevel x$2 = tree.copy$default$1();
                logFilterNode2 = tree.copy(x$2, (Map<String, LogFiltering.LogFilterNode>)x$1);
            } else if (None$.MODULE$.equals(option)) {
                Map x$3 = (Map)tree.children().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)LogFiltering$.add$1(new LogFiltering.LogFilterNode(tree.logLevel(), (Map<String, LogFiltering.LogFilterNode>)Predef$.MODULE$.Map().empty()), remaining, level)));
                LogLevel x$4 = tree.copy$default$1();
                logFilterNode2 = tree.copy(x$4, (Map<String, LogFiltering.LogFilterNode>)x$3);
            } else {
                throw new MatchError((Object)option);
            }
            logFilterNode = logFilterNode2;
        } else {
            throw new MatchError((Object)names);
        }
        return logFilterNode;
    }

    private LogFiltering$() {
    }
}

