/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.impl.matcher;

import com.netflix.spectator.impl.PatternMatcher;
import com.netflix.spectator.impl.matcher.CharClassMatcher;
import com.netflix.spectator.impl.matcher.CharSeqMatcher;
import com.netflix.spectator.impl.matcher.IndexOfMatcher;
import com.netflix.spectator.impl.matcher.Matcher;
import com.netflix.spectator.impl.matcher.Optimizer;
import com.netflix.spectator.impl.matcher.Parser;
import com.netflix.spectator.impl.matcher.SeqMatcher;
import com.netflix.spectator.impl.matcher.StartsWithMatcher;
import com.netflix.spectator.impl.matcher.TrueMatcher;
import com.netflix.spectator.impl.matcher.ZeroOrMoreMatcher;
import java.util.List;

public final class PatternUtils {
    private PatternUtils() {
    }

    public static PatternMatcher compile(String pattern) {
        String p = pattern;
        boolean ignoreCase = false;
        if (p.startsWith("(?i)")) {
            ignoreCase = true;
            p = pattern.substring(4);
        }
        if (p.length() > 0) {
            p = "^.*(" + p + ").*$";
        }
        Parser parser = new Parser(PatternUtils.expandEscapedChars(p));
        Matcher m = Optimizer.optimize(parser.parse());
        return ignoreCase ? m.ignoreCase() : m;
    }

    private static String context(String str, int pos) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < pos; ++i) {
            builder.append(' ');
        }
        builder.append('^');
        return str + "\n" + builder.toString();
    }

    static IllegalArgumentException error(String message, String str, int pos) {
        return new IllegalArgumentException(message + "\n" + PatternUtils.context(str, pos));
    }

    static UnsupportedOperationException unsupported(String message, String str, int pos) {
        return new UnsupportedOperationException(message + "\n" + PatternUtils.context(str, pos));
    }

    private static char parse(String num, int radix, String mode, String str, int pos) {
        try {
            return (char)Integer.parseInt(num, radix);
        }
        catch (NumberFormatException e) {
            throw PatternUtils.error("invalid " + mode + " escape sequence", str, pos);
        }
    }

    static String expandEscapedChars(String str) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\\') {
                if (++i >= str.length()) {
                    throw PatternUtils.error("dangling escape", str, i);
                }
                c = str.charAt(i);
                switch (c) {
                    case 't': {
                        builder.append('\t');
                        break;
                    }
                    case 'n': {
                        builder.append('\n');
                        break;
                    }
                    case 'r': {
                        builder.append('\r');
                        break;
                    }
                    case 'f': {
                        builder.append('\f');
                        break;
                    }
                    case 'a': {
                        builder.append('\u0007');
                        break;
                    }
                    case 'e': {
                        builder.append('\u001b');
                        break;
                    }
                    case '0': {
                        int numDigits = 0;
                        for (int j = i + 1; j < Math.min(i + 4, str.length()) && (c = str.charAt(j)) >= '0' && c <= '7'; ++j) {
                            ++numDigits;
                        }
                        if (numDigits < 1 || numDigits > 3) {
                            throw PatternUtils.error("invalid octal escape sequence", str, i);
                        }
                        c = PatternUtils.parse(str.substring(i + 1, i + numDigits + 1), 8, "octal", str, i);
                        builder.append(c);
                        i += numDigits;
                        break;
                    }
                    case 'x': {
                        if (i + 3 > str.length()) {
                            throw PatternUtils.error("invalid hexadecimal escape sequence", str, i);
                        }
                        c = PatternUtils.parse(str.substring(i + 1, i + 3), 16, "hexadecimal", str, i);
                        builder.append(c);
                        i += 2;
                        break;
                    }
                    case 'u': {
                        if (i + 5 > str.length()) {
                            throw PatternUtils.error("invalid unicode escape sequence", str, i);
                        }
                        c = PatternUtils.parse(str.substring(i + 1, i + 5), 16, "unicode", str, i);
                        builder.append(c);
                        i += 4;
                        break;
                    }
                    default: {
                        builder.append('\\').append(c);
                        break;
                    }
                }
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    static String escape(String str) {
        StringBuilder builder = new StringBuilder();
        block19: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\t': {
                    builder.append("\\t");
                    continue block19;
                }
                case '\n': {
                    builder.append("\\n");
                    continue block19;
                }
                case '\r': {
                    builder.append("\\r");
                    continue block19;
                }
                case '\f': {
                    builder.append("\\f");
                    continue block19;
                }
                case '\\': {
                    builder.append("\\\\");
                    continue block19;
                }
                case '^': {
                    builder.append("\\^");
                    continue block19;
                }
                case '$': {
                    builder.append("\\$");
                    continue block19;
                }
                case '.': {
                    builder.append("\\.");
                    continue block19;
                }
                case '?': {
                    builder.append("\\?");
                    continue block19;
                }
                case '*': {
                    builder.append("\\*");
                    continue block19;
                }
                case '+': {
                    builder.append("\\+");
                    continue block19;
                }
                case '[': {
                    builder.append("\\[");
                    continue block19;
                }
                case ']': {
                    builder.append("\\]");
                    continue block19;
                }
                case '(': {
                    builder.append("\\(");
                    continue block19;
                }
                case ')': {
                    builder.append("\\)");
                    continue block19;
                }
                case '{': {
                    builder.append("\\{");
                    continue block19;
                }
                case '}': {
                    builder.append("\\}");
                    continue block19;
                }
                default: {
                    if (c <= ' ' || c > '~') {
                        builder.append(String.format("\\u%04x", c));
                        continue block19;
                    }
                    builder.append(c);
                }
            }
        }
        return builder.toString();
    }

    static Matcher ignoreCase(Matcher matcher) {
        if (matcher instanceof CharClassMatcher) {
            CharClassMatcher m = (CharClassMatcher)matcher.as();
            return new CharClassMatcher(m.set(), true);
        }
        if (matcher instanceof CharSeqMatcher) {
            CharSeqMatcher m = (CharSeqMatcher)matcher.as();
            return new CharSeqMatcher(m.pattern(), true);
        }
        if (matcher instanceof IndexOfMatcher) {
            IndexOfMatcher m = (IndexOfMatcher)matcher.as();
            return new IndexOfMatcher(m.pattern(), m.next(), true);
        }
        if (matcher instanceof StartsWithMatcher) {
            StartsWithMatcher m = (StartsWithMatcher)matcher.as();
            return new StartsWithMatcher(m.pattern(), true);
        }
        return matcher;
    }

    static Matcher head(Matcher matcher) {
        if (matcher instanceof SeqMatcher) {
            List<Matcher> ms = ((SeqMatcher)matcher.as()).matchers();
            return ms.get(0);
        }
        return matcher;
    }

    static Matcher tail(Matcher matcher) {
        if (matcher instanceof SeqMatcher) {
            List<Matcher> ms = ((SeqMatcher)matcher.as()).matchers();
            return SeqMatcher.create(ms.subList(1, ms.size()));
        }
        return TrueMatcher.INSTANCE;
    }

    static Matcher getPrefix(Matcher matcher) {
        if (matcher instanceof SeqMatcher) {
            List<Matcher> ms = ((SeqMatcher)matcher.as()).matchers();
            return ms.get(0);
        }
        if (matcher instanceof ZeroOrMoreMatcher) {
            ZeroOrMoreMatcher zm = (ZeroOrMoreMatcher)matcher.as();
            return new ZeroOrMoreMatcher(zm.repeated(), TrueMatcher.INSTANCE);
        }
        if (matcher instanceof CharSeqMatcher) {
            String pattern = ((CharSeqMatcher)matcher.as()).pattern();
            return pattern.isEmpty() ? null : new CharSeqMatcher(pattern.charAt(0));
        }
        return matcher;
    }

    static Matcher getSuffix(Matcher matcher) {
        if (matcher instanceof SeqMatcher) {
            List<Matcher> ms = ((SeqMatcher)matcher.as()).matchers();
            return SeqMatcher.create(ms.subList(1, ms.size()));
        }
        if (matcher instanceof ZeroOrMoreMatcher) {
            ZeroOrMoreMatcher zm = (ZeroOrMoreMatcher)matcher.as();
            return zm.next();
        }
        if (matcher instanceof CharSeqMatcher) {
            String pattern = ((CharSeqMatcher)matcher.as()).pattern();
            return pattern.length() <= 1 ? TrueMatcher.INSTANCE : new CharSeqMatcher(pattern.substring(1));
        }
        return TrueMatcher.INSTANCE;
    }
}

