/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.ssh.SshConnection;
import com.xebialabs.overthere.ssh.SshSftpFile;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.Closeable;
import java.io.IOException;
import net.schmizz.sshj.sftp.SFTPClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SshSftpConnection
extends SshConnection {
    private SFTPClient sharedSftpClient;
    private static Logger logger = LoggerFactory.getLogger(SshSftpConnection.class);

    public SshSftpConnection(String type, ConnectionOptions options, AddressPortMapper mapper) {
        super(type, options, mapper);
    }

    @Override
    protected void connect() {
        super.connect();
    }

    @Override
    public void doClose() {
        if (this.sharedSftpClient != null) {
            this.disconnectSftp(this.sharedSftpClient);
            this.sharedSftpClient = null;
        }
        super.doClose();
    }

    @Override
    public OverthereFile getFile(String hostPath) throws RuntimeIOException {
        return new SshSftpFile(this, hostPath);
    }

    SFTPClient getSharedSftpClient() {
        if (this.sharedSftpClient == null) {
            this.sharedSftpClient = this.connectSftp();
        }
        return this.sharedSftpClient;
    }

    SFTPClient connectSftp() {
        logger.debug("Opening SFTP client to {}", (Object)this);
        try {
            return this.getSshClient().newSFTPClient();
        }
        catch (IOException e) {
            throw new RuntimeIOException(String.format("Cannot start SFTP session for %s", this), e);
        }
    }

    void disconnectSftp(SFTPClient sftp) {
        logger.debug("Closing SFTP client to {}", (Object)this);
        OverthereUtils.closeQuietly((Closeable)sftp);
    }

    protected abstract String pathToSftpPath(String var1);
}

