/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.gcp;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.Strings;
import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.Instance;
import com.google.api.services.compute.model.Metadata;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.compute.model.Project;
import com.google.auth.http.HttpCredentialsAdapter;
import com.xebialabs.overthere.gcp.GcpKeyManager;
import com.xebialabs.overthere.gcp.GcpSshKey;
import com.xebialabs.overthere.gcp.GenerateSshKey;
import com.xebialabs.overthere.gcp.SshKeyPair;
import com.xebialabs.overthere.gcp.credentials.GcpCredentialFactory;
import com.xebialabs.overthere.gcp.credentials.ProjectCredentials;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcpMetadataKeyManager
implements GcpKeyManager {
    private static final Logger logger = LoggerFactory.getLogger(GcpMetadataKeyManager.class);
    private static final String SSH_KEYS_KEYNAME = "ssh-keys";
    private static final String SSH_KEYS_USERNAME = "google-ssh";
    private static HttpTransport httpTransport;
    private static final JsonFactory gsonFactory;
    private final GcpCredentialFactory gcpCredentialFactory;
    private final GenerateSshKey generateSshKey;
    private ProjectCredentials projectCredentials;
    private GcpSshKey gcpSshKey;
    private Compute computeService;
    private final String zoneName;
    private final String instanceId;
    private final String username;
    private final String applicationName;

    GcpMetadataKeyManager(GenerateSshKey generateSshKey, GcpCredentialFactory gcpCredentialFactory, String zoneName, String instanceId, String username, String applicationName) {
        this.generateSshKey = generateSshKey;
        this.gcpCredentialFactory = gcpCredentialFactory;
        this.zoneName = zoneName;
        this.instanceId = instanceId;
        this.username = username;
        this.applicationName = applicationName;
    }

    @Override
    public GcpKeyManager init() {
        this.projectCredentials = this.gcpCredentialFactory.create();
        this.computeService = this.createComputeService();
        return this;
    }

    @Override
    public GcpSshKey refreshKey(long expiryInMs, int keySize) {
        if (this.gcpSshKey == null || System.currentTimeMillis() + 1000L > this.gcpSshKey.getExpirationTimeMs()) {
            SshKeyPair sshKeyPair = this.generateSshKey.generate(SSH_KEYS_USERNAME, keySize);
            long expirationTimeMs = System.currentTimeMillis() + expiryInMs;
            if (this.instanceId == null) {
                this.addKeyToProject(sshKeyPair.getPublicKey(), expirationTimeMs);
            } else {
                this.addKeyToInstance(sshKeyPair.getPublicKey(), expirationTimeMs);
            }
            logger.debug("Using new key pair for user {} it expires at {} ms", (Object)this.username, (Object)expirationTimeMs);
            this.gcpSshKey = new GcpSshKey(sshKeyPair, this.username, expirationTimeMs);
        }
        return this.gcpSshKey;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getUsername() {
        return this.username;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    private void addKeyToInstance(String publicKey, long expiryInMs) {
        try {
            Compute.Instances instances = this.computeService.instances();
            Instance instance = (Instance)instances.get(this.projectCredentials.getProjectId(), this.zoneName, this.instanceId).execute();
            Metadata metadata = instance.getMetadata();
            this.updateSshKey(metadata, publicKey, expiryInMs);
            Operation operation = (Operation)instances.setMetadata(this.projectCredentials.getProjectId(), this.zoneName, this.instanceId, metadata).execute();
            this.checkForOperationErrors(operation);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot install key pairs on project " + this.projectCredentials.getProjectId() + " and instance " + this.instanceId + " for username " + this.username, e);
        }
    }

    private void addKeyToProject(String publicKey, long expiryInMs) {
        try {
            Compute.Projects projects = this.computeService.projects();
            Project project = (Project)projects.get(this.projectCredentials.getProjectId()).execute();
            Metadata metadata = project.getCommonInstanceMetadata();
            this.updateSshKey(metadata, publicKey, expiryInMs);
            Operation operation = (Operation)projects.setCommonInstanceMetadata(this.projectCredentials.getProjectId(), metadata).execute();
            this.checkForOperationErrors(operation);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot install key pairs on project " + this.projectCredentials.getProjectId() + " for username " + this.username, e);
        }
    }

    protected void updateSshKey(Metadata metadata, String publicKey, long expiryInMs) {
        List items = metadata.getItems();
        ListIterator<Metadata.Items> itemsListIterator = items.listIterator();
        boolean updated = false;
        while (itemsListIterator.hasNext()) {
            Metadata.Items currentItem = (Metadata.Items)itemsListIterator.next();
            if (!SSH_KEYS_KEYNAME.equals(currentItem.getKey())) continue;
            itemsListIterator.set(this.composeSshKeyItem(currentItem.getValue(), publicKey, expiryInMs));
            updated = true;
            break;
        }
        if (!updated) {
            itemsListIterator.add(this.composeSshKeyItem(null, publicKey, expiryInMs));
        }
    }

    protected Metadata.Items composeSshKeyItem(String sshKeys, String publicKey, long expiryInMs) {
        if (Strings.isNullOrEmpty((String)sshKeys)) {
            return new Metadata.Items().setKey(SSH_KEYS_KEYNAME).setValue(this.composeSshKeyLine(publicKey, expiryInMs));
        }
        String[] sshKeysSplit = sshKeys.split("\n");
        StringBuilder resultSshKeys = new StringBuilder();
        for (String line : sshKeysSplit) {
            if (this.isUsernameInLine(line)) continue;
            resultSshKeys.append(line).append('\n');
        }
        resultSshKeys.append(this.composeSshKeyLine(publicKey, expiryInMs));
        return new Metadata.Items().setKey(SSH_KEYS_KEYNAME).setValue(resultSshKeys.toString());
    }

    protected boolean isUsernameInLine(String line) {
        return line != null && line.trim().startsWith(this.username);
    }

    protected String composeSshKeyLine(String publicKey, long expiryInMs) {
        return this.username + ":" + publicKey.replace('\n', ' ') + " {\"userName\":\"" + this.username + "\",\"expireOn\":\"" + GcpMetadataKeyManager.getISO8601StringForDate(expiryInMs) + "\"}";
    }

    private void checkForOperationErrors(Operation operation) {
        if (operation.getError() != null && operation.getError().getErrors() != null && !operation.getError().getErrors().isEmpty()) {
            Operation.Error.Errors errors = (Operation.Error.Errors)operation.getError().getErrors().get(0);
            throw new IllegalStateException("Cannot install key pairs on project " + this.projectCredentials.getProjectId() + " for username " + this.username + ": " + errors.getMessage());
        }
    }

    private Compute createComputeService() {
        if (this.projectCredentials.getOauth2Credential() != null) {
            return new Compute.Builder(httpTransport, gsonFactory, null).setApplicationName(this.applicationName).setHttpRequestInitializer((HttpRequestInitializer)this.projectCredentials.getOauth2Credential()).build();
        }
        return new Compute.Builder(httpTransport, gsonFactory, (HttpRequestInitializer)new HttpCredentialsAdapter(this.projectCredentials.getCredentials())).setApplicationName(this.applicationName).build();
    }

    private static String getISO8601StringForDate(long date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss+0000", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(date);
    }

    static {
        gsonFactory = GsonFactory.getDefaultInstance();
        try {
            httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create new trusted transport", e);
        }
    }
}

