/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere;

import com.xebialabs.overthere.CmdLineArgument;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CmdLine
implements Serializable {
    List<CmdLineArgument> arguments = new ArrayList<CmdLineArgument>();

    public CmdLine addArgument(String arg) {
        this.arguments.add(CmdLineArgument.arg(arg));
        return this;
    }

    public CmdLine addPassword(String arg) {
        this.arguments.add(CmdLineArgument.password(arg));
        return this;
    }

    public CmdLine addRaw(String arg) {
        this.arguments.add(CmdLineArgument.raw(arg));
        return this;
    }

    public CmdLine addTemplatedFragment(String template, Object ... variables) {
        for (String arg : template.split("\\s+")) {
            if (arg.matches(".*\\{\\d+}\\.*")) {
                String fragment = MessageFormat.format(arg, variables);
                this.addArgument(fragment);
                continue;
            }
            this.addRaw(arg);
        }
        return this;
    }

    public CmdLine addNested(CmdLine commandLine) {
        this.arguments.add(CmdLineArgument.nested(commandLine));
        return this;
    }

    public CmdLine add(CmdLineArgument arg) {
        OverthereUtils.checkNotNull(arg, "Cannot add null CmdLineArgument", new Object[0]);
        this.arguments.add(arg);
        return this;
    }

    public CmdLine add(List<CmdLineArgument> args) {
        OverthereUtils.checkNotNull(args, "Cannot add null List<CmdLineArgument>", new Object[0]);
        this.arguments.addAll(args);
        return this;
    }

    public List<CmdLineArgument> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    public String[] toCommandArray(OperatingSystemFamily os, boolean forLogging) {
        OverthereUtils.checkState(this.arguments.size() > 0, "Cannot encode empty command line", new Object[0]);
        String[] args = new String[this.arguments.size()];
        for (int i = 0; i < this.arguments.size(); ++i) {
            args[i] = this.arguments.get(i).toString(os, forLogging);
        }
        return args;
    }

    public String toCommandLine(OperatingSystemFamily os, boolean forLogging) {
        OverthereUtils.checkState(this.arguments.size() > 0, "Cannot encode empty command line", new Object[0]);
        StringBuilder sb = new StringBuilder();
        for (CmdLineArgument a : this.arguments) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            a.buildString(os, forLogging, sb);
        }
        return sb.toString();
    }

    public String toString() {
        return this.toCommandLine(OperatingSystemFamily.UNIX, true);
    }

    public static CmdLine build(String ... args) {
        CmdLine cmdLine = new CmdLine();
        for (String s : args) {
            cmdLine.addArgument(s);
        }
        return cmdLine;
    }
}

