/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cytodynamics.nucleus;

import com.linkedin.cytodynamics.exception.CytodynamicsClassNotFoundException;
import com.linkedin.cytodynamics.isolation.Chooser;
import com.linkedin.cytodynamics.isolation.ChooserMappingFactory;
import com.linkedin.cytodynamics.nucleus.Api;
import com.linkedin.cytodynamics.nucleus.DelegateRelationship;
import com.linkedin.cytodynamics.nucleus.IsolationLevel;
import com.linkedin.cytodynamics.nucleus.LogApiAdapter;
import com.linkedin.cytodynamics.nucleus.Logger;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class IsolatingClassLoader
extends URLClassLoader {
    private static final Logger LOGGER = LogApiAdapter.getLogger(IsolatingClassLoader.class);
    private static final Map<IsolationLevel, Chooser<Class<?>>> CLASS_CHOOSER_MAPPING = ChooserMappingFactory.buildChooserMapping(delegate -> LOGGER.warn(String.format("Class %s used from the delegate classloader would not be visible if running under FULL isolation, unless whitelisting is used.", delegate.getName())));
    private static final Map<IsolationLevel, Chooser<URL>> RESOURCE_CHOOSER_MAPPING = ChooserMappingFactory.buildChooserMapping(delegate -> LOGGER.warn(String.format("Resource %s used from the delegate classloader would not be visible if running under FULL isolation, unless whitelisting is used.", delegate.toString())));
    private static final Map<IsolationLevel, Chooser<List<URL>>> RESOURCES_CHOOSER_MAPPING = ChooserMappingFactory.buildChooserMappingForList(delegate -> LOGGER.warn(String.format("Resources [%s] used from the delegate classloader would not be visible if running under FULL isolation, unless whitelisting is used.", delegate.stream().map(URL::toString).collect(Collectors.joining(",")))));
    private final DelegateRelationship parentRelationship;
    private final List<DelegateRelationship> fallbackDelegates;

    IsolatingClassLoader(URL[] classpath, DelegateRelationship parentRelationship, List<DelegateRelationship> fallbackDelegates) {
        super(classpath, parentRelationship.getDelegateClassLoader());
        this.parentRelationship = parentRelationship;
        this.fallbackDelegates = fallbackDelegates;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> cl = this.findLoadedClass(name);
            if (cl == null) {
                cl = this.tryLoadClassWithDelegate(name, this.parentRelationship);
            }
            if (cl == null) {
                DelegateRelationship fallbackDelegate;
                Iterator<DelegateRelationship> iterator = this.fallbackDelegates.iterator();
                while (iterator.hasNext() && (cl = this.tryLoadClassWithDelegate(name, fallbackDelegate = iterator.next())) == null) {
                }
            }
            if (cl != null) {
                if (resolve) {
                    this.doResolveClass(cl);
                }
                return cl;
            }
            throw new CytodynamicsClassNotFoundException(String.format("Could not fully load class for name %s. It is possible that the immediate class is found, but a class that it depends on cannot be found", name));
        }
    }

    @Override
    public URL getResource(String name) {
        URL resource = this.tryLoadResourceWithDelegate(name, this.parentRelationship);
        if (resource != null) {
            return resource;
        }
        for (DelegateRelationship fallbackDelegate : this.fallbackDelegates) {
            resource = this.tryLoadResourceWithDelegate(name, fallbackDelegate);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        LinkedHashSet<URL> resources = new LinkedHashSet<URL>(this.loadResourcesWithDelegate(name, this.parentRelationship));
        for (DelegateRelationship fallbackDelegate : this.fallbackDelegates) {
            resources.addAll(this.loadResourcesWithDelegate(name, fallbackDelegate));
        }
        return Collections.enumeration(resources);
    }

    private Class<?> tryLoadClassWithDelegate(String name, DelegateRelationship delegateRelationship) {
        Class<?> delegateClass = null;
        boolean isBlacklisted = IsolatingClassLoader.matchesPredicate(delegateRelationship.getBlacklistedClassPredicates(), name);
        if (!isBlacklisted && (delegateClass = IsolatingClassLoader.tryLoadClass(delegateRelationship.getDelegateClassLoader(), name)) != null) {
            Class<?> apiAnnotationClass = IsolatingClassLoader.tryLoadClass(delegateRelationship.getDelegateClassLoader(), Api.class.getName());
            if (apiAnnotationClass != null && delegateClass.isAnnotationPresent(apiAnnotationClass)) {
                return delegateClass;
            }
            if (IsolatingClassLoader.matchesPredicate(delegateRelationship.getDelegatePreferredClassPredicates(), name)) {
                return delegateClass;
            }
        }
        Class<?> childClass = null;
        try {
            childClass = this.findClass(name);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            // empty catch block
        }
        Class<?> returnValue = CLASS_CHOOSER_MAPPING.get((Object)delegateRelationship.getIsolationLevel()).choose(delegateClass, childClass);
        if (returnValue == null && delegateClass != null && IsolatingClassLoader.matchesPredicate(delegateRelationship.getWhitelistedClassPredicates(), name)) {
            return delegateClass;
        }
        return returnValue;
    }

    private URL tryLoadResourceWithDelegate(String name, DelegateRelationship delegateRelationship) {
        URL delegateResource = null;
        boolean isBlacklisted = IsolatingClassLoader.matchesPredicate(delegateRelationship.getBlacklistedResourcePredicates(), name);
        if (!isBlacklisted && (delegateResource = delegateRelationship.getDelegateClassLoader().getResource(name)) != null && IsolatingClassLoader.matchesPredicate(delegateRelationship.getDelegatePreferredResourcePredicates(), name)) {
            return delegateResource;
        }
        URL childResource = this.findResource(name);
        URL returnValue = RESOURCE_CHOOSER_MAPPING.get((Object)delegateRelationship.getIsolationLevel()).choose(delegateResource, childResource);
        if (returnValue == null && delegateResource != null && IsolatingClassLoader.matchesPredicate(delegateRelationship.getWhitelistedResourcePredicates(), name)) {
            return delegateResource;
        }
        return returnValue;
    }

    private List<URL> loadResourcesWithDelegate(String name, DelegateRelationship delegateRelationship) throws IOException {
        LinkedHashSet<URL> resources = new LinkedHashSet<URL>();
        List<URL> delegateResources = Collections.emptyList();
        boolean isBlacklisted = IsolatingClassLoader.matchesPredicate(delegateRelationship.getBlacklistedResourcePredicates(), name);
        if (!isBlacklisted) {
            delegateResources = Collections.list(delegateRelationship.getDelegateClassLoader().getResources(name));
            if (IsolatingClassLoader.matchesPredicate(delegateRelationship.getDelegatePreferredResourcePredicates(), name)) {
                resources.addAll(delegateResources);
            }
        }
        ArrayList<URL> childResources = Collections.list(this.findResources(name));
        List<URL> chosenResources = IsolatingClassLoader.chooseResources(delegateRelationship, delegateResources, childResources);
        resources.addAll(chosenResources);
        if (IsolatingClassLoader.matchesPredicate(delegateRelationship.getWhitelistedResourcePredicates(), name)) {
            resources.addAll(delegateResources);
        }
        return new ArrayList<URL>(resources);
    }

    private static List<URL> chooseResources(DelegateRelationship delegateRelationship, List<URL> delegateResources, List<URL> childResources) {
        List<URL> delegateResourcesOrNull = delegateResources.isEmpty() ? null : delegateResources;
        List<URL> childResourcesOrNull = childResources.isEmpty() ? null : childResources;
        List<URL> chosenResourcesOrNull = RESOURCES_CHOOSER_MAPPING.get((Object)delegateRelationship.getIsolationLevel()).choose(delegateResourcesOrNull, childResourcesOrNull);
        return chosenResourcesOrNull == null ? Collections.emptyList() : chosenResourcesOrNull;
    }

    private static boolean matchesPredicate(Set<Predicate<String>> predicates, String value) {
        return predicates.stream().anyMatch(predicate -> predicate.test(value));
    }

    private static Class<?> tryLoadClass(ClassLoader classLoader, String name) {
        try {
            return classLoader.loadClass(name);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return null;
        }
    }

    void doResolveClass(Class<?> cl) {
        this.resolveClass(cl);
    }
}

