/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cytodynamics.nucleus;

import com.linkedin.cytodynamics.nucleus.DelegateRelationship;
import com.linkedin.cytodynamics.nucleus.IsolationLevel;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

public final class DelegateRelationshipBuilder {
    private ClassLoader delegateClassLoader = this.getClass().getClassLoader();
    private IsolationLevel isolationLevel = IsolationLevel.NONE;
    private Set<Predicate<String>> delegatePreferredClassPredicates = new HashSet<Predicate<String>>();
    private Set<Predicate<String>> blacklistedClassPredicates = new HashSet<Predicate<String>>();
    private Set<Predicate<String>> whitelistedClassPredicates = new HashSet<Predicate<String>>();
    private Set<Predicate<String>> delegatePreferredResourcePredicates = new HashSet<Predicate<String>>();
    private Set<Predicate<String>> blacklistedResourcePredicates = new HashSet<Predicate<String>>();
    private Set<Predicate<String>> whitelistedResourcePredicates = new HashSet<Predicate<String>>();

    private DelegateRelationshipBuilder() {
    }

    public static DelegateRelationshipBuilder builder() {
        return new DelegateRelationshipBuilder();
    }

    public DelegateRelationshipBuilder withDelegateClassLoader(ClassLoader delegateClassLoader) {
        this.delegateClassLoader = delegateClassLoader;
        return this;
    }

    public DelegateRelationshipBuilder withIsolationLevel(IsolationLevel isolationLevel) {
        this.isolationLevel = isolationLevel;
        return this;
    }

    public DelegateRelationshipBuilder addDelegatePreferredClassPredicate(Predicate<String> predicate) {
        this.delegatePreferredClassPredicates.add(predicate);
        return this;
    }

    public DelegateRelationshipBuilder addBlacklistedClassPredicate(Predicate<String> predicate) {
        this.blacklistedClassPredicates.add(predicate);
        return this;
    }

    public DelegateRelationshipBuilder addWhitelistedClassPredicate(Predicate<String> predicate) {
        this.whitelistedClassPredicates.add(predicate);
        return this;
    }

    public DelegateRelationshipBuilder addDelegatePreferredResourcePredicate(Predicate<String> predicate) {
        this.delegatePreferredResourcePredicates.add(predicate);
        return this;
    }

    public DelegateRelationshipBuilder addBlacklistedResourcePredicate(Predicate<String> predicate) {
        this.blacklistedResourcePredicates.add(predicate);
        return this;
    }

    public DelegateRelationshipBuilder addWhitelistedResourcePredicate(Predicate<String> predicate) {
        this.whitelistedResourcePredicates.add(predicate);
        return this;
    }

    public DelegateRelationship build() {
        return new DelegateRelationship(this.delegateClassLoader, this.isolationLevel, this.delegatePreferredClassPredicates, this.blacklistedClassPredicates, this.whitelistedClassPredicates, this.delegatePreferredResourcePredicates, this.blacklistedResourcePredicates, this.whitelistedResourcePredicates);
    }
}

