/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cytodynamics.matcher;

import java.util.function.Predicate;
import java.util.regex.Pattern;

public class GlobMatcher
implements Predicate<String> {
    private final Pattern pattern;

    public GlobMatcher(String globPattern) {
        StringBuilder builder = new StringBuilder();
        char[] globPatternChars = globPattern.toCharArray();
        StringBuilder currentToken = new StringBuilder();
        block4: for (char globPatternChar : globPatternChars) {
            switch (globPatternChar) {
                case '*': {
                    if (currentToken.length() != 0) {
                        builder.append(Pattern.quote(currentToken.toString()));
                        currentToken = new StringBuilder();
                    }
                    builder.append(".*");
                    continue block4;
                }
                case '?': {
                    if (currentToken.length() != 0) {
                        builder.append(Pattern.quote(currentToken.toString()));
                        currentToken = new StringBuilder();
                    }
                    builder.append(".");
                    continue block4;
                }
                default: {
                    currentToken.append(globPatternChar);
                }
            }
        }
        if (currentToken.length() != 0) {
            builder.append(Pattern.quote(currentToken.toString()));
        }
        String regexPattern = builder.toString();
        this.pattern = Pattern.compile(regexPattern);
    }

    @Override
    public boolean test(String toMatch) {
        return this.pattern.matcher(toMatch).matches();
    }
}

