/*
 * Decompiled with CFR 0.152.
 */
package sttp.client3.internal;

import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import sttp.client3.ByteArrayBody;
import sttp.client3.ByteBufferBody;
import sttp.client3.FileBody;
import sttp.client3.InputStreamBody;
import sttp.client3.MultipartBody;
import sttp.client3.NoBody$;
import sttp.client3.RequestBody;
import sttp.client3.RequestT;
import sttp.client3.StreamBody;
import sttp.client3.StringBody;
import sttp.client3.internal.SttpFile;
import sttp.client3.internal.ToCurlConverter$;
import sttp.model.Header;
import sttp.model.HeaderNames$;
import sttp.model.Method;
import sttp.model.Part;

@ScalaSignature(bytes="\u0006\u0005\u0005%c\u0001\u0002\t\u0012\u0001aAQ\u0001\t\u0001\u0005\u0002\u0005BQ!\u0013\u0001\u0005\u0002)CQ!\u0013\u0001\u0005\u0002UCQ\u0001\u0018\u0001\u0005\nuCQ\u0001\u0019\u0001\u0005\n\u0005DQa\u0019\u0001\u0005\n\u0011DQa\u001a\u0001\u0005\n!DQA\u001b\u0001\u0005\u0002-Dq!a\u0002\u0001\t\u0013\tI\u0001C\u0004\u0002\u000e\u0001!I!a\u0004\t\u000f\u0005m\u0001\u0001\"\u0003\u0002\u001e\u001d9\u0011qD\t\t\u0002\u0005\u0005bA\u0002\t\u0012\u0011\u0003\t\u0019\u0003\u0003\u0004!\u001b\u0011\u0005\u0011Q\u0005\u0005\b\u0003OiA\u0011AA\u0015\u0005=!vnQ;sY\u000e{gN^3si\u0016\u0014(B\u0001\n\u0014\u0003!Ig\u000e^3s]\u0006d'B\u0001\u000b\u0016\u0003\u001d\u0019G.[3oiNR\u0011AF\u0001\u0005gR$\bo\u0001\u0001\u0016\u0005e13C\u0001\u0001\u001b!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\t\t\u0004G\u0001!S\"A\t\u0011\u0005\u00152C\u0002\u0001\u0003\u0006O\u0001\u0011\r\u0001\u000b\u0002\u0002%F\u0011\u0011\u0006\f\t\u00037)J!a\u000b\u000f\u0003\u000f9{G\u000f[5oOB\u001aQ\u0006Q$\u0011\u000b9z\u0013g\u0010$\u000e\u0003MI!\u0001M\n\u0003\u0011I+\u0017/^3tiR\u0003\"A\r\u001f\u000f\u0005MRdB\u0001\u001b:\u001d\t)\u0004(D\u00017\u0015\t9t#\u0001\u0004=e>|GOP\u0005\u0002-%\u0011A#F\u0005\u0003wM\tq\u0001]1dW\u0006<W-\u0003\u0002>}\tA\u0011\nZ3oi&$\u0018P\u0003\u0002<'A\u0011Q\u0005\u0011\u0003\n\u0003\u001a\n\t\u0011!A\u0003\u0002\t\u00131a\u0018\u00132#\tI3\t\u0005\u0002\u001c\t&\u0011Q\t\b\u0002\u0004\u0003:L\bCA\u0013H\t%Ae%!A\u0001\u0002\u000b\u0005!IA\u0002`II\nQ!\u00199qYf$\"aS*\u0011\u00051\u0003fBA'O!\t)D$\u0003\u0002P9\u00051\u0001K]3eK\u001aL!!\u0015*\u0003\rM#(/\u001b8h\u0015\tyE\u0004C\u0003U\u0005\u0001\u0007A%A\u0004sKF,Xm\u001d;\u0015\u0007-3v\u000bC\u0003U\u0007\u0001\u0007A\u0005C\u0003Y\u0007\u0001\u0007\u0011,\u0001\ttK:\u001c\u0018\u000e^5wK\"+\u0017\rZ3sgB\u0019AJW&\n\u0005m\u0013&aA*fi\u0006iQ\r\u001f;sC\u000e$X*\u001a;i_\u0012$\"a\u00130\t\u000b}#\u0001\u0019\u0001\u0013\u0002\u0003I\f!\"\u001a=ue\u0006\u001cG/\u0016:m)\tY%\rC\u0003`\u000b\u0001\u0007A%\u0001\bfqR\u0014\u0018m\u0019;IK\u0006$WM]:\u0015\u0007-+g\rC\u0003`\r\u0001\u0007A\u0005C\u0003Y\r\u0001\u0007\u0011,A\u0006fqR\u0014\u0018m\u0019;C_\u0012LHCA&j\u0011\u0015yv\u00011\u0001%\u0003MA\u0017M\u001c3mK6+H\u000e^5qCJ$(i\u001c3z)\tYE\u000eC\u0003n\u0011\u0001\u0007a.A\u0003qCJ$8\u000fE\u0002pgZt!\u0001\u001d:\u000f\u0005U\n\u0018\"A\u000f\n\u0005mb\u0012B\u0001;v\u0005\r\u0019V-\u001d\u0006\u0003wq\u00012a\u001e>}\u001b\u0005A(BA=\u0016\u0003\u0015iw\u000eZ3m\u0013\tY\bP\u0001\u0003QCJ$\bgA?\u0002\u0004A!aF`A\u0001\u0013\ty8CA\u0006SKF,Xm\u001d;C_\u0012L\bcA\u0013\u0002\u0004\u0011Q\u0011Q\u00017\u0002\u0002\u0003\u0005)\u0011\u0001\"\u0003\u0007}#3'\u0001\bfqR\u0014\u0018m\u0019;PaRLwN\\:\u0015\u0007-\u000bY\u0001C\u0003`\u0013\u0001\u0007A%\u0001\nbI\u0012\u001c\u0006/Y2f\u0013\u001atu\u000e^#naRLH\u0003BA\t\u0003/\u0001RaGA\nI-K1!!\u0006\u001d\u0005%1UO\\2uS>t\u0017\u0007C\u0004\u0002\u001a)\u0001\r!!\u0005\u0002\r\u0019Le\u000e];u\u0003\u001dqWm\u001e7j]\u0016,\u0012aS\u0001\u0010)>\u001cUO\u001d7D_:4XM\u001d;feB\u00111%D\n\u0003\u001bi!\"!!\t\u0002\u001bI,\u0017/^3tiR{7)\u001e:m+\u0011\tY#!\r\u0016\u0005\u00055\u0002\u0003B\u0012\u0001\u0003_\u00012!JA\u0019\t\u00199sB1\u0001\u00024E\u0019\u0011&!\u000e1\r\u0005]\u0012qHA#!\u001d\u0011\u0014\u0011HA\u001f\u0003\u0007J1!a\u000f?\u0005\u001d\u0011V-];fgR\u00042!JA \t-\t\t%!\r\u0002\u0002\u0003\u0005)\u0011\u0001\"\u0003\u0007}#C\u0007E\u0002&\u0003\u000b\"1\"a\u0012\u00022\u0005\u0005\t\u0011!B\u0001\u0005\n\u0019q\fJ\u001b")
public class ToCurlConverter<R extends RequestT<Object, ?, ?>> {
    public static <R extends RequestT<?, ?, ?>> ToCurlConverter<R> requestToCurl() {
        return ToCurlConverter$.MODULE$.requestToCurl();
    }

    public String apply(R request) {
        return this.apply(request, (Set<String>)HeaderNames$.MODULE$.SensitiveHeaders());
    }

    public String apply(R request, Set<String> sensitiveHeaders) {
        String params = (String)((Function1)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)x$1 -> this.extractMethod(x$1), (Function1 & Serializable)x$2 -> this.extractUrl(x$2), (Function1 & Serializable)r -> this.extractHeaders(r, sensitiveHeaders), (Function1 & Serializable)x$3 -> this.extractBody(x$3), (Function1 & Serializable)x$4 -> this.extractOptions(x$4)}))).map((Function1 & Serializable)fInput -> this.addSpaceIfNotEmpty((Function1)fInput)).reduce((Function2 & Serializable)(acc, item) -> (Function1 & Serializable)r -> (String)acc.apply(r) + item.apply(r))).apply(request);
        return "curl" + params;
    }

    private String extractMethod(R r) {
        return "--request " + ((Method)((RequestT)r).method()).method();
    }

    private String extractUrl(R r) {
        return "--url '" + ((RequestT)r).uri() + "'";
    }

    private String extractHeaders(R r, Set<String> sensitiveHeaders) {
        return ((IterableOnceOps)((IterableOps)((RequestT)r).headers().filterNot((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ToCurlConverter.$anonfun$extractHeaders$1(x$5)))).map((Function1 & Serializable)h -> "--header '" + h.toStringSafe(sensitiveHeaders) + "'")).mkString(this.newline());
    }

    private String extractBody(R r) {
        Object object;
        RequestBody requestBody = ((RequestT)r).body();
        if (requestBody instanceof StringBody) {
            StringBody stringBody = (StringBody)requestBody;
            String text = stringBody.s();
            object = "--data-raw '" + text.replace("'", "\\'") + "'";
        } else if (requestBody instanceof ByteArrayBody) {
            object = "--data-binary <PLACEHOLDER>";
        } else if (requestBody instanceof ByteBufferBody) {
            object = "--data-binary <PLACEHOLDER>";
        } else if (requestBody instanceof InputStreamBody) {
            object = "--data-binary <PLACEHOLDER>";
        } else if (requestBody instanceof StreamBody) {
            object = "--data-binary <PLACEHOLDER>";
        } else if (requestBody instanceof MultipartBody) {
            MultipartBody multipartBody = (MultipartBody)requestBody;
            Seq parts = multipartBody.parts();
            object = this.handleMultipartBody(parts);
        } else if (requestBody instanceof FileBody) {
            FileBody fileBody = (FileBody)requestBody;
            SttpFile file = fileBody.f();
            object = "--data-binary @" + file.name();
        } else if (NoBody$.MODULE$.equals(requestBody)) {
            object = "";
        } else {
            throw new MatchError(requestBody);
        }
        return object;
    }

    public String handleMultipartBody(Seq<Part<RequestBody<?>>> parts) {
        return ((IterableOnceOps)parts.map((Function1 & Serializable)p -> {
            Object object;
            RequestBody requestBody = (RequestBody)p.body();
            if (requestBody instanceof StringBody) {
                StringBody stringBody = (StringBody)requestBody;
                String s = stringBody.s();
                object = "--form '" + p.name() + "=" + s + "'";
            } else if (requestBody instanceof FileBody) {
                FileBody fileBody = (FileBody)requestBody;
                SttpFile f = fileBody.f();
                object = "--form '" + p.name() + "=@" + f.name() + "'";
            } else {
                object = "--data-binary <PLACEHOLDER>";
            }
            return object;
        })).mkString(this.newline());
    }

    private String extractOptions(R r) {
        return ((RequestT)r).options().followRedirects() ? "--location" + this.newline() + "--max-redirs " + ((RequestT)r).options().maxRedirects() : "";
    }

    private Function1<R, String> addSpaceIfNotEmpty(Function1<R, String> fInput) {
        return (Function1 & Serializable)t -> ((String)fInput.apply(t)).isEmpty() ? "" : this.newline() + fInput.apply(t);
    }

    private String newline() {
        return " \\\n  ";
    }

    public static final /* synthetic */ boolean $anonfun$extractHeaders$1(Header x$5) {
        return x$5.name().equalsIgnoreCase(HeaderNames$.MODULE$.AcceptEncoding());
    }
}

