/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.common.scala.config;

import io.circe.Decoder;
import io.circe.DecodingFailure$;
import io.circe.Error;
import io.conduktor.clustersconfig.ClustersConfig;
import io.conduktor.clustersconfig.api.ClustersConfigSerializationService;
import io.conduktor.clustersconfig.api.ClustersConfigSerializationService$;
import io.conduktor.clustersconfig.api.models.ClusterDefinition;
import io.conduktor.clustersconfig.cluster;
import io.conduktor.clustersconfig.jmx;
import io.conduktor.clustersconfig.kafkaconnect;
import io.conduktor.clustersconfig.ksql;
import io.conduktor.clustersconfig.properties;
import io.conduktor.common.scala.config.CantWriteKeyStoreFileError;
import io.conduktor.common.scala.config.ConfigError;
import io.conduktor.common.scala.config.ConfigurationCorrupted$;
import io.conduktor.common.scala.config.ConfigurationIsNotFile;
import io.conduktor.common.scala.config.ExternalConfiguration;
import io.conduktor.common.scala.config.ExternalConfigurationService;
import io.conduktor.common.scala.config.RequiresPassword$;
import io.conduktor.common.scala.config.SerializationError;
import io.conduktor.common.scala.config.UnexpectedError;
import io.conduktor.common.scala.config.UnsupportedFormat;
import io.conduktor.primitives.types.Password;
import io.conduktor.primitives.types.Password$;
import io.conduktor.primitives.types.Port;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import zio.Accessible$;
import zio.CanFail$;
import zio.Chunk;
import zio.Has;
import zio.Has$;
import zio.IO$;
import zio.Task$;
import zio.ZIO;
import zio.ZIO$;
import zio.blocking.package;
import zio.prelude.AssociativeBoth$;
import zio.prelude.Invariant$;
import zio.prelude.package$;
import zio.stream.ZStream$;

public final class ExternalConfigurationService$ {
    public static final ExternalConfigurationService$ MODULE$ = new ExternalConfigurationService$();

    public ZIO<Has<ClustersConfigSerializationService>, ConfigError, Object> requirePassword(String rawConfig) {
        return ClustersConfigSerializationService$.MODULE$.apply((Function1 & Serializable)x$1 -> x$1.requiresPassword(ClustersConfigSerializationService.SerializedConfiguration$.MODULE$.apply(rawConfig)), Tag$.MODULE$.apply(ClustersConfigSerializationService.class, LightTypeTag$.MODULE$.parse(113249926, "\u0004\u0000\u0001Bio.conduktor.clustersconfig.api.ClustersConfigSerializationService\u0001\u0001", "\u0000\u0000\u0000", 21)), Accessible$.MODULE$.anyIsAny()).mapError((Function1 & Serializable)x$2 -> new UnsupportedFormat("Unsupported configuration."), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<ExternalConfigurationService>, ConfigError, Option<Tuple2<ExternalConfiguration, String>>> refreshAsString(ExternalConfiguration configuration) {
        return ZIO.AccessMPartiallyApplied$.MODULE$.apply$extension(ZIO$.MODULE$.accessM(), (Function1 & Serializable)x$3 -> ((ExternalConfigurationService)Has.HasSyntax$.MODULE$.get$extension(Has$.MODULE$.HasSyntax(x$3), (.less.colon.less)$less$colon$less$.MODULE$.refl(), Tag$.MODULE$.apply(ExternalConfigurationService.class, LightTypeTag$.MODULE$.parse(790385662, "\u0004\u0000\u0001=io.conduktor.common.scala.config.ExternalConfigurationService\u0001\u0001", "\u0000\u0000\u0000", 21)))).refreshAsString(configuration));
    }

    public <T> ZIO<Has<ExternalConfigurationService>, ConfigError, Option<Tuple2<ExternalConfiguration, T>>> refresh(ExternalConfiguration configuration, Decoder<T> evidence$1) {
        return this.refreshAsString(configuration).flatMap((Function1 & Serializable)opt -> IO$.MODULE$.foreach(opt, (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ExternalConfiguration conf = (ExternalConfiguration)tuple2._1();
            String str = (String)tuple2._2();
            ZIO zIO = IO$.MODULE$.fromEither((Function0 & Serializable)() -> io.circe.parser.package$.MODULE$.decode(str, evidence$1)).mapBoth((Function1 & Serializable)cause -> new SerializationError((Error)cause), (Function1 & Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)conf), x$4), CanFail$.MODULE$.canFail());
            return zIO;
        }));
    }

    public ZIO<Has<ExternalConfigurationService>, ConfigError, Option<Tuple2<ExternalConfiguration, List<ClusterDefinition>>>> refreshClusterDefinition(ExternalConfiguration configuration) {
        return this.refreshAsString(configuration).flatMap((Function1 & Serializable)opt -> ZIO$.MODULE$.foreach(opt, (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ExternalConfiguration conf = (ExternalConfiguration)tuple2._1();
            String str = (String)tuple2._2();
            ZIO zIO = ClustersConfigSerializationService$.MODULE$.apply((Function1 & Serializable)x$5 -> x$5.read(ClustersConfigSerializationService.SerializedConfiguration$.MODULE$.apply(str), configuration.password().flatMap((Function1 & Serializable)x$6 -> Password$.MODULE$.from(x$6).toOption())), Tag$.MODULE$.apply(ClustersConfigSerializationService.class, LightTypeTag$.MODULE$.parse(113249926, "\u0004\u0000\u0001Bio.conduktor.clustersconfig.api.ClustersConfigSerializationService\u0001\u0001", "\u0000\u0000\u0000", 21)), Accessible$.MODULE$.anyIsAny()).mapBoth((Function1 & Serializable)x0$2 -> {
                Product product;
                ClustersConfigSerializationService.Error.ReadError readError = x0$2;
                if (readError instanceof ClustersConfigSerializationService.Error$.UnsupportedFormat) {
                    ClustersConfigSerializationService.Error$.UnsupportedFormat unsupportedFormat = (ClustersConfigSerializationService.Error$.UnsupportedFormat)readError;
                    String message = unsupportedFormat.message();
                    product = new UnsupportedFormat(message);
                } else if (readError instanceof ClustersConfigSerializationService.Error$.SerializationError) {
                    ClustersConfigSerializationService.Error$.SerializationError serializationError = (ClustersConfigSerializationService.Error$.SerializationError)readError;
                    String message = serializationError.message();
                    product = new SerializationError((Error)DecodingFailure$.MODULE$.apply(message, (Function0 & Serializable)() -> scala.package$.MODULE$.List().empty()));
                } else if (readError instanceof ClustersConfigSerializationService.Error$.UnreadableResource) {
                    ClustersConfigSerializationService.Error$.UnreadableResource unreadableResource = (ClustersConfigSerializationService.Error$.UnreadableResource)readError;
                    String message = unreadableResource.message();
                    product = new ConfigurationIsNotFile(message);
                } else if (ClustersConfigSerializationService.Error$.CompromiseContent$.MODULE$.equals(readError)) {
                    product = ConfigurationCorrupted$.MODULE$;
                } else if (ClustersConfigSerializationService.Error$.RequiresPassword$.MODULE$.equals(readError)) {
                    product = RequiresPassword$.MODULE$;
                } else {
                    throw new MatchError((Object)readError);
                }
                return product;
            }, (Function1 & Serializable)x$7 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)conf), (Object)x$7.definitions()), CanFail$.MODULE$.canFail());
            return zIO;
        }));
    }

    public ZIO<Has<ClustersConfigSerializationService>, ConfigError, List<ClusterDefinition>> importClusterDefinition(Path configBasePath, String configuration, Option<Password> password) {
        return ClustersConfigSerializationService$.MODULE$.apply((Function1 & Serializable)x$8 -> x$8.read(ClustersConfigSerializationService.SerializedConfiguration$.MODULE$.apply(configuration), password), Tag$.MODULE$.apply(ClustersConfigSerializationService.class, LightTypeTag$.MODULE$.parse(113249926, "\u0004\u0000\u0001Bio.conduktor.clustersconfig.api.ClustersConfigSerializationService\u0001\u0001", "\u0000\u0000\u0000", 21)), Accessible$.MODULE$.anyIsAny()).mapError((Function1 & Serializable)x0$1 -> {
            Product product;
            ClustersConfigSerializationService.Error.ReadError readError = x0$1;
            if (readError instanceof ClustersConfigSerializationService.Error$.UnsupportedFormat) {
                ClustersConfigSerializationService.Error$.UnsupportedFormat unsupportedFormat = (ClustersConfigSerializationService.Error$.UnsupportedFormat)readError;
                String message = unsupportedFormat.message();
                product = new UnsupportedFormat(message);
            } else if (readError instanceof ClustersConfigSerializationService.Error$.SerializationError) {
                ClustersConfigSerializationService.Error$.SerializationError serializationError = (ClustersConfigSerializationService.Error$.SerializationError)readError;
                String message = serializationError.message();
                product = new SerializationError((Error)DecodingFailure$.MODULE$.apply(message, (Function0 & Serializable)() -> scala.package$.MODULE$.List().empty()));
            } else if (readError instanceof ClustersConfigSerializationService.Error$.UnreadableResource) {
                ClustersConfigSerializationService.Error$.UnreadableResource unreadableResource = (ClustersConfigSerializationService.Error$.UnreadableResource)readError;
                String message = unreadableResource.message();
                product = new ConfigurationIsNotFile(message);
            } else if (ClustersConfigSerializationService.Error$.CompromiseContent$.MODULE$.equals(readError)) {
                product = ConfigurationCorrupted$.MODULE$;
            } else if (ClustersConfigSerializationService.Error$.RequiresPassword$.MODULE$.equals(readError)) {
                product = RequiresPassword$.MODULE$;
            } else {
                throw new MatchError((Object)readError);
            }
            return product;
        }, CanFail$.MODULE$.canFail()).flatMap((Function1 & Serializable)clusterDefinitions -> (ZIO)package$.MODULE$.ForEachOps((Object)clusterDefinitions.definitions()).forEach((Function1 & Serializable)definition -> MODULE$.loadStoreFileLocally(configBasePath, (ClusterDefinition)definition), AssociativeBoth$.MODULE$.ZIOIdentityBoth(), Invariant$.MODULE$.ZIOCovariant(), Invariant$.MODULE$.ListForEach()));
    }

    public ZIO<Has<ClustersConfigSerializationService>, ConfigError, BoxedUnit> exportClusterDefinition(Path filePath, String password, ClustersConfig configs) {
        return zio.blocking.package$.MODULE$.blocking(Task$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> Files.deleteIfExists(filePath))).mapError((Function1 & Serializable)e -> new UnexpectedError((Throwable)e), CanFail$.MODULE$.canFail()).flatMap((Function1 & Serializable)x$12 -> ExternalConfigurationService$.$anonfun$exportClusterDefinition$3(filePath, password, configs, BoxesRunTime.unboxToBoolean((Object)x$12)));
    }

    private ZIO<Has<ClustersConfigSerializationService>, ConfigError, ClusterDefinition> loadStoreFileLocally(Path configBasePath, ClusterDefinition cluster2) {
        return ((ZIO)package$.MODULE$.ForEachOps((Object)cluster2.ksqlDbServers().configs()).forEach((Function1 & Serializable)ksqldb -> {
            ZIO keystore = (ZIO)package$.MODULE$.ForEachOps((Object)ksqldb.keyStore()).forEach((Function1 & Serializable)store -> MODULE$.loadConfigurationRessource(configBasePath, (ClusterDefinition.StoreFileContent)store), AssociativeBoth$.MODULE$.ZIOIdentityBoth(), Invariant$.MODULE$.ZIOCovariant(), Invariant$.MODULE$.OptionForEach());
            ZIO truststore = (ZIO)package$.MODULE$.ForEachOps((Object)ksqldb.trustStore()).forEach((Function1 & Serializable)store -> MODULE$.loadConfigurationRessource(configBasePath, (ClusterDefinition.StoreFileContent)store), AssociativeBoth$.MODULE$.ZIOIdentityBoth(), Invariant$.MODULE$.ZIOCovariant(), Invariant$.MODULE$.OptionForEach());
            return keystore.zip(truststore).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Option keystore = (Option)tuple2._1();
                Option truststore = (Option)tuple2._2();
                Option x$1 = keystore;
                Option x$2 = truststore;
                ClusterDefinition.HttpAuth x$3 = ksqldb.copy$default$1();
                ksql.Id x$4 = ksqldb.copy$default$2();
                ksql.Name x$5 = ksqldb.copy$default$3();
                properties.HeadersMap x$6 = ksqldb.copy$default$4();
                Option x$7 = ksqldb.copy$default$7();
                ClusterDefinition.KsqlDb ksqlDb = ksqldb.copy(x$3, x$4, x$5, x$6, x$1, x$2, x$7);
                return ksqlDb;
            });
        }, AssociativeBoth$.MODULE$.ZIOIdentityBoth(), Invariant$.MODULE$.ZIOCovariant(), Invariant$.MODULE$.ListForEach())).flatMap((Function1 & Serializable)ksqlConfigs -> ((ZIO)package$.MODULE$.ForEachOps((Object)cluster2.kafkaConnects().configs()).forEach((Function1 & Serializable)connect -> {
            ZIO keyStore = (ZIO)package$.MODULE$.ForEachOps((Object)connect.keyStore()).forEach((Function1 & Serializable)store -> MODULE$.loadConfigurationRessource(configBasePath, (ClusterDefinition.StoreFileContent)store), AssociativeBoth$.MODULE$.ZIOIdentityBoth(), Invariant$.MODULE$.ZIOCovariant(), Invariant$.MODULE$.OptionForEach());
            ZIO trustStore = (ZIO)package$.MODULE$.ForEachOps((Object)connect.trustStore()).forEach((Function1 & Serializable)store -> MODULE$.loadConfigurationRessource(configBasePath, (ClusterDefinition.StoreFileContent)store), AssociativeBoth$.MODULE$.ZIOIdentityBoth(), Invariant$.MODULE$.ZIOCovariant(), Invariant$.MODULE$.OptionForEach());
            return keyStore.zip(trustStore).map((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Option keystore = (Option)tuple2._1();
                Option truststore = (Option)tuple2._2();
                Option x$8 = keystore;
                Option x$9 = truststore;
                kafkaconnect.Id x$10 = connect.copy$default$1();
                kafkaconnect.Name x$11 = connect.copy$default$2();
                ClusterDefinition.KafkaConnect$.Auth x$12 = connect.copy$default$3();
                properties.HeadersMap x$13 = connect.copy$default$4();
                kafkaconnect.UnsecuredHttps x$14 = connect.copy$default$7();
                Option x$15 = connect.copy$default$8();
                ClusterDefinition.KafkaConnect kafkaConnect = connect.copy(x$10, x$11, x$12, x$13, x$8, x$9, x$14, x$15);
                return kafkaConnect;
            });
        }, AssociativeBoth$.MODULE$.ZIOIdentityBoth(), Invariant$.MODULE$.ZIOCovariant(), Invariant$.MODULE$.ListForEach())).flatMap((Function1 & Serializable)connectConfigs -> ((ZIO)package$.MODULE$.ForEachOps((Object)cluster2.metrics()).forEach((Function1 & Serializable)metrics -> ((ZIO)package$.MODULE$.ForEachOps((Object)metrics.method()).forEach((Function1 & Serializable)x0$3 -> {
            ZIO zIO;
            ClusterDefinition.MetricsMethod metricsMethod = x0$3;
            if (metricsMethod instanceof ClusterDefinition.MetricsMethod.Jmx) {
                ClusterDefinition.MetricsMethod.Jmx jmx2 = (ClusterDefinition.MetricsMethod.Jmx)metricsMethod;
                ClusterDefinition.JmxAuth auth = jmx2.auth();
                Port port = jmx2.port();
                Option keyStore = jmx2.keyStore();
                jmx.SecuredRegistry securedRegistry = jmx2.securedRegistry();
                Option trustStore = jmx2.trustStore();
                ZIO ks = (ZIO)package$.MODULE$.ForEachOps((Object)keyStore).forEach((Function1 & Serializable)store -> MODULE$.loadConfigurationRessource(configBasePath, (ClusterDefinition.StoreFileContent)store), AssociativeBoth$.MODULE$.ZIOIdentityBoth(), Invariant$.MODULE$.ZIOCovariant(), Invariant$.MODULE$.OptionForEach());
                ZIO ts = (ZIO)package$.MODULE$.ForEachOps((Object)trustStore).forEach((Function1 & Serializable)store -> MODULE$.loadConfigurationRessource(configBasePath, (ClusterDefinition.StoreFileContent)store), AssociativeBoth$.MODULE$.ZIOIdentityBoth(), Invariant$.MODULE$.ZIOCovariant(), Invariant$.MODULE$.OptionForEach());
                zIO = ks.zip(ts).map((Function1 & Serializable)x0$4 -> {
                    Tuple2 tuple2 = x0$4;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Option keystore = (Option)tuple2._1();
                    Option truststore = (Option)tuple2._2();
                    ClusterDefinition.MetricsMethod.Jmx jmx2 = new ClusterDefinition.MetricsMethod.Jmx(auth, port, keystore, securedRegistry, truststore);
                    return jmx2;
                });
            } else {
                zIO = ZIO$.MODULE$.succeed((Function0 & Serializable)() -> metricsMethod);
            }
            return zIO;
        }, AssociativeBoth$.MODULE$.ZIOIdentityBoth(), Invariant$.MODULE$.ZIOCovariant(), Invariant$.MODULE$.OptionForEach())).map((Function1 & Serializable)method -> {
            Option x$16 = method;
            ClusterDefinition.Metrics$.Status x$17 = metrics.copy$default$1();
            return metrics.copy(x$17, x$16);
        }), AssociativeBoth$.MODULE$.ZIOIdentityBoth(), Invariant$.MODULE$.ZIOCovariant(), Invariant$.MODULE$.OptionForEach())).map((Function1 & Serializable)metrics -> {
            ClusterDefinition.KsqlDb$.Configs x$18 = cluster2.ksqlDbServers().copy(ksqlConfigs);
            ClusterDefinition.KafkaConnect$.Configs x$19 = cluster2.kafkaConnects().copy(connectConfigs);
            Option x$20 = metrics;
            cluster.BootstrapServers x$21 = cluster2.copy$default$1();
            cluster.Name x$22 = cluster2.copy$default$2();
            Option x$23 = cluster2.copy$default$3();
            cluster.InternalId x$24 = cluster2.copy$default$4();
            properties.PropertiesMap x$25 = cluster2.copy$default$5();
            Option x$26 = cluster2.copy$default$9();
            Option x$27 = cluster2.copy$default$10();
            Option x$28 = cluster2.copy$default$11();
            Option x$29 = cluster2.copy$default$12();
            Option x$30 = cluster2.copy$default$13();
            ClusterDefinition definition = cluster2.copy(x$21, x$22, x$23, x$24, x$25, x$19, x$18, x$20, x$26, x$27, x$28, x$29, x$30);
            return definition;
        })));
    }

    private ZIO<Has<package.Blocking.Service>, ConfigError, ClusterDefinition.StoreFileContent> loadConfigurationRessource(Path configBasePath, ClusterDefinition.StoreFileContent store) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> configBasePath.resolve(store.path().value()).toAbsolutePath().normalize()).mapError((Function1 & Serializable)e -> new CantWriteKeyStoreFileError(e.getMessage()), CanFail$.MODULE$.canFail()).flatMap((Function1 & Serializable)importedConfPath -> zio.blocking.package$.MODULE$.blocking(Task$.MODULE$.apply((Function0 & Serializable)() -> Files.createDirectories(importedConfPath.getParent(), new FileAttribute[0]))).mapError((Function1 & Serializable)e -> new CantWriteKeyStoreFileError(e.getMessage()), CanFail$.MODULE$.canFail()).flatMap((Function1 & Serializable)x$14 -> {
            int maxFileInc = 999;
            return zio.blocking.package$.MODULE$.blocking(ZStream$.MODULE$.range(1, maxFileInc, ZStream$.MODULE$.range$default$3()).map((Function1 & Serializable)i -> ExternalConfigurationService$.$anonfun$loadConfigurationRessource$7(importedConfPath, BoxesRunTime.unboxToInt((Object)i))).filterM((Function1 & Serializable)p -> Task$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> !Files.exists(p, new LinkOption[0]))).mapM((Function1 & Serializable)p -> Task$.MODULE$.apply((Function0 & Serializable)() -> Files.write(p, (byte[])store.content().toArray((ClassTag)ClassTag$.MODULE$.Byte()), new OpenOption[0]))).runHead().mapError((Function1 & Serializable)e -> new CantWriteKeyStoreFileError(e.getMessage()), CanFail$.MODULE$.canFail()).someOrFail((Function0 & Serializable)() -> new CantWriteKeyStoreFileError("Can't create file with increment suffix."), (.less.colon.less)$less$colon$less$.MODULE$.refl())).map((Function1 & Serializable)confPath -> {
                io.conduktor.clustersconfig.Path x$1 = new io.conduktor.clustersconfig.Path(((Object)confPath).toString());
                Password x$2 = store.copy$default$1();
                Chunk x$3 = store.copy$default$2();
                return store.copy(x$2, x$3, x$1);
            });
        }));
    }

    public static final /* synthetic */ void $anonfun$exportClusterDefinition$15(Path x$10) {
        Path path = x$10;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ ZIO $anonfun$exportClusterDefinition$3(Path filePath$1, String password$2, ClustersConfig configs$1, boolean x$12) {
        boolean bl = x$12;
        ZIO zIO = zio.blocking.package$.MODULE$.blocking(Task$.MODULE$.apply((Function0 & Serializable)() -> Files.createFile(filePath$1, new FileAttribute[0]))).mapError((Function1 & Serializable)e -> new UnexpectedError((Throwable)e), CanFail$.MODULE$.canFail()).flatMap((Function1 & Serializable)x$11 -> {
            Path path = x$11;
            ZIO zIO = ZIO$.MODULE$.fromEither((Function0 & Serializable)() -> Password$.MODULE$.from(password$2)).mapError((Function1 & Serializable)e -> new UnsupportedFormat((String)e), CanFail$.MODULE$.canFail()).flatMap((Function1 & Serializable)pwd -> ClustersConfigSerializationService$.MODULE$.apply((Function1 & Serializable)x$9 -> x$9.write(configs$1, pwd), Tag$.MODULE$.apply(ClustersConfigSerializationService.class, LightTypeTag$.MODULE$.parse(113249926, "\u0004\u0000\u0001Bio.conduktor.clustersconfig.api.ClustersConfigSerializationService\u0001\u0001", "\u0000\u0000\u0000", 21)), Accessible$.MODULE$.anyIsAny()).mapError((Function1 & Serializable)x0$1 -> {
                ClustersConfigSerializationService.Error.WriteError writeError = x0$1;
                if (!(writeError instanceof ClustersConfigSerializationService.Error$.SerializationError)) {
                    throw new MatchError((Object)writeError);
                }
                ClustersConfigSerializationService.Error$.SerializationError serializationError = (ClustersConfigSerializationService.Error$.SerializationError)writeError;
                String message = serializationError.message();
                UnsupportedFormat unsupportedFormat = new UnsupportedFormat(message);
                return unsupportedFormat;
            }, CanFail$.MODULE$.canFail()).flatMap((Function1 & Serializable)serialized -> zio.blocking.package$.MODULE$.blocking(Task$.MODULE$.apply((Function0 & Serializable)() -> Files.writeString(filePath$1, (CharSequence)ClustersConfigSerializationService.SerializedConfiguration$.Ops$newtype$.MODULE$.configuration$extension(ClustersConfigSerializationService.SerializedConfiguration$.MODULE$.Ops$newtype(serialized)), new OpenOption[0]))).mapError((Function1 & Serializable)e -> new UnexpectedError((Throwable)e), CanFail$.MODULE$.canFail()).map((Function1 & Serializable)x$10 -> {
                ExternalConfigurationService$.$anonfun$exportClusterDefinition$15(x$10);
                return BoxedUnit.UNIT;
            })));
            return zIO;
        });
        return zIO;
    }

    public static final /* synthetic */ Path $anonfun$loadConfigurationRessource$7(Path importedConfPath$1, int i) {
        return Paths.get(new StringBuilder(1).append(importedConfPath$1).append("-").append(i).toString(), new String[0]).toAbsolutePath().normalize();
    }

    private ExternalConfigurationService$() {
    }
}

