/*
 * Decompiled with CFR 0.152.
 */
package net.harawata.appdirs.impl;

import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.KnownFolders;
import com.sun.jna.platform.win32.Shell32Util;
import com.sun.jna.platform.win32.Win32Exception;
import net.harawata.appdirs.AppDirsException;
import net.harawata.appdirs.impl.WindowsAppDirs;
import net.harawata.appdirs.impl.WindowsFolderResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellFolderResolver
implements WindowsFolderResolver {
    private static final Logger logger = LoggerFactory.getLogger(ShellFolderResolver.class);

    @Override
    public String resolveFolder(WindowsAppDirs.FolderId folderId) {
        try {
            logger.debug("Invoking SHGetKnownFolderPath");
            return Shell32Util.getKnownFolderPath((Guid.GUID)this.convertFolderIdToGuid(folderId));
        }
        catch (Win32Exception e) {
            logger.error("SHGetKnownFolderPath returns an error: {}", (Object)e.getErrorCode());
            throw new AppDirsException("SHGetKnownFolderPath returns an error: " + e.getErrorCode());
        }
        catch (UnsatisfiedLinkError e) {
            try {
                logger.debug("SHGetKnownFolderPath failed. Trying SHGetFolderPath.");
                int folder = this.convertFolderIdToCsidl(folderId);
                return Shell32Util.getFolderPath((int)folder);
            }
            catch (Win32Exception e2) {
                logger.error("SHGetFolderPath returns an error: {}", (Throwable)e2);
                throw new AppDirsException("SHGetFolderPath returns an error: " + e2.getErrorCode());
            }
        }
    }

    private Guid.GUID convertFolderIdToGuid(WindowsAppDirs.FolderId folderId) {
        switch (folderId) {
            case APPDATA: {
                return KnownFolders.FOLDERID_RoamingAppData;
            }
            case LOCAL_APPDATA: {
                return KnownFolders.FOLDERID_LocalAppData;
            }
            case COMMON_APPDATA: {
                return KnownFolders.FOLDERID_ProgramData;
            }
        }
        throw new AppDirsException("Unknown folder ID " + (Object)((Object)folderId) + " was specified.");
    }

    protected int convertFolderIdToCsidl(WindowsAppDirs.FolderId folderId) {
        switch (folderId) {
            case APPDATA: {
                return 26;
            }
            case LOCAL_APPDATA: {
                return 28;
            }
            case COMMON_APPDATA: {
                return 35;
            }
        }
        throw new AppDirsException("Unknown folder ID " + (Object)((Object)folderId) + " was specified.");
    }
}

