/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import cats.effect.unsafe.StripedHashtable$;
import cats.effect.unsafe.ThreadSafeHashtable$;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005%4Q!\u0006\f\u00031qA\u0001b\t\u0001\u0003\u0002\u0003\u0006I!\n\u0005\u0006Q\u0001!\t!\u000b\u0005\u0007[\u0001\u0001\u000b\u0015\u0002\u0018\t\r\r\u0003\u0001\u0015)\u0003&\u0011\u0019!\u0005\u0001)Q\u0005K!1Q\t\u0001Q!\n\u0015BaA\u0012\u0001!\u0002\u0013)\u0003BB$\u0001A\u0003%\u0011\u0007C\u0003I\u0001\u0011\u0005\u0011\n\u0003\u0004O\u0001\u0001&Ia\u0014\u0005\u0006+\u0002!\tA\u0016\u0005\u00063\u0002!\tA\u0017\u0005\u00077\u0002!\tA\u0006/\t\r\u0001\u0004A\u0011\u0001\fb\u0011\u0019\u0011\u0007\u0001\"\u0001\u0017C\u001e)1M\u0006E\u0005I\u001a)QC\u0006E\u0005K\")\u0001&\u0005C\u0001M\"Aq)\u0005b\u0001\n\u000b\tr\r\u0003\u0004i#\u0001\u0006i!\r\u0002\u0014)\"\u0014X-\u00193TC\u001a,\u0007*Y:ii\u0006\u0014G.\u001a\u0006\u0003/a\ta!\u001e8tC\u001a,'BA\r\u001b\u0003\u0019)gMZ3di*\t1$\u0001\u0003dCR\u001c8C\u0001\u0001\u001e!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0019\te.\u001f*fM\u0006y\u0011N\\5uS\u0006d7)\u00199bG&$\u0018p\u0001\u0001\u0011\u0005y1\u0013BA\u0014 \u0005\rIe\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005)b\u0003CA\u0016\u0001\u001b\u00051\u0002\"B\u0012\u0003\u0001\u0004)\u0013!\u00035bg\"$\u0018M\u00197f!\rqr&M\u0005\u0003a}\u0011Q!\u0011:sCf\u0004BA\b\u001a5\u0001&\u00111g\b\u0002\n\rVt7\r^5p]F\u0002\"!N\u001f\u000f\u0005YZdBA\u001c;\u001b\u0005A$BA\u001d%\u0003\u0019a$o\\8u}%\t\u0001%\u0003\u0002=?\u00059\u0001/Y2lC\u001e,\u0017B\u0001 @\u0005%!\u0006N]8xC\ndWM\u0003\u0002=?A\u0011a$Q\u0005\u0003\u0005~\u0011A!\u00168ji\u0006!1/\u001b>f\u0003\u0011i\u0017m]6\u0002\u0011\r\f\u0007/Y2jif\fQ\u0002\\8he9+X\u000eV1cY\u0016\u001c\u0018!\u0003+p[\n\u001cHo\u001c8f\u0003\r\u0001X\u000f\u001e\u000b\u0004\u0001*c\u0005\"B&\n\u0001\u0004\t\u0014AA2c\u0011\u0015i\u0015\u00021\u0001&\u0003\u0011A\u0017m\u001d5\u0002\r%t7/\u001a:u)\u0015\u0001\u0005KU*U\u0011\u0015\t&\u00021\u0001/\u0003\u0015!\u0018M\u00197f\u0011\u0015!%\u00021\u0001&\u0011\u0015Y%\u00021\u00012\u0011\u0015i%\u00021\u0001&\u0003\u0019\u0011X-\\8wKR\u0019\u0001i\u0016-\t\u000b-[\u0001\u0019A\u0019\t\u000b5[\u0001\u0019A\u0013\u0002\u001fUt7/\u00194f\u0011\u0006\u001c\b\u000e^1cY\u0016$\u0012AL\u0001\bSN,U\u000e\u001d;z+\u0005i\u0006C\u0001\u0010_\u0013\tyvDA\u0004C_>dW-\u00198\u0002\u001dUt7/\u00194f\u0007\u0006\u0004\u0018mY5usR\tQ%A\u000bv]N\fg-Z%oSRL\u0017\r\\\"ba\u0006\u001c\u0017\u000e^=\u0002'QC'/Z1e'\u00064W\rS1tQR\f'\r\\3\u0011\u0005-\n2CA\t\u001e)\u0005!W#A\u0019\u0002\u0015Q{WNY:u_:,\u0007\u0005")
public final class ThreadSafeHashtable {
    private final int initialCapacity;
    private Function1<Throwable, BoxedUnit>[] hashtable;
    private int size;
    private int mask;
    private int capacity;
    private final int log2NumTables;
    private final Function1<Throwable, BoxedUnit> Tombstone;

    public synchronized void put(Function1<Throwable, BoxedUnit> cb, int hash) {
        int sz = this.size;
        int cap = this.capacity;
        if (sz << 1 >= cap) {
            int newCap = cap << 1;
            int newMask = newCap - 1;
            Function1[] newHashtable = new Function1[newCap];
            Function1<Throwable, BoxedUnit>[] table = this.hashtable;
            for (int i = 0; i < cap; ++i) {
                Function1<Throwable, BoxedUnit> cur = table[i];
                if (cur == null || cur == this.Tombstone) continue;
                this.insert(newHashtable, newMask, cur, System.identityHashCode(cur) >> this.log2NumTables);
            }
            this.hashtable = newHashtable;
            this.mask = newMask;
            this.capacity = newCap;
        }
        this.insert(this.hashtable, this.mask, cb, hash);
        this.size = sz + 1;
    }

    private void insert(Function1<Throwable, BoxedUnit>[] table, int mask, Function1<Throwable, BoxedUnit> cb, int hash) {
        int idx = hash & mask;
        for (int remaining = mask; remaining >= 0; --remaining) {
            Function1<Throwable, BoxedUnit> cur = table[idx];
            if (cur == null || cur == this.Tombstone) {
                table[idx] = cb;
                return;
            }
            idx = idx + 1 & mask;
        }
    }

    public synchronized void remove(Function1<Throwable, BoxedUnit> cb, int hash) {
        int init;
        int msk = this.mask;
        int idx = init = hash & msk;
        Function1<Throwable, BoxedUnit>[] table = this.hashtable;
        for (int remaining = msk; remaining >= 0; --remaining) {
            Function1<Throwable, BoxedUnit> cur = table[idx];
            if (cb == cur) {
                table[idx] = this.Tombstone;
                --this.size;
                int sz = this.size;
                int cap = this.capacity;
                if (cap > this.initialCapacity && sz << 2 < cap) {
                    int newCap = cap >>> 1;
                    int newMask = newCap - 1;
                    Function1[] newHashtable = new Function1[newCap];
                    Function1<Throwable, BoxedUnit>[] table2 = this.hashtable;
                    for (int i = 0; i < cap; ++i) {
                        Function1<Throwable, BoxedUnit> cur2 = table2[i];
                        if (cur2 == null || cur2 == this.Tombstone) continue;
                        this.insert(newHashtable, newMask, cur2, System.identityHashCode(cur2) >> this.log2NumTables);
                    }
                    this.hashtable = newHashtable;
                    this.mask = newMask;
                    this.capacity = newCap;
                }
                return;
            }
            if (cur == null) {
                return;
            }
            idx = idx + 1 & msk;
        }
    }

    public Function1<Throwable, BoxedUnit>[] unsafeHashtable() {
        return this.hashtable;
    }

    public boolean isEmpty() {
        return this.size == 0 && ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])this.hashtable), (Function1 & Serializable)cb -> BoxesRunTime.boxToBoolean((boolean)ThreadSafeHashtable.$anonfun$isEmpty$1(this, cb)));
    }

    public int unsafeCapacity() {
        return this.capacity;
    }

    public int unsafeInitialCapacity() {
        return this.initialCapacity;
    }

    public static final /* synthetic */ boolean $anonfun$isEmpty$1(ThreadSafeHashtable $this, Function1 cb) {
        return cb == null || cb == $this.Tombstone;
    }

    public ThreadSafeHashtable(int initialCapacity) {
        this.initialCapacity = initialCapacity;
        this.hashtable = new Function1[initialCapacity];
        this.size = 0;
        this.mask = initialCapacity - 1;
        this.capacity = initialCapacity;
        this.log2NumTables = StripedHashtable$.MODULE$.log2NumTables();
        this.Tombstone = ThreadSafeHashtable$.MODULE$.Tombstone();
    }
}

