/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadLocalRandom;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005E4AAD\b\u0007-!Aa\u0004\u0001B\u0001B\u0003%q\u0004C\u0003#\u0001\u0011\u00051\u0005\u0003\u00040\u0001\u0001\u0006Ia\b\u0005\u0007a\u0001\u0001\u000b\u0011B\u0010\t\rE\u0002\u0001\u0015!\u00033\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u0015Y\u0005\u0001\"\u0001M\u0011\u00151\u0006\u0001\"\u0001X\u0011\u0015I\u0006\u0001\"\u0001[\u0011\u0015a\u0006\u0001\"\u0001^\u0011\u0015I\u0007\u0001\"\u0001k\u0011\u0015q\u0007\u0001\"\u0001k\u0011\u0015y\u0007\u0001\"\u0001q\u0005%\u00196-\u00197Rk\u0016,XM\u0003\u0002\u0011#\u00051QO\\:bM\u0016T!AE\n\u0002\r\u00154g-Z2u\u0015\u0005!\u0012\u0001B2biN\u001c\u0001!\u0006\u0002\u0018QM\u0011\u0001\u0001\u0007\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\u0017QD'/Z1e\u0007>,h\u000e\u001e\t\u00033\u0001J!!\t\u000e\u0003\u0007%sG/\u0001\u0004=S:LGO\u0010\u000b\u0003I9\u00022!\n\u0001'\u001b\u0005y\u0001CA\u0014)\u0019\u0001!Q!\u000b\u0001C\u0002)\u0012\u0011!Q\t\u0003Wa\u0001\"!\u0007\u0017\n\u00055R\"a\u0002(pi\"Lgn\u001a\u0005\u0006=\t\u0001\raH\u0001\u0005[\u0006\u001c8.A\u0005ok6\fV/Z;fg\u00061\u0011/^3vKN\u00042!G\u001a6\u0013\t!$DA\u0003BeJ\f\u0017\u0010E\u00027{\u0019j\u0011a\u000e\u0006\u0003qe\n!bY8oGV\u0014(/\u001a8u\u0015\tQ4(\u0001\u0003vi&d'\"\u0001\u001f\u0002\t)\fg/Y\u0005\u0003}]\u0012QcQ8oGV\u0014(/\u001a8u\u0019&t7.\u001a3Rk\u0016,X-A\u0003pM\u001a,'\u000fF\u0002B\t\u001a\u0003\"!\u0007\"\n\u0005\rS\"\u0001B+oSRDQ!\u0012\u0004A\u0002\u0019\n\u0011!\u0019\u0005\u0006\u000f\u001a\u0001\r\u0001S\u0001\u0007e\u0006tGm\\7\u0011\u0005YJ\u0015B\u0001&8\u0005E!\u0006N]3bI2{7-\u00197SC:$w.\\\u0001\t_\u001a4WM]!mYR\u0019\u0011)T+\t\u000b9;\u0001\u0019A(\u0002\u0005\u0005\u001c\bG\u0001)S!\rI2'\u0015\t\u0003OI#\u0011bU'\u0002\u0002\u0003\u0005)\u0011\u0001+\u0003\u0007}#\u0013'\u0005\u0002,M!)qi\u0002a\u0001\u0011\u0006!\u0001o\u001c7m)\t1\u0003\fC\u0003H\u0011\u0001\u0007\u0001*\u0001\u0004sK6|g/\u001a\u000b\u0003\u0003nCQ!R\u0005A\u0002\u0019\n\u0001b\u001d8baNDw\u000e\u001e\u000b\u0002=B\u0019qL\u001a\r\u000f\u0005\u0001$\u0007CA1\u001b\u001b\u0005\u0011'BA2\u0016\u0003\u0019a$o\\8u}%\u0011QMG\u0001\u0007!J,G-\u001a4\n\u0005\u001dD'aA*fi*\u0011QMG\u0001\bSN,U\u000e\u001d;z)\u0005Y\u0007CA\rm\u0013\ti'DA\u0004C_>dW-\u00198\u0002\u00119|g.R7qif\fQa\u00197fCJ$\u0012!\u0011")
public final class ScalQueue<A> {
    private final int mask;
    private final int numQueues;
    private final ConcurrentLinkedQueue<A>[] queues;

    public void offer(A a, ThreadLocalRandom random) {
        int idx = random.nextInt(this.numQueues);
        this.queues[idx].offer(a);
    }

    public void offerAll(Object[] as, ThreadLocalRandom random) {
        int nq = this.numQueues;
        for (Object fiber : as) {
            int idx = random.nextInt(nq);
            this.queues[idx].offer(fiber);
        }
    }

    public A poll(ThreadLocalRandom random) {
        int nq = this.numQueues;
        int from = random.nextInt(nq);
        A a = null;
        for (int i = 0; a == null && i < nq; ++i) {
            int idx = from + i & this.mask;
            a = this.queues[idx].poll();
        }
        return a;
    }

    public void remove(A a) {
        int nq = this.numQueues;
        boolean done = false;
        for (int i = 0; !done && i < nq; ++i) {
            done = this.queues[i].remove(a);
        }
    }

    public Set<Object> snapshot() {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])this.queues), (Function1 & Serializable)x$1 -> x$1.toArray(), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray(xs), ClassTag$.MODULE$.apply(Object.class))).toSet();
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEmpty() {
        void var3_3;
        int nq = this.numQueues;
        boolean empty = true;
        for (int i = 0; empty && i < nq; ++i) {
            empty = this.queues[i].isEmpty();
        }
        return (boolean)var3_3;
    }

    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    public void clear() {
        int nq = this.numQueues;
        for (int i = 0; i < nq; ++i) {
            this.queues[i].clear();
        }
    }

    public ScalQueue(int threadCount) {
        int value = threadCount - 1;
        value |= value >> 1;
        value |= value >> 2;
        value |= value >> 4;
        value |= value >> 8;
        this.mask = value | value >> 16;
        int nq = this.numQueues = this.mask + 1;
        ConcurrentLinkedQueue[] queues = new ConcurrentLinkedQueue[nq];
        for (int i = 0; i < nq; ++i) {
            queues[i] = new ConcurrentLinkedQueue();
        }
        this.queues = queues;
    }
}

