/*
 * Decompiled with CFR 0.152.
 */
package pdi.jwt;

import java.io.Serializable;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import pdi.jwt.JwtAlgorithm;
import pdi.jwt.JwtAlgorithm$ES256$;
import pdi.jwt.JwtAlgorithm$ES384$;
import pdi.jwt.JwtAlgorithm$ES512$;
import pdi.jwt.JwtArrayUtils;
import pdi.jwt.JwtBase64$;
import pdi.jwt.algorithms.JwtAsymmetricAlgorithm;
import pdi.jwt.algorithms.JwtECDSAAlgorithm;
import pdi.jwt.algorithms.JwtEdDSAAlgorithm;
import pdi.jwt.algorithms.JwtHmacAlgorithm;
import pdi.jwt.algorithms.JwtRSAAlgorithm;
import pdi.jwt.algorithms.JwtUnknownAlgorithm;
import pdi.jwt.exceptions.JwtNonSupportedAlgorithm;
import pdi.jwt.exceptions.JwtSignatureFormatException;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class JwtUtils$ {
    public static final JwtUtils$ MODULE$ = new JwtUtils$();
    private static final String ENCODING = "UTF-8";
    private static final String RSA;
    private static final String ECDSA;
    private static final String EdDSA;
    private static volatile byte bitmap$init$0;

    static {
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        RSA = "RSA";
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
        ECDSA = "EC";
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
        EdDSA = "EdDSA";
        bitmap$init$0 = (byte)(bitmap$init$0 | 8);
    }

    public String ENCODING() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/eloisant/Code/jwt-scala/core/src/main/scala/JwtUtils.scala: 13");
        }
        return ENCODING;
    }

    public String RSA() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/eloisant/Code/jwt-scala/core/src/main/scala/JwtUtils.scala: 14");
        }
        return RSA;
    }

    public String ECDSA() {
        if ((byte)(bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/eloisant/Code/jwt-scala/core/src/main/scala/JwtUtils.scala: 15");
        }
        return ECDSA;
    }

    public String EdDSA() {
        if ((byte)(bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/eloisant/Code/jwt-scala/core/src/main/scala/JwtUtils.scala: 16");
        }
        return EdDSA;
    }

    public String stringify(byte[] arr) {
        return new String(arr, this.ENCODING());
    }

    public byte[] bytify(String str) {
        return str.getBytes(this.ENCODING());
    }

    private String escape(String value) {
        return value.replaceAll("\"", "\\\\\"");
    }

    public String seqToJson(Seq<Object> seq) {
        return ((IterableOnceOps)seq.map((Function1 & Serializable)x0$1 -> {
            Object object = x0$1;
            if (object instanceof String) {
                String string = (String)object;
                return new StringBuilder(2).append("\"").append(MODULE$.escape(string)).append("\"").toString();
            }
            if (object instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                if (!bl) return "false";
                return "true";
            }
            if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                return Double.toString(d);
            }
            if (object instanceof Short) {
                short s = BoxesRunTime.unboxToShort((Object)object);
                return Short.toString(s);
            }
            if (object instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)object);
                return Float.toString(f);
            }
            if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                return Long.toString(l);
            }
            if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                return Integer.toString(n);
            }
            if (object instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                return bigDecimal.toString();
            }
            if (object instanceof BigInt) {
                BigInt bigInt = (BigInt)object;
                return bigInt.toString();
            }
            if (object instanceof Tuple2) {
                Tuple2 tuple2 = (Tuple2)object;
                Object key = tuple2._1();
                Object value = tuple2._2();
                if (key instanceof String) {
                    String string = (String)key;
                    return MODULE$.hashToJson((Seq<Tuple2<String, Object>>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)string), value)}))));
                }
            }
            if (!(object instanceof Object)) throw new MatchError(object);
            Object object2 = object;
            return new StringBuilder(2).append("\"").append(MODULE$.escape(object2.toString())).append("\"").toString();
        })).mkString("[", ",", "]");
    }

    public String hashToJson(Seq<Tuple2<String, Object>> hash) {
        return ((IterableOnceOps)hash.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                if (value instanceof String) {
                    String string = (String)value;
                    return new StringBuilder(5).append("\"").append(MODULE$.escape(key)).append("\":\"").append(MODULE$.escape(string)).append("\"").toString();
                }
            }
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                if (value instanceof Boolean) {
                    boolean bl = BoxesRunTime.unboxToBoolean((Object)value);
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key)).append("\":").append((Object)(bl ? "true" : "false")).toString();
                }
            }
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                if (value instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)value);
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key)).append("\":").append(Double.toString(d)).toString();
                }
            }
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                if (value instanceof Short) {
                    short s = BoxesRunTime.unboxToShort((Object)value);
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key)).append("\":").append(Short.toString(s)).toString();
                }
            }
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                if (value instanceof Float) {
                    float f = BoxesRunTime.unboxToFloat((Object)value);
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key)).append("\":").append(Float.toString(f)).toString();
                }
            }
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                if (value instanceof Long) {
                    long l = BoxesRunTime.unboxToLong((Object)value);
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key)).append("\":").append(Long.toString(l)).toString();
                }
            }
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                if (value instanceof Integer) {
                    int n = BoxesRunTime.unboxToInt((Object)value);
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key)).append("\":").append(Integer.toString(n)).toString();
                }
            }
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                if (value instanceof BigDecimal) {
                    BigDecimal bigDecimal = (BigDecimal)value;
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key)).append("\":").append(bigDecimal.toString()).toString();
                }
            }
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                if (value instanceof BigInt) {
                    BigInt bigInt = (BigInt)value;
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key)).append("\":").append(bigInt.toString()).toString();
                }
            }
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Object object = tuple2._2();
                if (object instanceof Tuple2) {
                    Tuple2 tuple22 = (Tuple2)object;
                    Object vKey = tuple22._1();
                    Object vValue = tuple22._2();
                    if (vKey instanceof String) {
                        String string = (String)vKey;
                        return new StringBuilder(3).append("\"").append(MODULE$.escape(key)).append("\":").append(MODULE$.hashToJson((Seq<Tuple2<String, Object>>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)string), vValue)}))))).toString();
                    }
                }
            }
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                if (value instanceof Seq) {
                    Seq seq = (Seq)value;
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key)).append("\":").append(MODULE$.seqToJson((Seq<Object>)seq)).toString();
                }
            }
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                if (value instanceof Set) {
                    Set set = (Set)value;
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key)).append("\":").append(MODULE$.seqToJson((Seq<Object>)set.toSeq())).toString();
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String key = (String)tuple2._1();
            Object value = tuple2._2();
            if (!(value instanceof Object)) throw new MatchError((Object)tuple2);
            Object object = value;
            return new StringBuilder(5).append("\"").append(MODULE$.escape(key)).append("\":\"").append(MODULE$.escape(object.toString())).append("\"").toString();
        })).mkString("{", ",", "}");
    }

    public String mergeJson(String json, Seq<String> jsonSeq) {
        String string;
        block3: {
            String string2 = json.trim();
            switch (string2 == null ? 0 : string2.hashCode()) {
                case 0: {
                    if (!"".equals(string2)) break;
                    string = "";
                    break block3;
                }
            }
            string = StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(string2), 1)), 1);
        }
        String initJson = string;
        return new StringBuilder(2).append("{").append(((IterableOnceOps)jsonSeq.map((Function1 & Serializable)x$1 -> x$1.trim())).fold((Object)initJson, (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                String j1 = (String)tuple2._1();
                String result = (String)tuple2._2();
                if (j1.length() < 5) {
                    return StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(result), 1)), 1);
                }
            }
            if (tuple2 != null) {
                String result = (String)tuple2._1();
                String j2 = (String)tuple2._2();
                if (j2.length() < 7) {
                    return result;
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String j1 = (String)tuple2._1();
            String j2 = (String)tuple2._2();
            return new StringBuilder(1).append(j1).append(",").append(StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(j2), 1)), 1)).toString();
        })).append("}").toString();
    }

    private byte[] parseKey(String key) {
        return JwtBase64$.MODULE$.decodeNonSafe(key.replaceAll("-----BEGIN (.*)-----", "").replaceAll("-----END (.*)-----", "").replaceAll("\r\n", "").replaceAll("\n", "").trim());
    }

    private PrivateKey parsePrivateKey(String key, String keyAlgo) {
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(this.parseKey(key));
        return KeyFactory.getInstance(keyAlgo).generatePrivate(spec);
    }

    private PublicKey parsePublicKey(String key, String keyAlgo) {
        X509EncodedKeySpec spec = new X509EncodedKeySpec(this.parseKey(key));
        return KeyFactory.getInstance(keyAlgo).generatePublic(spec);
    }

    public byte[] sign(byte[] data, SecretKey key, JwtHmacAlgorithm algorithm) {
        Mac mac = Mac.getInstance(algorithm.fullName());
        mac.init(key);
        return mac.doFinal(data);
    }

    public byte[] sign(String data, SecretKey key, JwtHmacAlgorithm algorithm) {
        return this.sign(this.bytify(data), key, algorithm);
    }

    public byte[] sign(byte[] data, PrivateKey key, JwtAsymmetricAlgorithm algorithm) {
        byte[] byArray;
        Signature signer = Signature.getInstance(algorithm.fullName());
        signer.initSign(key);
        signer.update(data);
        JwtAsymmetricAlgorithm jwtAsymmetricAlgorithm = algorithm;
        if (jwtAsymmetricAlgorithm instanceof JwtRSAAlgorithm) {
            byArray = signer.sign();
        } else if (jwtAsymmetricAlgorithm instanceof JwtECDSAAlgorithm) {
            JwtECDSAAlgorithm jwtECDSAAlgorithm = (JwtECDSAAlgorithm)jwtAsymmetricAlgorithm;
            byArray = this.transcodeSignatureToConcat(signer.sign(), this.getSignatureByteArrayLength(jwtECDSAAlgorithm));
        } else if (jwtAsymmetricAlgorithm instanceof JwtEdDSAAlgorithm) {
            byArray = signer.sign();
        } else {
            throw new MatchError((Object)jwtAsymmetricAlgorithm);
        }
        return byArray;
    }

    public byte[] sign(String data, PrivateKey key, JwtAsymmetricAlgorithm algorithm) {
        return this.sign(this.bytify(data), key, algorithm);
    }

    public byte[] sign(byte[] data, String key, JwtAlgorithm algorithm) {
        byte[] byArray;
        JwtAlgorithm jwtAlgorithm = algorithm;
        if (jwtAlgorithm instanceof JwtHmacAlgorithm) {
            JwtHmacAlgorithm jwtHmacAlgorithm = (JwtHmacAlgorithm)jwtAlgorithm;
            byArray = this.sign(data, (SecretKey)new SecretKeySpec(this.bytify(key), jwtHmacAlgorithm.fullName()), jwtHmacAlgorithm);
        } else if (jwtAlgorithm instanceof JwtRSAAlgorithm) {
            JwtRSAAlgorithm jwtRSAAlgorithm = (JwtRSAAlgorithm)jwtAlgorithm;
            byArray = this.sign(data, this.parsePrivateKey(key, this.RSA()), (JwtAsymmetricAlgorithm)jwtRSAAlgorithm);
        } else if (jwtAlgorithm instanceof JwtECDSAAlgorithm) {
            JwtECDSAAlgorithm jwtECDSAAlgorithm = (JwtECDSAAlgorithm)jwtAlgorithm;
            byArray = this.sign(data, this.parsePrivateKey(key, this.ECDSA()), (JwtAsymmetricAlgorithm)jwtECDSAAlgorithm);
        } else if (jwtAlgorithm instanceof JwtEdDSAAlgorithm) {
            JwtEdDSAAlgorithm jwtEdDSAAlgorithm = (JwtEdDSAAlgorithm)jwtAlgorithm;
            byArray = this.sign(data, this.parsePrivateKey(key, this.EdDSA()), (JwtAsymmetricAlgorithm)jwtEdDSAAlgorithm);
        } else {
            if (jwtAlgorithm instanceof JwtUnknownAlgorithm) {
                JwtUnknownAlgorithm jwtUnknownAlgorithm = (JwtUnknownAlgorithm)jwtAlgorithm;
                throw new JwtNonSupportedAlgorithm(jwtUnknownAlgorithm.fullName());
            }
            throw new MatchError((Object)jwtAlgorithm);
        }
        return byArray;
    }

    public byte[] sign(String data, String key, JwtAlgorithm algorithm) {
        return this.sign(this.bytify(data), key, algorithm);
    }

    public boolean verify(byte[] data, byte[] signature, SecretKey key, JwtHmacAlgorithm algorithm) {
        return JwtArrayUtils.constantTimeAreEqual(this.sign(data, key, algorithm), signature);
    }

    public boolean verify(byte[] data, byte[] signature, PublicKey key, JwtAsymmetricAlgorithm algorithm) {
        boolean bl;
        Signature signer = Signature.getInstance(algorithm.fullName());
        signer.initVerify(key);
        signer.update(data);
        JwtAsymmetricAlgorithm jwtAsymmetricAlgorithm = algorithm;
        if (jwtAsymmetricAlgorithm instanceof JwtRSAAlgorithm) {
            bl = signer.verify(signature);
        } else if (jwtAsymmetricAlgorithm instanceof JwtECDSAAlgorithm) {
            bl = signer.verify(this.transcodeSignatureToDER(signature));
        } else if (jwtAsymmetricAlgorithm instanceof JwtEdDSAAlgorithm) {
            bl = signer.verify(signature);
        } else {
            throw new MatchError((Object)jwtAsymmetricAlgorithm);
        }
        return bl;
    }

    public boolean verify(byte[] data, byte[] signature, String key, JwtAlgorithm algorithm) {
        boolean bl;
        JwtAlgorithm jwtAlgorithm = algorithm;
        if (jwtAlgorithm instanceof JwtHmacAlgorithm) {
            JwtHmacAlgorithm jwtHmacAlgorithm = (JwtHmacAlgorithm)jwtAlgorithm;
            bl = this.verify(data, signature, new SecretKeySpec(this.bytify(key), jwtHmacAlgorithm.fullName()), jwtHmacAlgorithm);
        } else if (jwtAlgorithm instanceof JwtRSAAlgorithm) {
            JwtRSAAlgorithm jwtRSAAlgorithm = (JwtRSAAlgorithm)jwtAlgorithm;
            bl = this.verify(data, signature, this.parsePublicKey(key, this.RSA()), jwtRSAAlgorithm);
        } else if (jwtAlgorithm instanceof JwtECDSAAlgorithm) {
            JwtECDSAAlgorithm jwtECDSAAlgorithm = (JwtECDSAAlgorithm)jwtAlgorithm;
            bl = this.verify(data, signature, this.parsePublicKey(key, this.ECDSA()), jwtECDSAAlgorithm);
        } else if (jwtAlgorithm instanceof JwtEdDSAAlgorithm) {
            JwtEdDSAAlgorithm jwtEdDSAAlgorithm = (JwtEdDSAAlgorithm)jwtAlgorithm;
            bl = this.verify(data, signature, this.parsePublicKey(key, this.EdDSA()), jwtEdDSAAlgorithm);
        } else {
            if (jwtAlgorithm instanceof JwtUnknownAlgorithm) {
                JwtUnknownAlgorithm jwtUnknownAlgorithm = (JwtUnknownAlgorithm)jwtAlgorithm;
                throw new JwtNonSupportedAlgorithm(jwtUnknownAlgorithm.fullName());
            }
            throw new MatchError((Object)jwtAlgorithm);
        }
        return bl;
    }

    public boolean verify(String data, String signature, String key, JwtAlgorithm algorithm) {
        return this.verify(this.bytify(data), this.bytify(signature), key, algorithm);
    }

    public int getSignatureByteArrayLength(JwtECDSAAlgorithm algorithm) {
        int n;
        JwtECDSAAlgorithm jwtECDSAAlgorithm = algorithm;
        if (JwtAlgorithm$ES256$.MODULE$.equals(jwtECDSAAlgorithm)) {
            n = 64;
        } else if (JwtAlgorithm$ES384$.MODULE$.equals(jwtECDSAAlgorithm)) {
            n = 96;
        } else if (JwtAlgorithm$ES512$.MODULE$.equals(jwtECDSAAlgorithm)) {
            n = 132;
        } else {
            throw new MatchError((Object)jwtECDSAAlgorithm);
        }
        return n;
    }

    public byte[] transcodeSignatureToConcat(byte[] derSignature, int outputLength) throws JwtSignatureFormatException {
        int sLength;
        int j;
        int rLength;
        int i;
        int n;
        if (derSignature.length < 8 || derSignature[0] != 48) {
            throw new JwtSignatureFormatException("Invalid ECDSA signature format");
        }
        byte by = derSignature[1];
        switch (by) {
            default: 
        }
        if (by > 0) {
            n = 2;
        } else if (by == (byte)129) {
            n = 3;
        } else {
            throw new JwtSignatureFormatException("Invalid ECDSA signature format");
        }
        int offset = n;
        for (i = rLength = derSignature[offset + 1]; i > 0 && derSignature[offset + 2 + rLength - i] == 0; --i) {
        }
        for (j = sLength = derSignature[offset + 2 + rLength + 1]; j > 0 && derSignature[offset + 2 + rLength + 2 + sLength - j] == 0; --j) {
        }
        int rawLen = Math.max(Math.max(i, j), outputLength / 2);
        if ((derSignature[offset - 1] & 0xFF) != derSignature.length - offset || (derSignature[offset - 1] & 0xFF) != 2 + rLength + 2 + sLength || derSignature[offset] != 2 || derSignature[offset + 2 + rLength] != 2) {
            throw new JwtSignatureFormatException("Invalid ECDSA signature format");
        }
        byte[] concatSignature = new byte[2 * rawLen];
        System.arraycopy(derSignature, offset + 2 + rLength - i, concatSignature, rawLen - i, i);
        System.arraycopy(derSignature, offset + 2 + rLength + 2 + sLength - j, concatSignature, 2 * rawLen - j, j);
        return concatSignature;
    }

    public byte[] transcodeSignatureToDER(byte[] signature) throws JwtSignatureFormatException {
        int signatureLength;
        Tuple2 tuple2 = ArrayOps$.MODULE$.splitAt$extension(Predef$.MODULE$.byteArrayOps(signature), signature.length / 2);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        byte[] r = (byte[])tuple2._1();
        byte[] s = (byte[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)r, (Object)s);
        Tuple2 tuple23 = tuple22;
        byte[] r2 = (byte[])tuple23._1();
        byte[] s2 = (byte[])tuple23._2();
        r2 = (byte[])ArrayOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.byteArrayOps(r2), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)JwtUtils$.$anonfun$transcodeSignatureToDER$1(BoxesRunTime.unboxToByte((Object)x$3))));
        if (r2.length > 0 && r2[0] < 0) {
            r2 = (byte[])ArrayOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.byteArrayOps(r2), (Object)BoxesRunTime.boxToByte((byte)((byte)0)), (ClassTag)ClassTag$.MODULE$.Byte());
        }
        if ((s2 = (byte[])ArrayOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.byteArrayOps(s2), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)JwtUtils$.$anonfun$transcodeSignatureToDER$2(BoxesRunTime.unboxToByte((Object)x$4))))).length > 0 && s2[0] < 0) {
            s2 = (byte[])ArrayOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.byteArrayOps(s2), (Object)BoxesRunTime.boxToByte((byte)((byte)0)), (ClassTag)ClassTag$.MODULE$.Byte());
        }
        if ((signatureLength = 2 + r2.length + 2 + s2.length) > 255) {
            throw new JwtSignatureFormatException("Invalid ECDSA signature format");
        }
        ListBuffer signatureDER = ListBuffer$.MODULE$.empty();
        signatureDER.$plus$eq((Object)BoxesRunTime.boxToByte((byte)48));
        Object object = signatureLength >= 128 ? signatureDER.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)129))) : BoxedUnit.UNIT;
        signatureDER.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)signatureLength)));
        signatureDER.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)2))).$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)r2.length))).$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapByteArray(r2));
        signatureDER.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)2))).$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)s2.length))).$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapByteArray(s2));
        return (byte[])signatureDER.toArray((ClassTag)ClassTag$.MODULE$.Byte());
    }

    public String[] splitString(String input, char separator) {
        ArrayBuffer builder = ArrayBuffer$.MODULE$.empty();
        int lastIndex = 0;
        int index = input.indexOf(separator, lastIndex);
        while (index != -1) {
            builder.$plus$eq((Object)input.substring(lastIndex, index));
            lastIndex = index + 1;
            index = input.indexOf(separator, lastIndex);
        }
        Object object = lastIndex < input.length() ? builder.$plus$eq((Object)input.substring(lastIndex, input.length())) : BoxedUnit.UNIT;
        return (String[])builder.toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public static final /* synthetic */ boolean $anonfun$transcodeSignatureToDER$1(byte x$3) {
        return x$3 == 0;
    }

    public static final /* synthetic */ boolean $anonfun$transcodeSignatureToDER$2(byte x$4) {
        return x$4 == 0;
    }

    private JwtUtils$() {
    }
}

