/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.file;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.function.BiPredicate;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import zio.CanFail$;
import zio.Chunk;
import zio.Chunk$;
import zio.Has;
import zio.ZIO;
import zio.ZIO$;
import zio.ZManaged;
import zio.ZManaged$;
import zio.blocking.package;
import zio.nio.charset.Charset;
import zio.nio.charset.Charset$Standard$;
import zio.nio.file.Files;
import zio.nio.file.Path;
import zio.nio.file.Path$;
import zio.stream.ZSink$;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public final class Files$ {
    public static final Files$ MODULE$ = new Files$();

    public ZStream<Has<package.Blocking.Service>, IOException, Path> newDirectoryStream(Path dir, String glob) {
        ZManaged managed = ZManaged$.MODULE$.fromAutoCloseable(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Files.newDirectoryStream(dir.javaPath(), glob))).map((Function1 & Serializable)x$1 -> x$1.iterator());
        return ZStream.RefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZStream$.MODULE$.RefineToOrDieOps(ZStream$.MODULE$.fromJavaIteratorManaged(managed).map((Function1 & Serializable)javaPath -> Path$.MODULE$.fromJava((java.nio.file.Path)javaPath))), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public ZStream<Has<package.Blocking.Service>, IOException, Path> newDirectoryStream(Path dir, Function1<Path, Object> filter) {
        DirectoryStream.Filter<java.nio.file.Path> javaFilter = javaPath -> BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)Path$.MODULE$.fromJava((java.nio.file.Path)javaPath)));
        ZManaged managed = ZManaged$.MODULE$.fromAutoCloseable(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Files.newDirectoryStream(dir.javaPath(), javaFilter))).map((Function1 & Serializable)x$2 -> x$2.iterator());
        return ZStream.RefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZStream$.MODULE$.RefineToOrDieOps(ZStream$.MODULE$.fromJavaIteratorManaged(managed).map((Function1 & Serializable)javaPath -> Path$.MODULE$.fromJava((java.nio.file.Path)javaPath))), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public String newDirectoryStream$default$2() {
        return "*";
    }

    public ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> createFile(Path path, Seq<FileAttribute<?>> attrs) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Files.createFile(path.javaPath(), (FileAttribute[])attrs.toArray(ClassTag$.MODULE$.apply(FileAttribute.class)))).unit()), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> createDirectory(Path path, Seq<FileAttribute<?>> attrs) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Files.createDirectory(path.javaPath(), (FileAttribute[])attrs.toArray(ClassTag$.MODULE$.apply(FileAttribute.class)))).unit()), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> createDirectories(Path path, Seq<FileAttribute<?>> attrs) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Files.createDirectories(path.javaPath(), (FileAttribute[])attrs.toArray(ClassTag$.MODULE$.apply(FileAttribute.class)))).unit()), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Path> createTempFileIn(Path dir, String suffix, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Path$.MODULE$.fromJava(Files.createTempFile(dir.javaPath(), (String)prefix.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), suffix, (FileAttribute[])fileAttributes.toSeq().toArray(ClassTag$.MODULE$.apply(FileAttribute.class)))))), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public ZManaged<Has<package.Blocking.Service>, IOException, Path> createTempFileInManaged(Path dir, String suffix, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes) {
        return ZManaged$.MODULE$.make(this.createTempFileIn(dir, suffix, prefix, fileAttributes), (Function1 & Serializable)x$3 -> MODULE$.deleteIfExists((Path)x$3).ignore());
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Path> createTempFile(String suffix, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Path$.MODULE$.fromJava(Files.createTempFile((String)prefix.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), suffix, (FileAttribute[])fileAttributes.toSeq().toArray(ClassTag$.MODULE$.apply(FileAttribute.class)))))), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public String createTempFileIn$default$2() {
        return ".tmp";
    }

    public String createTempFileInManaged$default$2() {
        return ".tmp";
    }

    public Option<String> createTempFileInManaged$default$3() {
        return None$.MODULE$;
    }

    public Iterable<FileAttribute<?>> createTempFileInManaged$default$4() {
        return package$.MODULE$.Nil();
    }

    public String createTempFile$default$1() {
        return ".tmp";
    }

    public ZManaged<Has<package.Blocking.Service>, IOException, Path> createTempFileManaged(String suffix, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes) {
        return ZManaged$.MODULE$.make(this.createTempFile(suffix, prefix, fileAttributes), (Function1 & Serializable)x$4 -> MODULE$.deleteIfExists((Path)x$4).ignore());
    }

    public String createTempFileManaged$default$1() {
        return ".tmp";
    }

    public Option<String> createTempFileManaged$default$2() {
        return None$.MODULE$;
    }

    public Iterable<FileAttribute<?>> createTempFileManaged$default$3() {
        return package$.MODULE$.Nil();
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Path> createTempDirectory(Path dir, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Path$.MODULE$.fromJava(Files.createTempDirectory(dir.javaPath(), (String)prefix.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (FileAttribute[])fileAttributes.toSeq().toArray(ClassTag$.MODULE$.apply(FileAttribute.class)))))), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public ZManaged<Has<package.Blocking.Service>, IOException, Path> createTempDirectoryManaged(Path dir, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes) {
        return ZManaged$.MODULE$.make(this.createTempDirectory(dir, prefix, fileAttributes), (Function1 & Serializable)x$5 -> MODULE$.deleteRecursive((Path)x$5).ignore());
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Path> createTempDirectory(Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Path$.MODULE$.fromJava(Files.createTempDirectory((String)prefix.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (FileAttribute[])fileAttributes.toSeq().toArray(ClassTag$.MODULE$.apply(FileAttribute.class)))))), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public ZManaged<Has<package.Blocking.Service>, IOException, Path> createTempDirectoryManaged(Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes) {
        return ZManaged$.MODULE$.make(this.createTempDirectory(prefix, fileAttributes), (Function1 & Serializable)x$6 -> MODULE$.deleteRecursive((Path)x$6).ignore());
    }

    public ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> createSymbolicLink(Path link, Path target, Seq<FileAttribute<?>> fileAttributes) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Files.createSymbolicLink(link.javaPath(), target.javaPath(), (FileAttribute[])fileAttributes.toArray(ClassTag$.MODULE$.apply(FileAttribute.class)))).unit()), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> createLink(Path link, Path existing) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Files.createLink(link.javaPath(), existing.javaPath())).unit()), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> delete(Path path) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0)(JFunction0.mcV.sp & Serializable)() -> Files.delete(path.javaPath()))), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Object> deleteIfExists(Path path) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0)(JFunction0.mcZ.sp & Serializable)() -> Files.deleteIfExists(path.javaPath()))), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Object> deleteRecursive(Path path2) {
        return this.newDirectoryStream(path2, this.newDirectoryStream$default$2()).mapM((Function1 & Serializable)path -> MODULE$.delete((Path)path)).run(ZSink$.MODULE$.count()).$less$times((Function0 & Serializable)() -> MODULE$.delete(path2));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> copy(Path source, Path target, Seq<CopyOption> copyOptions) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Files.copy(source.javaPath(), target.javaPath(), (CopyOption[])copyOptions.toArray(ClassTag$.MODULE$.apply(CopyOption.class)))).unit()), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> move(Path source, Path target, Seq<CopyOption> copyOptions) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Files.move(source.javaPath(), target.javaPath(), (CopyOption[])copyOptions.toArray(ClassTag$.MODULE$.apply(CopyOption.class)))).unit()), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Path> readSymbolicLink(Path link) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Path$.MODULE$.fromJava(Files.readSymbolicLink(link.javaPath())))), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, IOException, FileStore> getFileStore(Path path) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Files.getFileStore(path.javaPath()))), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Object> isSameFile(Path path, Path path2) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0)(JFunction0.mcZ.sp & Serializable)() -> Files.isSameFile(path.javaPath(), path2.javaPath()))), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Object> isHidden(Path path) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0)(JFunction0.mcZ.sp & Serializable)() -> Files.isHidden(path.javaPath()))), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, IOException, String> probeContentType(Path path) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Files.probeContentType(path.javaPath()))), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public <A extends FileAttributeView, B, E> ZIO<Has<package.Blocking.Service>, E, B> useFileAttributeView(Path path, Seq<LinkOption> linkOptions, Function1<A, ZIO<Has<package.Blocking.Service>, E, B>> f, ClassTag<A> evidence$1) {
        Class viewClass = scala.reflect.package$.MODULE$.classTag(evidence$1).runtimeClass();
        return zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Files.getFileAttributeView(path.javaPath(), viewClass, (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class)))).orDie((.less.colon.less)$less$colon$less$.MODULE$.refl(), CanFail$.MODULE$.canFail()).flatMap(f);
    }

    public <A extends BasicFileAttributes> ZIO<Has<package.Blocking.Service>, IOException, A> readAttributes(Path path, Seq<LinkOption> linkOptions, ClassTag<A> evidence$2) {
        Class attributeClass = scala.reflect.package$.MODULE$.classTag(evidence$2).runtimeClass();
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Files.readAttributes(path.javaPath(), attributeClass, (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class))))), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, Exception, BoxedUnit> setAttribute(Path path, Files.Attribute attribute, Object value, Seq<LinkOption> linkOptions) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Files.setAttribute(path.javaPath(), attribute.toJava(), value, (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class)))).unit()), ClassTag$.MODULE$.apply(Exception.class), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Object> getAttribute(Path path, Files.Attribute attribute, Seq<LinkOption> linkOptions) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Files.getAttribute(path.javaPath(), attribute.toJava(), (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class))))), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Map<String, Object>> readAttributes(Path path, Files.Attributes attributes, Seq<LinkOption> linkOptions) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Files.readAttributes(path.javaPath(), attributes.toJava(), (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class)))).map((Function1 & Serializable)x$7 -> CollectionConverters$.MODULE$.MapHasAsScala(x$7).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, IOException, scala.collection.immutable.Set<PosixFilePermission>> getPosixFilePermissions(Path path, Seq<LinkOption> linkOptions) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Files.getPosixFilePermissions(path.javaPath(), (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class)))).map((Function1 & Serializable)x$8 -> CollectionConverters$.MODULE$.SetHasAsScala(x$8).asScala().toSet())), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> setPosixFilePermissions(Path path, scala.collection.immutable.Set<PosixFilePermission> permissions) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Files.setPosixFilePermissions(path.javaPath(), CollectionConverters$.MODULE$.SetHasAsJava((Set)permissions).asJava())).unit()), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, IOException, UserPrincipal> getOwner(Path path, Seq<LinkOption> linkOptions) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Files.getOwner(path.javaPath(), (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class))))), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> setOwner(Path path, UserPrincipal owner) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Files.setOwner(path.javaPath(), owner)).unit()), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, Nothing$, Object> isSymbolicLink(Path path) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0)(JFunction0.mcZ.sp & Serializable)() -> Files.isSymbolicLink(path.javaPath())).orDie((.less.colon.less)$less$colon$less$.MODULE$.refl(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, Nothing$, Object> isDirectory(Path path, Seq<LinkOption> linkOptions) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0)(JFunction0.mcZ.sp & Serializable)() -> Files.isDirectory(path.javaPath(), (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class)))).orDie((.less.colon.less)$less$colon$less$.MODULE$.refl(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, Nothing$, Object> isRegularFile(Path path, Seq<LinkOption> linkOptions) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0)(JFunction0.mcZ.sp & Serializable)() -> Files.isRegularFile(path.javaPath(), (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class)))).orDie((.less.colon.less)$less$colon$less$.MODULE$.refl(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, IOException, FileTime> getLastModifiedTime(Path path, Seq<LinkOption> linkOptions) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Files.getLastModifiedTime(path.javaPath(), (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class))))), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> setLastModifiedTime(Path path, FileTime time) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Files.setLastModifiedTime(path.javaPath(), time)).unit()), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Object> size(Path path) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0)(JFunction0.mcJ.sp & Serializable)() -> Files.size(path.javaPath()))), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, Nothing$, Object> exists(Path path, Seq<LinkOption> linkOptions) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0)(JFunction0.mcZ.sp & Serializable)() -> Files.exists(path.javaPath(), (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class)))).orDie((.less.colon.less)$less$colon$less$.MODULE$.refl(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, Nothing$, Object> notExists(Path path, Seq<LinkOption> linkOptions) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0)(JFunction0.mcZ.sp & Serializable)() -> Files.notExists(path.javaPath(), (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class)))).orDie((.less.colon.less)$less$colon$less$.MODULE$.refl(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, Nothing$, Object> isReadable(Path path) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0)(JFunction0.mcZ.sp & Serializable)() -> Files.isReadable(path.javaPath())).orDie((.less.colon.less)$less$colon$less$.MODULE$.refl(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, Nothing$, Object> isWritable(Path path) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0)(JFunction0.mcZ.sp & Serializable)() -> Files.isWritable(path.javaPath())).orDie((.less.colon.less)$less$colon$less$.MODULE$.refl(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, Nothing$, Object> isExecutable(Path path) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0)(JFunction0.mcZ.sp & Serializable)() -> Files.isExecutable(path.javaPath())).orDie((.less.colon.less)$less$colon$less$.MODULE$.refl(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Chunk<Object>> readAllBytes(Path path) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Chunk$.MODULE$.fromArray((Object)Files.readAllBytes(path.javaPath())))), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, IOException, List<String>> readAllLines(Path path, Charset charset) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> CollectionConverters$.MODULE$.ListHasAsScala(Files.readAllLines(path.javaPath(), charset.javaCharset())).asScala().toList())), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public Charset readAllLines$default$2() {
        return Charset$Standard$.MODULE$.utf8();
    }

    public ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> writeBytes(Path path, Chunk<Object> bytes, Seq<OpenOption> openOptions) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Files.write(path.javaPath(), (byte[])bytes.toArray((ClassTag)ClassTag$.MODULE$.Byte()), (OpenOption[])openOptions.toArray(ClassTag$.MODULE$.apply(OpenOption.class)))).unit()), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> writeLines(Path path, Iterable<CharSequence> lines, Charset charset, scala.collection.immutable.Set<OpenOption> openOptions) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Files.write(path.javaPath(), (java.lang.Iterable<? extends CharSequence>)CollectionConverters$.MODULE$.IterableHasAsJava(lines).asJava(), charset.javaCharset(), (OpenOption[])openOptions.toSeq().toArray(ClassTag$.MODULE$.apply(OpenOption.class)))).unit()), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public Charset writeLines$default$3() {
        return Charset$Standard$.MODULE$.utf8();
    }

    public scala.collection.immutable.Set<OpenOption> writeLines$default$4() {
        return Predef$.MODULE$.Set().empty();
    }

    public ZStream<Has<package.Blocking.Service>, IOException, String> lines(Path path, Charset charset) {
        return ZStream.RefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZStream$.MODULE$.RefineToOrDieOps(ZStream$.MODULE$.fromJavaStreamManaged(ZManaged$.MODULE$.fromAutoCloseable(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Files.lines(path.javaPath(), charset.javaCharset()))))), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public Charset lines$default$2() {
        return Charset$Standard$.MODULE$.utf8();
    }

    public ZStream<Has<package.Blocking.Service>, IOException, Path> list(Path path) {
        return ZStream.RefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZStream$.MODULE$.RefineToOrDieOps(ZStream$.MODULE$.fromJavaStreamManaged(ZManaged$.MODULE$.fromAutoCloseable(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Files.list(path.javaPath())))).map((Function1 & Serializable)javaPath -> Path$.MODULE$.fromJava((java.nio.file.Path)javaPath))), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public ZStream<Has<package.Blocking.Service>, IOException, Path> walk(Path path, int maxDepth, scala.collection.immutable.Set<FileVisitOption> visitOptions) {
        return ZStream.RefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZStream$.MODULE$.RefineToOrDieOps(ZStream$.MODULE$.fromJavaStreamManaged(ZManaged$.MODULE$.fromAutoCloseable(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Files.walk(path.javaPath(), maxDepth, (FileVisitOption[])visitOptions.toSeq().toArray(ClassTag$.MODULE$.apply(FileVisitOption.class)))))).map((Function1 & Serializable)javaPath -> Path$.MODULE$.fromJava((java.nio.file.Path)javaPath))), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public int walk$default$2() {
        return Integer.MAX_VALUE;
    }

    public scala.collection.immutable.Set<FileVisitOption> walk$default$3() {
        return Predef$.MODULE$.Set().empty();
    }

    public ZStream<Has<package.Blocking.Service>, IOException, Path> find(Path path2, int maxDepth, scala.collection.immutable.Set<FileVisitOption> visitOptions, Function2<Path, BasicFileAttributes, Object> test) {
        BiPredicate<java.nio.file.Path, BasicFileAttributes> matcher = (path, attr) -> BoxesRunTime.unboxToBoolean((Object)test.apply((Object)Path$.MODULE$.fromJava((java.nio.file.Path)path), attr));
        return ZStream.RefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZStream$.MODULE$.RefineToOrDieOps(ZStream$.MODULE$.fromJavaStreamManaged(ZManaged$.MODULE$.fromAutoCloseable(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Files.find(path2.javaPath(), maxDepth, matcher, (FileVisitOption[])visitOptions.toSeq().toArray(ClassTag$.MODULE$.apply(FileVisitOption.class)))))).map((Function1 & Serializable)javaPath -> Path$.MODULE$.fromJava((java.nio.file.Path)javaPath))), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    public int find$default$2() {
        return Integer.MAX_VALUE;
    }

    public scala.collection.immutable.Set<FileVisitOption> find$default$3() {
        return Predef$.MODULE$.Set().empty();
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Object> copy(ZStream<Has<package.Blocking.Service>, IOException, Object> in, Path target, Seq<CopyOption> options) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(in.toInputStream((.less.colon.less)$less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl()).use((Function1 & Serializable)inputStream -> zio.blocking.package$.MODULE$.effectBlocking((Function0)(JFunction0.mcJ.sp & Serializable)() -> Files.copy(inputStream, target.javaPath(), (CopyOption[])options.toArray(ClassTag$.MODULE$.apply(CopyOption.class)))))), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail());
    }

    private Files$() {
    }
}

