/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.charset;

import java.io.Serializable;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichFloat$;
import zio.CanFail$;
import zio.Chunk;
import zio.Chunk$;
import zio.IO$;
import zio.UIO$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZManaged;
import zio.nio.Buffer$;
import zio.nio.ByteBuffer;
import zio.nio.CharBuffer;
import zio.nio.charset.AutoDetect;
import zio.nio.charset.AutoDetect$NotDetected$;
import zio.nio.charset.AutoDetect$NotSupported$;
import zio.nio.charset.Charset;
import zio.nio.charset.Charset$;
import zio.nio.charset.CharsetDecoder;
import zio.nio.charset.CoderResult;
import zio.nio.charset.CoderResult$;
import zio.nio.charset.CoderResult$Overflow$;
import zio.nio.charset.CoderResult$Underflow$;
import zio.stream.ZTransducer;
import zio.stream.ZTransducer$;

public final class CharsetDecoder$ {
    public static final CharsetDecoder$ MODULE$ = new CharsetDecoder$();

    public java.nio.charset.CharsetDecoder fromJava(java.nio.charset.CharsetDecoder javaDecoder) {
        return javaDecoder;
    }

    public final float averageCharsPerByte$extension(java.nio.charset.CharsetDecoder $this) {
        return $this.averageCharsPerByte();
    }

    public final Charset charset$extension(java.nio.charset.CharsetDecoder $this) {
        return Charset$.MODULE$.fromJava($this.charset());
    }

    public final ZIO<Object, CharacterCodingException, CharBuffer> decode$extension(java.nio.charset.CharsetDecoder $this, ByteBuffer in) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(in.withJavaBuffer((Function1 & Serializable)jBuf -> IO$.MODULE$.effect((Function0 & Serializable)() -> Buffer$.MODULE$.charFromJava($this.decode((java.nio.ByteBuffer)jBuf))))), ClassTag$.MODULE$.apply(CharacterCodingException.class), CanFail$.MODULE$.canFail());
    }

    public final ZIO<Object, Nothing$, CoderResult> decode$extension(java.nio.charset.CharsetDecoder $this, ByteBuffer in, CharBuffer out, boolean endOfInput) {
        return in.withJavaBuffer((Function1 & Serializable)jIn -> out.withJavaBuffer((Function1 & Serializable)jOut -> IO$.MODULE$.effectTotal((Function0 & Serializable)() -> CoderResult$.MODULE$.fromJava($this.decode((java.nio.ByteBuffer)jIn, (java.nio.CharBuffer)jOut, endOfInput)))));
    }

    public final ZIO<Object, Nothing$, AutoDetect> autoDetect$extension(java.nio.charset.CharsetDecoder $this) {
        return UIO$.MODULE$.effectTotal((Function0 & Serializable)() -> {
            if ($this.isAutoDetecting()) {
                if ($this.isCharsetDetected()) {
                    return new AutoDetect.Detected(Charset$.MODULE$.fromJava($this.detectedCharset()));
                }
                return AutoDetect$NotDetected$.MODULE$;
            }
            return AutoDetect$NotSupported$.MODULE$;
        });
    }

    public final ZIO<Object, Nothing$, CoderResult> flush$extension(java.nio.charset.CharsetDecoder $this, CharBuffer out) {
        return out.withJavaBuffer((Function1 & Serializable)jOut -> UIO$.MODULE$.effectTotal((Function0 & Serializable)() -> CoderResult$.MODULE$.fromJava($this.flush((java.nio.CharBuffer)jOut))));
    }

    public final ZIO<Object, Nothing$, CodingErrorAction> malformedInputAction$extension(java.nio.charset.CharsetDecoder $this) {
        return UIO$.MODULE$.effectTotal((Function0 & Serializable)() -> $this.malformedInputAction());
    }

    public final ZIO<Object, Nothing$, BoxedUnit> onMalformedInput$extension(java.nio.charset.CharsetDecoder $this, CodingErrorAction errorAction) {
        return UIO$.MODULE$.effectTotal((Function0 & Serializable)() -> $this.onMalformedInput(errorAction)).unit();
    }

    public final ZIO<Object, Nothing$, CodingErrorAction> unmappableCharacterAction$extension(java.nio.charset.CharsetDecoder $this) {
        return UIO$.MODULE$.effectTotal((Function0 & Serializable)() -> $this.unmappableCharacterAction());
    }

    public final ZIO<Object, Nothing$, BoxedUnit> onUnmappableCharacter$extension(java.nio.charset.CharsetDecoder $this, CodingErrorAction errorAction) {
        return UIO$.MODULE$.effectTotal((Function0 & Serializable)() -> $this.onUnmappableCharacter(errorAction)).unit();
    }

    public final float maxCharsPerByte$extension(java.nio.charset.CharsetDecoder $this) {
        return $this.maxCharsPerByte();
    }

    public final ZIO<Object, Nothing$, String> replacement$extension(java.nio.charset.CharsetDecoder $this) {
        return UIO$.MODULE$.effectTotal((Function0 & Serializable)() -> $this.replacement());
    }

    public final ZIO<Object, Nothing$, BoxedUnit> replaceWith$extension(java.nio.charset.CharsetDecoder $this, String replacement) {
        return UIO$.MODULE$.effectTotal((Function0 & Serializable)() -> $this.replaceWith(replacement)).unit();
    }

    public final ZIO<Object, Nothing$, BoxedUnit> reset$extension(java.nio.charset.CharsetDecoder $this) {
        return UIO$.MODULE$.effectTotal((Function0 & Serializable)() -> $this.reset()).unit();
    }

    public final ZTransducer<Object, CharacterCodingException, Object, Object> transducer$extension(java.nio.charset.CharsetDecoder $this, int bufSize) {
        ZManaged push = this.reset$extension($this).toManaged_().flatMap((Function1 & Serializable)x$8 -> Buffer$.MODULE$.byte(bufSize).toManaged_().flatMap((Function1 & Serializable)byteBuffer -> Buffer$.MODULE$.char(RichFloat$.MODULE$.round$extension(Predef$.MODULE$.floatWrapper((float)bufSize * MODULE$.averageCharsPerByte$extension($this)))).toManaged_().map((Function1 & Serializable)charBuffer -> (Function1 & Serializable)x$1 -> (ZIO)x$1.map((Function1 & Serializable)inChunk -> CharsetDecoder$.decodeChunk$1(inChunk, byteBuffer, $this, charBuffer)).getOrElse((Function0 & Serializable)() -> byteBuffer.flip().$times$greater((Function0 & Serializable)() -> CharsetDecoder$.endOfInput$2($this, byteBuffer, charBuffer).flatMap((Function1 & Serializable)decodedChars -> CharsetDecoder$.flushRemaining$1($this, charBuffer, byteBuffer).map((Function1 & Serializable)x$7 -> decodedChars.$plus$plus(x$7)))).$less$times((Function0 & Serializable)() -> byteBuffer.clear()).$less$times((Function0 & Serializable)() -> charBuffer.clear())))));
        if (bufSize < 50) {
            return ZTransducer$.MODULE$.die((Function0 & Serializable)() -> new IllegalArgumentException(new StringBuilder(30).append("Buffer size is ").append(bufSize).append(", must be >= 50").toString()));
        }
        return ZTransducer$.MODULE$.apply(push);
    }

    public final int transducer$default$1$extension(java.nio.charset.CharsetDecoder $this) {
        return 5000;
    }

    public final int hashCode$extension(java.nio.charset.CharsetDecoder $this) {
        return $this.hashCode();
    }

    public final boolean equals$extension(java.nio.charset.CharsetDecoder $this, Object x$1) {
        boolean bl = x$1 instanceof CharsetDecoder;
        if (bl) {
            java.nio.charset.CharsetDecoder charsetDecoder = x$1 == null ? null : ((CharsetDecoder)x$1).javaDecoder();
            java.nio.charset.CharsetDecoder charsetDecoder2 = $this;
            if (!(charsetDecoder2 != null ? !charsetDecoder2.equals(charsetDecoder) : charsetDecoder != null)) {
                return true;
            }
        }
        return false;
    }

    private static final ZIO handleCoderResult$1(CoderResult coderResult, ByteBuffer byteBuffer$1, CharBuffer charBuffer$1) {
        ZIO zIO;
        boolean bl = CoderResult$Underflow$.MODULE$.equals(coderResult) ? true : CoderResult$Overflow$.MODULE$.equals(coderResult);
        if (bl) {
            zIO = byteBuffer$1.compact().$times$greater((Function0 & Serializable)() -> charBuffer$1.flip()).$times$greater((Function0 & Serializable)() -> charBuffer$1.getChunk(charBuffer$1.getChunk$default$1())).$less$times((Function0 & Serializable)() -> charBuffer$1.clear());
        } else if (coderResult instanceof CoderResult.Malformed) {
            int length = ((CoderResult.Malformed)coderResult).length();
            zIO = IO$.MODULE$.fail((Function0 & Serializable)() -> new MalformedInputException(length));
        } else if (coderResult instanceof CoderResult.Unmappable) {
            int length = ((CoderResult.Unmappable)coderResult).length();
            zIO = IO$.MODULE$.fail((Function0 & Serializable)() -> new UnmappableCharacterException(length));
        } else {
            throw new MatchError((Object)coderResult);
        }
        return zIO;
    }

    public static final /* synthetic */ Tuple2 $anonfun$transducer$11(Chunk inBytes$1, int bufRemaining) {
        Tuple2 tuple2;
        Tuple2 tuple22 = tuple2 = inBytes$1.length() > bufRemaining ? inBytes$1.splitAt(bufRemaining) : new Tuple2((Object)inBytes$1, (Object)Chunk$.MODULE$.empty());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Chunk cfr_ignored_0 = (Chunk)tuple2._1();
        Chunk cfr_ignored_1 = (Chunk)tuple2._2();
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)bufRemaining), (Object)tuple2);
    }

    private static final ZIO decodeChunk$1(Chunk inBytes, ByteBuffer byteBuffer$1, java.nio.charset.CharsetDecoder $this$12, CharBuffer charBuffer$1) {
        return byteBuffer$1.remaining().map((Function1 & Serializable)bufRemaining -> CharsetDecoder$.$anonfun$transducer$11(inBytes, BoxesRunTime.unboxToInt((Object)bufRemaining))).flatMap((Function1 & Serializable)x$6 -> {
            Tuple2 tuple2;
            if (x$6 == null || (tuple2 = (Tuple2)x$6._2()) == null) {
                throw new MatchError(x$6);
            }
            Chunk decodeBytes = (Chunk)tuple2._1();
            Chunk remainingBytes = (Chunk)tuple2._2();
            ZIO zIO = byteBuffer$1.putChunk(decodeBytes).flatMap((Function1 & Serializable)x$5 -> byteBuffer$1.flip().flatMap((Function1 & Serializable)x$4 -> MODULE$.decode$extension($this$12, byteBuffer$1, charBuffer$1, false).flatMap((Function1 & Serializable)result -> CharsetDecoder$.handleCoderResult$1(result, byteBuffer$1, charBuffer$1).flatMap((Function1 & Serializable)decodedChars -> (remainingBytes.isEmpty() ? IO$.MODULE$.succeed((Function0 & Serializable)() -> Chunk$.MODULE$.empty()) : CharsetDecoder$.decodeChunk$1(remainingBytes, byteBuffer$1, $this$12, charBuffer$1)).map((Function1 & Serializable)remainderChars -> decodedChars.$plus$plus(remainderChars))))));
            return zIO;
        });
    }

    private static final ZIO endOfInput$2(java.nio.charset.CharsetDecoder $this$12, ByteBuffer byteBuffer$1, CharBuffer charBuffer$1) {
        return MODULE$.decode$extension($this$12, byteBuffer$1, charBuffer$1, true).flatMap((Function1 & Serializable)result -> CharsetDecoder$.handleCoderResult$1(result, byteBuffer$1, charBuffer$1).flatMap((Function1 & Serializable)decodedChars -> {
            CoderResult coderResult = result;
            CoderResult$Overflow$ coderResult$Overflow$ = CoderResult$Overflow$.MODULE$;
            return (coderResult != null && coderResult.equals(coderResult$Overflow$) ? CharsetDecoder$.endOfInput$2($this$12, byteBuffer$1, charBuffer$1) : IO$.MODULE$.succeed((Function0 & Serializable)() -> Chunk$.MODULE$.empty())).map((Function1 & Serializable)remainderChars -> decodedChars.$plus$plus(remainderChars));
        }));
    }

    private static final ZIO flushRemaining$1(java.nio.charset.CharsetDecoder $this$12, CharBuffer charBuffer$1, ByteBuffer byteBuffer$1) {
        return MODULE$.flush$extension($this$12, charBuffer$1).flatMap((Function1 & Serializable)result -> CharsetDecoder$.handleCoderResult$1(result, byteBuffer$1, charBuffer$1).flatMap((Function1 & Serializable)decodedChars -> {
            CoderResult coderResult = result;
            CoderResult$Overflow$ coderResult$Overflow$ = CoderResult$Overflow$.MODULE$;
            return (coderResult != null && coderResult.equals(coderResult$Overflow$) ? CharsetDecoder$.flushRemaining$1($this$12, charBuffer$1, byteBuffer$1) : IO$.MODULE$.succeed((Function0 & Serializable)() -> Chunk$.MODULE$.empty())).map((Function1 & Serializable)remainderChars -> decodedChars.$plus$plus(remainderChars));
        }));
    }

    private CharsetDecoder$() {
    }
}

