/*
 * Decompiled with CFR 0.152.
 */
package zio.stream.compression;

import java.io.Serializable;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import scala.Function0;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import zio.Chunk;
import zio.Chunk$;
import zio.ZIO;
import zio.ZIO$;
import zio.stream.compression.CompressionLevel;
import zio.stream.compression.CompressionStrategy;
import zio.stream.compression.Deflate$;
import zio.stream.compression.FlushMode;
import zio.stream.compression.Gzipper$;

@ScalaSignature(bytes="\u0006\u0005\u0005Mb!\u0002\u000f\u001e\u0001u\u0019\u0003\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\t\u0011=\u0002!\u0011!Q\u0001\nAB\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\tq\u0001\u0011\t\u0011)A\u0005s!)A\b\u0001C\u0001{!91\t\u0001b\u0001\n\u0013!\u0005BB(\u0001A\u0003%Q\tC\u0004Q\u0001\t\u0007I\u0011B)\t\ra\u0003\u0001\u0015!\u0003S\u0011\u001dI\u0006\u00011A\u0005\niCqA\u0018\u0001A\u0002\u0013%q\f\u0003\u0004f\u0001\u0001\u0006Ka\u0017\u0005\bM\u0002\u0001\r\u0011\"\u0003h\u0011\u001dY\u0007\u00011A\u0005\n1DaA\u001c\u0001!B\u0013A\u0007bB8\u0001\u0005\u0004%I\u0001\u001d\u0005\u0007i\u0002\u0001\u000b\u0011B9\t\u000bU\u0004A\u0011\u0001<\t\u000f\u0005%\u0001\u0001\"\u0001\u0002\f!9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0001bBA\u000b\u0001\u0011\u0005\u0011qC\u0004\t\u00033i\u0002\u0012A\u0010\u0002\u001c\u00199A$\bE\u0001?\u0005u\u0001B\u0002\u001f\u0018\t\u0003\ty\u0002C\u0005\u0002\"]\u0011\r\u0011\"\u0003\u0002\u0014!A\u00111E\f!\u0002\u0013\t\u0019\u0001C\u0004\u0002&]!\t!a\n\u0003\u000f\u001dS\u0018\u000e\u001d9fe*\u0011adH\u0001\fG>l\u0007O]3tg&|gN\u0003\u0002!C\u000511\u000f\u001e:fC6T\u0011AI\u0001\u0004u&|7C\u0001\u0001%!\t)\u0003&D\u0001'\u0015\u00059\u0013!B:dC2\f\u0017BA\u0015'\u0005\u0019\te.\u001f*fM\u0006Q!-\u001e4gKJ\u001c\u0016N_3\u0004\u0001A\u0011Q%L\u0005\u0003]\u0019\u00121!\u00138u\u0003\u0015aWM^3m!\t\t$'D\u0001\u001e\u0013\t\u0019TD\u0001\tD_6\u0004(/Z:tS>tG*\u001a<fY\u0006A1\u000f\u001e:bi\u0016<\u0017\u0010\u0005\u00022m%\u0011q'\b\u0002\u0014\u0007>l\u0007O]3tg&|gn\u0015;sCR,w-_\u0001\nM2,8\u000f['pI\u0016\u0004\"!\r\u001e\n\u0005mj\"!\u0003$mkNDWj\u001c3f\u0003\u0019a\u0014N\\5u}Q)ah\u0010!B\u0005B\u0011\u0011\u0007\u0001\u0005\u0006U\u0015\u0001\r\u0001\f\u0005\u0006_\u0015\u0001\r\u0001\r\u0005\u0006i\u0015\u0001\r!\u000e\u0005\u0006q\u0015\u0001\r!O\u0001\u0004GJ\u001cW#A#\u0011\u0005\u0019kU\"A$\u000b\u0005!K\u0015a\u0001>ja*\u0011!jS\u0001\u0005kRLGNC\u0001M\u0003\u0011Q\u0017M^1\n\u00059;%!B\"S\u0007N\u0012\u0014\u0001B2sG\u0002\naAY;gM\u0016\u0014X#\u0001*\u0011\u0007\u0015\u001aV+\u0003\u0002UM\t)\u0011I\u001d:bsB\u0011QEV\u0005\u0003/\u001a\u0012AAQ=uK\u00069!-\u001e4gKJ\u0004\u0013A\u00035fC\u0012,'oU3oiV\t1\f\u0005\u0002&9&\u0011QL\n\u0002\b\u0005>|G.Z1o\u00039AW-\u00193feN+g\u000e^0%KF$\"\u0001Y2\u0011\u0005\u0015\n\u0017B\u00012'\u0005\u0011)f.\u001b;\t\u000f\u0011\\\u0011\u0011!a\u00017\u0006\u0019\u0001\u0010J\u0019\u0002\u0017!,\u0017\rZ3s'\u0016tG\u000fI\u0001\nS:\u0004X\u000f^*ju\u0016,\u0012\u0001\u001b\t\u0003K%L!A\u001b\u0014\u0003\t1{gnZ\u0001\u000eS:\u0004X\u000f^*ju\u0016|F%Z9\u0015\u0005\u0001l\u0007b\u00023\u000f\u0003\u0003\u0005\r\u0001[\u0001\u000bS:\u0004X\u000f^*ju\u0016\u0004\u0013\u0001\u00033fM2\fG/\u001a:\u0016\u0003E\u0004\"A\u0012:\n\u0005M<%\u0001\u0003#fM2\fG/\u001a:\u0002\u0013\u0011,g\r\\1uKJ\u0004\u0013AB8o\u001d>tW-F\u0001x!\u0019A\u0018p\u001f@\u0002\u00045\t\u0011%\u0003\u0002{C\t\u0019!,S(\u0011\u0005\u0015b\u0018BA?'\u0005\r\te.\u001f\t\u0003K}L1!!\u0001'\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B\u0001_A\u0003+&\u0019\u0011qA\u0011\u0003\u000b\rCWO\\6\u0002\u000f=t7\t[;oWR\u0019q/!\u0004\t\u000f\u0005=1\u00031\u0001\u0002\u0004\u0005)1\r[;oW\u0006Qq-\u001a;Ue\u0006LG.\u001a:\u0016\u0005\u0005\r\u0011!B2m_N,G#\u00011\u0002\u000f\u001dS\u0018\u000e\u001d9feB\u0011\u0011gF\n\u0003/\u0011\"\"!a\u0007\u0002\r!,\u0017\rZ3s\u0003\u001dAW-\u00193fe\u0002\nA!\\1lKRQ\u0011\u0011FA\u0016\u0003[\ty#!\r\u0011\u000baL8P  \t\u000b)Z\u0002\u0019\u0001\u0017\t\u000b=Z\u0002\u0019\u0001\u0019\t\u000bQZ\u0002\u0019A\u001b\t\u000baZ\u0002\u0019A\u001d")
public class Gzipper {
    private final FlushMode flushMode;
    private final CRC32 crc;
    private final byte[] buffer;
    private boolean headerSent;
    private long inputSize;
    private final Deflater deflater;

    public static ZIO<Object, Nothing$, Gzipper> make(int bufferSize, CompressionLevel level, CompressionStrategy strategy, FlushMode flushMode) {
        return Gzipper$.MODULE$.make(bufferSize, level, strategy, flushMode);
    }

    private CRC32 crc() {
        return this.crc;
    }

    private byte[] buffer() {
        return this.buffer;
    }

    private boolean headerSent() {
        return this.headerSent;
    }

    private void headerSent_$eq(boolean x$1) {
        this.headerSent = x$1;
    }

    private long inputSize() {
        return this.inputSize;
    }

    private void inputSize_$eq(long x$1) {
        this.inputSize = x$1;
    }

    private Deflater deflater() {
        return this.deflater;
    }

    public ZIO<Object, Nothing$, Chunk<Object>> onNone() {
        return ZIO$.MODULE$.effectTotal((Function0 & Serializable)() -> {
            void var2_2;
            this.deflater().finish();
            Chunk restAndTrailer = Deflate$.MODULE$.pullOutput(this.deflater(), this.buffer(), $this.flushMode).$plus$plus(this.getTrailer());
            Chunk lastChunk = this.headerSent() ? restAndTrailer : Gzipper$.MODULE$.zio$stream$compression$Gzipper$$header().$plus$plus(restAndTrailer);
            this.deflater().reset();
            this.crc().reset();
            this.inputSize_$eq(0L);
            this.headerSent_$eq(false);
            return var2_2;
        });
    }

    public ZIO<Object, Nothing$, Chunk<Object>> onChunk(Chunk<Object> chunk) {
        return ZIO$.MODULE$.effectTotal((Function0 & Serializable)() -> {
            byte[] input = (byte[])chunk.toArray((ClassTag)ClassTag$.MODULE$.Byte());
            this.inputSize_$eq(this.inputSize() + (long)input.length);
            this.crc().update(input);
            this.deflater().setInput(input);
            Chunk<Object> deflated = Deflate$.MODULE$.pullOutput(this.deflater(), this.buffer(), $this.flushMode);
            if (this.headerSent()) {
                return deflated;
            }
            this.headerSent_$eq(true);
            return Gzipper$.MODULE$.zio$stream$compression$Gzipper$$header().$plus$plus(deflated);
        });
    }

    public Chunk<Object> getTrailer() {
        long v = this.crc().getValue();
        long s = this.inputSize() & 0xFFFFFFFFL;
        return Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapByteArray(new byte[]{Gzipper.byte$1(v, 0), Gzipper.byte$1(v, 1), Gzipper.byte$1(v, 2), Gzipper.byte$1(v, 3), Gzipper.byte$1(s, 0), Gzipper.byte$1(s, 1), Gzipper.byte$1(s, 2), Gzipper.byte$1(s, 3)}));
    }

    public void close() {
        this.deflater().finish();
    }

    private static final byte byte$1(long v, int n) {
        return (byte)(v >> n * 8 & 0xFFL);
    }

    public Gzipper(int bufferSize, CompressionLevel level, CompressionStrategy strategy, FlushMode flushMode) {
        this.flushMode = flushMode;
        this.crc = new CRC32();
        this.buffer = new byte[bufferSize];
        this.headerSent = false;
        this.inputSize = 0L;
        Deflater deflater = new Deflater(level.jValue(), true);
        deflater.setStrategy(strategy.jValue());
        this.deflater = deflater;
    }
}

