/*
 * Decompiled with CFR 0.152.
 */
package fs2.compression;

import cats.effect.kernel.Sync;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Pull;
import fs2.Pull$;
import fs2.Pull$StreamPullOps$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.Stream$InvariantOps$;
import fs2.Stream$ToPull$;
import fs2.compat.NotGiven$;
import fs2.compression.Compression;
import fs2.compression.CompressionCompanionPlatform$;
import fs2.compression.CompressionCompanionPlatform$$anon$1$gzipCompressionMethod$;
import fs2.compression.CompressionCompanionPlatform$$anon$1$gzipExtraFlag$;
import fs2.compression.CompressionCompanionPlatform$$anon$1$gzipFlag$;
import fs2.compression.CompressionCompanionPlatform$$anon$1$gzipOperatingSystem$;
import fs2.compression.CompressionPlatform;
import fs2.compression.DeflateParams;
import fs2.compression.GunzipResult;
import fs2.compression.GunzipResult$;
import fs2.compression.InflateParams;
import fs2.compression.ZLibParams;
import fs2.compression.ZLibParams$Header$GZIP$;
import java.io.EOFException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005Y2\u0001b\u0001\u0003\u0011\u0002\u0007\u0005A\u0001\u0003\u0005\u0006\u001f\u0001!\t!\u0005\u0005\u0006+\u0001!\u0019A\u0006\u0002\u001d\u0007>l\u0007O]3tg&|gnQ8na\u0006t\u0017n\u001c8QY\u0006$hm\u001c:n\u0015\t)a!A\u0006d_6\u0004(/Z:tS>t'\"A\u0004\u0002\u0007\u0019\u001c(g\u0005\u0002\u0001\u0013A\u0011!\"D\u0007\u0002\u0017)\tA\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000f\u0017\t1\u0011I\\=SK\u001a\fa\u0001J5oSR$3\u0001\u0001\u000b\u0002%A\u0011!bE\u0005\u0003)-\u0011A!\u00168ji\u00069am\u001c:Ts:\u001cWCA\f\u001f)\tA\"\u0006E\u0002\u001a5qi\u0011\u0001B\u0005\u00037\u0011\u00111bQ8naJ,7o]5p]B\u0011QD\b\u0007\u0001\t\u0015y\"A1\u0001!\u0005\u00051UCA\u0011)#\t\u0011S\u0005\u0005\u0002\u000bG%\u0011Ae\u0003\u0002\b\u001d>$\b.\u001b8h!\tQa%\u0003\u0002(\u0017\t\u0019\u0011I\\=\u0005\u000b%r\"\u0019A\u0011\u0003\t}#CE\r\u0005\u0006W\t\u0001\u001d\u0001L\u0001\u0002\rB\u0019Q\u0006\u000e\u000f\u000e\u00039R!a\f\u0019\u0002\r-,'O\\3m\u0015\t\t$'\u0001\u0004fM\u001a,7\r\u001e\u0006\u0002g\u0005!1-\u0019;t\u0013\t)dF\u0001\u0003Ts:\u001c\u0007")
public interface CompressionCompanionPlatform {
    public static /* synthetic */ Compression forSync$(CompressionCompanionPlatform $this, Sync F) {
        return $this.forSync(F);
    }

    default public <F> Compression<F> forSync(Sync<F> F) {
        return new Compression.UnsealedCompression<F>(null, F){
            private volatile CompressionCompanionPlatform$$anon$1$gzipCompressionMethod$ gzipCompressionMethod$module;
            private volatile CompressionCompanionPlatform$$anon$1$gzipFlag$ gzipFlag$module;
            private volatile CompressionCompanionPlatform$$anon$1$gzipExtraFlag$ gzipExtraFlag$module;
            private volatile CompressionCompanionPlatform$$anon$1$gzipOperatingSystem$ gzipOperatingSystem$module;
            private final int gzipHeaderBytes;
            private final byte gzipMagicFirstByte;
            private final byte gzipMagicSecondByte;
            private final int gzipOptionalExtraFieldLengthBytes;
            private final int gzipHeaderCrcBytes;
            private final int gzipInputCrcBytes;
            private final int gzipInputSizeBytes;
            private final int gzipTrailerBytes;
            private final byte zeroByte;
            private final int fileNameBytesSoftLimit;
            private final int fileCommentBytesSoftLimit;
            private final Sync F$1;

            public Function1<Stream<F, Object>, Stream<F, Object>> gzip(int bufferSize, Option<Object> deflateLevel, Option<Object> deflateStrategy, Option<Instant> modificationTime, Option<String> fileName, Option<String> comment) {
                return CompressionPlatform.gzip$(this, bufferSize, deflateLevel, deflateStrategy, modificationTime, fileName, comment);
            }

            public int gzip$default$1() {
                return CompressionPlatform.gzip$default$1$(this);
            }

            public Option<Object> gzip$default$2() {
                return CompressionPlatform.gzip$default$2$(this);
            }

            public Option<Object> gzip$default$3() {
                return CompressionPlatform.gzip$default$3$(this);
            }

            public Option<Instant> gzip$default$4() {
                return CompressionPlatform.gzip$default$4$(this);
            }

            public Option<String> gzip$default$5() {
                return CompressionPlatform.gzip$default$5$(this);
            }

            public Option<String> gzip$default$6() {
                return CompressionPlatform.gzip$default$6$(this);
            }

            public Function1<Stream<F, Object>, Stream<F, GunzipResult<F>>> gunzip(int bufferSize) {
                return CompressionPlatform.gunzip$(this, bufferSize);
            }

            public int gunzip$default$1() {
                return CompressionPlatform.gunzip$default$1$(this);
            }

            private CompressionCompanionPlatform$$anon$1$gzipCompressionMethod$ gzipCompressionMethod() {
                if (this.gzipCompressionMethod$module == null) {
                    this.gzipCompressionMethod$lzycompute$1();
                }
                return this.gzipCompressionMethod$module;
            }

            private CompressionCompanionPlatform$$anon$1$gzipFlag$ gzipFlag() {
                if (this.gzipFlag$module == null) {
                    this.gzipFlag$lzycompute$1();
                }
                return this.gzipFlag$module;
            }

            private CompressionCompanionPlatform$$anon$1$gzipExtraFlag$ gzipExtraFlag() {
                if (this.gzipExtraFlag$module == null) {
                    this.gzipExtraFlag$lzycompute$1();
                }
                return this.gzipExtraFlag$module;
            }

            private CompressionCompanionPlatform$$anon$1$gzipOperatingSystem$ gzipOperatingSystem() {
                if (this.gzipOperatingSystem$module == null) {
                    this.gzipOperatingSystem$lzycompute$1();
                }
                return this.gzipOperatingSystem$module;
            }

            public Function1<Stream<F, Object>, Stream<F, Object>> deflate(DeflateParams deflateParams) {
                return (Function1 & Serializable)stream -> Stream$.MODULE$.bracket($this.F$1.delay((Function0 & Serializable)() -> {
                    void var1_1;
                    Deflater deflater = new Deflater(deflateParams.level().juzDeflaterLevel(), deflateParams.header().juzDeflaterNoWrap());
                    deflater.setStrategy(deflateParams.strategy().juzDeflaterStrategy());
                    return var1_1;
                }), (Function1 & Serializable)deflater -> $this.F$1.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> deflater.end())).flatMap((Function1 & Serializable)deflater -> (Stream)this._deflate(deflateParams, (Deflater)deflater, (Option<CRC32>)None$.MODULE$).apply(stream), NotGiven$.MODULE$.default());
            }

            private Function1<Stream<F, Object>, Stream<F, Object>> _deflate(DeflateParams deflateParams, Deflater deflater, Option<CRC32> crc32) {
                return (Function1 & Serializable)in -> Stream$.MODULE$.suspend((Function0 & Serializable)() -> {
                    byte[] deflatedBuffer = new byte[deflateParams.bufferSizeOrMinimum()];
                    return Pull$StreamPullOps$.MODULE$.stream$extension(Pull$.MODULE$.StreamPullOps((Pull)this._deflate_stream(deflateParams, deflater, crc32, deflatedBuffer).apply(in)));
                });
            }

            private Pull<F, Object, BoxedUnit> _deflate_chunk(DeflateParams deflateParams, Deflater deflater, Option<CRC32> crc32, Chunk<Object> chunk, byte[] deflatedBuffer, boolean isFinalChunk) {
                Chunk.ArraySlice<O2> bytesChunk = chunk.toArraySlice(ClassTag$.MODULE$.Byte());
                deflater.setInput((byte[])bytesChunk.values(), bytesChunk.offset(), bytesChunk.length());
                if (isFinalChunk) {
                    deflater.finish();
                }
                crc32.foreach((Function1 & Serializable)x$1 -> {
                    $anon$1.$anonfun$_deflate_chunk$1(bytesChunk, x$1);
                    return BoxedUnit.UNIT;
                });
                return this.pull$1(deflatedBuffer, deflater, deflateParams, isFinalChunk);
            }

            private Function1<Stream<F, Object>, Pull<F, Object, BoxedUnit>> _deflate_stream(DeflateParams deflateParams, Deflater deflater, Option<CRC32> crc32, byte[] deflatedBuffer) {
                return (Function1 & Serializable)x$2 -> Stream$ToPull$.MODULE$.uncons$extension(Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(x$2))).flatMap((Function1 & Serializable)x0$1 -> {
                    Pull<Object, Object, Object> pull;
                    Some some;
                    Tuple2 tuple2;
                    Option option = x0$1;
                    if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                        Chunk inflatedChunk = (Chunk)tuple2._1();
                        Stream inflatedStream = (Stream)tuple2._2();
                        pull = this._deflate_chunk(deflateParams, deflater, crc32, inflatedChunk, deflatedBuffer, false).$greater$greater((Function0 & Serializable)() -> (Pull)this._deflate_stream(deflateParams, deflater, crc32, deflatedBuffer).apply((Object)inflatedStream));
                    } else if (None$.MODULE$.equals(option)) {
                        pull = this._deflate_chunk(deflateParams, deflater, crc32, Chunk$.MODULE$.empty(), deflatedBuffer, true);
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return pull;
                });
            }

            public Function1<Stream<F, Object>, Stream<F, Object>> inflate(InflateParams inflateParams) {
                return (Function1 & Serializable)stream -> Pull$StreamPullOps$.MODULE$.stream$extension(Pull$.MODULE$.StreamPullOps(Pull$.MODULE$.bracketCase(Pull$.MODULE$.eval($this.F$1.delay((Function0 & Serializable)() -> new Inflater(inflateParams.header().juzDeflaterNoWrap()))), (Function1 & Serializable)inflater -> (Pull)this._inflate(inflateParams, (Inflater)inflater, (Option<CRC32>)None$.MODULE$).apply(stream), (Function2 & Serializable)(inflater, x$3) -> Pull$.MODULE$.eval($this.F$1.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> inflater.end())))));
            }

            private Function1<Stream<F, Object>, Pull<F, Object, BoxedUnit>> _inflate(InflateParams inflateParams, Inflater inflater, Option<CRC32> crc32) {
                return (Function1 & Serializable)in -> Pull$.MODULE$.suspend((Function0 & Serializable)() -> {
                    byte[] inflatedBuffer = new byte[inflateParams.bufferSizeOrMinimum()];
                    return Stream$ToPull$.MODULE$.uncons$extension(Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(in))).flatMap((Function1 & Serializable)x0$1 -> {
                        Pull<Object, Object, Object> pull;
                        Some some;
                        Tuple2 tuple2;
                        Option option = x0$1;
                        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                            Chunk deflatedChunk = (Chunk)tuple2._1();
                            Stream deflatedStream = (Stream)tuple2._2();
                            pull = this._inflate_chunk(inflater, crc32, deflatedChunk, inflatedBuffer).$greater$greater((Function0 & Serializable)() -> (Pull)this._inflate_stream(inflateParams, inflater, crc32, inflatedBuffer).apply((Object)deflatedStream));
                        } else if (None$.MODULE$.equals(option)) {
                            pull = Pull$.MODULE$.done();
                        } else {
                            throw new MatchError((Object)option);
                        }
                        return pull;
                    });
                });
            }

            private Pull<F, Object, BoxedUnit> _inflate_chunk(Inflater inflater, Option<CRC32> crc32, Chunk<Object> chunk, byte[] inflatedBuffer) {
                Chunk.ArraySlice<O2> bytesChunk = chunk.toArraySlice(ClassTag$.MODULE$.Byte());
                inflater.setInput((byte[])bytesChunk.values(), bytesChunk.offset(), bytesChunk.length());
                return this.pull$2(inflater, bytesChunk, inflatedBuffer, crc32);
            }

            private Function1<Stream<F, Object>, Pull<F, Object, BoxedUnit>> _inflate_stream(InflateParams inflateParams, Inflater inflater, Option<CRC32> crc32, byte[] inflatedBuffer) {
                return (Function1 & Serializable)x$5 -> Stream$ToPull$.MODULE$.uncons$extension(Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(x$5))).flatMap((Function1 & Serializable)x0$1 -> {
                    Pull<Object, Object, Object> pull;
                    Some some;
                    Tuple2 tuple2;
                    Option option = x0$1;
                    if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                        Chunk deflatedChunk = (Chunk)tuple2._1();
                        Stream deflatedStream = (Stream)tuple2._2();
                        pull = this._inflate_chunk(inflater, crc32, deflatedChunk, inflatedBuffer).$greater$greater((Function0 & Serializable)() -> (Pull)this._inflate_stream(inflateParams, inflater, crc32, inflatedBuffer).apply((Object)deflatedStream));
                    } else if (None$.MODULE$.equals(option)) {
                        pull = !inflater.finished() ? Pull$.MODULE$.raiseError(new DataFormatException("Insufficient data"), RaiseThrowable$.MODULE$.fromApplicativeError($this.F$1)) : Pull$.MODULE$.done();
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return pull;
                });
            }

            public Function1<Stream<F, Object>, Stream<F, Object>> gzip(Option<String> fileName, Option<Instant> modificationTime, Option<String> comment, DeflateParams deflateParams) {
                return (Function1 & Serializable)stream -> {
                    void var6_11;
                    DeflateParams deflateParams = deflateParams;
                    if (deflateParams != null) {
                        DeflateParams deflateParams2 = deflateParams;
                        ZLibParams.Header header = deflateParams2.header();
                        ZLibParams$Header$GZIP$ zLibParams$Header$GZIP$ = ZLibParams$Header$GZIP$.MODULE$;
                        if (!(header != null ? !header.equals(zLibParams$Header$GZIP$) : zLibParams$Header$GZIP$ != null)) {
                            Stream<F2, O2> stream2 = Stream$.MODULE$.bracket($this.F$1.delay((Function0 & Serializable)() -> {
                                Deflater deflater = new Deflater(deflateParams2.level().juzDeflaterLevel(), true);
                                deflater.setStrategy(deflateParams2.strategy().juzDeflaterStrategy());
                                return new Tuple2((Object)deflater, (Object)new CRC32());
                            }), (Function1 & Serializable)x0$1 -> {
                                Tuple2 tuple2 = x0$1;
                                if (tuple2 == null) {
                                    throw new MatchError((Object)tuple2);
                                }
                                Deflater deflater = (Deflater)tuple2._1();
                                Object object = $this.F$1.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> deflater.end());
                                return object;
                            }).flatMap((Function1 & Serializable)x0$2 -> {
                                Tuple2 tuple2 = x0$2;
                                if (tuple2 == null) {
                                    throw new MatchError((Object)tuple2);
                                }
                                Deflater deflater = (Deflater)tuple2._1();
                                CRC32 crc32 = (CRC32)tuple2._2();
                                Stream<F2, O2> stream = this._gzip_header(fileName, modificationTime, comment, deflateParams2.level().juzDeflaterLevel(), deflateParams2.fhCrcEnabled()).$plus$plus((Function0 & Serializable)() -> (Stream)this._deflate(deflateParams2, deflater, (Option<CRC32>)new Some((Object)crc32)).apply(stream)).$plus$plus((Function0 & Serializable)() -> this._gzip_trailer(deflater, crc32));
                                return stream;
                            }, NotGiven$.MODULE$.default());
                            return var6_11;
                        }
                    }
                    if (deflateParams == null) throw new MatchError((Object)deflateParams);
                    DeflateParams deflateParams3 = deflateParams;
                    Stream<F, Nothing$> stream3 = Stream$.MODULE$.raiseError(new ZipException(new StringBuilder(28).append(ZLibParams$Header$GZIP$.MODULE$).append(" header type required, not ").append(deflateParams3.header()).append(".").toString()), RaiseThrowable$.MODULE$.fromApplicativeError($this.F$1));
                    return var6_11;
                };
            }

            private Stream<F, Object> _gzip_header(Option<String> fileName, Option<Instant> modificationTime, Option<String> comment, int deflateLevel, boolean fhCrcEnabled) {
                byte by;
                long secondsSince197001010000 = BoxesRunTime.unboxToLong((Object)modificationTime.map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)$anon$1.$anonfun$_gzip_header$1(x$6))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
                byte[] byArray = new byte[10];
                byArray[0] = this.gzipMagicFirstByte();
                byArray[1] = this.gzipMagicSecondByte();
                byArray[2] = this.gzipCompressionMethod().DEFLATE();
                byArray[3] = (byte)((fhCrcEnabled ? this.gzipFlag().FHCRC() : this.zeroByte()) + BoxesRunTime.unboxToByte((Object)fileName.map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToByte((byte)$anon$1.$anonfun$_gzip_header$3(this, x$7))).getOrElse((Function0)(JFunction0.mcB.sp & Serializable)() -> this.zeroByte())) + BoxesRunTime.unboxToByte((Object)comment.map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToByte((byte)$anon$1.$anonfun$_gzip_header$5(this, x$8))).getOrElse((Function0)(JFunction0.mcB.sp & Serializable)() -> this.zeroByte())));
                byArray[4] = (byte)(secondsSince197001010000 & 0xFFL);
                byArray[5] = (byte)(secondsSince197001010000 >> 8 & 0xFFL);
                byArray[6] = (byte)(secondsSince197001010000 >> 16 & 0xFFL);
                byArray[7] = (byte)(secondsSince197001010000 >> 24 & 0xFFL);
                int n = deflateLevel;
                switch (n) {
                    case 9: {
                        by = this.gzipExtraFlag().DEFLATE_MAX_COMPRESSION_SLOWEST_ALGO();
                        break;
                    }
                    case 1: {
                        by = this.gzipExtraFlag().DEFLATE_FASTEST_ALGO();
                        break;
                    }
                    default: {
                        by = this.zeroByte();
                        break;
                    }
                }
                byArray[8] = by;
                byArray[9] = this.gzipOperatingSystem().THIS();
                byte[] header = byArray;
                CRC32 crc32 = new CRC32();
                crc32.update(header);
                Option fileNameEncoded = fileName.map((Function1 & Serializable)string -> {
                    void var3_3;
                    byte[] bytes = string.replaceAll("\u0000", "_").getBytes(StandardCharsets.ISO_8859_1);
                    crc32.update(bytes);
                    crc32.update(this.zeroByte());
                    return var3_3;
                });
                Option commentEncoded = comment.map((Function1 & Serializable)string -> {
                    void var3_3;
                    byte[] bytes = string.replaceAll("\u0000", " ").getBytes(StandardCharsets.ISO_8859_1);
                    crc32.update(bytes);
                    crc32.update(this.zeroByte());
                    return var3_3;
                });
                long crc32Value = crc32.getValue();
                byte[] crc16 = fhCrcEnabled ? new byte[]{(byte)(crc32Value & 0xFFL), (byte)(crc32Value >> 8 & 0xFFL)} : Array$.MODULE$.emptyByteArray();
                return Stream$.MODULE$.chunk(this.moveAsChunkBytes(header)).$plus$plus((Function0 & Serializable)() -> (Stream)fileNameEncoded.map((Function1 & Serializable)bytes -> Stream$.MODULE$.chunk(this.moveAsChunkBytes((byte[])bytes)).$plus$plus((Function0 & Serializable)() -> Stream$.MODULE$.emit(BoxesRunTime.boxToByte((byte)this.zeroByte())))).getOrElse((Function0 & Serializable)() -> Stream$.MODULE$.empty())).$plus$plus((Function0 & Serializable)() -> (Stream)commentEncoded.map((Function1 & Serializable)bytes -> Stream$.MODULE$.chunk(this.moveAsChunkBytes((byte[])bytes)).$plus$plus((Function0 & Serializable)() -> Stream$.MODULE$.emit(BoxesRunTime.boxToByte((byte)this.zeroByte())))).getOrElse((Function0 & Serializable)() -> Stream$.MODULE$.empty())).$plus$plus((Function0 & Serializable)() -> Stream$.MODULE$.chunk(this.moveAsChunkBytes(crc16)));
            }

            private Stream<F, Object> _gzip_trailer(Deflater deflater, CRC32 crc32) {
                long crc32Value = crc32.getValue();
                int bytesIn = deflater.getTotalIn();
                byte[] trailer = new byte[]{(byte)(crc32Value & 0xFFL), (byte)(crc32Value >> 8 & 0xFFL), (byte)(crc32Value >> 16 & 0xFFL), (byte)(crc32Value >> 24 & 0xFFL), (byte)(bytesIn & 0xFF), (byte)(bytesIn >> 8 & 0xFF), (byte)(bytesIn >> 16 & 0xFF), (byte)(bytesIn >> 24 & 0xFF)};
                return Stream$.MODULE$.chunk(this.moveAsChunkBytes(trailer));
            }

            public Function1<Stream<F, Object>, Stream<F, GunzipResult<F>>> gunzip(InflateParams inflateParams) {
                return (Function1 & Serializable)stream -> {
                    void var3_8;
                    InflateParams inflateParams = inflateParams;
                    if (inflateParams != null) {
                        InflateParams inflateParams2 = inflateParams;
                        ZLibParams.Header header = inflateParams2.header();
                        ZLibParams$Header$GZIP$ zLibParams$Header$GZIP$ = ZLibParams$Header$GZIP$.MODULE$;
                        if (!(header != null ? !header.equals(zLibParams$Header$GZIP$) : zLibParams$Header$GZIP$ != null)) {
                            Stream<Object, Nothing$> stream2 = Pull$StreamPullOps$.MODULE$.stream$extension(Pull$.MODULE$.StreamPullOps(Pull$.MODULE$.bracketCase(Pull$.MODULE$.eval($this.F$1.delay((Function0 & Serializable)() -> new Tuple3((Object)new Inflater(true), (Object)new CRC32(), (Object)new CRC32()))), (Function1 & Serializable)x0$1 -> {
                                Tuple3 tuple3 = x0$1;
                                if (tuple3 == null) {
                                    throw new MatchError((Object)tuple3);
                                }
                                Inflater inflater = (Inflater)tuple3._1();
                                CRC32 headerCrc32 = (CRC32)tuple3._2();
                                CRC32 contentCrc32 = (CRC32)tuple3._3();
                                Stream<F, O> qual$1 = Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(stream));
                                int x$1 = this.gzipHeaderBytes();
                                boolean x$2 = Stream$ToPull$.MODULE$.unconsN$default$2$extension(qual$1);
                                Pull<F2, O2, R2> pull = Stream$ToPull$.MODULE$.unconsN$extension(qual$1, x$1, x$2).flatMap((Function1 & Serializable)x0$2 -> {
                                    Pull<Object, GunzipResult<F>, BoxedUnit> pull;
                                    Some some;
                                    Tuple2 tuple2;
                                    Option option = x0$2;
                                    if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                                        Chunk mandatoryHeaderChunk = (Chunk)tuple2._1();
                                        Stream streamAfterMandatoryHeader = (Stream)tuple2._2();
                                        pull = this._gunzip_matchMandatoryHeader(inflateParams2, mandatoryHeaderChunk, streamAfterMandatoryHeader, headerCrc32, contentCrc32, inflater);
                                    } else if (None$.MODULE$.equals(option)) {
                                        pull = Pull$.MODULE$.output1(new GunzipResult<F>(Stream$.MODULE$.raiseError(new EOFException(), RaiseThrowable$.MODULE$.fromApplicativeError($this.F$1)), GunzipResult$.MODULE$.apply$default$2(), GunzipResult$.MODULE$.apply$default$3(), GunzipResult$.MODULE$.apply$default$4()));
                                    } else {
                                        throw new MatchError((Object)option);
                                    }
                                    return pull;
                                });
                                return pull;
                            }, (Function2 & Serializable)(x0$3, x1$1) -> {
                                Tuple3 tuple3;
                                Tuple2 tuple2 = new Tuple2(x0$3, x1$1);
                                if (tuple2 == null || (tuple3 = (Tuple3)tuple2._1()) == null) {
                                    throw new MatchError((Object)tuple2);
                                }
                                Inflater inflater = (Inflater)tuple3._1();
                                Pull<Object, Nothing$, R> pull = Pull$.MODULE$.eval($this.F$1.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> inflater.end()));
                                return pull;
                            })));
                            return var3_8;
                        }
                    }
                    if (inflateParams == null) throw new MatchError((Object)inflateParams);
                    InflateParams inflateParams3 = inflateParams;
                    Stream<F, Nothing$> stream3 = Stream$.MODULE$.raiseError(new ZipException(new StringBuilder(28).append(ZLibParams$Header$GZIP$.MODULE$).append(" header type required, not ").append(inflateParams3.header()).append(".").toString()), RaiseThrowable$.MODULE$.fromApplicativeError($this.F$1));
                    return var3_8;
                };
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            private Pull<?, GunzipResult<F>, BoxedUnit> _gunzip_matchMandatoryHeader(InflateParams inflateParams, Chunk<Object> mandatoryHeaderChunk, Stream<F, Object> streamAfterMandatoryHeader, CRC32 headerCrc32, CRC32 contentCrc32, Inflater inflater) {
                void var7_21;
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)mandatoryHeaderChunk.size()), mandatoryHeaderChunk.toArraySlice(ClassTag$.MODULE$.Byte()).values());
                if (tuple2 != null) {
                    Object object;
                    int n = tuple2._1$mcI$sp();
                    byte[] byArray = (byte[])tuple2._2();
                    if (this.gzipHeaderBytes() == n && byArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)byArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 9) == 0) {
                        byte by = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0));
                        byte by2 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1));
                        byte by3 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2));
                        byte flags = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 3));
                        if (this.gzipMagicFirstByte() == by && this.gzipMagicSecondByte() == by2 && this.gzipCompressionMethod().DEFLATE() == by3 && this.gzipFlag().reserved5(flags)) {
                            Pull<F, GunzipResult<F>, BoxedUnit> pull = Pull$.MODULE$.output1(new GunzipResult<F>(Stream$.MODULE$.raiseError(new ZipException("Unsupported gzip flag reserved bit 5 is non-zero"), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1)), GunzipResult$.MODULE$.apply$default$2(), GunzipResult$.MODULE$.apply$default$3(), GunzipResult$.MODULE$.apply$default$4()));
                            return var7_21;
                        }
                    }
                }
                if (tuple2 != null) {
                    Object object;
                    int n = tuple2._1$mcI$sp();
                    byte[] byArray = (byte[])tuple2._2();
                    if (this.gzipHeaderBytes() == n && byArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)byArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 9) == 0) {
                        byte by = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0));
                        byte by4 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1));
                        byte by5 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2));
                        byte flags = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 3));
                        if (this.gzipMagicFirstByte() == by && this.gzipMagicSecondByte() == by4 && this.gzipCompressionMethod().DEFLATE() == by5 && this.gzipFlag().reserved6(flags)) {
                            Pull<F, GunzipResult<F>, BoxedUnit> pull = Pull$.MODULE$.output1(new GunzipResult<F>(Stream$.MODULE$.raiseError(new ZipException("Unsupported gzip flag reserved bit 6 is non-zero"), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1)), GunzipResult$.MODULE$.apply$default$2(), GunzipResult$.MODULE$.apply$default$3(), GunzipResult$.MODULE$.apply$default$4()));
                            return var7_21;
                        }
                    }
                }
                if (tuple2 != null) {
                    Object object;
                    int n = tuple2._1$mcI$sp();
                    byte[] byArray = (byte[])tuple2._2();
                    if (this.gzipHeaderBytes() == n && byArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)byArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 9) == 0) {
                        byte by = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0));
                        byte by6 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1));
                        byte by7 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2));
                        byte flags = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 3));
                        if (this.gzipMagicFirstByte() == by && this.gzipMagicSecondByte() == by6 && this.gzipCompressionMethod().DEFLATE() == by7 && this.gzipFlag().reserved7(flags)) {
                            Pull<F, GunzipResult<F>, BoxedUnit> pull = Pull$.MODULE$.output1(new GunzipResult<F>(Stream$.MODULE$.raiseError(new ZipException("Unsupported gzip flag reserved bit 7 is non-zero"), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1)), GunzipResult$.MODULE$.apply$default$2(), GunzipResult$.MODULE$.apply$default$3(), GunzipResult$.MODULE$.apply$default$4()));
                            return var7_21;
                        }
                    }
                }
                if (tuple2 != null) {
                    Object object;
                    int n = tuple2._1$mcI$sp();
                    byte[] header = (byte[])tuple2._2();
                    if (this.gzipHeaderBytes() == n && header != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)header)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 10) == 0) {
                        byte by = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0));
                        byte by8 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1));
                        byte by9 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2));
                        byte flags = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 3));
                        if (this.gzipMagicFirstByte() == by && this.gzipMagicSecondByte() == by8 && this.gzipCompressionMethod().DEFLATE() == by9) {
                            headerCrc32.update(header);
                            long secondsSince197001010000 = this.unsignedToLong(header[4], header[5], header[6], header[7]);
                            Pull<F2, O2, R2> pull = Stream$ToPull$.MODULE$.uncons1$extension(Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(this._gunzip_readOptionalHeader(inflateParams, streamAfterMandatoryHeader, flags, headerCrc32, contentCrc32, secondsSince197001010000, inflater)))).flatMap((Function1 & Serializable)x0$1 -> {
                                Pull<F, GunzipResult, BoxedUnit> pull;
                                Some some;
                                Tuple2 tuple2;
                                Option option = x0$1;
                                if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                                    GunzipResult gunzipResult = (GunzipResult)tuple2._1();
                                    pull = Pull$.MODULE$.output1(gunzipResult);
                                } else if (None$.MODULE$.equals(option)) {
                                    pull = Pull$.MODULE$.output1(new GunzipResult<F>(Stream$.MODULE$.raiseError(new EOFException(), RaiseThrowable$.MODULE$.fromApplicativeError($this.F$1)), GunzipResult$.MODULE$.apply$default$2(), GunzipResult$.MODULE$.apply$default$3(), GunzipResult$.MODULE$.apply$default$4()));
                                } else {
                                    throw new MatchError((Object)option);
                                }
                                return pull;
                            });
                            return var7_21;
                        }
                    }
                }
                if (tuple2 != null) {
                    Object object;
                    int n = tuple2._1$mcI$sp();
                    byte[] byArray = (byte[])tuple2._2();
                    if (this.gzipHeaderBytes() == n && byArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)byArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 10) == 0) {
                        byte by = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0));
                        byte by10 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1));
                        byte compressionMethod = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2));
                        if (this.gzipMagicFirstByte() == by && this.gzipMagicSecondByte() == by10) {
                            Pull<F, GunzipResult<F>, BoxedUnit> pull = Pull$.MODULE$.output1(new GunzipResult<F>(Stream$.MODULE$.raiseError(new ZipException(new StringBuilder(37).append("Unsupported gzip compression method: ").append(compressionMethod).toString()), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1)), GunzipResult$.MODULE$.apply$default$2(), GunzipResult$.MODULE$.apply$default$3(), GunzipResult$.MODULE$.apply$default$4()));
                            return var7_21;
                        }
                    }
                }
                Pull<F, GunzipResult<F>, BoxedUnit> pull = Pull$.MODULE$.output1(new GunzipResult<F>(Stream$.MODULE$.raiseError(new ZipException("Not in gzip format"), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1)), GunzipResult$.MODULE$.apply$default$2(), GunzipResult$.MODULE$.apply$default$3(), GunzipResult$.MODULE$.apply$default$4()));
                return var7_21;
            }

            private Stream<F, GunzipResult<F>> _gunzip_readOptionalHeader(InflateParams inflateParams, Stream<F, Object> streamAfterMandatoryHeader, byte flags, CRC32 headerCrc32, CRC32 contentCrc32, long secondsSince197001010000, Inflater inflater) {
                return streamAfterMandatoryHeader.through(this._gunzip_skipOptionalExtraField(this.gzipFlag().fextra(flags), headerCrc32)).through(this._gunzip_readOptionalStringField(this.gzipFlag().fname(flags), headerCrc32, "file name", this.fileNameBytesSoftLimit())).flatMap((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Option fileName = (Option)tuple2._1();
                    Stream streamAfterFileName = (Stream)tuple2._2();
                    Stream<F2, O2> stream = streamAfterFileName.through(this._gunzip_readOptionalStringField(this.gzipFlag().fcomment(flags), headerCrc32, "file comment", this.fileCommentBytesSoftLimit())).flatMap((Function1 & Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Option comment = (Option)tuple2._1();
                        Stream streamAfterComment = (Stream)tuple2._2();
                        None$ x$1 = secondsSince197001010000 != 0L ? new Some((Object)Instant.ofEpochSecond(secondsSince197001010000)) : None$.MODULE$;
                        Option x$2 = fileName;
                        Option x$3 = comment;
                        Stream<F, Object> x$4 = streamAfterComment.through(this._gunzip_validateHeader((byte)(flags & this.gzipFlag().FHCRC()) == this.gzipFlag().FHCRC(), headerCrc32)).through((Function1 & Serializable)s -> Pull$StreamPullOps$.MODULE$.stream$extension(Pull$.MODULE$.StreamPullOps((Pull)this._inflate(inflateParams, inflater, (Option<CRC32>)new Some((Object)contentCrc32)).apply(s)))).through(this._gunzip_validateTrailer(contentCrc32, inflater));
                        Stream<F, GunzipResult<F>> stream = Stream$.MODULE$.emit(new GunzipResult<F>(x$4, (Option<Instant>)x$1, (Option<String>)x$2, (Option<String>)x$3));
                        return stream;
                    }, NotGiven$.MODULE$.default());
                    return stream;
                }, NotGiven$.MODULE$.default());
            }

            private Function1<Stream<F, Object>, Stream<F, Object>> _gunzip_skipOptionalExtraField(boolean isPresent, CRC32 crc32) {
                return (Function1 & Serializable)stream -> {
                    Stream<F2, O2> stream2;
                    if (isPresent) {
                        Stream<F, O> qual$1 = Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(stream));
                        int x$1 = this.gzipOptionalExtraFieldLengthBytes();
                        boolean x$2 = Stream$ToPull$.MODULE$.unconsN$default$2$extension(qual$1);
                        stream2 = Pull$StreamPullOps$.MODULE$.stream$extension(Pull$.MODULE$.StreamPullOps(Stream$ToPull$.MODULE$.unconsN$extension(qual$1, x$1, x$2).flatMap(arg_0 -> $anon$1.$anonfun$_gunzip_skipOptionalExtraField$2(this, crc32, arg_0)))).flatten($less$colon$less$.MODULE$.refl());
                    } else {
                        stream2 = stream;
                    }
                    return stream2;
                };
            }

            private Function1<Stream<F, Object>, Stream<F, Tuple2<Option<String>, Stream<F, Object>>>> _gunzip_readOptionalStringField(boolean isPresent, CRC32 crc32, String fieldName, int fieldBytesSoftLimit) {
                return (Function1 & Serializable)stream -> isPresent ? Pull$StreamPullOps$.MODULE$.stream$extension(Pull$.MODULE$.StreamPullOps(((Pull)this.unconsUntil((Function1<O, Object>)(Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$_gunzip_readOptionalStringField$2(this, BoxesRunTime.unboxToByte((Object)x$9))), fieldBytesSoftLimit, (ClassTag<O>)ClassTag$.MODULE$.Byte()).apply(stream)).flatMap((Function1 & Serializable)x0$1 -> {
                    Pull<F, Tuple2, BoxedUnit> pull;
                    Some some;
                    Tuple2 tuple2;
                    Option option = x0$1;
                    if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                        Some some2;
                        Chunk chunk = (Chunk)tuple2._1();
                        Stream rest = (Stream)tuple2._2();
                        if (chunk.isEmpty()) {
                            some2 = new Some((Object)"");
                        } else {
                            Chunk.ArraySlice<O2> bytesChunk = chunk.toArraySlice(ClassTag$.MODULE$.Byte());
                            crc32.update((byte[])bytesChunk.values(), bytesChunk.offset(), bytesChunk.length());
                            some2 = new Some((Object)new String((byte[])bytesChunk.values(), bytesChunk.offset(), bytesChunk.length(), StandardCharsets.ISO_8859_1));
                        }
                        pull = Pull$.MODULE$.output1(new Tuple2((Object)some2, rest.dropWhile((Function1 & Serializable)object -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$_gunzip_readOptionalStringField$4(this, crc32, BoxesRunTime.unboxToByte((Object)object)))).drop(1L)));
                    } else if (None$.MODULE$.equals(option)) {
                        pull = Pull$.MODULE$.output1(new Tuple2((Object)Option$.MODULE$.empty(), Stream$.MODULE$.raiseError(new ZipException(new StringBuilder(21).append("Failed to read ").append(fieldName).append(" field").toString()), RaiseThrowable$.MODULE$.fromApplicativeError($this.F$1))));
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return pull;
                }))) : Stream$.MODULE$.emit(new Tuple2((Object)Option$.MODULE$.empty(), stream));
            }

            private Function1<Stream<F, Object>, Stream<F, Object>> _gunzip_validateHeader(boolean isPresent, CRC32 crc32) {
                return (Function1 & Serializable)stream -> {
                    Stream<F2, O2> stream2;
                    if (isPresent) {
                        Stream<F, O> qual$1 = Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(stream));
                        int x$1 = this.gzipHeaderCrcBytes();
                        boolean x$2 = Stream$ToPull$.MODULE$.unconsN$default$2$extension(qual$1);
                        stream2 = Pull$StreamPullOps$.MODULE$.stream$extension(Pull$.MODULE$.StreamPullOps(Stream$ToPull$.MODULE$.unconsN$extension(qual$1, x$1, x$2).flatMap((Function1 & Serializable)x0$1 -> {
                            Pull<F, Object, Object> pull;
                            Some some;
                            Tuple2 tuple2;
                            Option option = x0$1;
                            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                                long actualHeaderCrc16;
                                Chunk headerCrcChunk = (Chunk)tuple2._1();
                                Stream streamAfterHeaderCrc = (Stream)tuple2._2();
                                int expectedHeaderCrc16 = this.unsignedToInt(BoxesRunTime.unboxToByte(headerCrcChunk.apply(0)), BoxesRunTime.unboxToByte(headerCrcChunk.apply(1)));
                                pull = (long)expectedHeaderCrc16 != (actualHeaderCrc16 = crc32.getValue() & 0xFFFFL) ? Pull$.MODULE$.raiseError(new ZipException("Header failed CRC validation"), RaiseThrowable$.MODULE$.fromApplicativeError($this.F$1)) : Pull$.MODULE$.output1(streamAfterHeaderCrc);
                            } else if (None$.MODULE$.equals(option)) {
                                pull = Pull$.MODULE$.raiseError(new ZipException("Failed to read header CRC"), RaiseThrowable$.MODULE$.fromApplicativeError($this.F$1));
                            } else {
                                throw new MatchError((Object)option);
                            }
                            return pull;
                        }))).flatten($less$colon$less$.MODULE$.refl());
                    } else {
                        stream2 = stream;
                    }
                    return stream2;
                };
            }

            private Function1<Stream<F, Object>, Stream<F, Object>> _gunzip_validateTrailer(CRC32 crc32, Inflater inflater) {
                return (Function1 & Serializable)stream -> Pull$StreamPullOps$.MODULE$.stream$extension(Pull$.MODULE$.StreamPullOps((Pull)this.streamUntilTrailer$1(Chunk$.MODULE$.empty(), inflater, crc32).apply(stream)));
            }

            private <O> Function1<Stream<F, O>, Pull<F, Nothing$, Option<Tuple2<Chunk<O>, Stream<F, O>>>>> unconsUntil(Function1<O, Object> predicate, int softLimit, ClassTag<O> evidence$1) {
                return (Function1 & Serializable)stream -> $anon$1.go$1((List)package$.MODULE$.Nil(), stream, $anon$1.go$default$3$1(), predicate, evidence$1, softLimit);
            }

            private int gzipHeaderBytes() {
                return this.gzipHeaderBytes;
            }

            private byte gzipMagicFirstByte() {
                return this.gzipMagicFirstByte;
            }

            private byte gzipMagicSecondByte() {
                return this.gzipMagicSecondByte;
            }

            private int gzipOptionalExtraFieldLengthBytes() {
                return this.gzipOptionalExtraFieldLengthBytes;
            }

            private int gzipHeaderCrcBytes() {
                return this.gzipHeaderCrcBytes;
            }

            private int gzipInputCrcBytes() {
                return this.gzipInputCrcBytes;
            }

            private int gzipInputSizeBytes() {
                return this.gzipInputSizeBytes;
            }

            private int gzipTrailerBytes() {
                return this.gzipTrailerBytes;
            }

            private byte zeroByte() {
                return this.zeroByte;
            }

            private int fileNameBytesSoftLimit() {
                return this.fileNameBytesSoftLimit;
            }

            private int fileCommentBytesSoftLimit() {
                return this.fileCommentBytesSoftLimit;
            }

            private Chunk<Object> moveAsChunkBytes(byte[] values) {
                return this.moveAsChunkBytes(values, values.length);
            }

            private Chunk<Object> moveAsChunkBytes(byte[] values, int length) {
                return length > 0 ? Chunk$.MODULE$.array(values, 0, length, ClassTag$.MODULE$.Byte()) : Chunk$.MODULE$.empty();
            }

            private Chunk<Object> copyAsChunkBytes(byte[] values, int length) {
                Chunk<Object> chunk;
                if (length > 0) {
                    byte[] target = new byte[length];
                    System.arraycopy(values, 0, target, 0, length);
                    chunk = Chunk$.MODULE$.array(target, 0, length, ClassTag$.MODULE$.Byte());
                } else {
                    chunk = Chunk$.MODULE$.empty();
                }
                return chunk;
            }

            private int unsignedToInt(byte lsb, byte msb) {
                return (msb & 0xFF) << 8 | lsb & 0xFF;
            }

            private long unsignedToLong(byte lsb, byte byte2, byte byte3, byte msb) {
                return ((long)msb & 0xFFL) << 24 | (long)((byte3 & 0xFF) << 16) | (long)((byte2 & 0xFF) << 8) | (long)(lsb & 0xFF);
            }

            private final void gzipCompressionMethod$lzycompute$1() {
                $anon$1 var1_1 = this;
                synchronized (var1_1) {
                    if (this.gzipCompressionMethod$module == null) {
                        this.gzipCompressionMethod$module = new CompressionCompanionPlatform$$anon$1$gzipCompressionMethod$(this);
                    }
                }
            }

            private final void gzipFlag$lzycompute$1() {
                $anon$1 var1_1 = this;
                synchronized (var1_1) {
                    if (this.gzipFlag$module == null) {
                        this.gzipFlag$module = new CompressionCompanionPlatform$$anon$1$gzipFlag$(this);
                    }
                }
            }

            private final void gzipExtraFlag$lzycompute$1() {
                $anon$1 var1_1 = this;
                synchronized (var1_1) {
                    if (this.gzipExtraFlag$module == null) {
                        this.gzipExtraFlag$module = new CompressionCompanionPlatform$$anon$1$gzipExtraFlag$(this);
                    }
                }
            }

            private final void gzipOperatingSystem$lzycompute$1() {
                $anon$1 var1_1 = this;
                synchronized (var1_1) {
                    if (this.gzipOperatingSystem$module == null) {
                        this.gzipOperatingSystem$module = new CompressionCompanionPlatform$$anon$1$gzipOperatingSystem$(this);
                    }
                }
            }

            public static final /* synthetic */ void $anonfun$_deflate_chunk$1(Chunk.ArraySlice bytesChunk$1, CRC32 x$1) {
                x$1.update((byte[])bytesChunk$1.values(), bytesChunk$1.offset(), bytesChunk$1.length());
            }

            private static final boolean isDone$1(boolean isFinalChunk$1, Deflater deflater$3) {
                return isFinalChunk$1 && deflater$3.finished() || !isFinalChunk$1 && deflater$3.needsInput();
            }

            private static final int runDeflate$1(Deflater deflater$3, byte[] deflatedBuffer$1, DeflateParams deflateParams$3, boolean isFinalChunk$1) {
                return $anon$1.isDone$1(isFinalChunk$1, deflater$3) ? 0 : deflater$3.deflate(deflatedBuffer$1, 0, deflateParams$3.bufferSizeOrMinimum(), deflateParams$3.flushMode().juzDeflaterFlushMode());
            }

            private final Pull pull$1(byte[] deflatedBuffer$1, Deflater deflater$3, DeflateParams deflateParams$3, boolean isFinalChunk$1) {
                int deflatedBytes = $anon$1.runDeflate$1(deflater$3, deflatedBuffer$1, deflateParams$3, isFinalChunk$1);
                return $anon$1.isDone$1(isFinalChunk$1, deflater$3) ? Pull$.MODULE$.output(this.copyAsChunkBytes(deflatedBuffer$1, deflatedBytes)) : Pull$.MODULE$.output(this.copyAsChunkBytes(deflatedBuffer$1, deflatedBytes)).$greater$greater((Function0 & Serializable)() -> this.pull$1(deflatedBuffer$1, deflater$3, deflateParams$3, isFinalChunk$1));
            }

            public static final /* synthetic */ void $anonfun$_inflate_chunk$1(byte[] inflatedBuffer$2, int byteCount$1, CRC32 x$4) {
                x$4.update(inflatedBuffer$2, 0, byteCount$1);
            }

            /*
             * WARNING - void declaration
             */
            private static final int runInflate$1(Inflater inflater$3, byte[] inflatedBuffer$2, Option crc32$4) {
                int n;
                if (inflater$3.finished()) {
                    n = -2;
                } else if (inflater$3.needsInput()) {
                    n = -1;
                } else {
                    void var3_3;
                    int byteCount = inflater$3.inflate(inflatedBuffer$2);
                    crc32$4.foreach((Function1 & Serializable)x$4 -> {
                        $anon$1.$anonfun$_inflate_chunk$1(inflatedBuffer$2, byteCount, x$4);
                        return BoxedUnit.UNIT;
                    });
                    n = var3_3;
                }
                return n;
            }

            private final Pull pull$2(Inflater inflater$3, Chunk.ArraySlice bytesChunk$2, byte[] inflatedBuffer$2, Option crc32$4) {
                Pull<Object, Object, Object> pull;
                int n = $anon$1.runInflate$1(inflater$3, inflatedBuffer$2, crc32$4);
                switch (n) {
                    default: 
                }
                if (n <= -2) {
                    int n2 = inflater$3.getRemaining();
                    switch (n2) {
                        default: 
                    }
                    pull = n2 > 0 ? Pull$.MODULE$.output(Chunk$.MODULE$.array(bytesChunk$2.values(), bytesChunk$2.offset() + bytesChunk$2.length() - n2, n2, ClassTag$.MODULE$.Byte())) : Pull$.MODULE$.done();
                } else if (n == -1) {
                    pull = Pull$.MODULE$.done();
                } else if (n < inflatedBuffer$2.length) {
                    if (inflater$3.finished()) {
                        int n3 = inflater$3.getRemaining();
                        switch (n3) {
                            default: 
                        }
                        pull = n3 > 0 ? Pull$.MODULE$.output(this.copyAsChunkBytes(inflatedBuffer$2, n)).$greater$greater((Function0 & Serializable)() -> Pull$.MODULE$.output(Chunk$.MODULE$.array(bytesChunk$2.values(), bytesChunk$2.offset() + bytesChunk$2.length() - n3, n3, ClassTag$.MODULE$.Byte()))) : Pull$.MODULE$.output(this.copyAsChunkBytes(inflatedBuffer$2, n));
                    } else {
                        pull = Pull$.MODULE$.output(this.copyAsChunkBytes(inflatedBuffer$2, n));
                    }
                } else {
                    pull = Pull$.MODULE$.output(this.copyAsChunkBytes(inflatedBuffer$2, n)).$greater$greater((Function0 & Serializable)() -> this.pull$2(inflater$3, bytesChunk$2, inflatedBuffer$2, crc32$4));
                }
                return pull;
            }

            public static final /* synthetic */ long $anonfun$_gzip_header$1(Instant x$6) {
                return x$6.getEpochSecond();
            }

            public static final /* synthetic */ byte $anonfun$_gzip_header$3($anon$1 $this, String x$7) {
                return $this.gzipFlag().FNAME();
            }

            public static final /* synthetic */ byte $anonfun$_gzip_header$5($anon$1 $this, String x$8) {
                return $this.gzipFlag().FCOMMENT();
            }

            public static final /* synthetic */ Pull $anonfun$_gunzip_skipOptionalExtraField$3($anon$1 $this, CRC32 crc32$8, Option x0$2) {
                Pull<F, Object, Object> pull;
                Some some;
                Tuple2 tuple2;
                Option option = x0$2;
                if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                    Chunk optionalExtraFieldChunk = (Chunk)tuple2._1();
                    Stream streamAfterOptionalExtraField = (Stream)tuple2._2();
                    Chunk.ArraySlice<O2> fieldBytes = optionalExtraFieldChunk.toArraySlice(ClassTag$.MODULE$.Byte());
                    crc32$8.update((byte[])fieldBytes.values(), fieldBytes.offset(), fieldBytes.length());
                    pull = Pull$.MODULE$.output1(streamAfterOptionalExtraField);
                } else if (None$.MODULE$.equals(option)) {
                    pull = Pull$.MODULE$.raiseError(new ZipException("Failed to read optional extra field header"), RaiseThrowable$.MODULE$.fromApplicativeError($this.F$1));
                } else {
                    throw new MatchError((Object)option);
                }
                return pull;
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public static final /* synthetic */ Pull $anonfun$_gunzip_skipOptionalExtraField$2($anon$1 $this, CRC32 crc32$8, Option x0$1) {
                block5: {
                    block4: {
                        var5_3 = x0$1;
                        if (!(var5_3 instanceof Some) || (var7_5 = (Tuple2)(var6_4 = (Some)var5_3).value()) == null) break block4;
                        optionalExtraFieldLengthChunk = (Chunk)var7_5._1();
                        streamAfterOptionalExtraFieldLength = (Stream)var7_5._2();
                        var10_8 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)optionalExtraFieldLengthChunk.size()), optionalExtraFieldLengthChunk.toArraySlice(ClassTag$.MODULE$.Byte()).values());
                        if (var10_8 == null) ** GOTO lbl-1000
                        var11_9 = var10_8._1$mcI$sp();
                        lengthBytes = (byte[])var10_8._2();
                        if ($this.gzipOptionalExtraFieldLengthBytes() == var11_9 && lengthBytes != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(var13_11 = Array$.MODULE$.unapplySeq((Object)lengthBytes)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(var13_11)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(var13_11), 2) == 0) {
                            firstByte = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(var13_11), 0));
                            secondByte = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(var13_11), 1));
                            crc32$8.update(lengthBytes);
                            optionalExtraFieldLength = $this.unsignedToInt(firstByte, secondByte);
                            qual$2 = Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(streamAfterOptionalExtraFieldLength));
                            x$3 = optionalExtraFieldLength;
                            x$4 = Stream$ToPull$.MODULE$.unconsN$default$2$extension(qual$2);
                            var4_18 /* !! */  = Stream$ToPull$.MODULE$.unconsN$extension(qual$2, x$3, x$4).flatMap((Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$_gunzip_skipOptionalExtraField$3(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.CRC32 scala.Option ), (Lscala/Option;)Lfs2/Pull;)($this, (CRC32)crc32$8));
                        } else lbl-1000:
                        // 2 sources

                        {
                            var4_18 /* !! */  = Pull$.MODULE$.raiseError(new ZipException("Failed to read optional extra field header length"), RaiseThrowable$.MODULE$.fromApplicativeError($this.F$1));
                        }
                        var3_19 = var4_18 /* !! */ ;
                        break block5;
                    }
                    if (None$.MODULE$.equals(var5_3)) {
                        var3_19 = Pull$.MODULE$.raiseError(new EOFException(), RaiseThrowable$.MODULE$.fromApplicativeError($this.F$1));
                    } else {
                        throw new MatchError((Object)var5_3);
                    }
                }
                return var3_19;
            }

            public static final /* synthetic */ boolean $anonfun$_gunzip_readOptionalStringField$2($anon$1 $this, byte x$9) {
                return x$9 == $this.zeroByte();
            }

            public static final /* synthetic */ boolean $anonfun$_gunzip_readOptionalStringField$4($anon$1 $this, CRC32 crc32$9, byte by) {
                crc32$9.update(by);
                return by != $this.zeroByte();
            }

            private final Pull validateTrailer$1(Chunk trailerChunk, CRC32 crc32$11, Inflater inflater$8) {
                Pull<Object, Nothing$, Object> pull;
                if (trailerChunk.size() == this.gzipTrailerBytes()) {
                    long expectedInputCrc32 = this.unsignedToLong(BoxesRunTime.unboxToByte(trailerChunk.apply(0)), BoxesRunTime.unboxToByte(trailerChunk.apply(1)), BoxesRunTime.unboxToByte(trailerChunk.apply(2)), BoxesRunTime.unboxToByte(trailerChunk.apply(3)));
                    long actualInputCrc32 = crc32$11.getValue();
                    long expectedInputSize = this.unsignedToLong(BoxesRunTime.unboxToByte(trailerChunk.apply(4)), BoxesRunTime.unboxToByte(trailerChunk.apply(5)), BoxesRunTime.unboxToByte(trailerChunk.apply(6)), BoxesRunTime.unboxToByte(trailerChunk.apply(7)));
                    long actualInputSize = inflater$8.getBytesWritten() & 0xFFFFFFFFL;
                    pull = expectedInputCrc32 != actualInputCrc32 ? Pull$.MODULE$.raiseError(new ZipException("Content failed CRC validation"), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1)) : (expectedInputSize != actualInputSize ? Pull$.MODULE$.raiseError(new ZipException("Content failed size validation"), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1)) : Pull$.MODULE$.done());
                } else {
                    pull = Pull$.MODULE$.raiseError(new ZipException("Failed to read trailer (1)"), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1));
                }
                return pull;
            }

            private final Function1 streamUntilTrailer$1(Chunk last, Inflater inflater$8, CRC32 crc32$11) {
                return (Function1 & Serializable)x$10 -> Stream$ToPull$.MODULE$.uncons$extension(Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(x$10))).flatMap((Function1 & Serializable)x0$1 -> {
                    Pull<F2, O2, S> pull;
                    Some some;
                    Tuple2 tuple2;
                    Option option = x0$1;
                    if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                        Chunk next = (Chunk)tuple2._1();
                        Stream rest = (Stream)tuple2._2();
                        pull = inflater$8.finished() ? (next.size() >= this.gzipTrailerBytes() ? (last.nonEmpty() ? Pull$.MODULE$.output(last).$greater$greater((Function0 & Serializable)() -> (Pull)this.streamUntilTrailer$1(next, inflater$8, crc32$11).apply((Object)rest)) : (Pull<F2, O2, S>)this.streamUntilTrailer$1(next, inflater$8, crc32$11).apply((Object)rest)) : (Pull<F2, O2, S>)this.streamUntilTrailer$1(last.$plus$plus(next), inflater$8, crc32$11).apply((Object)rest)) : (last.nonEmpty() ? Pull$.MODULE$.output(last).$greater$greater((Function0 & Serializable)() -> Pull$.MODULE$.output(next)).$greater$greater((Function0 & Serializable)() -> (Pull)this.streamUntilTrailer$1(Chunk$.MODULE$.empty(), inflater$8, crc32$11).apply((Object)rest)) : Pull$.MODULE$.output(next).$greater$greater((Function0 & Serializable)() -> (Pull)this.streamUntilTrailer$1(Chunk$.MODULE$.empty(), inflater$8, crc32$11).apply((Object)rest)));
                    } else if (None$.MODULE$.equals(option)) {
                        int preTrailerBytes = last.size() - this.gzipTrailerBytes();
                        pull = preTrailerBytes > 0 ? Pull$.MODULE$.output(last.take(preTrailerBytes)).$greater$greater((Function0 & Serializable)() -> this.validateTrailer$1(last.drop(preTrailerBytes), crc32$11, inflater$8)) : this.validateTrailer$1(last, crc32$11, inflater$8);
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return pull;
                });
            }

            private static final Pull go$1(List acc, Stream rest, int size, Function1 predicate$1, ClassTag evidence$1$1, int softLimit$1) {
                return Stream$ToPull$.MODULE$.uncons$extension(Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(rest))).flatMap((Function1 & Serializable)x0$1 -> {
                    Some some;
                    Tuple2 tuple2;
                    Pull<F, Nothing$, Some> pull;
                    Option option = x0$1;
                    if (None$.MODULE$.equals(option)) {
                        pull = Pull$.MODULE$.pure(None$.MODULE$);
                    } else if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                        Pull<F, Nothing$, Some> pull2;
                        Chunk hd = (Chunk)tuple2._1();
                        Stream tl = (Stream)tuple2._2();
                        Option<Object> option2 = hd.indexWhere(predicate$1);
                        if (option2 instanceof Some) {
                            Some some2 = (Some)option2;
                            int i = BoxesRunTime.unboxToInt((Object)some2.value());
                            Tuple2<Chunk<O>, Chunk<O>> tuple22 = hd.splitAt(i);
                            if (tuple22 == null) {
                                throw new MatchError(tuple22);
                            }
                            Chunk pfx = (Chunk)tuple22._1();
                            Chunk sfx = (Chunk)tuple22._2();
                            Tuple2 tuple23 = new Tuple2((Object)pfx, (Object)sfx);
                            Tuple2 tuple24 = tuple23;
                            Chunk pfx2 = (Chunk)tuple24._1();
                            Chunk sfx2 = (Chunk)tuple24._2();
                            Chunk chunk = pfx2;
                            pull2 = Pull$.MODULE$.pure(new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Chunk$.MODULE$.concat(acc.$colon$colon((Object)chunk).reverse(), evidence$1$1)), tl.cons(sfx2))));
                        } else if (None$.MODULE$.equals(option2)) {
                            Pull<F, Nothing$, Some> pull3;
                            int newSize = size + hd.size();
                            if (newSize < softLimit$1) {
                                Chunk chunk = hd;
                                pull3 = $anon$1.go$1(acc.$colon$colon((Object)chunk), tl, newSize, predicate$1, evidence$1$1, softLimit$1);
                            } else {
                                Chunk chunk = hd;
                                pull3 = Pull$.MODULE$.pure(new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Chunk$.MODULE$.concat(acc.$colon$colon((Object)chunk).reverse(), evidence$1$1)), (Object)tl)));
                            }
                            pull2 = pull3;
                        } else {
                            throw new MatchError(option2);
                        }
                        pull = pull2;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return pull;
                });
            }

            private static final int go$default$3$1() {
                return 0;
            }
            {
                this.F$1 = F$1;
                CompressionPlatform.$init$(this);
                this.gzipHeaderBytes = 10;
                this.gzipMagicFirstByte = (byte)31;
                this.gzipMagicSecondByte = (byte)139;
                this.gzipOptionalExtraFieldLengthBytes = 2;
                this.gzipHeaderCrcBytes = 2;
                this.gzipInputCrcBytes = 4;
                this.gzipInputSizeBytes = 4;
                this.gzipTrailerBytes = this.gzipInputCrcBytes() + this.gzipInputSizeBytes();
                this.zeroByte = 0;
                this.fileNameBytesSoftLimit = 1024;
                this.fileCommentBytesSoftLimit = 0x100000;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$_deflate$1(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.DeflateParams java.util.zip.Deflater scala.Option fs2.Stream ), $anonfun$_deflate$2(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.DeflateParams java.util.zip.Deflater scala.Option fs2.Stream ), $anonfun$_deflate_chunk$1$adapted(fs2.Chunk$ArraySlice java.util.zip.CRC32 ), $anonfun$_deflate_chunk$2(fs2.compression.CompressionCompanionPlatform$$anon$1 byte[] java.util.zip.Deflater fs2.compression.DeflateParams boolean ), $anonfun$_deflate_stream$1(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.DeflateParams java.util.zip.Deflater scala.Option byte[] fs2.Stream ), $anonfun$_deflate_stream$2(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.DeflateParams java.util.zip.Deflater scala.Option byte[] scala.Option ), $anonfun$_deflate_stream$3(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.DeflateParams java.util.zip.Deflater scala.Option byte[] fs2.Stream ), $anonfun$_gunzip_matchMandatoryHeader$1(fs2.compression.CompressionCompanionPlatform$$anon$1 scala.Option ), $anonfun$_gunzip_readOptionalHeader$1(fs2.compression.CompressionCompanionPlatform$$anon$1 byte java.util.zip.CRC32 long fs2.compression.InflateParams java.util.zip.Inflater java.util.zip.CRC32 scala.Tuple2 ), $anonfun$_gunzip_readOptionalHeader$2(fs2.compression.CompressionCompanionPlatform$$anon$1 long scala.Option byte java.util.zip.CRC32 fs2.compression.InflateParams java.util.zip.Inflater java.util.zip.CRC32 scala.Tuple2 ), $anonfun$_gunzip_readOptionalHeader$3(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.InflateParams java.util.zip.Inflater java.util.zip.CRC32 fs2.Stream ), $anonfun$_gunzip_readOptionalStringField$1(fs2.compression.CompressionCompanionPlatform$$anon$1 boolean int java.util.zip.CRC32 java.lang.String fs2.Stream ), $anonfun$_gunzip_readOptionalStringField$2$adapted(fs2.compression.CompressionCompanionPlatform$$anon$1 java.lang.Object ), $anonfun$_gunzip_readOptionalStringField$3(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.CRC32 java.lang.String scala.Option ), $anonfun$_gunzip_readOptionalStringField$4$adapted(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.CRC32 java.lang.Object ), $anonfun$_gunzip_skipOptionalExtraField$1(fs2.compression.CompressionCompanionPlatform$$anon$1 boolean java.util.zip.CRC32 fs2.Stream ), $anonfun$_gunzip_skipOptionalExtraField$2(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.CRC32 scala.Option ), $anonfun$_gunzip_skipOptionalExtraField$3(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.CRC32 scala.Option ), $anonfun$_gunzip_validateHeader$1(fs2.compression.CompressionCompanionPlatform$$anon$1 boolean java.util.zip.CRC32 fs2.Stream ), $anonfun$_gunzip_validateHeader$2(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.CRC32 scala.Option ), $anonfun$_gunzip_validateTrailer$1(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.CRC32 java.util.zip.Inflater fs2.Stream ), $anonfun$_gunzip_validateTrailer$2(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.Inflater fs2.Chunk java.util.zip.CRC32 fs2.Stream ), $anonfun$_gunzip_validateTrailer$3(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.Inflater fs2.Chunk java.util.zip.CRC32 scala.Option ), $anonfun$_gunzip_validateTrailer$4(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.Chunk fs2.Stream java.util.zip.Inflater java.util.zip.CRC32 ), $anonfun$_gunzip_validateTrailer$5(fs2.Chunk ), $anonfun$_gunzip_validateTrailer$6(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.Stream java.util.zip.Inflater java.util.zip.CRC32 ), $anonfun$_gunzip_validateTrailer$7(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.Stream java.util.zip.Inflater java.util.zip.CRC32 ), $anonfun$_gunzip_validateTrailer$8(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.Chunk int java.util.zip.CRC32 java.util.zip.Inflater ), $anonfun$_gzip_header$1$adapted(java.time.Instant ), $anonfun$_gzip_header$10(fs2.compression.CompressionCompanionPlatform$$anon$1 byte[] ), $anonfun$_gzip_header$11(fs2.compression.CompressionCompanionPlatform$$anon$1 ), $anonfun$_gzip_header$12(), $anonfun$_gzip_header$13(fs2.compression.CompressionCompanionPlatform$$anon$1 scala.Option ), $anonfun$_gzip_header$14(fs2.compression.CompressionCompanionPlatform$$anon$1 byte[] ), $anonfun$_gzip_header$15(fs2.compression.CompressionCompanionPlatform$$anon$1 ), $anonfun$_gzip_header$16(), $anonfun$_gzip_header$17(fs2.compression.CompressionCompanionPlatform$$anon$1 byte[] ), $anonfun$_gzip_header$2(), $anonfun$_gzip_header$3$adapted(fs2.compression.CompressionCompanionPlatform$$anon$1 java.lang.String ), $anonfun$_gzip_header$4(fs2.compression.CompressionCompanionPlatform$$anon$1 ), $anonfun$_gzip_header$5$adapted(fs2.compression.CompressionCompanionPlatform$$anon$1 java.lang.String ), $anonfun$_gzip_header$6(fs2.compression.CompressionCompanionPlatform$$anon$1 ), $anonfun$_gzip_header$7(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.CRC32 java.lang.String ), $anonfun$_gzip_header$8(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.CRC32 java.lang.String ), $anonfun$_gzip_header$9(fs2.compression.CompressionCompanionPlatform$$anon$1 scala.Option ), $anonfun$_inflate$1(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.InflateParams java.util.zip.Inflater scala.Option fs2.Stream ), $anonfun$_inflate$2(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.InflateParams fs2.Stream java.util.zip.Inflater scala.Option ), $anonfun$_inflate$3(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.Inflater scala.Option byte[] fs2.compression.InflateParams scala.Option ), $anonfun$_inflate$4(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.InflateParams java.util.zip.Inflater scala.Option byte[] fs2.Stream ), $anonfun$_inflate_chunk$1$adapted(byte[] int java.util.zip.CRC32 ), $anonfun$_inflate_chunk$2(fs2.Chunk$ArraySlice int ), $anonfun$_inflate_chunk$3(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.Inflater fs2.Chunk$ArraySlice byte[] scala.Option ), $anonfun$_inflate_stream$1(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.Inflater scala.Option byte[] fs2.compression.InflateParams fs2.Stream ), $anonfun$_inflate_stream$2(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.Inflater scala.Option byte[] fs2.compression.InflateParams scala.Option ), $anonfun$_inflate_stream$3(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.InflateParams java.util.zip.Inflater scala.Option byte[] fs2.Stream ), $anonfun$deflate$1(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.DeflateParams fs2.Stream ), $anonfun$deflate$2(fs2.compression.DeflateParams ), $anonfun$deflate$3(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.Deflater ), $anonfun$deflate$4(java.util.zip.Deflater ), $anonfun$deflate$5(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.DeflateParams fs2.Stream java.util.zip.Deflater ), $anonfun$gunzip$1(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.InflateParams fs2.Stream ), $anonfun$gunzip$2(), $anonfun$gunzip$3(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.Stream fs2.compression.InflateParams scala.Tuple3 ), $anonfun$gunzip$4(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.InflateParams java.util.zip.CRC32 java.util.zip.CRC32 java.util.zip.Inflater scala.Option ), $anonfun$gunzip$5(fs2.compression.CompressionCompanionPlatform$$anon$1 scala.Tuple3 cats.effect.kernel.Resource$ExitCase ), $anonfun$gunzip$6(java.util.zip.Inflater ), $anonfun$gzip$10(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.DeflateParams java.util.zip.Deflater java.util.zip.CRC32 fs2.Stream ), $anonfun$gzip$11(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.Deflater java.util.zip.CRC32 ), $anonfun$gzip$5(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.DeflateParams scala.Option scala.Option scala.Option fs2.Stream ), $anonfun$gzip$6(fs2.compression.DeflateParams ), $anonfun$gzip$7(fs2.compression.CompressionCompanionPlatform$$anon$1 scala.Tuple2 ), $anonfun$gzip$8(java.util.zip.Deflater ), $anonfun$gzip$9(fs2.compression.CompressionCompanionPlatform$$anon$1 scala.Option scala.Option scala.Option fs2.compression.DeflateParams fs2.Stream scala.Tuple2 ), $anonfun$inflate$1(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.InflateParams fs2.Stream ), $anonfun$inflate$2(fs2.compression.InflateParams ), $anonfun$inflate$3(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.InflateParams fs2.Stream java.util.zip.Inflater ), $anonfun$inflate$4(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.Inflater cats.effect.kernel.Resource$ExitCase ), $anonfun$inflate$5(java.util.zip.Inflater ), $anonfun$unconsUntil$1(scala.Function1 scala.reflect.ClassTag int fs2.Stream ), $anonfun$unconsUntil$2(scala.Function1 scala.collection.immutable.List scala.reflect.ClassTag int int scala.Option )}, serializedLambda);
            }
        };
    }

    public static void $init$(CompressionCompanionPlatform $this) {
    }
}

