/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.Closeable;
import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.IndexOffsetOverflowException;
import kafka.log.AbstractIndex$;
import kafka.log.IndexEntry;
import kafka.log.IndexSearchType;
import kafka.log.IndexSearchType$KEY$;
import kafka.log.IndexSearchType$VALUE$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Logging$;
import org.apache.kafka.common.utils.ByteBufferUnmapper;
import org.apache.kafka.common.utils.OperatingSystem;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.event.Level;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t=e!B\u001f?\u0003\u0003\u0019\u0005\u0002\u0003*\u0001\u0005\u0003\u0007I\u0011B*\t\u0011]\u0003!\u00111A\u0005\naC\u0001\"\u0019\u0001\u0003\u0002\u0003\u0006K\u0001\u0016\u0005\tM\u0002\u0011)\u0019!C\u0001O\"A1\u000e\u0001B\u0001B\u0003%\u0001\u000e\u0003\u0005m\u0001\t\u0015\r\u0011\"\u0001n\u0011!\t\bA!A!\u0002\u0013q\u0007\u0002\u0003:\u0001\u0005\u000b\u0007I\u0011A:\t\u0011]\u0004!\u0011!Q\u0001\nQDQ\u0001\u001f\u0001\u0005\u0002eD!\"!\u0001\u0001\u0001\u0004\u0005\r\u0011\"\u0003h\u0011-\t\u0019\u0001\u0001a\u0001\u0002\u0004%I!!\u0002\t\u0015\u0005%\u0001\u00011A\u0001B\u0003&\u0001\u000e\u0003\u0004\u0002\u000e\u00011\t\"\u001c\u0005\u0007\u0003\u001f\u0001A\u0011C7\t\u0013\u0005E\u0001A1A\u0005\u0012\u0005M\u0001\u0002CA\u0015\u0001\u0001\u0006I!!\u0006\t\u0013\u0005-\u0002\u00011A\u0005\u0012\u00055\u0002\"CA\u001e\u0001\u0001\u0007I\u0011CA\u001f\u0011!\t\t\u0005\u0001Q!\n\u0005=\u0002bBA#\u0001\u0001\u0006KA\u001c\u0005\t\u0003\u0013\u0002\u0001\u0019!C\t[\"I\u00111\n\u0001A\u0002\u0013E\u0011Q\n\u0005\b\u0003#\u0002\u0001\u0015)\u0003o\u0011\u0019\t)\u0006\u0001C\u0001g\"1\u0011q\u000b\u0001\u0005\u0002MCa!!\u0017\u0001\t\u0003i\u0007BBA.\u0001\u0011\u0005Q\u000e\u0003\u0004\u0002^\u0001!\ta\u001a\u0005\b\u0003?\u0002A\u0011AA1\u0011\u001d\t9\u0007\u0001C\u0001\u0003SBq!a\u001c\u0001\t\u0003\t\t\bC\u0004\u0002x\u0001!\t!!\u001f\t\u000f\u0005m\u0004\u0001\"\u0001\u0002~!9\u0011q\u0010\u0001\u0005\u0002\u0005e\u0004BBAA\u0001\u0011\u0005Q\u000eC\u0004\u0002\u0004\u0002!\t!!\u001f\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002z!9\u0011q\u0011\u0001\u0007\u0002\u0005e\u0004bBAE\u0001\u0019E\u0011\u0011\u0010\u0005\b\u0003\u0017\u0003a\u0011AAG\u0011\u001d\t\u0019\n\u0001C\u0001\u0003sBq!!&\u0001\t\u0003\t9\nC\u0004\u0002\u001c\u0002!\t!!(\t\u000f\u0005\u0005\u0006\u0001\"\u0005\u0002z!A\u00111\u0015\u0001\u0005\u0012y\nI\bC\u0004\u0002&\u0002!\t\"a*\t\u000f\u0005U\u0007A\"\u0005\u0002X\"9\u0011Q\u001e\u0001\u0005\u0012\u0005=\bb\u0002B\u0002\u0001\u0011E!Q\u0001\u0005\b\u0005\u001b\u0001A\u0011\u0002B\b\u0011\u001d\u0011i\u0002\u0001C\u0005\u0005?AqA!\u000b\u0001\t\u0013\u0011Y\u0003C\u0004\u00036\u0001!IAa\u000e\b\u000f\t\u0005c\b#\u0001\u0003D\u00191QH\u0010E\u0001\u0005\u000bBa\u0001\u001f\u001d\u0005\u0002\te\u0003\"\u0003B.q\t\u0007I\u0011\tB/\u0011!\u0011)\b\u000fQ\u0001\n\t}\u0003\"\u0003B<qE\u0005I\u0011\u0001B=\u00055\t%m\u001d;sC\u000e$\u0018J\u001c3fq*\u0011q\bQ\u0001\u0004Y><'\"A!\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0012'\u0011\u0005\u0015SU\"\u0001$\u000b\u0005\u001dC\u0015\u0001\u00027b]\u001eT\u0011!S\u0001\u0005U\u00064\u0018-\u0003\u0002L\r\n1qJ\u00196fGR\u0004\"!\u0014)\u000e\u00039S!a\u0014%\u0002\u0005%|\u0017BA)O\u0005%\u0019En\\:fC\ndW-A\u0003`M&dW-F\u0001U!\tiU+\u0003\u0002W\u001d\n!a)\u001b7f\u0003%yf-\u001b7f?\u0012*\u0017\u000f\u0006\u0002Z?B\u0011!,X\u0007\u00027*\tA,A\u0003tG\u0006d\u0017-\u0003\u0002_7\n!QK\\5u\u0011\u001d\u0001'!!AA\u0002Q\u000b1\u0001\u001f\u00132\u0003\u0019yf-\u001b7fA!\u00121a\u0019\t\u00035\u0012L!!Z.\u0003\u0011Y|G.\u0019;jY\u0016\f!BY1tK>3gm]3u+\u0005A\u0007C\u0001.j\u0013\tQ7L\u0001\u0003M_:<\u0017a\u00032bg\u0016|eMZ:fi\u0002\nA\"\\1y\u0013:$W\r_*ju\u0016,\u0012A\u001c\t\u00035>L!\u0001].\u0003\u0007%sG/A\u0007nCbLe\u000eZ3y'&TX\rI\u0001\toJLG/\u00192mKV\tA\u000f\u0005\u0002[k&\u0011ao\u0017\u0002\b\u0005>|G.Z1o\u0003%9(/\u001b;bE2,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0006urlhp \t\u0003w\u0002i\u0011A\u0010\u0005\u0006%*\u0001\r\u0001\u0016\u0005\u0006M*\u0001\r\u0001\u001b\u0005\bY*\u0001\n\u00111\u0001o\u0011\u0015\u0011(\u00021\u0001u\u0003\u001dyF.\u001a8hi\"\f1b\u00187f]\u001e$\bn\u0018\u0013fcR\u0019\u0011,a\u0002\t\u000f\u0001d\u0011\u0011!a\u0001Q\u0006Aq\f\\3oORD\u0007\u0005\u000b\u0002\u000eG\u0006IQM\u001c;ssNK'0Z\u0001\r?^\f'/\\#oiJLWm]\u0001\u0005Y>\u001c7.\u0006\u0002\u0002\u0016A!\u0011qCA\u0013\u001b\t\tIB\u0003\u0003\u0002\u001c\u0005u\u0011!\u00027pG.\u001c(\u0002BA\u0010\u0003C\t!bY8oGV\u0014(/\u001a8u\u0015\r\t\u0019\u0003S\u0001\u0005kRLG.\u0003\u0003\u0002(\u0005e!!\u0004*fK:$(/\u00198u\u0019>\u001c7.A\u0003m_\u000e\\\u0007%\u0001\u0003n[\u0006\u0004XCAA\u0018!\u0011\t\t$a\u000e\u000e\u0005\u0005M\"bAA\u001b\u0011\u0006\u0019a.[8\n\t\u0005e\u00121\u0007\u0002\u0011\u001b\u0006\u0004\b/\u001a3CsR,')\u001e4gKJ\f\u0001\"\\7ba~#S-\u001d\u000b\u00043\u0006}\u0002\u0002\u00031\u0014\u0003\u0003\u0005\r!a\f\u0002\u000b5l\u0017\r\u001d\u0011)\u0005Q\u0019\u0017aC0nCb,e\u000e\u001e:jKND#!F2\u0002\u0011}+g\u000e\u001e:jKN\fAbX3oiJLWm]0%KF$2!WA(\u0011\u001d\u0001w#!AA\u00029\f\u0011bX3oiJLWm\u001d\u0011)\u0005a\u0019\u0017AB5t\rVdG.\u0001\u0003gS2,\u0017AC7bq\u0016sGO]5fg\u00069QM\u001c;sS\u0016\u001c\u0018A\u00027f]\u001e$\b.A\bva\u0012\fG/\u001a)be\u0016tG\u000fR5s)\rI\u00161\r\u0005\u0007\u0003Kr\u0002\u0019\u0001+\u0002\u0013A\f'/\u001a8u\t&\u0014\u0018A\u0002:fg&TX\rF\u0002u\u0003WBa!!\u001c \u0001\u0004q\u0017a\u00028foNK'0Z\u0001\te\u0016t\u0017-\\3U_R\u0019\u0011,a\u001d\t\r\u0005U\u0004\u00051\u0001U\u0003\u00051\u0017!\u00024mkNDG#A-\u0002\u001d\u0011,G.\u001a;f\u0013\u001a,\u00050[:ugR\tA/A\bue&lGk\u001c,bY&$7+\u001b>f\u0003-\u0019\u0018N_3J]\nKH/Z:\u0002\u000b\rdwn]3\u0002\u0019\rdwn]3IC:$G.\u001a:\u0002\u0017M\fg.\u001b;z\u0007\",7m[\u0001\tiJ,hnY1uK\u0006QAO];oG\u0006$X\rV8\u0015\u0007e\u000by\t\u0003\u0004\u0002\u0012&\u0002\r\u0001[\u0001\u0007_\u001a47/\u001a;\u0002\u000bI,7/\u001a;\u0002\u001dI,G.\u0019;jm\u0016|eMZ:fiR\u0019a.!'\t\r\u0005E5\u00061\u0001i\u0003=\u0019\u0017M\\!qa\u0016tGm\u00144gg\u0016$Hc\u0001;\u0002 \"1\u0011\u0011\u0013\u0017A\u0002!\fab]1gK\u001a{'oY3V]6\f\u0007/\u0001\u0006g_J\u001cW-\u00168nCB\f\u0011\"\\1zE\u0016dunY6\u0016\t\u0005%\u0016\u0011\u0017\u000b\u0005\u0003W\u000bi\r\u0006\u0003\u0002.\u0006\r\u0007\u0003BAX\u0003cc\u0001\u0001B\u0004\u00024>\u0012\r!!.\u0003\u0003Q\u000bB!a.\u0002>B\u0019!,!/\n\u0007\u0005m6LA\u0004O_RD\u0017N\\4\u0011\u0007i\u000by,C\u0002\u0002Bn\u00131!\u00118z\u0011!\t)m\fCA\u0002\u0005\u001d\u0017a\u00014v]B)!,!3\u0002.&\u0019\u00111Z.\u0003\u0011q\u0012\u0017P\\1nKzBq!!\u00050\u0001\u0004\ty\r\u0005\u0003\u0002\u0018\u0005E\u0017\u0002BAj\u00033\u0011A\u0001T8dW\u0006Q\u0001/\u0019:tK\u0016sGO]=\u0015\r\u0005e\u0017q\\Au!\rY\u00181\\\u0005\u0004\u0003;t$AC%oI\u0016DXI\u001c;ss\"9\u0011\u0011\u001d\u0019A\u0002\u0005\r\u0018A\u00022vM\u001a,'\u000f\u0005\u0003\u00022\u0005\u0015\u0018\u0002BAt\u0003g\u0011!BQ=uK\n+hMZ3s\u0011\u0019\tY\u000f\ra\u0001]\u0006\ta.\u0001\rmCJ<Wm\u001d;M_^,'OQ8v]\u0012\u001cFn\u001c;G_J$rA\\Ay\u0003k\fI\u0010C\u0004\u0002tF\u0002\r!a9\u0002\u0007%$\u0007\u0010\u0003\u0004\u0002xF\u0002\r\u0001[\u0001\u0007i\u0006\u0014x-\u001a;\t\u000f\u0005m\u0018\u00071\u0001\u0002~\u0006a1/Z1sG\",e\u000e^5usB\u001910a@\n\u0007\t\u0005aHA\bJ]\u0012,\u0007pU3be\u000eDG+\u001f9f\u0003e\u0019X.\u00197mKN$X\u000b\u001d9fe\n{WO\u001c3TY>$hi\u001c:\u0015\u000f9\u00149A!\u0003\u0003\f!9\u00111\u001f\u001aA\u0002\u0005\r\bBBA|e\u0001\u0007\u0001\u000eC\u0004\u0002|J\u0002\r!!@\u0002#%tG-\u001a=TY>$(+\u00198hK\u001a{'\u000f\u0006\u0005\u0003\u0012\t]!\u0011\u0004B\u000e!\u0015Q&1\u00038o\u0013\r\u0011)b\u0017\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0005M8\u00071\u0001\u0002d\"1\u0011q_\u001aA\u0002!Dq!a?4\u0001\u0004\ti0A\td_6\u0004\u0018M]3J]\u0012,\u00070\u00128uef$rA\u001cB\u0011\u0005K\u00119\u0003C\u0004\u0003$Q\u0002\r!!7\u0002\u0015%tG-\u001a=F]R\u0014\u0018\u0010\u0003\u0004\u0002xR\u0002\r\u0001\u001b\u0005\b\u0003w$\u0004\u0019AA\u007f\u0003a\u0011x.\u001e8e\t><h\u000eV8Fq\u0006\u001cG/T;mi&\u0004H.\u001a\u000b\u0006]\n5\"\u0011\u0007\u0005\u0007\u0005_)\u0004\u0019\u00018\u0002\r9,XNY3s\u0011\u0019\u0011\u0019$\u000ea\u0001]\u00061a-Y2u_J\f!\u0002^8SK2\fG/\u001b<f)\u0011\u0011IDa\u0010\u0011\ti\u0013YD\\\u0005\u0004\u0005{Y&AB(qi&|g\u000e\u0003\u0004\u0002\u0012Z\u0002\r\u0001[\u0001\u000e\u0003\n\u001cHO]1di&sG-\u001a=\u0011\u0005mD4#\u0002\u001d\u0003H\t5\u0003c\u0001.\u0003J%\u0019!1J.\u0003\r\u0005s\u0017PU3g!\u0011\u0011yE!\u0016\u000e\u0005\tE#b\u0001B*\u0001\u0006)Q\u000f^5mg&!!q\u000bB)\u0005\u001daunZ4j]\u001e$\"Aa\u0011\u0002\u00151|wmZ3s\u001d\u0006lW-\u0006\u0002\u0003`A!!\u0011\rB8\u001d\u0011\u0011\u0019Ga\u001b\u0011\u0007\t\u00154,\u0004\u0002\u0003h)\u0019!\u0011\u000e\"\u0002\rq\u0012xn\u001c;?\u0013\r\u0011igW\u0001\u0007!J,G-\u001a4\n\t\tE$1\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\t54,A\u0006m_\u001e<WM\u001d(b[\u0016\u0004\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0003|)\u001aaN! ,\u0005\t}\u0004\u0003\u0002BA\u0005\u0017k!Aa!\u000b\t\t\u0015%qQ\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!#\\\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u001b\u0013\u0019IA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public abstract class AbstractIndex
implements Closeable {
    private volatile File _file;
    private final long baseOffset;
    private final int maxIndexSize;
    private final boolean writable;
    private volatile long _length;
    private final ReentrantLock lock;
    private volatile MappedByteBuffer mmap;
    private volatile int _maxEntries;
    private volatile int _entries;

    public static int $lessinit$greater$default$3() {
        return -1;
    }

    public static String loggerName() {
        return AbstractIndex$.MODULE$.loggerName();
    }

    public static void fatal(Function0<String> msg, Function0<Throwable> e) {
        AbstractIndex$ fatal_this = AbstractIndex$.MODULE$;
        if (fatal_this.logger().underlying().isErrorEnabled(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker())) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var3_3 = null;
            fatal_this.logger().underlying().error(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker(), Logging.msgWithLogIdent$(fatal_this, msgWithLogIdent_msg), (Throwable)e.apply());
            return;
        }
    }

    public static void fatal(Function0<String> msg) {
        AbstractIndex$ fatal_this = AbstractIndex$.MODULE$;
        if (fatal_this.logger().underlying().isErrorEnabled(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker())) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var2_2 = null;
            fatal_this.logger().underlying().error(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker(), Logging.msgWithLogIdent$(fatal_this, msgWithLogIdent_msg));
            return;
        }
    }

    public static void error(Function0<String> msg, Function0<Throwable> e) {
        AbstractIndex$ error_this = AbstractIndex$.MODULE$;
        if (error_this.logger().underlying().isErrorEnabled()) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var3_3 = null;
            error_this.logger().underlying().error(Logging.msgWithLogIdent$(error_this, msgWithLogIdent_msg), (Throwable)e.apply());
            return;
        }
    }

    public static void error(Function0<String> msg) {
        AbstractIndex$ error_this = AbstractIndex$.MODULE$;
        if (error_this.logger().underlying().isErrorEnabled()) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var2_2 = null;
            error_this.logger().underlying().error(Logging.msgWithLogIdent$(error_this, msgWithLogIdent_msg));
            return;
        }
    }

    public static void warn(Function0<String> msg, Function0<Throwable> e) {
        AbstractIndex$ warn_this = AbstractIndex$.MODULE$;
        if (warn_this.logger().underlying().isWarnEnabled()) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var3_3 = null;
            warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg), (Throwable)e.apply());
            return;
        }
    }

    public static void warn(Function0<String> msg) {
        AbstractIndex$ warn_this = AbstractIndex$.MODULE$;
        if (warn_this.logger().underlying().isWarnEnabled()) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var2_2 = null;
            warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg));
            return;
        }
    }

    public static void info(Function0<String> msg, Function0<Throwable> e) {
        AbstractIndex$ info_this = AbstractIndex$.MODULE$;
        if (info_this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var3_3 = null;
            info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg), (Throwable)e.apply());
            return;
        }
    }

    public static void info(Function0<String> msg) {
        AbstractIndex$ info_this = AbstractIndex$.MODULE$;
        if (info_this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var2_2 = null;
            info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
            return;
        }
    }

    public static void debug(Function0<String> msg, Function0<Throwable> e) {
        AbstractIndex$ debug_this = AbstractIndex$.MODULE$;
        if (debug_this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var3_3 = null;
            debug_this.logger().underlying().debug(Logging.msgWithLogIdent$(debug_this, msgWithLogIdent_msg), (Throwable)e.apply());
            return;
        }
    }

    public static void debug(Function0<String> msg) {
        AbstractIndex$ debug_this = AbstractIndex$.MODULE$;
        if (debug_this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var2_2 = null;
            debug_this.logger().underlying().debug(Logging.msgWithLogIdent$(debug_this, msgWithLogIdent_msg));
            return;
        }
    }

    public static boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(AbstractIndex$.MODULE$);
    }

    public static boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(AbstractIndex$.MODULE$);
    }

    public static void trace(Function0<String> msg, Function0<Throwable> e) {
        AbstractIndex$ trace_this = AbstractIndex$.MODULE$;
        if (trace_this.logger().underlying().isTraceEnabled()) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var3_3 = null;
            trace_this.logger().underlying().trace(Logging.msgWithLogIdent$(trace_this, msgWithLogIdent_msg), (Throwable)e.apply());
            return;
        }
    }

    public static void trace(Function0<String> msg) {
        AbstractIndex$ trace_this = AbstractIndex$.MODULE$;
        if (trace_this.logger().underlying().isTraceEnabled()) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var2_2 = null;
            trace_this.logger().underlying().trace(Logging.msgWithLogIdent$(trace_this, msgWithLogIdent_msg));
            return;
        }
    }

    private File _file() {
        return this._file;
    }

    private void _file_$eq(File x$1) {
        this._file = x$1;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int maxIndexSize() {
        return this.maxIndexSize;
    }

    public boolean writable() {
        return this.writable;
    }

    private long _length() {
        return this._length;
    }

    private void _length_$eq(long x$1) {
        this._length = x$1;
    }

    public abstract int entrySize();

    public int _warmEntries() {
        return 8192 / this.entrySize();
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    public MappedByteBuffer mmap() {
        return this.mmap;
    }

    public void mmap_$eq(MappedByteBuffer x$1) {
        this.mmap = x$1;
    }

    public int _entries() {
        return this._entries;
    }

    public void _entries_$eq(int x$1) {
        this._entries = x$1;
    }

    public boolean isFull() {
        return this._entries() >= this._maxEntries;
    }

    public File file() {
        return this._file();
    }

    public int maxEntries() {
        return this._maxEntries;
    }

    public int entries() {
        return this._entries();
    }

    public long length() {
        return this._length();
    }

    public void updateParentDir(File parentDir) {
        this._file_$eq(new File(parentDir, this.file().getName()));
    }

    public boolean resize(int newSize) {
        boolean bl;
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            bl = AbstractIndex.$anonfun$resize$1(this, newSize);
        }
        finally {
            inLock_lock.unlock();
        }
        return bl;
    }

    public void renameTo(File f) {
        try {
            Utils.atomicMoveWithFallback((Path)this.file().toPath(), (Path)f.toPath(), (boolean)false);
        }
        finally {
            this._file_$eq(f);
        }
    }

    public void flush() {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            AbstractIndex.$anonfun$flush$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public boolean deleteIfExists() {
        this.closeHandler();
        return Files.deleteIfExists(this.file().toPath());
    }

    public void trimToValidSize() {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            this.resize(this.entrySize() * this._entries());
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public int sizeInBytes() {
        return this.entrySize() * this._entries();
    }

    @Override
    public void close() {
        this.trimToValidSize();
        this.closeHandler();
    }

    public void closeHandler() {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            this.safeForceUnmap();
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public abstract void sanityCheck();

    public abstract void truncate();

    public abstract void truncateTo(long var1);

    public void reset() {
        this.truncate();
        this.resize(this.maxIndexSize());
    }

    public int relativeOffset(long offset) {
        Option<Object> relativeOffset = this.toRelative(offset);
        if (relativeOffset.isEmpty()) {
            throw new IndexOffsetOverflowException(new StringBuilder(32).append("Integer overflow for offset: ").append(offset).append(" (").append(this.file().getAbsoluteFile()).append(")").toString());
        }
        return BoxesRunTime.unboxToInt((Object)relativeOffset.get());
    }

    public boolean canAppendOffset(long offset) {
        return this.toRelative(offset).isDefined();
    }

    public void safeForceUnmap() {
        if (this.mmap() != null) {
            try {
                this.forceUnmap();
                return;
            }
            catch (Throwable t) {
                AbstractIndex$ error_this = AbstractIndex$.MODULE$;
                if (error_this.logger().underlying().isErrorEnabled()) {
                    String msgWithLogIdent_msg = AbstractIndex.$anonfun$safeForceUnmap$1(this);
                    Object var3_3 = null;
                    error_this.logger().underlying().error(Logging.msgWithLogIdent$(error_this, msgWithLogIdent_msg), t);
                }
                return;
            }
        }
    }

    public void forceUnmap() {
        try {
            ByteBufferUnmapper.unmap((String)this.file().getAbsolutePath(), (ByteBuffer)this.mmap());
        }
        finally {
            this.mmap_$eq(null);
        }
    }

    public <T> T maybeLock(Lock lock, Function0<T> fun) {
        Object object;
        if (OperatingSystem.IS_WINDOWS || OperatingSystem.IS_ZOS) {
            lock.lock();
        }
        try {
            object = fun.apply();
        }
        finally {
            if (OperatingSystem.IS_WINDOWS || OperatingSystem.IS_ZOS) {
                lock.unlock();
            }
        }
        return (T)object;
    }

    public abstract IndexEntry parseEntry(ByteBuffer var1, int var2);

    public int largestLowerBoundSlotFor(ByteBuffer idx, long target, IndexSearchType searchEntity) {
        return this.indexSlotRangeFor(idx, target, searchEntity)._1$mcI$sp();
    }

    public int smallestUpperBoundSlotFor(ByteBuffer idx, long target, IndexSearchType searchEntity) {
        return this.indexSlotRangeFor(idx, target, searchEntity)._2$mcI$sp();
    }

    private Tuple2<Object, Object> indexSlotRangeFor(ByteBuffer idx, long target, IndexSearchType searchEntity) {
        if (this._entries() == 0) {
            return new Tuple2.mcII.sp(-1, -1);
        }
        int firstHotEntry = Math.max(0, this._entries() - 1 - this._warmEntries());
        if (this.compareIndexEntry(this.parseEntry(idx, firstHotEntry), target, searchEntity) < 0) {
            return this.binarySearch$1(firstHotEntry, this._entries() - 1, idx, target, searchEntity);
        }
        if (this.compareIndexEntry(this.parseEntry(idx, 0), target, searchEntity) > 0) {
            return new Tuple2.mcII.sp(-1, 0);
        }
        return this.binarySearch$1(0, firstHotEntry, idx, target, searchEntity);
    }

    private int compareIndexEntry(IndexEntry indexEntry, long target, IndexSearchType searchEntity) {
        int n;
        if (IndexSearchType$KEY$.MODULE$.equals(searchEntity)) {
            n = Long.compare(indexEntry.indexKey(), target);
        } else if (IndexSearchType$VALUE$.MODULE$.equals(searchEntity)) {
            n = Long.compare(indexEntry.indexValue(), target);
        } else {
            throw new MatchError((Object)searchEntity);
        }
        return n;
    }

    private int roundDownToExactMultiple(int number, int factor) {
        return factor * (number / factor);
    }

    private Option<Object> toRelative(long offset) {
        long relativeOffset = offset - this.baseOffset();
        if (relativeOffset < 0L || relativeOffset > Integer.MAX_VALUE) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)((int)relativeOffset)));
    }

    public static final /* synthetic */ String $anonfun$resize$2(AbstractIndex $this, int roundedNewSize$1) {
        return new StringBuilder(51).append("Index ").append($this.file().getAbsolutePath()).append(" was not resized because it already has size ").append(roundedNewSize$1).toString();
    }

    public static final /* synthetic */ String $anonfun$resize$3(AbstractIndex $this, int roundedNewSize$1) {
        return new StringBuilder(0).append(new StringBuilder(27).append("Resized ").append($this.file().getAbsolutePath()).append(" to ").append(roundedNewSize$1).append(", position is ").append($this.mmap().position()).append(" ").toString()).append(new StringBuilder(13).append("and limit is ").append($this.mmap().limit()).toString()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$resize$1(AbstractIndex $this, int newSize$1) {
        boolean bl;
        int roundDownToExactMultiple_factor = $this.entrySize();
        int n = roundDownToExactMultiple_factor * (newSize$1 / roundDownToExactMultiple_factor);
        if ($this._length() == (long)n) {
            AbstractIndex$ debug_this = AbstractIndex$.MODULE$;
            if (debug_this.logger().underlying().isDebugEnabled()) {
                String msgWithLogIdent_msg = AbstractIndex.$anonfun$resize$2($this, n);
                Object var9_5 = null;
                debug_this.logger().underlying().debug(Logging.msgWithLogIdent$(debug_this, msgWithLogIdent_msg));
            }
            return false;
        }
        RandomAccessFile raf = new RandomAccessFile($this.file(), "rw");
        try {
            int position = $this.mmap().position();
            if (OperatingSystem.IS_WINDOWS || OperatingSystem.IS_ZOS) {
                $this.safeForceUnmap();
            }
            raf.setLength(n);
            $this._length_$eq(n);
            $this.mmap_$eq(raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, n));
            $this._maxEntries = $this.mmap().limit() / $this.entrySize();
            $this.mmap().position(position);
            AbstractIndex$ debug_this = AbstractIndex$.MODULE$;
            if (debug_this.logger().underlying().isDebugEnabled()) {
                String msgWithLogIdent_msg = AbstractIndex.$anonfun$resize$3($this, n);
                Object var10_9 = null;
                debug_this.logger().underlying().debug(Logging.msgWithLogIdent$(debug_this, msgWithLogIdent_msg));
            }
            Object var6_8 = null;
            bl = true;
        }
        finally {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> raf.close(), AbstractIndex$.MODULE$, Level.WARN);
        }
        return bl;
    }

    public static final /* synthetic */ MappedByteBuffer $anonfun$flush$1(AbstractIndex $this) {
        return $this.mmap().force();
    }

    public static final /* synthetic */ void $anonfun$closeHandler$1(AbstractIndex $this) {
        $this.safeForceUnmap();
    }

    public static final /* synthetic */ String $anonfun$safeForceUnmap$1(AbstractIndex $this) {
        return new StringBuilder(22).append("Error unmapping index ").append($this.file()).toString();
    }

    public static final /* synthetic */ Throwable $anonfun$safeForceUnmap$2(Throwable t$1) {
        return t$1;
    }

    private final Tuple2 binarySearch$1(int begin, int end, ByteBuffer idx$1, long target$1, IndexSearchType searchEntity$1) {
        int lo = begin;
        int hi = end;
        while (lo < hi) {
            int mid = lo + hi + 1 >>> 1;
            IndexEntry found = this.parseEntry(idx$1, mid);
            int compareResult = this.compareIndexEntry(found, target$1, searchEntity$1);
            if (compareResult > 0) {
                hi = mid - 1;
                continue;
            }
            if (compareResult < 0) {
                lo = mid;
                continue;
            }
            return new Tuple2.mcII.sp(mid, mid);
        }
        return new Tuple2.mcII.sp(lo, lo == this._entries() - 1 ? -1 : lo + 1);
    }

    /*
     * WARNING - void declaration
     */
    public AbstractIndex(File _file, long baseOffset, int maxIndexSize, boolean writable) {
        MappedByteBuffer mappedByteBuffer;
        this._file = _file;
        this.baseOffset = baseOffset;
        this.maxIndexSize = maxIndexSize;
        this.writable = writable;
        this.lock = new ReentrantLock();
        boolean newlyCreated = this.file().createNewFile();
        RandomAccessFile raf = writable ? new RandomAccessFile(this.file(), "rw") : new RandomAccessFile(this.file(), "r");
        try {
            MappedByteBuffer idx;
            if (newlyCreated) {
                if (maxIndexSize < this.entrySize()) {
                    throw new IllegalArgumentException(new StringBuilder(24).append("Invalid max index size: ").append(maxIndexSize).toString());
                }
                int roundDownToExactMultiple_factor = this.entrySize();
                raf.setLength(roundDownToExactMultiple_factor * (maxIndexSize / roundDownToExactMultiple_factor));
            }
            this._length_$eq(raf.length());
            MappedByteBuffer mappedByteBuffer2 = idx = writable ? raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this._length()) : raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this._length());
            if (newlyCreated) {
                idx.position(0);
            } else {
                void roundDownToExactMultiple_factor;
                int n = this.entrySize();
                int roundDownToExactMultiple_number = idx.limit();
                idx.position((int)(roundDownToExactMultiple_factor * (roundDownToExactMultiple_number / roundDownToExactMultiple_factor)));
            }
            mappedByteBuffer = idx;
        }
        finally {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> raf.close(), AbstractIndex$.MODULE$, Level.WARN);
        }
        this.mmap = mappedByteBuffer;
        this._maxEntries = this.mmap().limit() / this.entrySize();
        this._entries = this.mmap().position() / this.entrySize();
    }
}

