/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.security;

import io.conduktor.security.Proxy;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/conduktor/security/ProxySetup;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "setupProxy", "", "p", "Lio/conduktor/security/Proxy;", "common"})
public final class ProxySetup {
    @NotNull
    public static final ProxySetup INSTANCE = new ProxySetup();
    private static final Logger logger = LoggerFactory.getLogger(INSTANCE.getClass());

    private ProxySetup() {
    }

    public final void setupProxy(@Nullable Proxy p) {
        if (p == null || p.getAutoDetect()) {
            logger.info("Proxy is set to auto-detect. Using system proxies.");
            System.setProperty("java.net.useSystemProxies", "true");
            return;
        }
        logger.info("Setting up proxy to " + p.getHost() + ":" + p.getPort() + " " + (p.getHasAuth() ? "with auth" : "without auth"));
        System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
        System.setProperty("http.proxyHost", p.getHost());
        System.setProperty("https.proxyHost", p.getHost());
        System.setProperty("http.proxyPort", String.valueOf(p.getPort()));
        System.setProperty("https.proxyPort", String.valueOf(p.getPort()));
        CharSequence charSequence = p.getNonProxyHosts();
        if (!(charSequence == null || charSequence.length() == 0)) {
            System.setProperty("http.nonProxyHosts", p.getNonProxyHosts());
        }
        if (!((charSequence = (CharSequence)p.getUser()) == null || charSequence.length() == 0)) {
            System.setProperty("http.proxyUser", p.getUser());
            System.setProperty("https.proxyUser", p.getUser());
        }
        if (!((charSequence = (CharSequence)p.getPassword()) == null || charSequence.length() == 0)) {
            System.setProperty("http.proxyPassword", p.getPassword());
            System.setProperty("https.proxyPassword", p.getPassword());
        }
        if (p.getHasAuth()) {
            Authenticator.setDefault(new Authenticator(p){
                final /* synthetic */ Proxy $p;
                {
                    this.$p = $p;
                }

                @NotNull
                protected PasswordAuthentication getPasswordAuthentication() {
                    String string = this.$p.getUser();
                    Intrinsics.checkNotNull((Object)string);
                    String string2 = this.$p.getPassword();
                    Intrinsics.checkNotNull((Object)string2);
                    char[] cArray = string2.toCharArray();
                    Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
                    return new PasswordAuthentication(string, cArray);
                }
            });
        }
    }
}

