/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.security;

import arrow.core.Either;
import arrow.core.EitherKt;
import arrow.core.NonFatalKt;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLContext;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nl.altindag.ssl.SSLFactory;
import nl.altindag.ssl.util.KeyStoreUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\u0018\u0000 )2\u00020\u0001:\u0001)B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0010\u001a\n \u000f*\u0004\u0018\u00010\u00110\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0005H\u0002JB\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00182\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00182\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u0018J\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001d0\u00142\u0006\u0010\u001e\u001a\u00020\u0003J\u0018\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180#0\u0014J\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001d0\u00142\u0006\u0010%\u001a\u00020\u0018J\b\u0010&\u001a\u00020\u001dH\u0002J\r\u0010'\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b(R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lio/conduktor/security/CertificateManager;", "", "cacertsPath", "Ljava/nio/file/Path;", "allowNonTrustedCertificates", "", "(Ljava/nio/file/Path;Z)V", "getAllowNonTrustedCertificates", "()Z", "getCacertsPath", "()Ljava/nio/file/Path;", "cf", "Ljava/security/cert/CertificateFactory;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "baseSSLFactoryBuilder", "Lnl/altindag/ssl/SSLFactory$Builder;", "enableConduktorTruststore", "buildSSLFactory", "Larrow/core/Either;", "", "Lnl/altindag/ssl/SSLFactory;", "trustStorePath", "", "trustStorePwd", "keyStorePath", "keyStorePwd", "import", "", "trustedCertExternalPath", "importOneWithoutSaving", "cacerts", "Ljava/security/KeyStore;", "list", "", "remove", "alias", "resetSSLContext", "setSSLContextWithConduktorTrustStore", "setSSLContextWithConduktorTrustStore$common", "Companion", "common"})
public final class CertificateManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path cacertsPath;
    private final boolean allowNonTrustedCertificates;
    private final Logger logger;
    @NotNull
    private final CertificateFactory cf;
    @NotNull
    public static final String truststorePassword = "changeit";

    public CertificateManager(@NotNull Path cacertsPath, boolean allowNonTrustedCertificates) {
        this.cacertsPath = cacertsPath;
        this.allowNonTrustedCertificates = allowNonTrustedCertificates;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.cf = CertificateFactory.getInstance("X.509");
    }

    @NotNull
    public final Path getCacertsPath() {
        return this.cacertsPath;
    }

    public final boolean getAllowNonTrustedCertificates() {
        return this.allowNonTrustedCertificates;
    }

    @NotNull
    public final Either<Throwable, SSLFactory> buildSSLFactory(@Nullable String trustStorePath, @Nullable String trustStorePwd, @Nullable String keyStorePath, @Nullable String keyStorePwd) {
        Either either;
        Either.Companion this_$iv = Either.Companion;
        boolean $i$f$tryCatch = false;
        try {
            SSLFactory.Builder builder;
            SSLFactory.Builder builder2;
            boolean bl = false;
            SSLFactory.Builder it = CertificateManager.baseSSLFactoryBuilder$default(this, false, 1, null);
            boolean bl2 = false;
            if (!this.allowNonTrustedCertificates && trustStorePath != null) {
                char[] cArray;
                Path path = Paths.get(trustStorePath, new String[0]);
                String string = trustStorePwd;
                if (string != null) {
                    char[] cArray2 = string.toCharArray();
                    cArray = cArray2;
                    Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"this as java.lang.String).toCharArray()");
                } else {
                    cArray = null;
                }
                builder2 = it.withTrustMaterial(path, cArray);
            } else {
                builder2 = it;
            }
            it = builder2;
            boolean bl3 = false;
            String string = keyStorePath;
            if (string != null) {
                char[] cArray;
                Path path = Paths.get(string, new String[0]);
                String string2 = keyStorePwd;
                if (string2 != null) {
                    char[] cArray3 = string2.toCharArray();
                    cArray = cArray3;
                    Intrinsics.checkNotNullExpressionValue((Object)cArray3, (String)"this as java.lang.String).toCharArray()");
                } else {
                    cArray = null;
                }
                builder = it.withIdentityMaterial(path, cArray);
            } else {
                builder = it;
            }
            either = EitherKt.right((Object)builder.build());
        }
        catch (Throwable t$iv) {
            either = EitherKt.left((Object)NonFatalKt.nonFatalOrThrow((Throwable)t$iv));
        }
        return either;
    }

    public static /* synthetic */ Either buildSSLFactory$default(CertificateManager certificateManager, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            string4 = null;
        }
        return certificateManager.buildSSLFactory(string, string2, string3, string4);
    }

    public final void setSSLContextWithConduktorTrustStore$common() {
        SSLFactory fac = CertificateManager.baseSSLFactoryBuilder$default(this, false, 1, null).build();
        SSLContext.setDefault(fac.getSslContext());
    }

    private final void resetSSLContext() {
        SSLFactory fac = this.baseSSLFactoryBuilder(false).build();
        SSLContext.setDefault(fac.getSslContext());
    }

    private final SSLFactory.Builder baseSSLFactoryBuilder(boolean enableConduktorTruststore) {
        SSLFactory.Builder builder;
        SSLFactory.Builder sslFactoryBuilder = SSLFactory.builder();
        boolean bl = false;
        if (this.allowNonTrustedCertificates) {
            builder = sslFactoryBuilder.withTrustingAllCertificatesWithoutValidation();
        } else {
            SSLFactory.Builder it = sslFactoryBuilder.withDefaultTrustMaterial().withSystemTrustMaterial();
            boolean bl2 = false;
            if (enableConduktorTruststore && Files.exists(this.cacertsPath, new LinkOption[0])) {
                char[] cArray = truststorePassword.toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
                builder = it.withTrustMaterial(this.cacertsPath, cArray);
            } else {
                builder = it;
            }
        }
        return builder;
    }

    static /* synthetic */ SSLFactory.Builder baseSSLFactoryBuilder$default(CertificateManager certificateManager, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return certificateManager.baseSSLFactoryBuilder(bl);
    }

    @NotNull
    public final Either<Throwable, List<String>> list() {
        Either either;
        Either this_$iv = Companion.loadKeyStore$common(this.cacertsPath, truststorePassword);
        boolean $i$f$map = false;
        Either $this$flatMap$iv$iv = this_$iv;
        boolean $i$f$flatMap = false;
        Either either2 = $this$flatMap$iv$iv;
        if (either2 instanceof Either.Right) {
            Object it$iv = ((Either.Right)$this$flatMap$iv$iv).getValue();
            boolean bl = false;
            KeyStore it = (KeyStore)it$iv;
            boolean bl2 = false;
            ArrayList<String> arrayList = Collections.list(it.aliases());
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(this)");
            List list = arrayList;
            either = (Either)new Either.Right((Object)list);
        } else if (either2 instanceof Either.Left) {
            either = $this$flatMap$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return either;
    }

    @NotNull
    public final Either<Throwable, Unit> remove(@NotNull String alias) {
        Either either;
        Either either2;
        Either $this$flatMap$iv = Companion.loadKeyStore$common(this.cacertsPath, truststorePassword);
        boolean $i$f$flatMap = false;
        Either either3 = $this$flatMap$iv;
        if (either3 instanceof Either.Right) {
            Either either4;
            KeyStore cacerts = (KeyStore)((Either.Right)$this$flatMap$iv).getValue();
            boolean bl = false;
            Either.Companion this_$iv = Either.Companion;
            boolean $i$f$tryCatch = false;
            try {
                boolean bl2 = false;
                cacerts.deleteEntry(alias);
                CertificateManager.Companion.saveKeyStore(cacerts, this.cacertsPath, truststorePassword);
                this.logger.info("Certificate " + alias + " removed from Conduktor's truststore");
                ArrayList<String> arrayList = Collections.list(cacerts.aliases());
                Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(this)");
                if (((List)arrayList).isEmpty()) {
                    this.resetSSLContext();
                    Files.deleteIfExists(this.cacertsPath);
                    this.logger.info("SSLContext reset to defaults");
                }
                either4 = EitherKt.right((Object)Unit.INSTANCE);
            }
            catch (Throwable t$iv) {
                either4 = EitherKt.left((Object)NonFatalKt.nonFatalOrThrow((Throwable)t$iv));
            }
            either2 = either4;
        } else if (either3 instanceof Either.Left) {
            either2 = $this$flatMap$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Either $this$handleErrorWith$iv = either2;
        boolean $i$f$handleErrorWith = false;
        either3 = $this$handleErrorWith$iv;
        if (either3 instanceof Either.Left) {
            Throwable it = (Throwable)((Either.Left)$this$handleErrorWith$iv).getValue();
            boolean bl = false;
            this.logger.warn("Error removing certificate from Conduktor's truststore", it);
            either = (Either)new Either.Left((Object)it);
        } else if (either3 instanceof Either.Right) {
            either = $this$handleErrorWith$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return either;
    }

    @NotNull
    public final Either<Throwable, Unit> import(@NotNull Path trustedCertExternalPath) {
        Either either;
        Either either2;
        Either $this$flatMap$iv = Companion.loadKeyStore$common(this.cacertsPath, truststorePassword);
        boolean $i$f$flatMap = false;
        Either either3 = $this$flatMap$iv;
        if (either3 instanceof Either.Right) {
            Either either4;
            KeyStore cacerts = (KeyStore)((Either.Right)$this$flatMap$iv).getValue();
            boolean bl = false;
            Either.Companion this_$iv = Either.Companion;
            boolean $i$f$tryCatch = false;
            try {
                boolean bl2 = false;
                String alias = this.importOneWithoutSaving(trustedCertExternalPath, cacerts);
                CertificateManager.Companion.saveKeyStore(cacerts, this.cacertsPath, truststorePassword);
                this.setSSLContextWithConduktorTrustStore$common();
                this.logger.info("Certificate " + alias + " added to Conduktor's truststore, SSLContext updated");
                either4 = EitherKt.right((Object)Unit.INSTANCE);
            }
            catch (Throwable t$iv) {
                either4 = EitherKt.left((Object)NonFatalKt.nonFatalOrThrow((Throwable)t$iv));
            }
            either2 = either4;
        } else if (either3 instanceof Either.Left) {
            either2 = $this$flatMap$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Either $this$handleErrorWith$iv = either2;
        boolean $i$f$handleErrorWith = false;
        either3 = $this$handleErrorWith$iv;
        if (either3 instanceof Either.Left) {
            Throwable it = (Throwable)((Either.Left)$this$handleErrorWith$iv).getValue();
            boolean bl = false;
            this.logger.warn("Error adding certificate to Conduktor's truststore", it);
            either = (Either)new Either.Left((Object)it);
        } else if (either3 instanceof Either.Right) {
            either = $this$handleErrorWith$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return either;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String importOneWithoutSaving(Path trustedCertExternalPath, KeyStore cacerts) {
        String string;
        Object object = new OpenOption[]{StandardOpenOption.READ};
        object = Files.newInputStream(trustedCertExternalPath, object);
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)object;
            boolean bl = false;
            Certificate cert = this.cf.generateCertificate(it);
            String alias = trustedCertExternalPath.toFile().getName();
            if (cacerts.containsAlias(alias)) {
                cacerts.deleteEntry(alias);
            }
            cacerts.setCertificateEntry(alias, cert);
            string = alias;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return string;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\nJ)\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u000fJ \u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/conduktor/security/CertificateManager$Companion;", "", "()V", "truststorePassword", "", "createEmptyKeyStore", "", "storePath", "Ljava/nio/file/Path;", "password", "createEmptyKeyStore$common", "loadKeyStore", "Larrow/core/Either;", "", "Ljava/security/KeyStore;", "loadKeyStore$common", "saveKeyStore", "store", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Either<Throwable, KeyStore> loadKeyStore$common(@NotNull Path storePath, @NotNull String password) {
            Either either;
            Either.Companion this_$iv = Either.Companion;
            boolean $i$f$tryCatch = false;
            try {
                KeyStore keyStore;
                boolean bl = false;
                if (Files.exists(storePath, new LinkOption[0])) {
                    char[] cArray = password.toCharArray();
                    Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
                    keyStore = KeyStoreUtils.loadKeyStore((Path)storePath, (char[])cArray);
                } else {
                    KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                    char[] cArray = password.toCharArray();
                    Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
                    keystore.load(null, cArray);
                    keyStore = keystore;
                }
                either = EitherKt.right((Object)keyStore);
            }
            catch (Throwable t$iv) {
                either = EitherKt.left((Object)NonFatalKt.nonFatalOrThrow((Throwable)t$iv));
            }
            return either;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void saveKeyStore(KeyStore store, Path storePath, String password) {
            Closeable closeable = Files.newOutputStream(storePath, new OpenOption[0]);
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl = false;
                char[] cArray = password.toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
                store.store(it, cArray);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        public final void createEmptyKeyStore$common(@NotNull Path storePath, @NotNull String password) {
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            char[] cArray = password.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
            keystore.load(null, cArray);
            this.saveKeyStore(keystore, storePath, password);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

