/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.common;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import kotlin.Metadata;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\b\u001a\u0012\u0010\t\u001a\u00020\b*\u00020\b2\u0006\u0010\n\u001a\u00020\b\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"SECOND_TO_MILLISECOND_FACTOR", "", "fraction", "", "start", "end", "current", "epochMillis", "Ljava/time/LocalDateTime;", "max", "other", "utcEpochMillisFromLocaleTimeZone", "common"})
public final class KotlinExtensionsKt {
    public static final long SECOND_TO_MILLISECOND_FACTOR = 1000L;

    public static final long utcEpochMillisFromLocaleTimeZone(@NotNull LocalDateTime $this$utcEpochMillisFromLocaleTimeZone) {
        return $this$utcEpochMillisFromLocaleTimeZone.atZone(ZoneId.systemDefault()).withZoneSameInstant(ZoneOffset.UTC).toEpochSecond() * 1000L;
    }

    public static final long epochMillis(@NotNull LocalDateTime $this$epochMillis) {
        return $this$epochMillis.atZone(ZoneOffset.UTC).toEpochSecond() * 1000L;
    }

    @NotNull
    public static final LocalDateTime max(@NotNull LocalDateTime $this$max, @NotNull LocalDateTime other) {
        return $this$max.isAfter(other) ? $this$max : other;
    }

    public static final double fraction(long start, long end, long current) {
        long coerce = RangesKt.coerceIn((long)current, (long)start, (long)end);
        return 1.0 - 1.0 * (double)(end - start - (coerce - start)) / (double)(end - start);
    }
}

