/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.urlconnection;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.utils.ProxySystemSetting;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

@SdkPublicApi
public final class ProxyConfiguration
implements ToCopyableBuilder<Builder, ProxyConfiguration> {
    private final URI endpoint;
    private final String username;
    private final String password;
    private final Set<String> nonProxyHosts;
    private final String host;
    private final int port;
    private final String scheme;
    private final boolean useSystemPropertyValues;

    private ProxyConfiguration(DefaultClientProxyConfigurationBuilder builder) {
        this.endpoint = builder.endpoint;
        this.username = builder.username;
        this.password = builder.password;
        this.nonProxyHosts = builder.nonProxyHosts;
        this.useSystemPropertyValues = builder.useSystemPropertyValues;
        this.host = this.resolveHost();
        this.port = this.resolvePort();
        this.scheme = this.resolveScheme();
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String scheme() {
        return this.scheme;
    }

    public String username() {
        return this.resolveValue(this.username, ProxySystemSetting.PROXY_USERNAME);
    }

    public String password() {
        return this.resolveValue(this.password, ProxySystemSetting.PROXY_PASSWORD);
    }

    public Set<String> nonProxyHosts() {
        Set hosts = this.nonProxyHosts == null && this.useSystemPropertyValues ? SdkHttpUtils.parseNonProxyHostsProperty() : this.nonProxyHosts;
        return Collections.unmodifiableSet(hosts != null ? hosts : Collections.emptySet());
    }

    public Builder toBuilder() {
        return ProxyConfiguration.builder().endpoint(this.endpoint).username(this.username).password(this.password).nonProxyHosts(this.nonProxyHosts);
    }

    public static Builder builder() {
        return new DefaultClientProxyConfigurationBuilder();
    }

    public String toString() {
        return ToString.builder((String)"ProxyConfiguration").add("endpoint", (Object)this.endpoint).add("username", (Object)this.username).add("nonProxyHosts", this.nonProxyHosts).build();
    }

    private String resolveHost() {
        return this.endpoint != null ? this.endpoint.getHost() : this.resolveValue(null, ProxySystemSetting.PROXY_HOST);
    }

    private int resolvePort() {
        if (this.endpoint != null) {
            return this.endpoint.getPort();
        }
        if (this.useSystemPropertyValues) {
            return ProxySystemSetting.PROXY_PORT.getStringValue().map(Integer::parseInt).orElse(0);
        }
        return 0;
    }

    public String resolveScheme() {
        return this.endpoint != null ? this.endpoint.getScheme() : null;
    }

    private String resolveValue(String value, ProxySystemSetting systemSetting) {
        return value == null && this.useSystemPropertyValues ? (String)systemSetting.getStringValue().orElse(null) : value;
    }

    private static final class DefaultClientProxyConfigurationBuilder
    implements Builder {
        private URI endpoint;
        private String username;
        private String password;
        private Set<String> nonProxyHosts;
        private Boolean useSystemPropertyValues = Boolean.TRUE;

        private DefaultClientProxyConfigurationBuilder() {
        }

        @Override
        public Builder endpoint(URI endpoint) {
            if (endpoint != null) {
                Validate.isTrue((boolean)StringUtils.isEmpty((CharSequence)endpoint.getUserInfo()), (String)"Proxy endpoint user info is not supported.", (Object[])new Object[0]);
                Validate.isTrue((boolean)StringUtils.isEmpty((CharSequence)endpoint.getPath()), (String)"Proxy endpoint path is not supported.", (Object[])new Object[0]);
                Validate.isTrue((boolean)StringUtils.isEmpty((CharSequence)endpoint.getQuery()), (String)"Proxy endpoint query is not supported.", (Object[])new Object[0]);
                Validate.isTrue((boolean)StringUtils.isEmpty((CharSequence)endpoint.getFragment()), (String)"Proxy endpoint fragment is not supported.", (Object[])new Object[0]);
            }
            this.endpoint = endpoint;
            return this;
        }

        public void setEndpoint(URI endpoint) {
            this.endpoint(endpoint);
        }

        @Override
        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public void setUsername(String username) {
            this.username(username);
        }

        @Override
        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public void setPassword(String password) {
            this.password(password);
        }

        @Override
        public Builder nonProxyHosts(Set<String> nonProxyHosts) {
            this.nonProxyHosts = nonProxyHosts != null ? new HashSet<String>(nonProxyHosts) : null;
            return this;
        }

        @Override
        public Builder addNonProxyHost(String nonProxyHost) {
            if (this.nonProxyHosts == null) {
                this.nonProxyHosts = new HashSet<String>();
            }
            this.nonProxyHosts.add(nonProxyHost);
            return this;
        }

        public void setNonProxyHosts(Set<String> nonProxyHosts) {
            this.nonProxyHosts(nonProxyHosts);
        }

        @Override
        public Builder useSystemPropertyValues(Boolean useSystemPropertyValues) {
            this.useSystemPropertyValues = useSystemPropertyValues;
            return this;
        }

        public void setUseSystemPropertyValues(Boolean useSystemPropertyValues) {
            this.useSystemPropertyValues(useSystemPropertyValues);
        }

        public ProxyConfiguration build() {
            return new ProxyConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProxyConfiguration> {
        public Builder endpoint(URI var1);

        public Builder username(String var1);

        public Builder password(String var1);

        public Builder nonProxyHosts(Set<String> var1);

        public Builder addNonProxyHost(String var1);

        public Builder useSystemPropertyValues(Boolean var1);
    }
}

