/*
 * Decompiled with CFR 0.152.
 */
package tornadofx;

import java.util.function.Consumer;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.control.Skin;
import javafx.scene.control.skin.CellSkinBase;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tornadofx.DataGrid;
import tornadofx.DataGridCell;
import tornadofx.DataGridRow;
import tornadofx.DataGridSkin;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0002\u0010\u0005J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0014J0\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0014J0\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0014J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0002J\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u0016J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\tH\u0014J\b\u0010\u001d\u001a\u00020\u0018H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ltornadofx/DataGridRowSkin;", "T", "Ljavafx/scene/control/skin/CellSkinBase;", "Ltornadofx/DataGridRow;", "control", "(Ltornadofx/DataGridRow;)V", "lastUpdatedCells", "Lkotlin/ranges/IntRange;", "computeMaxHeight", "", "width", "topInset", "rightInset", "bottomInset", "leftInset", "computePrefHeight", "computePrefWidth", "height", "createCell", "Ltornadofx/DataGridCell;", "getCellAtIndex", "index", "", "layoutChildren", "", "x", "y", "w", "h", "updateCells", "tornadofx"})
public final class DataGridRowSkin<T>
extends CellSkinBase<DataGridRow<T>> {
    private IntRange lastUpdatedCells;

    private final void updateCells() {
        DataGridRow dataGridRow = (DataGridRow)this.getSkinnable();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)dataGridRow), (String)"skinnable");
        int rowIndex = dataGridRow.getIndex();
        if (rowIndex > -1) {
            IntRange intRange;
            DataGrid dataGrid = ((DataGridRow)this.getSkinnable()).getDataGrid();
            Skin skin = dataGrid.getSkin();
            if (skin == null) {
                throw new TypeCastException("null cannot be cast to non-null type tornadofx.DataGridSkin<*>");
            }
            int maxCellsInRow = ((DataGridSkin)skin).computeMaxCellsInRow();
            int totalCellsInGrid = dataGrid.getItems().size();
            int startCellIndex = rowIndex * maxCellsInRow;
            int endCellIndex = startCellIndex + maxCellsInRow - 1;
            int cacheIndex = 0;
            int n = startCellIndex;
            IntRange intRange2 = new IntRange(n, endCellIndex);
            DataGridRowSkin dataGridRowSkin = this;
            boolean bl = false;
            boolean bl2 = false;
            IntRange it = intRange2;
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)it, (Object)this.lastUpdatedCells)) {
                return;
            }
            dataGridRowSkin.lastUpdatedCells = intRange = intRange2;
            int cellIndex = startCellIndex;
            while (cellIndex <= endCellIndex && cellIndex < totalCellsInGrid) {
                DataGridCell<T> cell = this.getCellAtIndex(cacheIndex);
                if (cell == null) {
                    cell = this.createCell();
                    this.getChildren().add(cell);
                }
                cell.setUpdating(true);
                cell.updateIndex(-1);
                cell.setUpdating(false);
                cell.updateIndex(cellIndex);
                ++cellIndex;
                ++cacheIndex;
            }
            this.getChildren().remove(cacheIndex, this.getChildren().size());
        }
    }

    private final DataGridCell<T> createCell() {
        Object object = ((DataGridRow)this.getSkinnable()).getDataGrid().getCellFactory();
        if (object == null || (object = (DataGridCell)((Object)object.invoke(((DataGridRow)this.getSkinnable()).getDataGrid()))) == null) {
            object = new DataGridCell(((DataGridRow)this.getSkinnable()).getDataGrid());
        }
        return object;
    }

    @Nullable
    public final DataGridCell<T> getCellAtIndex(int index) {
        if (index < this.getChildren().size()) {
            return (DataGridCell)((Object)this.getChildren().get(index));
        }
        return null;
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        DataGrid dataGrid = ((DataGridRow)this.getSkinnable()).getDataGrid();
        Skin skin = dataGrid.getSkin();
        if (skin == null) {
            throw new TypeCastException("null cannot be cast to non-null type tornadofx.DataGridSkin<*>");
        }
        return dataGrid.getCellHeight() * (double)((DataGridSkin)skin)._getItemCount();
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        DataGrid dataGrid = ((DataGridRow)this.getSkinnable()).getDataGrid();
        return dataGrid.getCellHeight() + dataGrid.getVerticalCellSpacing() * (double)2;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        DataGrid dataGrid = ((DataGridRow)this.getSkinnable()).getDataGrid();
        return (dataGrid.getCellWidth() + dataGrid.getHorizontalCellSpacing() * (double)2) * (double)((DataGridRow)this.getSkinnable()).getDataGridSkin().computeMaxCellsInRow();
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        DataGrid dataGrid = ((DataGridRow)this.getSkinnable()).getDataGrid();
        double cellWidth = dataGrid.getCellWidth();
        double cellHeight = dataGrid.getCellHeight();
        double horizontalCellSpacing = dataGrid.getHorizontalCellSpacing();
        double verticalCellSpacing = dataGrid.getVerticalCellSpacing();
        double xPos = 0.0;
        for (Node child : this.getChildren()) {
            child.resizeRelocate(xPos + horizontalCellSpacing, y + verticalCellSpacing, cellWidth, cellHeight);
            xPos += cellWidth + horizontalCellSpacing * (double)2;
        }
    }

    public DataGridRowSkin(@NotNull DataGridRow<T> control) {
        Intrinsics.checkParameterIsNotNull(control, (String)"control");
        super((Cell)control);
        int n = -1;
        this.lastUpdatedCells = new IntRange(n, -1);
        this.getChildren().clear();
        this.updateCells();
        this.registerChangeListener((ObservableValue)((DataGridRow)this.getSkinnable()).indexProperty(), new Consumer<ObservableValue<?>>(){

            @Override
            public final void accept(ObservableValue<?> it) {
                this.updateCells();
            }
        });
        this.registerChangeListener((ObservableValue)((DataGridRow)this.getSkinnable()).widthProperty(), new Consumer<ObservableValue<?>>(){

            @Override
            public final void accept(ObservableValue<?> it) {
                this.updateCells();
            }
        });
        this.registerChangeListener((ObservableValue)((DataGridRow)this.getSkinnable()).heightProperty(), new Consumer<ObservableValue<?>>(){

            @Override
            public final void accept(ObservableValue<?> it) {
                this.updateCells();
            }
        });
    }
}

