/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.model.WindowType;
import io.confluent.ksql.rest.entity.FieldInfo;
import io.confluent.ksql.rest.entity.QueryHostStat;
import io.confluent.ksql.rest.entity.QueryOffsetSummary;
import io.confluent.ksql.rest.entity.RunningQuery;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName(value="description")
@JsonSubTypes(value={})
public class SourceDescription {
    private final String name;
    private final Optional<WindowType> windowType;
    private final List<RunningQuery> readQueries;
    private final List<RunningQuery> writeQueries;
    private final List<FieldInfo> fields;
    private final String type;
    private final String timestamp;
    private final String statistics;
    private final String errorStats;
    private final boolean extended;
    private final String keyFormat;
    private final String valueFormat;
    private final String topic;
    private final int partitions;
    private final int replication;
    private final String statement;
    private final List<QueryOffsetSummary> queryOffsetSummaries;
    private final List<String> sourceConstraints;
    private final List<QueryHostStat> clusterStatistics;
    private final List<QueryHostStat> clusterErrorStats;

    @JsonCreator
    public SourceDescription(@JsonProperty(value="name") String name, @JsonProperty(value="windowType") Optional<WindowType> windowType, @JsonProperty(value="readQueries") List<RunningQuery> readQueries, @JsonProperty(value="writeQueries") List<RunningQuery> writeQueries, @JsonProperty(value="fields") List<FieldInfo> fields, @JsonProperty(value="type") String type, @JsonProperty(value="timestamp") String timestamp, @JsonProperty(value="statistics") String statistics, @JsonProperty(value="errorStats") String errorStats, @JsonProperty(value="extended") boolean extended, @JsonProperty(value="keyFormat") String keyFormat, @JsonProperty(value="valueFormat") String valueFormat, @JsonProperty(value="topic") String topic, @JsonProperty(value="partitions") int partitions, @JsonProperty(value="replication") int replication, @JsonProperty(value="statement") String statement, @JsonProperty(value="queryOffsetSummaries") List<QueryOffsetSummary> queryOffsetSummaries, @JsonProperty(value="sourceConstraints") List<String> sourceConstraints, @JsonProperty(value="clusterStatistics") List<QueryHostStat> clusterStats, @JsonProperty(value="clusterErrorStats") List<QueryHostStat> clusterErrors) {
        this.name = Objects.requireNonNull(name, "name");
        this.windowType = Objects.requireNonNull(windowType, "windowType");
        this.readQueries = ImmutableList.copyOf((Collection)Objects.requireNonNull(readQueries, "readQueries"));
        this.writeQueries = ImmutableList.copyOf((Collection)Objects.requireNonNull(writeQueries, "writeQueries"));
        this.fields = ImmutableList.copyOf((Collection)Objects.requireNonNull(fields, "fields"));
        this.type = Objects.requireNonNull(type, "type");
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp");
        this.statistics = Objects.requireNonNull(statistics, "statistics");
        this.errorStats = Objects.requireNonNull(errorStats, "errorStats");
        this.extended = extended;
        this.keyFormat = Objects.requireNonNull(keyFormat, "keyFormat");
        this.valueFormat = Objects.requireNonNull(valueFormat, "valueFormat");
        this.topic = Objects.requireNonNull(topic, "topic");
        this.partitions = partitions;
        this.replication = replication;
        this.statement = Objects.requireNonNull(statement, "statement");
        this.queryOffsetSummaries = ImmutableList.copyOf((Collection)Objects.requireNonNull(queryOffsetSummaries, "queryOffsetSummaries"));
        this.sourceConstraints = ImmutableList.copyOf((Collection)Objects.requireNonNull(sourceConstraints, "sourceConstraints"));
        this.clusterErrorStats = ImmutableList.copyOf(clusterErrors);
        this.clusterStatistics = ImmutableList.copyOf(clusterStats);
    }

    public SourceDescription(@JsonProperty(value="name") String name, @JsonProperty(value="windowType") Optional<WindowType> windowType, @JsonProperty(value="readQueries") List<RunningQuery> readQueries, @JsonProperty(value="writeQueries") List<RunningQuery> writeQueries, @JsonProperty(value="fields") List<FieldInfo> fields, @JsonProperty(value="type") String type, @JsonProperty(value="timestamp") String timestamp, @JsonProperty(value="statistics") String statistics, @JsonProperty(value="errorStats") String errorStats, @JsonProperty(value="extended") boolean extended, @JsonProperty(value="keyFormat") String keyFormat, @JsonProperty(value="valueFormat") String valueFormat, @JsonProperty(value="topic") String topic, @JsonProperty(value="partitions") int partitions, @JsonProperty(value="replication") int replication, @JsonProperty(value="statement") String statement, @JsonProperty(value="queryOffsetSummaries") List<QueryOffsetSummary> queryOffsetSummaries, @JsonProperty(value="sourceConstraints") List<String> sourceConstraints) {
        this(name, windowType, readQueries, writeQueries, fields, type, timestamp, statistics, errorStats, extended, keyFormat, valueFormat, topic, partitions, replication, statement, queryOffsetSummaries, sourceConstraints, (List<QueryHostStat>)ImmutableList.of(), (List<QueryHostStat>)ImmutableList.of());
    }

    public String getStatement() {
        return this.statement;
    }

    public Optional<WindowType> getWindowType() {
        return this.windowType;
    }

    public int getPartitions() {
        return this.partitions;
    }

    public int getReplication() {
        return this.replication;
    }

    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="fields is ImmutableList")
    public List<FieldInfo> getFields() {
        return this.fields;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public String getType() {
        return this.type;
    }

    public String getKeyFormat() {
        return this.keyFormat;
    }

    public String getValueFormat() {
        return this.valueFormat;
    }

    public String getTopic() {
        return this.topic;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="writeQueries is ImmutableList")
    public List<RunningQuery> getWriteQueries() {
        return this.writeQueries;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="readQueries is ImmutableList")
    public List<RunningQuery> getReadQueries() {
        return this.readQueries;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getStatistics() {
        if (this.statistics.length() > 0) {
            return "The statistics field is deprecated and will be removed in a future version of ksql. Please update your client to the latest version and use statisticsMap instead.\n" + this.statistics;
        }
        return "";
    }

    public String getErrorStats() {
        if (this.errorStats.length() > 0) {
            return "The errorStats field is deprecated and will be removed in a future version of ksql. Please update your client to the latest version and use errorStatsMap instead.\n" + this.errorStats + '\n';
        }
        return "";
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="queryOffsetSummaries is ImmutableList")
    public List<QueryOffsetSummary> getQueryOffsetSummaries() {
        return this.queryOffsetSummaries;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="sourceConstraints is ImmutableList")
    public List<String> getSourceConstraints() {
        return this.sourceConstraints;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="clusterStatistics is ImmutableList")
    public List<QueryHostStat> getClusterStatistics() {
        return this.clusterStatistics;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="clusterErrorStats is ImmutableList")
    public List<QueryHostStat> getClusterErrorStats() {
        return this.clusterErrorStats;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceDescription that = (SourceDescription)o;
        return this.extended == that.extended && this.partitions == that.partitions && this.replication == that.replication && Objects.equals(this.name, that.name) && Objects.equals(this.windowType, that.windowType) && Objects.equals(this.readQueries, that.readQueries) && Objects.equals(this.writeQueries, that.writeQueries) && Objects.equals(this.fields, that.fields) && Objects.equals(this.type, that.type) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.statistics, that.statistics) && Objects.equals(this.errorStats, that.errorStats) && Objects.equals(this.clusterStatistics, that.clusterStatistics) && Objects.equals(this.clusterErrorStats, that.clusterErrorStats) && Objects.equals(this.keyFormat, that.keyFormat) && Objects.equals(this.valueFormat, that.valueFormat) && Objects.equals(this.topic, that.topic) && Objects.equals(this.statement, that.statement) && Objects.equals(this.queryOffsetSummaries, that.queryOffsetSummaries) && Objects.equals(this.sourceConstraints, that.sourceConstraints);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.windowType, this.readQueries, this.writeQueries, this.fields, this.type, this.timestamp, this.statistics, this.errorStats, this.extended, this.keyFormat, this.valueFormat, this.topic, this.partitions, this.replication, this.statement, this.queryOffsetSummaries, this.sourceConstraints);
    }
}

