/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Joiner;
import io.confluent.ksql.util.KsqlConstants;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.streams.KafkaStreams;

@JsonIgnoreProperties(ignoreUnknown=true)
public class QueryStatusCount {
    private final EnumMap<KsqlConstants.KsqlQueryStatus, Integer> statuses;

    public static QueryStatusCount fromStreamsStateCounts(Map<KafkaStreams.State, Integer> states) {
        Map<KsqlConstants.KsqlQueryStatus, Integer> ksqlQueryStatus = states.entrySet().stream().collect(Collectors.toMap(e -> KsqlConstants.fromStreamsState((KafkaStreams.State)((KafkaStreams.State)e.getKey())), Map.Entry::getValue));
        return new QueryStatusCount(ksqlQueryStatus);
    }

    public QueryStatusCount() {
        this(Collections.emptyMap());
    }

    @JsonCreator
    public QueryStatusCount(Map<KsqlConstants.KsqlQueryStatus, Integer> states) {
        this.statuses = states.isEmpty() ? QueryStatusCount.returnEnumMap() : new EnumMap<KsqlConstants.KsqlQueryStatus, Integer>(states);
    }

    public void updateStatusCount(String state, int change) {
        this.updateStatusCount(KafkaStreams.State.valueOf((String)state), change);
    }

    public void updateStatusCount(KafkaStreams.State state, int change) {
        this.updateStatusCount(KsqlConstants.fromStreamsState((KafkaStreams.State)state), change);
    }

    public void updateStatusCount(KsqlConstants.KsqlQueryStatus state, int change) {
        this.statuses.compute(state, (key, existing) -> existing == null ? change : existing + change);
    }

    @JsonValue
    public Map<KsqlConstants.KsqlQueryStatus, Integer> getStatuses() {
        return Collections.unmodifiableMap(this.statuses);
    }

    public KsqlConstants.KsqlQueryStatus getAggregateStatus() {
        if (this.statuses.getOrDefault(KsqlConstants.KsqlQueryStatus.ERROR, 0) != 0) {
            return KsqlConstants.KsqlQueryStatus.ERROR;
        }
        return KsqlConstants.KsqlQueryStatus.RUNNING;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryStatusCount that = (QueryStatusCount)o;
        return Objects.equals(this.statuses, that.statuses);
    }

    public int hashCode() {
        return Objects.hash(this.statuses);
    }

    public String toString() {
        return Joiner.on((String)",").withKeyValueSeparator(":").join(this.statuses);
    }

    private static EnumMap<KsqlConstants.KsqlQueryStatus, Integer> returnEnumMap() {
        return new EnumMap<KsqlConstants.KsqlQueryStatus, Integer>(KsqlConstants.KsqlQueryStatus.class);
    }
}

