/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.flowless;

import javafx.application.Platform;
import javafx.beans.DefaultProperty;
import javafx.beans.NamedArg;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Region;
import org.fxmisc.flowless.Virtualized;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

@DefaultProperty(value="content")
public class VirtualizedScrollPane<V extends Node>
extends Region
implements Virtualized {
    private static final PseudoClass CONTENT_FOCUSED = PseudoClass.getPseudoClass((String)"content-focused");
    private final ScrollBar hbar;
    private final ScrollBar vbar;
    private final V content;
    private final ChangeListener<Boolean> contentFocusedListener;
    private final ChangeListener<Double> hbarValueListener;
    private ChangeListener<Double> hPosEstimateListener;
    private final ChangeListener<Double> vbarValueListener;
    private final ChangeListener<Double> vPosEstimateListener;
    private Var<Double> hbarValue;
    private Var<Double> vbarValue;
    private Var<Double> hPosEstimate;
    private Var<Double> vPosEstimate;
    private final Var<ScrollPane.ScrollBarPolicy> hbarPolicy;
    private final Var<ScrollPane.ScrollBarPolicy> vbarPolicy;

    public final ScrollPane.ScrollBarPolicy getHbarPolicy() {
        return (ScrollPane.ScrollBarPolicy)this.hbarPolicy.getValue();
    }

    public final void setHbarPolicy(ScrollPane.ScrollBarPolicy value) {
        this.hbarPolicy.setValue((Object)value);
    }

    public final Var<ScrollPane.ScrollBarPolicy> hbarPolicyProperty() {
        return this.hbarPolicy;
    }

    public final ScrollPane.ScrollBarPolicy getVbarPolicy() {
        return (ScrollPane.ScrollBarPolicy)this.vbarPolicy.getValue();
    }

    public final void setVbarPolicy(ScrollPane.ScrollBarPolicy value) {
        this.vbarPolicy.setValue((Object)value);
    }

    public final Var<ScrollPane.ScrollBarPolicy> vbarPolicyProperty() {
        return this.vbarPolicy;
    }

    public VirtualizedScrollPane(@NamedArg(value="content") V content, @NamedArg(value="hPolicy") ScrollPane.ScrollBarPolicy hPolicy, @NamedArg(value="vPolicy") ScrollPane.ScrollBarPolicy vPolicy) {
        this.getStyleClass().add((Object)"virtualized-scroll-pane");
        this.content = content;
        this.hbar = new ScrollBar();
        this.vbar = new ScrollBar();
        this.hbar.setOrientation(Orientation.HORIZONTAL);
        this.vbar.setOrientation(Orientation.VERTICAL);
        this.hbar.setMin(0.0);
        this.vbar.setMin(0.0);
        this.hbar.maxProperty().bind(((Virtualized)content).totalWidthEstimateProperty());
        this.vbar.maxProperty().bind(((Virtualized)content).totalHeightEstimateProperty());
        VirtualizedScrollPane.setupUnitIncrement(this.hbar);
        VirtualizedScrollPane.setupUnitIncrement(this.vbar);
        this.hbar.blockIncrementProperty().bind((ObservableValue)this.hbar.visibleAmountProperty());
        this.vbar.blockIncrementProperty().bind((ObservableValue)this.vbar.visibleAmountProperty());
        this.hPosEstimate = Val.combine(((Virtualized)content).estimatedScrollXProperty(), (ObservableValue)Val.map((ObservableValue)content.layoutBoundsProperty(), Bounds::getWidth), ((Virtualized)content).totalWidthEstimateProperty(), VirtualizedScrollPane::offsetToScrollbarPosition).asVar(this::setHPosition);
        this.vPosEstimate = Val.combine(((Virtualized)content).estimatedScrollYProperty(), (ObservableValue)Val.map((ObservableValue)content.layoutBoundsProperty(), Bounds::getHeight), ((Virtualized)content).totalHeightEstimateProperty(), VirtualizedScrollPane::offsetToScrollbarPosition).orElseConst((Object)0.0).asVar(this::setVPosition);
        this.hbarValue = Var.doubleVar((DoubleProperty)this.hbar.valueProperty());
        this.vbarValue = Var.doubleVar((DoubleProperty)this.vbar.valueProperty());
        this.hbarValueListener = (observable, oldValue, newValue) -> {
            this.hPosEstimate.removeListener(this.hPosEstimateListener);
            this.hPosEstimate.setValue(newValue);
            this.hPosEstimate.addListener(this.hPosEstimateListener);
        };
        this.hbarValue.addListener(this.hbarValueListener);
        this.hPosEstimateListener = (observable, oldValue, newValue) -> {
            this.hbarValue.removeListener(this.hbarValueListener);
            this.hbarValue.setValue(newValue);
            this.hbarValue.addListener(this.hbarValueListener);
        };
        this.hPosEstimate.addListener(this.hPosEstimateListener);
        this.vbarValueListener = (observable, oldValue, newValue) -> this.vPosEstimate.setValue(newValue);
        this.vbarValue.addListener(this.vbarValueListener);
        this.vPosEstimateListener = (observable, oldValue, newValue) -> this.vbarValue.setValue(newValue);
        this.vPosEstimate.addListener(this.vPosEstimateListener);
        this.hbarPolicy = Var.newSimpleVar((Object)hPolicy);
        this.vbarPolicy = Var.newSimpleVar((Object)vPolicy);
        Val layoutWidth = Val.map((ObservableValue)this.layoutBoundsProperty(), Bounds::getWidth);
        Val layoutHeight = Val.map((ObservableValue)this.layoutBoundsProperty(), Bounds::getHeight);
        Val needsHBar0 = Val.combine(((Virtualized)content).totalWidthEstimateProperty(), (ObservableValue)layoutWidth, (cw, lw) -> cw > lw);
        Val needsVBar0 = Val.combine(((Virtualized)content).totalHeightEstimateProperty(), (ObservableValue)layoutHeight, (ch, lh) -> ch > lh);
        Val needsHBar = Val.combine((ObservableValue)needsHBar0, (ObservableValue)needsVBar0, ((Virtualized)content).totalWidthEstimateProperty(), (ObservableValue)this.vbar.widthProperty(), (ObservableValue)layoutWidth, (needsH, needsV, cw, vbw, lw) -> needsH != false || needsV != false && cw + vbw.doubleValue() > lw);
        Val needsVBar = Val.combine((ObservableValue)needsVBar0, (ObservableValue)needsHBar0, ((Virtualized)content).totalHeightEstimateProperty(), (ObservableValue)this.hbar.heightProperty(), (ObservableValue)layoutHeight, (needsV, needsH, ch, hbh, lh) -> needsV != false || needsH != false && ch + hbh.doubleValue() > lh);
        Val shouldDisplayHorizontal = Val.flatMap(this.hbarPolicy, policy -> {
            switch (policy) {
                case NEVER: {
                    return Val.constant((Object)false);
                }
                case ALWAYS: {
                    return Val.constant((Object)true);
                }
            }
            return needsHBar;
        });
        Val shouldDisplayVertical = Val.flatMap(this.vbarPolicy, policy -> {
            switch (policy) {
                case NEVER: {
                    return Val.constant((Object)false);
                }
                case ALWAYS: {
                    return Val.constant((Object)true);
                }
            }
            return needsVBar;
        });
        shouldDisplayHorizontal.addListener(obs -> Platform.runLater(() -> ((VirtualizedScrollPane)this).requestLayout()));
        shouldDisplayVertical.addListener(obs -> Platform.runLater(() -> ((VirtualizedScrollPane)this).requestLayout()));
        this.hbar.visibleProperty().bind((ObservableValue)shouldDisplayHorizontal);
        this.vbar.visibleProperty().bind((ObservableValue)shouldDisplayVertical);
        this.contentFocusedListener = (obs, ov, nv) -> this.pseudoClassStateChanged(CONTENT_FOCUSED, (boolean)nv);
        content.focusedProperty().addListener(this.contentFocusedListener);
        this.getChildren().addAll((Object[])new Node[]{content, this.hbar, this.vbar});
        this.getChildren().addListener(obs -> this.dispose());
    }

    public VirtualizedScrollPane(@NamedArg(value="content") V content) {
        this(content, ScrollPane.ScrollBarPolicy.AS_NEEDED, ScrollPane.ScrollBarPolicy.AS_NEEDED);
    }

    public V getContent() {
        return this.content;
    }

    public V removeContent() {
        this.getChildren().clear();
        return this.content;
    }

    private void dispose() {
        this.content.focusedProperty().removeListener(this.contentFocusedListener);
        this.hbarValue.removeListener(this.hbarValueListener);
        this.hPosEstimate.removeListener(this.hPosEstimateListener);
        this.vbarValue.removeListener(this.vbarValueListener);
        this.vPosEstimate.removeListener(this.vPosEstimateListener);
        this.unbindScrollBar(this.hbar);
        this.unbindScrollBar(this.vbar);
    }

    private void unbindScrollBar(ScrollBar bar) {
        bar.maxProperty().unbind();
        bar.unitIncrementProperty().unbind();
        bar.blockIncrementProperty().unbind();
        bar.visibleProperty().unbind();
    }

    @Override
    public Val<Double> totalWidthEstimateProperty() {
        return ((Virtualized)this.content).totalWidthEstimateProperty();
    }

    @Override
    public Val<Double> totalHeightEstimateProperty() {
        return ((Virtualized)this.content).totalHeightEstimateProperty();
    }

    @Override
    public Var<Double> estimatedScrollXProperty() {
        return ((Virtualized)this.content).estimatedScrollXProperty();
    }

    @Override
    public Var<Double> estimatedScrollYProperty() {
        return ((Virtualized)this.content).estimatedScrollYProperty();
    }

    @Override
    public void scrollXBy(double deltaX) {
        ((Virtualized)this.content).scrollXBy(deltaX);
    }

    @Override
    public void scrollYBy(double deltaY) {
        ((Virtualized)this.content).scrollYBy(deltaY);
    }

    @Override
    public void scrollXToPixel(double pixel) {
        ((Virtualized)this.content).scrollXToPixel(pixel);
    }

    @Override
    public void scrollYToPixel(double pixel) {
        ((Virtualized)this.content).scrollYToPixel(pixel);
    }

    protected double computePrefWidth(double height) {
        return this.content.prefWidth(height);
    }

    protected double computePrefHeight(double width) {
        return this.content.prefHeight(width);
    }

    protected double computeMinWidth(double height) {
        return this.vbar.minWidth(-1.0);
    }

    protected double computeMinHeight(double width) {
        return this.hbar.minHeight(-1.0);
    }

    protected double computeMaxWidth(double height) {
        return this.content.maxWidth(height);
    }

    protected double computeMaxHeight(double width) {
        return this.content.maxHeight(width);
    }

    protected void layoutChildren() {
        double layoutWidth = this.snapSizeX(this.getLayoutBounds().getWidth());
        double layoutHeight = this.snapSizeY(this.getLayoutBounds().getHeight());
        boolean vbarVisible = this.vbar.isVisible();
        boolean hbarVisible = this.hbar.isVisible();
        double vbarWidth = this.snapSizeX(vbarVisible ? this.vbar.prefWidth(-1.0) : 0.0);
        double hbarHeight = this.snapSizeY(hbarVisible ? this.hbar.prefHeight(-1.0) : 0.0);
        double w = layoutWidth - vbarWidth;
        double h = layoutHeight - hbarHeight;
        this.content.resize(w, h);
        this.hbar.setVisibleAmount(w);
        this.vbar.setVisibleAmount(h);
        if (vbarVisible) {
            this.vbar.resizeRelocate(layoutWidth - vbarWidth, 0.0, vbarWidth, h);
        }
        if (hbarVisible) {
            this.hbar.resizeRelocate(0.0, layoutHeight - hbarHeight, w, hbarHeight);
        }
    }

    private void setHPosition(double pos) {
        double offset = VirtualizedScrollPane.scrollbarPositionToOffset(pos, this.content.getLayoutBounds().getWidth(), (Double)((Virtualized)this.content).totalWidthEstimateProperty().getValue());
        ((Virtualized)this.content).estimatedScrollXProperty().setValue((Object)Math.round(offset));
    }

    private void setVPosition(double pos) {
        double offset = VirtualizedScrollPane.scrollbarPositionToOffset(pos, this.content.getLayoutBounds().getHeight(), (Double)((Virtualized)this.content).totalHeightEstimateProperty().getValue());
        ((Virtualized)this.content).estimatedScrollYProperty().setValue((Object)Math.round(offset));
    }

    private static void setupUnitIncrement(final ScrollBar bar) {
        bar.unitIncrementProperty().bind((ObservableValue)new DoubleBinding(){
            {
                this.bind(new Observable[]{bar.maxProperty(), bar.visibleAmountProperty()});
            }

            protected double computeValue() {
                double visible;
                double max = bar.getMax();
                return max > (visible = bar.getVisibleAmount()) ? 16.0 / (max - visible) * max : 0.0;
            }
        });
    }

    private static double offsetToScrollbarPosition(double contentOffset, double viewportSize, double contentSize) {
        return contentSize > viewportSize ? contentOffset / (contentSize - viewportSize) * contentSize : 0.0;
    }

    private static double scrollbarPositionToOffset(double scrollbarPos, double viewportSize, double contentSize) {
        return contentSize > viewportSize ? scrollbarPos / contentSize * (contentSize - viewportSize) : 0.0;
    }
}

