/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.server.interpreter;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.Charset;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.LinearSeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import sttp.model.ContentTypeRange;
import sttp.model.HasHeaders;
import sttp.model.Header;
import sttp.model.Header$;
import sttp.model.HeaderNames$;
import sttp.model.MediaType;
import sttp.model.MediaType$;
import sttp.model.StatusCode;
import sttp.tapir.Codec;
import sttp.tapir.CodecFormat;
import sttp.tapir.EndpointIO;
import sttp.tapir.EndpointOutput;
import sttp.tapir.EndpointTransput;
import sttp.tapir.Mapping;
import sttp.tapir.RawBodyType;
import sttp.tapir.StreamBodyIO;
import sttp.tapir.WebSocketBodyOutput;
import sttp.tapir.internal.package;
import sttp.tapir.server.interpreter.OutputValues;
import sttp.tapir.server.interpreter.ToResponseBody;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005c\u0001\u0002\u0005\n\u0001IA\u0001B\u0007\u0001\u0003\u0002\u0003\u0006Ia\u0007\u0005\t[\u0001\u0011\t\u0011)A\u0005]!)A\b\u0001C\u0001{!)\u0011\t\u0001C\u0001\u0005\")a\r\u0001C\u0005O\")a\u0010\u0001C\u0005\u007f\"9\u0011Q\u0004\u0001\u0005\n\u0005}!!D#oG>$WmT;uaV$8O\u0003\u0002\u000b\u0017\u0005Y\u0011N\u001c;feB\u0014X\r^3s\u0015\taQ\"\u0001\u0004tKJ4XM\u001d\u0006\u0003\u001d=\tQ\u0001^1qSJT\u0011\u0001E\u0001\u0005gR$\bo\u0001\u0001\u0016\u0007M\t3f\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\t1\u0011I\\=SK\u001a\f\u0011C]1x)>\u0014Vm\u001d9p]N,'i\u001c3z!\u0011aRd\b\u0016\u000e\u0003%I!AH\u0005\u0003\u001dQ{'+Z:q_:\u001cXMQ8esB\u0011\u0001%\t\u0007\u0001\t\u0015\u0011\u0003A1\u0001$\u0005\u0005\u0011\u0015C\u0001\u0013(!\t)R%\u0003\u0002'-\t9aj\u001c;iS:<\u0007CA\u000b)\u0013\tIcCA\u0002B]f\u0004\"\u0001I\u0016\u0005\u000b1\u0002!\u0019A\u0012\u0003\u0003M\u000b1#Y2dKB$8oQ8oi\u0016tG\u000fV=qKN\u00042a\f\u001b7\u001b\u0005\u0001$BA\u00193\u0003%IW.\\;uC\ndWM\u0003\u00024-\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005U\u0002$aA*fcB\u0011qGO\u0007\u0002q)\u0011\u0011hD\u0001\u0006[>$W\r\\\u0005\u0003wa\u0012\u0001cQ8oi\u0016tG\u000fV=qKJ\u000bgnZ3\u0002\rqJg.\u001b;?)\rqt\b\u0011\t\u00059\u0001y\"\u0006C\u0003\u001b\u0007\u0001\u00071\u0004C\u0003.\u0007\u0001\u0007a&A\u0003baBd\u0017\u0010\u0006\u0003D\rB#\u0007c\u0001\u000fE?%\u0011Q)\u0003\u0002\r\u001fV$\b/\u001e;WC2,Xm\u001d\u0005\u0006\u000f\u0012\u0001\r\u0001S\u0001\u0007_V$\b/\u001e;1\u0005%s\u0005c\u0001&L\u001b6\tQ\"\u0003\u0002M\u001b\tqQI\u001c3q_&tGoT;uaV$\bC\u0001\u0011O\t%ye)!A\u0001\u0002\u000b\u00051EA\u0002`IEBQ!\u0015\u0003A\u0002I\u000bQA^1mk\u0016\u0004\"aU1\u000f\u0005QsfBA+]\u001d\t16L\u0004\u0002X56\t\u0001L\u0003\u0002Z#\u00051AH]8pizJ\u0011\u0001E\u0005\u0003\u001d=I!!X\u0007\u0002\u0011%tG/\u001a:oC2L!a\u00181\u0002\u000fA\f7m[1hK*\u0011Q,D\u0005\u0003E\u000e\u0014a\u0001U1sC6\u001c(BA0a\u0011\u0015)G\u00011\u0001D\u0003\tyg/A\u0005baBd\u0017\u0010U1jeR11\t[8wwvDQ![\u0003A\u0002)\fA\u0001\\3giB\u00121.\u001c\t\u0004\u0015.c\u0007C\u0001\u0011n\t%q\u0007.!A\u0001\u0002\u000b\u00051EA\u0002`IIBQ\u0001]\u0003A\u0002E\fQA]5hQR\u0004$A\u001d;\u0011\u0007)[5\u000f\u0005\u0002!i\u0012IQo\\A\u0001\u0002\u0003\u0015\ta\t\u0002\u0004?\u0012\u001a\u0004\"B<\u0006\u0001\u0004A\u0018!B:qY&$\bCA*z\u0013\tQ8MA\u0006Ta2LG\u000fU1sC6\u001c\b\"\u0002?\u0006\u0001\u0004\u0011\u0016A\u00029be\u0006l7\u000fC\u0003f\u000b\u0001\u00071)A\u0006baBd\u0017pU5oO2,GcB\"\u0002\u0002\u0005e\u00111\u0004\u0005\u0007\u000f\u001a\u0001\r!a\u00011\t\u0005\u0015\u0011Q\u0003\t\u0007\u0003\u000f\ti!a\u0005\u000f\u0007)\u000bI!C\u0002\u0002\f5\ta\"\u00128ea>Lg\u000e^(viB,H/\u0003\u0003\u0002\u0010\u0005E!AB*j]\u001edWMC\u0002\u0002\f5\u00012\u0001IA\u000b\t-\t9\"!\u0001\u0002\u0002\u0003\u0005)\u0011A\u0012\u0003\u0007}#C\u0007C\u0003R\r\u0001\u0007!\u000bC\u0003f\r\u0001\u00071)\u0001\ndQ>|7/Z(oK>3g+\u0019:jC:$H\u0003BA\u0011\u0003c\u0001D!a\t\u0002.A1\u0011QEA\u0014\u0003Wq1!VA\u0005\u0013\u0011\tI#!\u0005\u0003\u0019=sWm\u00144WCJL\u0017M\u001c;\u0011\u0007\u0001\ni\u0003\u0002\u0006\u00020\u001d\t\t\u0011!A\u0003\u0002\r\u0012Aa\u0018\u00132c!9\u00111G\u0004A\u0002\u0005U\u0012\u0001C7baBLgnZ:\u0011\t=\"\u0014q\u0007\u0019\u0005\u0003s\ti\u0004\u0005\u0004\u0002&\u0005\u001d\u00121\b\t\u0004A\u0005uBaCA \u0003c\t\t\u0011!A\u0003\u0002\r\u0012Aa\u0018\u00132a\u0001")
public class EncodeOutputs<B, S> {
    private final ToResponseBody<B, S> rawToResponseBody;
    private final Seq<ContentTypeRange> acceptsContentTypes;

    public OutputValues<B> apply(EndpointOutput<?> output, package.Params value, OutputValues<B> ov) {
        OutputValues<B> outputValues;
        EndpointOutput<?> endpointOutput = output;
        if (endpointOutput instanceof EndpointIO.Single) {
            EndpointIO.Single single = (EndpointIO.Single)endpointOutput;
            outputValues = this.applySingle(single, value, ov);
        } else if (endpointOutput instanceof EndpointOutput.Single) {
            EndpointOutput.Single single = (EndpointOutput.Single)endpointOutput;
            outputValues = this.applySingle(single, value, ov);
        } else if (endpointOutput instanceof EndpointIO.Pair) {
            EndpointIO.Pair pair = (EndpointIO.Pair)endpointOutput;
            EndpointTransput left = pair.left();
            EndpointTransput right = pair.right();
            Function1<package.Params, Tuple2<package.Params, package.Params>> split = pair.split$access$3();
            outputValues = this.applyPair((EndpointOutput<?>)left, (EndpointOutput<?>)right, split, value, ov);
        } else if (endpointOutput instanceof EndpointOutput.Pair) {
            EndpointOutput.Pair pair = (EndpointOutput.Pair)endpointOutput;
            EndpointTransput left = pair.left();
            EndpointTransput right = pair.right();
            Function1<package.Params, Tuple2<package.Params, package.Params>> split = pair.split$access$3();
            outputValues = this.applyPair((EndpointOutput<?>)left, (EndpointOutput<?>)right, split, value, ov);
        } else {
            if (endpointOutput instanceof EndpointOutput.Void) {
                throw new IllegalArgumentException("Cannot encode a void output!");
            }
            throw new MatchError(endpointOutput);
        }
        return outputValues;
    }

    private OutputValues<B> applyPair(EndpointOutput<?> left, EndpointOutput<?> right, Function1<package.Params, Tuple2<package.Params, package.Params>> split, package.Params params2, OutputValues<B> ov) {
        Tuple2 tuple2 = (Tuple2)split.apply((Object)params2);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        package.Params leftParams = (package.Params)tuple2._1();
        package.Params rightParams = (package.Params)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)leftParams, (Object)rightParams);
        Tuple2 tuple23 = tuple22;
        package.Params leftParams2 = (package.Params)tuple23._1();
        package.Params rightParams2 = (package.Params)tuple23._2();
        return this.apply(right, rightParams2, this.apply(left, leftParams2, ov));
    }

    private OutputValues<B> applySingle(EndpointOutput.Single<?> output, package.Params value, OutputValues<B> ov) {
        EndpointIO.StreamBodyWrapper streamBodyWrapper;
        StreamBodyIO streamBodyIO;
        OutputValues<B> outputValues;
        EndpointOutput.Single<?> single = output;
        if (single instanceof EndpointIO.Empty) {
            outputValues = ov;
        } else if (single instanceof EndpointOutput.FixedStatusCode) {
            EndpointOutput.FixedStatusCode fixedStatusCode = (EndpointOutput.FixedStatusCode)single;
            int sc = fixedStatusCode.statusCode();
            outputValues = ov.withStatusCode(sc);
        } else if (single instanceof EndpointIO.FixedHeader) {
            EndpointIO.FixedHeader fixedHeader = (EndpointIO.FixedHeader)single;
            Header header2 = fixedHeader.h();
            outputValues = ov.withHeader(header2.name(), header2.value());
        } else if (single instanceof EndpointIO.Body) {
            EndpointIO.Body body2 = (EndpointIO.Body)single;
            RawBodyType rawBodyType = body2.bodyType();
            Codec codec = body2.codec();
            Option<Charset> maybeCharset = codec.format().mediaType().mainType().equalsIgnoreCase("text") ? sttp.tapir.internal.package$.MODULE$.charset(rawBodyType) : None$.MODULE$;
            outputValues = ov.withBody((Function1 & Serializable)headers2 -> $this.rawToResponseBody.fromRawValue(EncodeOutputs.encodedC$1(codec, value), (HasHeaders)headers2, (CodecFormat)codec.format(), rawBodyType)).withDefaultContentType(codec.format(), maybeCharset);
        } else if (single instanceof EndpointIO.StreamBodyWrapper && (streamBodyIO = (streamBodyWrapper = (EndpointIO.StreamBodyWrapper)single).wrapped()) instanceof StreamBodyIO) {
            StreamBodyIO streamBodyIO2 = streamBodyIO;
            Codec codec = streamBodyIO2.codec();
            Option<Charset> charset = streamBodyIO2.charset();
            outputValues = ov.withBody((Function1 & Serializable)headers2 -> $this.rawToResponseBody.fromStreamValue(EncodeOutputs.encodedC$1(codec, value), (HasHeaders)headers2, (CodecFormat)codec.format(), charset)).withDefaultContentType(codec.format(), charset).withHeaderTransformation((Function1<Vector<Header>, Vector<Header>>)(Function1 & Serializable)hs -> hs.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.is(HeaderNames$.MODULE$.ContentLength()))) ? hs : (Vector)hs.$colon$plus((Object)Header$.MODULE$.apply(HeaderNames$.MODULE$.TransferEncoding(), "chunked")));
        } else if (single instanceof EndpointIO.Header) {
            EndpointIO.Header header3 = (EndpointIO.Header)single;
            String name = header3.name();
            Codec codec = header3.codec();
            outputValues = (OutputValues<B>)((LinearSeqOps)EncodeOutputs.encodedC$1(codec, value)).foldLeft(ov, (Function2 & Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                OutputValues ovv = (OutputValues)tuple2._1();
                String headerValue = (String)tuple2._2();
                OutputValues outputValues = ovv.withHeader(name, headerValue);
                return outputValues;
            });
        } else if (single instanceof EndpointIO.Headers) {
            EndpointIO.Headers headers3 = (EndpointIO.Headers)single;
            Codec codec = headers3.codec();
            outputValues = (OutputValues)((LinearSeqOps)EncodeOutputs.encodedC$1(codec, value)).foldLeft(ov, (Function2 & Serializable)(ov2, h) -> ov2.withHeader(h.name(), h.value()));
        } else if (single instanceof EndpointIO.MappedPair) {
            EndpointIO.MappedPair mappedPair = (EndpointIO.MappedPair)single;
            EndpointIO.Pair wrapped = mappedPair.io();
            Mapping mapping = mappedPair.mapping();
            outputValues = this.apply(wrapped, new package.ParamsAsAny(EncodeOutputs.encodedM$1(mapping, value)), ov);
        } else if (single instanceof EndpointOutput.StatusCode) {
            EndpointOutput.StatusCode statusCode2 = (EndpointOutput.StatusCode)single;
            Codec codec = statusCode2.codec();
            outputValues = ov.withStatusCode(((StatusCode)EncodeOutputs.encodedC$1(codec, value)).code());
        } else if (single instanceof EndpointOutput.WebSocketBodyWrapper) {
            EndpointOutput.WebSocketBodyWrapper webSocketBodyWrapper = (EndpointOutput.WebSocketBodyWrapper)single;
            WebSocketBodyOutput o = webSocketBodyWrapper.wrapped();
            outputValues = ov.withBody((Function1 & Serializable)x$3 -> $this.rawToResponseBody.fromWebSocketPipe(EncodeOutputs.encodedC$1(o.codec(), value), o));
        } else if (single instanceof EndpointOutput.OneOf) {
            EndpointOutput.OneOf oneOf = (EndpointOutput.OneOf)single;
            List mappings = oneOf.variants();
            Mapping mapping = oneOf.mapping();
            Object enc = EncodeOutputs.encodedM$1(mapping, value);
            List applicableMappings = mappings.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)EncodeOutputs.$anonfun$applySingle$8(enc, x$4)));
            Predef$.MODULE$.require(applicableMappings.nonEmpty(), (Function0 & Serializable)() -> new StringBuilder(40).append("OneOf output without applicable mapping ").append(oneOf.show()).toString());
            EndpointOutput.OneOfVariant<?> chosenVariant = this.chooseOneOfVariant((Seq<EndpointOutput.OneOfVariant<?>>)applicableMappings);
            outputValues = this.apply(chosenVariant.output(), new package.ParamsAsAny(enc), ov);
        } else if (single instanceof EndpointOutput.MappedPair) {
            EndpointOutput.MappedPair mappedPair = (EndpointOutput.MappedPair)single;
            EndpointOutput.Pair wrapped = mappedPair.output();
            Mapping mapping = mappedPair.mapping();
            outputValues = this.apply(wrapped, new package.ParamsAsAny(EncodeOutputs.encodedM$1(mapping, value)), ov);
        } else {
            throw new MatchError(single);
        }
        return outputValues;
    }

    private EndpointOutput.OneOfVariant<?> chooseOneOfVariant(Seq<EndpointOutput.OneOfVariant<?>> mappings) {
        EndpointOutput.OneOfVariant oneOfVariant;
        Seq bodyMappings = (Seq)mappings.flatMap((Function1 & Serializable)om -> sttp.tapir.internal.package$.MODULE$.RichEndpointOutput(om.output()).traverseOutputs(new Serializable(null, (EndpointOutput.OneOfVariant)om){
            private static final long serialVersionUID = 0L;
            private final EndpointOutput.OneOfVariant om$1;

            public final <A1 extends EndpointOutput<?>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                EndpointIO.StreamBodyWrapper streamBodyWrapper;
                StreamBodyIO<BS, T, ?> streamBodyIO;
                Object object;
                A1 A1 = x1;
                if (A1 instanceof EndpointIO.Body) {
                    EndpointIO.Body body2 = (EndpointIO.Body)A1;
                    RawBodyType<R> bodyType2 = body2.bodyType();
                    Codec<R, T, CodecFormat> codec = body2.codec();
                    Tuple2[] tuple2Array = new Tuple2[1];
                    MediaType qual$1 = codec.format().mediaType();
                    Option x$1 = sttp.tapir.internal.package$.MODULE$.charset(bodyType2).map((Function1 & Serializable)x$5 -> x$5.name());
                    String x$2 = qual$1.copy$default$1();
                    String x$3 = qual$1.copy$default$2();
                    Map x$4 = qual$1.copy$default$4();
                    tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)qual$1.copy(x$2, x$3, x$1, x$4)), (Object)this.om$1);
                    object = package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])tuple2Array));
                } else if (A1 instanceof EndpointIO.StreamBodyWrapper && (streamBodyIO = (streamBodyWrapper = (EndpointIO.StreamBodyWrapper)A1).wrapped()) instanceof StreamBodyIO) {
                    StreamBodyIO<BS, T, ?> streamBodyIO2 = streamBodyIO;
                    Codec<BS, T, CodecFormat> codec = streamBodyIO2.codec();
                    Option<Charset> charset = streamBodyIO2.charset();
                    Tuple2[] tuple2Array = new Tuple2[1];
                    MediaType qual$2 = codec.format().mediaType();
                    Option x$52 = charset.map((Function1 & Serializable)x$6 -> x$6.name());
                    String x$62 = qual$2.copy$default$1();
                    String x$7 = qual$2.copy$default$2();
                    Map x$8 = qual$2.copy$default$4();
                    tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)qual$2.copy(x$62, x$7, x$52, x$8)), (Object)this.om$1);
                    object = package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])tuple2Array));
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(EndpointOutput<?> x1) {
                EndpointIO.StreamBodyWrapper streamBodyWrapper;
                StreamBodyIO<BS, T, ?> streamBodyIO;
                EndpointOutput<?> endpointOutput = x1;
                boolean bl = endpointOutput instanceof EndpointIO.Body ? true : endpointOutput instanceof EndpointIO.StreamBodyWrapper && (streamBodyIO = (streamBodyWrapper = (EndpointIO.StreamBodyWrapper)endpointOutput).wrapped()) instanceof StreamBodyIO;
                return bl;
            }
            {
                this.om$1 = om$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(java.nio.charset.Charset ), $anonfun$applyOrElse$2(java.nio.charset.Charset )}, serializedLambda);
            }
        }));
        if (bodyMappings.nonEmpty()) {
            Seq mediaTypes = (Seq)bodyMappings.map((Function1 & Serializable)x$7 -> (MediaType)x$7._1());
            oneOfVariant = (EndpointOutput.OneOfVariant)MediaType$.MODULE$.bestMatch(mediaTypes, this.acceptsContentTypes).flatMap((Function1 & Serializable)mt -> bodyMappings.find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)EncodeOutputs.$anonfun$chooseOneOfVariant$4(mt, x$8))).map((Function1 & Serializable)x$9 -> (EndpointOutput.OneOfVariant)x$9._2())).getOrElse((Function0 & Serializable)() -> (EndpointOutput.OneOfVariant)mappings.head());
        } else {
            oneOfVariant = (EndpointOutput.OneOfVariant)mappings.head();
        }
        return oneOfVariant;
    }

    private static final Object encodedC$1(Codec codec, package.Params value$1) {
        return codec.encode(value$1.asAny());
    }

    private static final Object encodedM$1(Mapping mapping, package.Params value$1) {
        return mapping.encode(value$1.asAny());
    }

    public static final /* synthetic */ boolean $anonfun$applySingle$8(Object enc$1, EndpointOutput.OneOfVariant x$4) {
        return BoxesRunTime.unboxToBoolean((Object)x$4.appliesTo().apply(enc$1));
    }

    public static final /* synthetic */ boolean $anonfun$chooseOneOfVariant$4(MediaType mt$1, Tuple2 x$8) {
        Object object = x$8._1();
        MediaType mediaType = mt$1;
        return !(object != null ? !object.equals(mediaType) : mediaType != null);
    }

    public EncodeOutputs(ToResponseBody<B, S> rawToResponseBody, Seq<ContentTypeRange> acceptsContentTypes) {
        this.rawToResponseBody = rawToResponseBody;
        this.acceptsContentTypes = acceptsContentTypes;
    }
}

