/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.utils;

import java.util.Objects;
import java.util.function.Predicate;

public final class FormatOptions {
    private static final String ESCAPE = "`";
    private final Predicate<String> addQuotesPredicate;

    public static FormatOptions none() {
        return new FormatOptions(word -> true);
    }

    public static FormatOptions noEscape() {
        return new FormatOptions(word -> false);
    }

    public static FormatOptions of(Predicate<String> addQuotesPredicate) {
        return new FormatOptions(addQuotesPredicate);
    }

    private FormatOptions(Predicate<String> fieldNameEscaper) {
        this.addQuotesPredicate = Objects.requireNonNull(fieldNameEscaper, "addQuotesPredicate");
    }

    private boolean shouldQuote(String word) {
        return this.addQuotesPredicate.test(word);
    }

    public String escape(String word) {
        return this.shouldQuote(word) ? ESCAPE + word + ESCAPE : word;
    }
}

