/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql.types;

import com.google.common.annotations.VisibleForTesting;
import com.google.errorprone.annotations.Immutable;
import java.util.Objects;

@Immutable
public class SqlLambda {
    private final int numInputs;

    public static SqlLambda of(Integer numInputs) {
        return new SqlLambda(numInputs);
    }

    @VisibleForTesting
    SqlLambda(Integer numInputs) {
        this.numInputs = numInputs;
    }

    public Integer getNumInputs() {
        return this.numInputs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlLambda lambda = (SqlLambda)o;
        return this.numInputs == lambda.numInputs;
    }

    public int hashCode() {
        return Objects.hash(this.numInputs);
    }

    public String toString() {
        return "LAMBDA";
    }
}

