/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.util;

import java.awt.Color;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.regex.Pattern;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class Strings$ {
    public static final Strings$ MODULE$;
    private static final Regex QueryParam;
    private static final Regex AtPeriod;
    private static final Regex IsoPeriod;
    private static final Regex IsoDate;
    private static final Regex IsoDateTime;
    private static final Regex IsoOffsetDateTime;
    private static final Regex RelativeDate;
    private static final Regex NamedDate;
    private static final Regex UnixDate;
    private static final Map<Class<?>, Function1<String, Object>> conversions;
    private static final String[] uriEscapes;
    private static final boolean[] allowedInVarName;
    private static final String[] byteHexStrings;

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void var0;
        MODULE$ = new Strings$();
        QueryParam = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^([^=]+)=(.*)$"));
        AtPeriod = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(\\d+)([a-z]+)$"));
        IsoPeriod = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(P.*)$"));
        IsoDate = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(\\d{4}-\\d{2}-\\d{2}(?:[-+Z].*)?)$"));
        IsoDateTime = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}(?::\\d{2}(?:\\.\\d{3})?)?Z?)$"));
        IsoOffsetDateTime = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}(?::\\d{2}(?:\\.\\d{3})?)?[-+].*)$"));
        RelativeDate = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^([a-z]+)([\\-+])(.+)$"));
        NamedDate = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^([a-z]+)$"));
        UnixDate = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^([0-9]+)$"));
        conversions = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(String.class), (Function1 & Serializable)v -> v), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Boolean.TYPE), (Function1 & Serializable)v -> Boolean.valueOf(v)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Byte.TYPE), (Function1 & Serializable)v -> Byte.valueOf(v)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Short.TYPE), (Function1 & Serializable)v -> Short.valueOf(v)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Integer.TYPE), (Function1 & Serializable)v -> Integer.valueOf(v)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Long.TYPE), (Function1 & Serializable)v -> Long.valueOf(v)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Float.TYPE), (Function1 & Serializable)v -> Float.valueOf(v)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Double.TYPE), (Function1 & Serializable)v -> Double.valueOf(v)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Number.class), (Function1 & Serializable)v -> Double.valueOf(v)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Boolean.class), (Function1 & Serializable)v -> Boolean.valueOf(v)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Byte.class), (Function1 & Serializable)v -> Byte.valueOf(v)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Short.class), (Function1 & Serializable)v -> Short.valueOf(v)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Integer.class), (Function1 & Serializable)v -> Integer.valueOf(v)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Long.class), (Function1 & Serializable)v -> Long.valueOf(v)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Float.class), (Function1 & Serializable)v -> Float.valueOf(v)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Double.class), (Function1 & Serializable)v -> Double.valueOf(v)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ZonedDateTime.class), (Function1 & Serializable)v -> MODULE$.parseDate((String)v, MODULE$.parseDate$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ZoneId.class), (Function1 & Serializable)v -> ZoneId.of(v)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Duration.class), (Function1 & Serializable)v -> MODULE$.parseDuration((String)v)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Pattern.class), (Function1 & Serializable)v -> Pattern.compile(v)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Color.class), (Function1 & Serializable)v -> MODULE$.parseColor((String)v))}));
        String[] array = new String[128];
        for (int pos = 0; pos < array.length; ++pos) {
            char c2 = (char)pos;
            array[pos] = Character.isISOControl(c2) ? Strings$.hex$1(c2) : ((Object)BoxesRunTime.boxToCharacter((char)c2)).toString();
        }
        array[32] = Strings$.hex$1(' ');
        array[43] = Strings$.hex$1('+');
        array[35] = Strings$.hex$1('#');
        array[34] = Strings$.hex$1('\"');
        array[37] = Strings$.hex$1('%');
        array[38] = Strings$.hex$1('&');
        array[59] = Strings$.hex$1(';');
        array[60] = Strings$.hex$1('<');
        array[61] = Strings$.hex$1('=');
        array[62] = Strings$.hex$1('>');
        array[63] = Strings$.hex$1('?');
        array[91] = Strings$.hex$1('[');
        array[92] = Strings$.hex$1('\\');
        array[93] = Strings$.hex$1(']');
        array[94] = Strings$.hex$1('^');
        array[123] = Strings$.hex$1('{');
        array[124] = Strings$.hex$1('|');
        array[125] = Strings$.hex$1('}');
        uriEscapes = var0;
        boolean[] alphabet = new boolean[128];
        alphabet[46] = true;
        alphabet[45] = true;
        alphabet[95] = true;
        new RichChar(Predef$.MODULE$.charWrapper('a')).to((Object)BoxesRunTime.boxToCharacter((char)'z')).foreach$mVc$sp((Function1 & Serializable)c -> {
            alphabet[BoxesRunTime.unboxToChar((Object)c)] = true;
            return BoxedUnit.UNIT;
        });
        new RichChar(Predef$.MODULE$.charWrapper('A')).to((Object)BoxesRunTime.boxToCharacter((char)'Z')).foreach$mVc$sp((Function1 & Serializable)c -> {
            alphabet[BoxesRunTime.unboxToChar((Object)c)] = true;
            return BoxedUnit.UNIT;
        });
        new RichChar(Predef$.MODULE$.charWrapper('0')).to((Object)BoxesRunTime.boxToCharacter((char)'9')).foreach$mVc$sp((Function1 & Serializable)c -> {
            alphabet[BoxesRunTime.unboxToChar((Object)c)] = true;
            return BoxedUnit.UNIT;
        });
        allowedInVarName = var3_3;
        byteHexStrings = (String[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 256).map((Function1 & Serializable)i -> Strings$.MODULE$.zeroPad(Integer.toHexString(BoxesRunTime.unboxToInt((Object)i)), 2)).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    private Regex QueryParam() {
        return QueryParam;
    }

    private Regex AtPeriod() {
        return AtPeriod;
    }

    private Regex IsoPeriod() {
        return IsoPeriod;
    }

    private Regex IsoDate() {
        return IsoDate;
    }

    private Regex IsoDateTime() {
        return IsoDateTime;
    }

    private Regex IsoOffsetDateTime() {
        return IsoOffsetDateTime;
    }

    private Regex RelativeDate() {
        return RelativeDate;
    }

    private Regex NamedDate() {
        return NamedDate;
    }

    private Regex UnixDate() {
        return UnixDate;
    }

    public Map<Class<?>, Function1<String, Object>> conversions() {
        return conversions;
    }

    public boolean conversionExists(Class<?> c) {
        return this.conversions().contains(c);
    }

    private <T extends Enum<T>> T enumValueOf(Class<?> c, String v) {
        return (T)Enum.valueOf(c, v);
    }

    public <T> T cast(Class<?> c, String v) {
        Object object;
        if (c.isEnum()) {
            object = this.enumValueOf(c, v);
        } else {
            Option option = this.conversions().get(c);
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalArgumentException(new java.lang.StringBuilder(43).append("unsupported property type ").append(c.getName()).append(", must be one of ").append(this.conversions().keys().mkString(", ")).toString());
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            Function1 f = (Function1)some.value();
            Object object2 = f.apply((Object)v);
            object = object2;
        }
        return object;
    }

    private String[] uriEscapes() {
        return uriEscapes;
    }

    public String urlEncode(String s) {
        StringBuilder buf = new StringBuilder();
        int size = s.length();
        for (int pos = 0; pos < size; ++pos) {
            char c = s.charAt(pos);
            StringBuilder stringBuilder = c < '\u0080' ? buf.append(this.uriEscapes()[c]) : buf.append(URLEncoder.encode(((Object)BoxesRunTime.boxToCharacter((char)c)).toString(), "UTF-8"));
        }
        return buf.toString();
    }

    public String urlDecode(String s) {
        return this.hexDecode(s, this.hexDecode$default$2());
    }

    public String hexDecode(String input, char escapeChar) {
        StringBuilder buf = new StringBuilder();
        int size = input.length();
        for (int pos = 0; pos < size; ++pos) {
            StringBuilder stringBuilder;
            char c = input.charAt(pos);
            if (c == escapeChar) {
                if (size - pos <= 2) {
                    buf.append(input.substring(pos));
                    pos = size;
                    stringBuilder = BoxedUnit.UNIT;
                    continue;
                }
                int c1 = this.hexValue(input.charAt(pos + 1));
                int c2 = this.hexValue(input.charAt(pos + 2));
                if (c1 >= 0 && c2 >= 0) {
                    char nc = (char)(c1 << 4 | c2);
                    buf.append(nc);
                    pos += 2;
                    stringBuilder = BoxedUnit.UNIT;
                    continue;
                }
                stringBuilder = buf.append(c);
                continue;
            }
            stringBuilder = buf.append(c);
        }
        return buf.toString();
    }

    public char hexDecode$default$2() {
        return '%';
    }

    private int hexValue(char c) {
        char c2 = c;
        switch (c2) {
            default: 
        }
        return c2 >= '0' && c2 <= '9' ? c2 - 48 : (c2 >= 'A' && c2 <= 'F' ? c2 - 65 + 10 : (c2 >= 'a' && c2 <= 'f' ? c2 - 97 + 10 : -1));
    }

    private Map<String, List<String>> add(Map<String, List<String>> acc, String k, String v) {
        String dv;
        String dk = this.urlDecode(k);
        String string = dv = this.urlDecode(v);
        return (Map)acc.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)dk), (Object)((List)acc.getOrElse((Object)dk, (Function0 & Serializable)() -> Nil$.MODULE$)).$colon$colon((Object)string)));
    }

    public Map<String, List<String>> parseQueryString(String query) {
        Map map;
        if (query == null) {
            map = Predef$.MODULE$.Map().empty();
        } else {
            Map params = Predef$.MODULE$.Map().empty();
            map = (Map)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])query.split("[&;]+")), (Object)params, (Function2 & Serializable)(acc, p) -> {
                Map<String, List<String>> map;
                Option option;
                String string = p;
                if (string != null && !(option = MODULE$.QueryParam().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(2) == 0) {
                    String k = (String)((LinearSeqOps)option.get()).apply(0);
                    String v = (String)((LinearSeqOps)option.get()).apply(1);
                    map = MODULE$.add((Map<String, List<String>>)acc, k, v);
                } else {
                    map = MODULE$.add((Map<String, List<String>>)acc, string, "1");
                }
                return map;
            });
        }
        return map;
    }

    private boolean[] allowedInVarName() {
        return allowedInVarName;
    }

    private int simpleVar(String str, int i, StringBuilder key) {
        int j;
        for (j = i; j < str.length(); ++j) {
            char c = str.charAt(j);
            if (c >= this.allowedInVarName().length || !this.allowedInVarName()[c]) {
                return j;
            }
            key.append(c);
        }
        return j;
    }

    private int parenVar(String str, int i, StringBuilder key) {
        for (int j = i; j < str.length(); ++j) {
            char c = str.charAt(j);
            if (c == ')') {
                return j + 1;
            }
            key.append(c);
        }
        key.clear();
        return i;
    }

    private int getKey(String str, int i, StringBuilder key) {
        char c = str.charAt(i + 1);
        return c == '(' ? this.parenVar(str, i + 2, key) : this.simpleVar(str, i + 1, key);
    }

    public String substitute(String str, Map<String, String> vars) {
        return this.substitute(str, (Function1<String, String>)(Function1 & Serializable)k -> (String)vars.getOrElse(k, (Function0 & Serializable)() -> k));
    }

    public String substitute(String str, Function1<String, String> vars) {
        StringBuilder key = new StringBuilder(str.length());
        StringBuilder buf = new StringBuilder(str.length() * 2);
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c != '$') {
                buf.append(c);
                ++i;
                continue;
            }
            i = this.getKey(str, i, key);
            String k = key.toString();
            Object object = !k.isEmpty() ? buf.append((String)vars.apply((Object)k)) : BoxedUnit.UNIT;
            key.clear();
        }
        return buf.toString();
    }

    public boolean isRelativeDate(String str) {
        return this.isRelativeDate(str, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRelativeDate(String str, boolean customRef) {
        String string = str;
        if (string == null) return false;
        Option option = this.RelativeDate().unapplySeq((CharSequence)string);
        if (option.isEmpty()) return false;
        if (option.get() == null) return false;
        if (((List)option.get()).lengthCompare(3) != 0) return false;
        String r = (String)((LinearSeqOps)option.get()).apply(0);
        if (!customRef) return true;
        String string2 = r;
        String string3 = "now";
        if (string2 == null) {
            if (string3 == null) return false;
        } else if (string2.equals(string3)) return false;
        String string4 = r;
        String string5 = "epoch";
        if (string4 == null) {
            if (string5 == null) return false;
            return true;
        } else if (string4.equals(string5)) return false;
        return true;
    }

    public Option<String> extractReferencePointDate(String str) {
        Option option;
        None$ none$;
        Option option2;
        String string = str;
        if (string != null && !(option2 = this.RelativeDate().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(3) == 0) {
            String r = (String)((LinearSeqOps)option2.get()).apply(0);
            none$ = new Some((Object)r);
        } else if (string != null && !(option = this.NamedDate().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
            String r = (String)((LinearSeqOps)option.get()).apply(0);
            none$ = new Some((Object)r);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public ZonedDateTime parseDate(String str, ZoneId tz) {
        return this.parseDate(ZonedDateTime.now(tz), str, tz);
    }

    public ZonedDateTime parseDate(ZonedDateTime ref, String str, ZoneId tz) {
        Option option;
        Option option2;
        Option option3;
        Option option4;
        Option option5;
        ZonedDateTime zonedDateTime;
        Option option6;
        String string = str;
        if (string != null && !(option6 = this.IsoDate().unapplySeq((CharSequence)string)).isEmpty() && option6.get() != null && ((List)option6.get()).lengthCompare(1) == 0) {
            LocalDate date = LocalDate.parse(str, DateTimeFormatter.ISO_DATE.withZone(tz));
            zonedDateTime = ZonedDateTime.of(date, LocalTime.MIN, tz);
        } else if (string != null && !(option5 = this.IsoDateTime().unapplySeq((CharSequence)string)).isEmpty() && option5.get() != null && ((List)option5.get()).lengthCompare(1) == 0) {
            ZoneId z = str.endsWith("Z") ? ZoneOffset.UTC : tz;
            zonedDateTime = ZonedDateTime.parse(str, DateTimeFormatter.ISO_DATE_TIME.withZone(z));
        } else if (string != null && !(option4 = this.IsoOffsetDateTime().unapplySeq((CharSequence)string)).isEmpty() && option4.get() != null && ((List)option4.get()).lengthCompare(1) == 0) {
            zonedDateTime = ZonedDateTime.parse(str, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        } else if (string != null && !(option3 = this.RelativeDate().unapplySeq((CharSequence)string)).isEmpty() && option3.get() != null && ((List)option3.get()).lengthCompare(3) == 0) {
            ZonedDateTime zonedDateTime2;
            String r = (String)((LinearSeqOps)option3.get()).apply(0);
            String op = (String)((LinearSeqOps)option3.get()).apply(1);
            String p = (String)((LinearSeqOps)option3.get()).apply(2);
            String string2 = op;
            if ("-".equals(string2)) {
                zonedDateTime2 = this.parseRefVar(ref, r).minus(this.parseDuration(p));
            } else if ("+".equals(string2)) {
                zonedDateTime2 = this.parseRefVar(ref, r).plus(this.parseDuration(p));
            } else {
                throw new IllegalArgumentException(new java.lang.StringBuilder(18).append("invalid operation ").append(op).toString());
            }
            zonedDateTime = zonedDateTime2;
        } else if (string != null && !(option2 = this.NamedDate().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(1) == 0) {
            String r = (String)((LinearSeqOps)option2.get()).apply(0);
            zonedDateTime = this.parseRefVar(ref, r);
        } else if (string != null && !(option = this.UnixDate().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
            String d = (String)((LinearSeqOps)option.get()).apply(0);
            long v = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(d));
            long t = v > Integer.MAX_VALUE ? v : v * 1000L;
            zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(t), tz);
        } else {
            throw new IllegalArgumentException(new java.lang.StringBuilder(13).append("invalid date ").append(str).toString());
        }
        return zonedDateTime;
    }

    public ZoneId parseDate$default$2() {
        return ZoneOffset.UTC;
    }

    private ZonedDateTime parseRefVar(ZonedDateTime ref, String v) {
        String string = v;
        ZonedDateTime zonedDateTime = "now".equals(string) ? ZonedDateTime.now(ZoneOffset.UTC) : ("epoch".equals(string) ? ZonedDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC) : ref);
        return zonedDateTime;
    }

    public Duration parseDuration(String str) {
        Option option;
        Duration duration;
        Option option2;
        String string = str;
        if (string != null && !(option2 = this.AtPeriod().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(2) == 0) {
            String a = (String)((LinearSeqOps)option2.get()).apply(0);
            String u = (String)((LinearSeqOps)option2.get()).apply(1);
            duration = this.parseAtDuration(a, u);
        } else if (string != null && !(option = this.IsoPeriod().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
            duration = Duration.parse(str);
        } else {
            throw new IllegalArgumentException(new java.lang.StringBuilder(15).append("invalid period ").append(str).toString());
        }
        return duration;
    }

    private Duration parseAtDuration(String amount, String unit) {
        Duration duration;
        int v = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(amount));
        String string = unit;
        boolean bl = "seconds".equals(string) ? true : ("second".equals(string) ? true : "s".equals(string));
        if (bl) {
            duration = Duration.ofSeconds(v);
        } else {
            boolean bl2 = "minutes".equals(string) ? true : ("minute".equals(string) ? true : ("min".equals(string) ? true : "m".equals(string)));
            if (bl2) {
                duration = Duration.ofMinutes(v);
            } else {
                boolean bl3 = "hours".equals(string) ? true : ("hour".equals(string) ? true : "h".equals(string));
                if (bl3) {
                    duration = Duration.ofHours(v);
                } else {
                    boolean bl4 = "days".equals(string) ? true : ("day".equals(string) ? true : "d".equals(string));
                    if (bl4) {
                        duration = Duration.ofDays(v);
                    } else {
                        boolean bl5 = "weeks".equals(string) ? true : ("week".equals(string) ? true : ("wk".equals(string) ? true : "w".equals(string)));
                        if (bl5) {
                            duration = Duration.ofDays(v * 7);
                        } else {
                            boolean bl6 = "months".equals(string) ? true : "month".equals(string);
                            if (bl6) {
                                duration = Duration.ofDays(v * 30);
                            } else {
                                boolean bl7 = "years".equals(string) ? true : ("year".equals(string) ? true : "y".equals(string));
                                if (bl7) {
                                    duration = Duration.ofDays(v * 365);
                                } else {
                                    throw new IllegalArgumentException(new java.lang.StringBuilder(13).append("unknown unit ").append(unit).toString());
                                }
                            }
                        }
                    }
                }
            }
        }
        return duration;
    }

    /*
     * Unable to fully structure code
     */
    public Tuple2<Instant, Instant> timeRange(String s, String e, ZoneId tz) {
        if (this.isRelativeDate(s, true)) ** GOTO lbl-1000
        v0 = s;
        var5_4 = "e";
        if (!(v0 != null ? v0.equals(var5_4) == false : var5_4 != null)) lbl-1000:
        // 2 sources

        {
            Predef$.MODULE$.require(this.isRelativeDate(e, true) == false, (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$timeRange$1(), ()Ljava/lang/String;)());
            end = this.parseDate(e, tz);
            start = this.parseDate(end, s, tz);
            v1 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)start.toInstant()), (Object)end.toInstant());
        } else {
            start = this.parseDate(s, tz);
            end = this.parseDate(start, e, tz);
            v1 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)start.toInstant()), (Object)end.toInstant());
        }
        range = v1;
        Predef$.MODULE$.require(this.isBeforeOrEqual((Instant)range._1(), (Instant)range._2()), (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$timeRange$2(), ()Ljava/lang/String;)());
        return range;
    }

    public ZoneId timeRange$default$3() {
        return ZoneOffset.UTC;
    }

    private boolean isBeforeOrEqual(Instant s, Instant e) {
        return s.isBefore(e) || s.equals(e);
    }

    public Color parseColor(String str) {
        int len = str.length();
        Predef$.MODULE$.require(len == 3 || len == 6 || len == 8, (Function0 & Serializable)() -> "color must be hex string [AA]RRGGBB");
        String colorStr = len == 3 ? StringOps$.MODULE$.map$extension(Predef$.MODULE$.augmentString(str), (Function1 & Serializable)c -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToChar((Object)c)), BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToChar((Object)c))}))).mkString() : str;
        return len <= 6 ? new Color(Integer.parseInt(colorStr, 16), false) : new Color((int)Long.parseLong(colorStr, 16), true);
    }

    private final long oneSecond() {
        return 1000L;
    }

    private final long oneMinute() {
        return 60000L;
    }

    private final long oneHour() {
        return 3600000L;
    }

    private final long oneDay() {
        return 86400000L;
    }

    private final long oneWeek() {
        return 604800000L;
    }

    public String toString(Duration d) {
        long l = d.toMillis();
        String string = l % 604800000L == 0L ? new java.lang.StringBuilder(1).append(l / 604800000L).append("w").toString() : (l % 86400000L == 0L ? new java.lang.StringBuilder(1).append(l / 86400000L).append("d").toString() : (l % 3600000L == 0L ? new java.lang.StringBuilder(1).append(l / 3600000L).append("h").toString() : (l % 60000L == 0L ? new java.lang.StringBuilder(1).append(l / 60000L).append("m").toString() : (l % 1000L == 0L ? new java.lang.StringBuilder(1).append(l / 1000L).append("s").toString() : d.toString()))));
        return string;
    }

    public String stripMargin(String str) {
        String s = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(str)).trim();
        return s.replaceAll("\n\n+", "@@@").replaceAll("\n", " ").replaceAll("@@@", "\n\n");
    }

    public String zeroPad(String s, int width) {
        String string;
        int n = width - s.length();
        if (n <= 0) {
            string = s;
        } else {
            StringBuilder builder = new StringBuilder(width);
            for (int i = 0; i < n; ++i) {
                builder.append('0');
            }
            builder.append(s);
            string = builder.toString();
        }
        return string;
    }

    public String zeroPad(int v, int width) {
        return this.zeroPad(Integer.toHexString(v), width);
    }

    public String zeroPad(long v, int width) {
        return this.zeroPad(Long.toHexString(v), width);
    }

    public String zeroPad(BigInteger v, int width) {
        return this.zeroPad(v.toString(16), width);
    }

    private String[] byteHexStrings() {
        return byteHexStrings;
    }

    public String zeroPad(byte[] v, int width) {
        int i;
        int n = width - 2 * v.length;
        StringBuilder builder = new StringBuilder(package$.MODULE$.max(width, 2 * v.length));
        for (i = 0; i < n; ++i) {
            builder.append('0');
        }
        for (i = 0; i < v.length; ++i) {
            int idx = Byte.toUnsignedInt(v[i]);
            builder.append(this.byteHexStrings()[idx]);
        }
        return builder.toString();
    }

    private static final String hex$1(char c) {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%%%02X"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)c)}));
    }

    public static final /* synthetic */ String $anonfun$timeRange$1() {
        return "start and end are both relative";
    }

    public static final /* synthetic */ String $anonfun$timeRange$2() {
        return "end time is before start time";
    }

    private Strings$() {
    }
}

