/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.util;

import com.netflix.atlas.core.util.RollingInterval;
import com.netflix.atlas.core.util.Strings$;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.runtime.ModuleSerializationProxy;

public final class RollingInterval$
implements Serializable {
    public static final RollingInterval$ MODULE$ = new RollingInterval$();

    public RollingInterval apply(String interval) {
        String[] parts = interval.split("\\s*,\\s*");
        Predef$.MODULE$.require(parts.length == 3, (Function0 & Serializable)() -> new StringBuilder(26).append("invalid rolling interval: ").append(interval).toString());
        Duration s = Strings$.MODULE$.parseDuration(parts[0]);
        Duration e = Strings$.MODULE$.parseDuration(parts[1]);
        ChronoUnit unit = ChronoUnit.valueOf(parts[2]);
        return new RollingInterval(s, e, unit);
    }

    public void com$netflix$atlas$core$util$RollingInterval$$checkParams(Duration offset, Duration duration, ChronoUnit unit) {
        Duration unitDuration = Duration.of(1L, unit);
        Predef$.MODULE$.require(duration.toMillis() >= unitDuration.toMillis(), (Function0 & Serializable)() -> new StringBuilder(13).append("duration ").append(duration).append(" <= ").append(unitDuration).toString());
        Predef$.MODULE$.require(offset.toMillis() % unitDuration.toMillis() == 0L, (Function0 & Serializable)() -> new StringBuilder(27).append("offset must be multiple of ").append(unit).toString());
        Predef$.MODULE$.require(duration.toMillis() % unitDuration.toMillis() == 0L, (Function0 & Serializable)() -> new StringBuilder(29).append("duration must be multiple of ").append(unit).toString());
    }

    public Instant ceil(Instant t, ChronoUnit unit) {
        Instant truncated;
        Instant instant = truncated = t.truncatedTo(unit);
        Instant instant2 = t;
        return !(instant != null ? !((Object)instant).equals(instant2) : instant2 != null) ? t : truncated.plus(1L, unit);
    }

    public RollingInterval apply(Duration offset, Duration duration, ChronoUnit unit) {
        return new RollingInterval(offset, duration, unit);
    }

    public Option<Tuple3<Duration, Duration, ChronoUnit>> unapply(RollingInterval x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.offset(), (Object)x$0.duration(), (Object)x$0.unit()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RollingInterval$.class);
    }

    private RollingInterval$() {
    }
}

