/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.util;

import com.netflix.atlas.core.util.ArrayHelper$;
import com.netflix.atlas.core.util.Hash$;
import com.netflix.atlas.core.util.PrimeFinder;
import com.netflix.atlas.core.util.RefIntHashMap$;
import java.io.Serializable;
import scala.Function0;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Builder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Mc\u0001\u0002\r\u001a\u0001\u0011B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\u0006a\u0001!\t!\r\u0005\u0007{\u0001\u0001\u000b\u0015\u0002 \t\r\u0005\u0003\u0001\u0015)\u0003C\u0011\u0019\u0019\u0005\u0001)Q\u0005[!1A\t\u0001Q!\n5BQ!\u0012\u0001\u0005\n\u0019CQ!\u0013\u0001\u0005\n)CQ\u0001\u0014\u0001\u0005\n5CQ!\u0015\u0001\u0005\nICQ!\u0015\u0001\u0005\u0002yCQ!\u0019\u0001\u0005\u0002\tDQ!\u001a\u0001\u0005\u0002\u0019DQA\u001b\u0001\u0005\u0002-DQA\u001b\u0001\u0005\u00025DQ!\u001d\u0001\u0005\u0002IDQ\u0001\u001f\u0001\u0005\u0002eDQA\u001f\u0001\u0005\u0002mDq!!\u0006\u0001\t\u0003\t9bB\u0005\u00020e\t\t\u0011#\u0001\u00022\u0019A\u0001$GA\u0001\u0012\u0003\t\u0019\u0004\u0003\u00041+\u0011\u0005\u0011Q\u0007\u0005\n\u0003o)\u0012\u0013!C\u0001\u0003s\u0011QBU3g\u0013:$\b*Y:i\u001b\u0006\u0004(B\u0001\u000e\u001c\u0003\u0011)H/\u001b7\u000b\u0005qi\u0012\u0001B2pe\u0016T!AH\u0010\u0002\u000b\u0005$H.Y:\u000b\u0005\u0001\n\u0013a\u00028fi\u001ad\u0017\u000e\u001f\u0006\u0002E\u0005\u00191m\\7\u0004\u0001U\u0011QEN\n\u0003\u0001\u0019\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012a!\u00118z%\u00164\u0017\u0001C2ba\u0006\u001c\u0017\u000e^=\u0011\u0005\u001dr\u0013BA\u0018)\u0005\rIe\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005Ib\u0004cA\u001a\u0001i5\t\u0011\u0004\u0005\u00026m1\u0001A!B\u001c\u0001\u0005\u0004A$!\u0001+\u0012\u0005e2\u0003CA\u0014;\u0013\tY\u0004FA\u0004O_RD\u0017N\\4\t\u000f1\u0012\u0001\u0013!a\u0001[\u0005!1.Z=t!\r9s\bN\u0005\u0003\u0001\"\u0012Q!\u0011:sCf\faA^1mk\u0016\u001c\bcA\u0014@[\u0005!Qo]3e\u0003\u0019\u0019W\u000f^8gM\u0006i1m\\7qkR,7)\u001e;pM\u001a$\"!L$\t\u000b!;\u0001\u0019A\u0017\u0002\u00039\f\u0001B\\3x\u0003J\u0014\u0018-\u001f\u000b\u0003}-CQ\u0001\u0013\u0005A\u00025\naA]3tSj,G#\u0001(\u0011\u0005\u001dz\u0015B\u0001))\u0005\u0011)f.\u001b;\u0002\u0007A,H\u000fF\u0003T-bSF\f\u0005\u0002()&\u0011Q\u000b\u000b\u0002\b\u0005>|G.Z1o\u0011\u00159&\u00021\u0001?\u0003\tY7\u000fC\u0003Z\u0015\u0001\u0007!)\u0001\u0002wg\")1L\u0003a\u0001i\u0005\t1\u000eC\u0003^\u0015\u0001\u0007Q&A\u0001w)\rqu\f\u0019\u0005\u00067.\u0001\r\u0001\u000e\u0005\u0006;.\u0001\r!L\u0001\faV$\u0018JZ!cg\u0016tG\u000fF\u0002TG\u0012DQa\u0017\u0007A\u0002QBQ!\u0018\u0007A\u00025\n1aZ3u)\ris\r\u001b\u0005\u000676\u0001\r\u0001\u000e\u0005\u0006S6\u0001\r!L\u0001\u0005I\u001adG/A\u0005j]\u000e\u0014X-\\3oiR\u0011a\n\u001c\u0005\u00067:\u0001\r\u0001\u000e\u000b\u0004\u001d:|\u0007\"B.\u0010\u0001\u0004!\u0004\"\u00029\u0010\u0001\u0004i\u0013AB1n_VtG/A\u0004g_J,\u0017m\u00195\u0015\u00059\u001b\b\"\u0002;\u0011\u0001\u0004)\u0018!\u00014\u0011\u000b\u001d2H'\f(\n\u0005]D#!\u0003$v]\u000e$\u0018n\u001c83\u0003\u0011\u0019\u0018N_3\u0016\u00035\n!\"\\1q)>\f%O]1z+\ra\u0018\u0011\u0001\u000b\u0004{\u0006EAc\u0001@\u0002\u000eA\u0019qeP@\u0011\u0007U\n\t\u0001B\u0004\u0002\u0004I\u0011\r!!\u0002\u0003\u0003I\u000b2!OA\u0004!\r9\u0013\u0011B\u0005\u0004\u0003\u0017A#aA!os\"1AO\u0005a\u0001\u0003\u001f\u0001Ra\n<5[}Da!a\u0005\u0013\u0001\u0004q\u0018A\u00022vM\u001a,'/A\u0003u_6\u000b\u0007/\u0006\u0002\u0002\u001aA1\u00111DA\u0015i5rA!!\b\u0002&A\u0019\u0011q\u0004\u0015\u000e\u0005\u0005\u0005\"bAA\u0012G\u00051AH]8pizJ1!a\n)\u0003\u0019\u0001&/\u001a3fM&!\u00111FA\u0017\u0005\ri\u0015\r\u001d\u0006\u0004\u0003OA\u0013!\u0004*fM&sG\u000fS1tQ6\u000b\u0007\u000f\u0005\u00024+M\u0011QC\n\u000b\u0003\u0003c\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\nT\u0003BA\u001e\u0003#*\"!!\u0010+\u00075\nyd\u000b\u0002\u0002BA!\u00111IA'\u001b\t\t)E\u0003\u0003\u0002H\u0005%\u0013!C;oG\",7m[3e\u0015\r\tY\u0005K\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA(\u0003\u000b\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u00159tC1\u00019\u0001")
public class RefIntHashMap<T> {
    private T[] keys;
    private int[] values;
    private int used;
    private int cutoff;

    public static <T> int $lessinit$greater$default$1() {
        return RefIntHashMap$.MODULE$.$lessinit$greater$default$1();
    }

    private int computeCutoff(int n) {
        return package$.MODULE$.max(3, n / 2);
    }

    private T[] newArray(int n) {
        return (Object[])ArrayHelper$.MODULE$.newInstance(PrimeFinder.nextPrime(n));
    }

    private void resize() {
        T[] tmpKS = this.newArray(this.keys.length * 2);
        int[] tmpVS = new int[tmpKS.length];
        for (int i = 0; i < this.keys.length; ++i) {
            T k = this.keys[i];
            Object object = k != null ? BoxesRunTime.boxToBoolean((boolean)this.put(tmpKS, tmpVS, k, this.values[i])) : BoxedUnit.UNIT;
        }
        this.keys = tmpKS;
        this.values = tmpVS;
        this.cutoff = this.computeCutoff(tmpKS.length);
    }

    private boolean put(T[] ks, int[] vs, T k, int v) {
        int pos = Hash$.MODULE$.absOrZero(k.hashCode()) % ks.length;
        T posV = ks[pos];
        while (posV != null && !BoxesRunTime.equals(posV, k)) {
            pos = (pos + 1) % ks.length;
            posV = ks[pos];
        }
        ks[pos] = k;
        vs[pos] = v;
        return posV == null;
    }

    public void put(T k, int v) {
        block1: {
            if (this.used >= this.cutoff) {
                this.resize();
            }
            if (!this.put(this.keys, this.values, k, v)) break block1;
            ++this.used;
        }
    }

    public boolean putIfAbsent(T k, int v) {
        boolean bl;
        if (this.used >= this.cutoff) {
            this.resize();
        }
        int pos = Hash$.MODULE$.absOrZero(k.hashCode()) % this.keys.length;
        T posV = this.keys[pos];
        while (posV != null && !BoxesRunTime.equals(posV, k)) {
            pos = (pos + 1) % this.keys.length;
            posV = this.keys[pos];
        }
        if (posV != null) {
            bl = false;
        } else {
            this.keys[pos] = k;
            this.values[pos] = v;
            ++this.used;
            bl = true;
        }
        return bl;
    }

    public int get(T k, int dflt) {
        int pos = Hash$.MODULE$.absOrZero(k.hashCode()) % this.keys.length;
        T prev;
        while ((prev = this.keys[pos]) != null) {
            if (prev.equals(k)) {
                return this.values[pos];
            }
            pos = (pos + 1) % this.keys.length;
        }
        return dflt;
    }

    public void increment(T k) {
        this.increment(k, 1);
    }

    public void increment(T k, int amount) {
        if (this.used >= this.cutoff) {
            this.resize();
        }
        int pos = Hash$.MODULE$.absOrZero(k.hashCode()) % this.keys.length;
        while (true) {
            T prev;
            if ((prev = this.keys[pos]) == null || BoxesRunTime.equals(prev, k)) {
                this.keys[pos] = k;
                int[] nArray = this.values;
                int n = pos;
                nArray[n] = nArray[n] + amount;
                if (prev == null) {
                    ++this.used;
                }
                return;
            }
            pos = (pos + 1) % this.keys.length;
        }
    }

    public void foreach(Function2<T, Object, BoxedUnit> f) {
        for (int i = 0; i < this.keys.length; ++i) {
            T k = this.keys[i];
            Object object = k != null ? f.apply(k, (Object)BoxesRunTime.boxToInteger((int)this.values[i])) : BoxedUnit.UNIT;
        }
    }

    public int size() {
        return this.used;
    }

    public <R> Object mapToArray(Object buffer, Function2<T, Object, R> f) {
        Predef$.MODULE$.require(ScalaRunTime$.MODULE$.array_length(buffer) == this.used, (Function0 & Serializable)() -> new StringBuilder(27).append("buffer.length (").append(ScalaRunTime$.MODULE$.array_length(buffer)).append(") != size (").append($this.used).append(")").toString());
        int j = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            T k = this.keys[i];
            if (k == null) continue;
            ScalaRunTime$.MODULE$.array_update(buffer, j, f.apply(k, (Object)BoxesRunTime.boxToInteger((int)this.values[i])));
            ++j;
        }
        return buffer;
    }

    public Map<T, Object> toMap() {
        Builder builder = Predef$.MODULE$.Map().newBuilder();
        this.foreach((Function2 & Serializable)(k, v) -> {
            builder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(k), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)v))));
            return BoxedUnit.UNIT;
        });
        return (Map)builder.result();
    }

    public RefIntHashMap(int capacity) {
        this.keys = this.newArray(capacity);
        this.values = new int[this.keys.length];
        this.used = 0;
        this.cutoff = this.computeCutoff(this.keys.length);
    }
}

