/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.util;

import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.AnyRefMap;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.util.Try$;
import scala.util.hashing.MurmurHash3$;

public final class Hash$ {
    public static final Hash$ MODULE$ = new Hash$();
    private static final ThreadLocal<ByteBuffer> buffer = ThreadLocal.withInitial(() -> ByteBuffer.allocate(8));
    private static final AnyRefMap<String, MessageDigest> cloneableDigests = MODULE$.createDigests();

    public int murmur3(long v) {
        ByteBuffer buf = buffer.get();
        buf.clear();
        buf.putLong(v);
        return MurmurHash3$.MODULE$.bytesHash(buf.array());
    }

    private AnyRefMap<String, MessageDigest> cloneableDigests() {
        return cloneableDigests;
    }

    /*
     * WARNING - void declaration
     */
    private AnyRefMap<String, MessageDigest> createDigests() {
        void var1_1;
        AnyRefMap digests = new AnyRefMap();
        ((List)new .colon.colon((Object)"MD5", (List)new .colon.colon((Object)"SHA1", (List)Nil$.MODULE$))).foreach((Function1 & Serializable)algorithm -> {
            Hash$.$anonfun$createDigests$1(digests, algorithm);
            return BoxedUnit.UNIT;
        });
        return var1_1;
    }

    public MessageDigest get(String algorithm) {
        MessageDigest digest = (MessageDigest)this.cloneableDigests().getOrNull((Object)algorithm);
        return digest != null ? (MessageDigest)digest.clone() : MessageDigest.getInstance(algorithm);
    }

    public BigInteger md5(byte[] input) {
        return this.computeHash("MD5", input);
    }

    public BigInteger md5(String input) {
        return this.computeHash("MD5", input.getBytes("UTF-8"));
    }

    public BigInteger sha1(byte[] input) {
        return this.computeHash("SHA1", input);
    }

    public BigInteger sha1(String input) {
        return this.computeHash("SHA1", input.getBytes("UTF-8"));
    }

    public byte[] sha1bytes(String input) {
        return this.computeHashBytes("SHA1", input.getBytes("UTF-8"));
    }

    public int absOrZero(int v) {
        return package$.MODULE$.max(package$.MODULE$.abs(v), 0);
    }

    private BigInteger computeHash(String algorithm, byte[] bytes) {
        return new BigInteger(1, this.computeHashBytes(algorithm, bytes));
    }

    private byte[] computeHashBytes(String algorithm, byte[] bytes) {
        MessageDigest md = this.get(algorithm);
        md.update(bytes);
        return md.digest();
    }

    public static final /* synthetic */ void $anonfun$createDigests$3(AnyRefMap digests$1, String algorithm$1, MessageDigest digest) {
        Try$.MODULE$.apply((Function0 & Serializable)() -> (MessageDigest)digest.clone()).foreach((Function1 & Serializable)clone -> (AnyRefMap)digests$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)algorithm$1), clone)));
    }

    public static final /* synthetic */ void $anonfun$createDigests$1(AnyRefMap digests$1, String algorithm) {
        Try$.MODULE$.apply((Function0 & Serializable)() -> MessageDigest.getInstance(algorithm)).foreach((Function1 & Serializable)digest -> {
            Hash$.$anonfun$createDigests$3(digests$1, algorithm, digest);
            return BoxedUnit.UNIT;
        });
    }

    private Hash$() {
    }
}

