/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.norm;

import com.netflix.atlas.core.norm.NormalizeValueFunction$;
import com.netflix.atlas.core.norm.ValueFunction;
import java.io.Serializable;
import scala.Function0;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005]<Q!\u0006\f\t\u0002\u00052Qa\t\f\t\u0002\u0011BQaK\u0001\u0005\u00021Bq!L\u0001C\u0002\u00135a\u0006\u0003\u00042\u0003\u0001\u0006ia\f\u0005\be\u0005\u0011\r\u0011\"\u00034\u0011\u0019a\u0014\u0001)A\u0005i\u0019!1E\u0006\u0001>\u0011!\tuA!A!\u0002\u0013\u0011\u0005\u0002C#\b\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u0011\u0019;!\u0011!Q\u0001\nyBQaK\u0004\u0005\u0002\u001dCq\u0001T\u0004A\u0002\u0013%Q\nC\u0004O\u000f\u0001\u0007I\u0011B(\t\rU;\u0001\u0015)\u0003C\u0011\u001d1v\u00011A\u0005\n]CqaW\u0004A\u0002\u0013%A\f\u0003\u0004_\u000f\u0001\u0006K\u0001\u0017\u0005\u0006?\u001e!\t\u0001\u0019\u0005\u0006K\u001e!IA\u001a\u0005\u0006U\u001e!\te[\u0001\u0017\u001d>\u0014X.\u00197ju\u00164\u0016\r\\;f\rVt7\r^5p]*\u0011q\u0003G\u0001\u0005]>\u0014XN\u0003\u0002\u001a5\u0005!1m\u001c:f\u0015\tYB$A\u0003bi2\f7O\u0003\u0002\u001e=\u00059a.\u001a;gY&D(\"A\u0010\u0002\u0007\r|Wn\u0001\u0001\u0011\u0005\t\nQ\"\u0001\f\u0003-9{'/\\1mSj,g+\u00197vK\u001a+hn\u0019;j_:\u001c\"!A\u0013\u0011\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011%\u0001\nO\u001f~\u0003&+\u0012,J\u001fV\u001bv,\u0016)E\u0003R+U#A\u0018\u0010\u0003Ar\u0012a\u0000\u0001\u0014\u001d>{\u0006KU#W\u0013>+6kX+Q\t\u0006#V\tI\u0001\u0015Q\u0016\f'\u000f\u001e2fCR,\u0005\u0010]5sK\u000e{WO\u001c;\u0016\u0003Q\u0002\"!\u000e\u001e\u000e\u0003YR!a\u000e\u001d\u0002\u0007\u0005\u0004\u0018N\u0003\u0002:9\u0005I1\u000f]3di\u0006$xN]\u0005\u0003wY\u0012qaQ8v]R,'/A\u000biK\u0006\u0014HOY3bi\u0016C\b/\u001b:f\u0007>,h\u000e\u001e\u0011\u0014\u0007\u001d)c\b\u0005\u0002#\u007f%\u0011\u0001I\u0006\u0002\u000e-\u0006dW/\u001a$v]\u000e$\u0018n\u001c8\u0002\tM$X\r\u001d\t\u0003M\rK!\u0001R\u0014\u0003\t1{gnZ\u0001\nQ\u0016\f'\u000f\u001e2fCR\fAA\\3yiR!\u0001*\u0013&L!\t\u0011s\u0001C\u0003B\u0017\u0001\u0007!\tC\u0003F\u0017\u0001\u0007!\tC\u0003G\u0017\u0001\u0007a(\u0001\bmCN$X\u000b\u001d3bi\u0016$\u0016.\\3\u0016\u0003\t\u000b!\u0003\\1tiV\u0003H-\u0019;f)&lWm\u0018\u0013fcR\u0011\u0001k\u0015\t\u0003MEK!AU\u0014\u0003\tUs\u0017\u000e\u001e\u0005\b)6\t\t\u00111\u0001C\u0003\rAH%M\u0001\u0010Y\u0006\u001cH/\u00169eCR,G+[7fA\u0005IA.Y:u-\u0006dW/Z\u000b\u00021B\u0011a%W\u0005\u00035\u001e\u0012a\u0001R8vE2,\u0017!\u00047bgR4\u0016\r\\;f?\u0012*\u0017\u000f\u0006\u0002Q;\"9A\u000bEA\u0001\u0002\u0004A\u0016A\u00037bgR4\u0016\r\\;fA\u0005)\u0011\r\u001d9msR\u0019\u0001+Y2\t\u000b\t\u0014\u0002\u0019\u0001\"\u0002\u0013QLW.Z:uC6\u0004\b\"\u00023\u0013\u0001\u0004A\u0016!\u0002<bYV,\u0017!D<fS\u001eDG/\u001a3WC2,X\rF\u0002YO&DQ\u0001[\nA\u0002\t\u000baa\u001c4gg\u0016$\b\"\u00023\u0014\u0001\u0004A\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u00031\u0004\"!\u001c;\u000f\u00059\u0014\bCA8(\u001b\u0005\u0001(BA9!\u0003\u0019a$o\\8u}%\u00111oJ\u0001\u0007!J,G-\u001a4\n\u0005U4(AB*ue&twM\u0003\u0002tO\u0001")
public class NormalizeValueFunction
implements ValueFunction {
    private final long step;
    private final long heartbeat;
    private final ValueFunction next;
    private long lastUpdateTime;
    private double lastValue;

    private long lastUpdateTime() {
        return this.lastUpdateTime;
    }

    private void lastUpdateTime_$eq(long x$1) {
        this.lastUpdateTime = x$1;
    }

    private double lastValue() {
        return this.lastValue;
    }

    private void lastValue_$eq(double x$1) {
        this.lastValue = x$1;
    }

    @Override
    public void apply(long timestamp, double value) {
        block8: {
            if (timestamp <= this.lastUpdateTime()) break block8;
            if (this.lastUpdateTime() > 0L && timestamp - this.lastUpdateTime() > this.heartbeat) {
                NormalizeValueFunction$.MODULE$.com$netflix$atlas$core$norm$NormalizeValueFunction$$heartbeatExpireCount().increment();
                this.lastUpdateTime_$eq(-1L);
                this.lastValue_$eq(0.0);
            }
            long offset = timestamp % this.step;
            long stepBoundary = timestamp - offset;
            if (this.lastUpdateTime() < stepBoundary) {
                if (this.lastUpdateTime() != -1L) {
                    long intervalOffset = this.lastUpdateTime() % this.step;
                    long nextBoundary = this.lastUpdateTime() - intervalOffset + this.step;
                    this.lastValue_$eq(this.lastValue() + this.weightedValue(this.step - intervalOffset, value));
                    this.next.apply(nextBoundary, this.lastValue());
                    while (nextBoundary < stepBoundary) {
                        this.next.apply(nextBoundary += this.step, value);
                    }
                } else if (offset == 0L) {
                    this.next.apply(timestamp, value);
                } else {
                    this.next.apply(stepBoundary, this.weightedValue(this.step - offset, value));
                }
                this.lastUpdateTime_$eq(timestamp);
                this.lastValue_$eq(this.weightedValue(offset, value));
            } else {
                long intervalOffset = timestamp - this.lastUpdateTime();
                this.lastUpdateTime_$eq(timestamp);
                this.lastValue_$eq(this.lastValue() + this.weightedValue(intervalOffset, value));
            }
        }
    }

    private double weightedValue(long offset, double value) {
        double weight = (double)offset / (double)this.step;
        return value * weight;
    }

    public String toString() {
        String name = this.getClass().getSimpleName();
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s(step=%d, heartbeat=%d, lastUpdateTime=%d, lastValue=%f)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name, BoxesRunTime.boxToLong((long)this.step), BoxesRunTime.boxToLong((long)this.heartbeat), BoxesRunTime.boxToLong((long)this.lastUpdateTime()), BoxesRunTime.boxToDouble((double)this.lastValue())}));
    }

    public NormalizeValueFunction(long step, long heartbeat, ValueFunction next) {
        this.step = step;
        this.heartbeat = heartbeat;
        this.next = next;
        Predef$.MODULE$.require(step >= 1L, (Function0 & Serializable)() -> "step must be >= 1");
        Predef$.MODULE$.require(heartbeat >= 1L, (Function0 & Serializable)() -> "heartbeat must be >= 1");
        this.lastUpdateTime = -1L;
        this.lastValue = 0.0;
    }
}

