/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.model;

import com.netflix.atlas.core.model.ItemId;
import com.netflix.atlas.core.model.ItemId$;
import com.netflix.atlas.core.util.Hash$;
import com.netflix.atlas.core.util.InternMap;
import com.netflix.atlas.core.util.InternMap$;
import com.netflix.atlas.core.util.Interner;
import com.netflix.atlas.core.util.Interner$;
import com.netflix.atlas.core.util.SmallHashMap;
import com.netflix.atlas.core.util.SmallHashMap$;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.ScalaRunTime$;

public final class TaggedItem$ {
    public static final TaggedItem$ MODULE$ = new TaggedItem$();
    private static final ItemId emptyId = ItemId$.MODULE$.apply(Hash$.MODULE$.sha1bytes(""));
    private static final int initCapacity = 1000000;
    private static final InternMap<ItemId> idInterner = InternMap$.MODULE$.concurrent(MODULE$.initCapacity(), InternMap$.MODULE$.concurrent$default$2(), InternMap$.MODULE$.concurrent$default$3(), ManifestFactory$.MODULE$.classType(ItemId.class));
    private static final InternMap<Map<String, String>> tagsInterner = InternMap$.MODULE$.concurrent(MODULE$.initCapacity(), InternMap$.MODULE$.concurrent$default$2(), InternMap$.MODULE$.concurrent$default$3(), ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(String.class)})));
    private static final Comparator<Tuple2<String, String>> keyComparator = new Comparator<Tuple2<String, String>>(){

        public Comparator<Tuple2<String, String>> reversed() {
            return Comparator.super.reversed();
        }

        public Comparator<Tuple2<String, String>> thenComparing(Comparator<? super Tuple2<String, String>> x$1) {
            return Comparator.super.thenComparing(x$1);
        }

        public <U> Comparator<Tuple2<String, String>> thenComparing(Function<? super Tuple2<String, String>, ? extends U> x$1, Comparator<? super U> x$2) {
            return Comparator.super.thenComparing(x$1, x$2);
        }

        public <U extends Comparable<? super U>> Comparator<Tuple2<String, String>> thenComparing(Function<? super Tuple2<String, String>, ? extends U> x$1) {
            return Comparator.super.thenComparing(x$1);
        }

        public Comparator<Tuple2<String, String>> thenComparingInt(ToIntFunction<? super Tuple2<String, String>> x$1) {
            return Comparator.super.thenComparingInt(x$1);
        }

        public Comparator<Tuple2<String, String>> thenComparingLong(ToLongFunction<? super Tuple2<String, String>> x$1) {
            return Comparator.super.thenComparingLong(x$1);
        }

        public Comparator<Tuple2<String, String>> thenComparingDouble(ToDoubleFunction<? super Tuple2<String, String>> x$1) {
            return Comparator.super.thenComparingDouble(x$1);
        }

        public int compare(Tuple2<String, String> t1, Tuple2<String, String> t2) {
            return ((String)t1._1()).compareTo((String)t2._1());
        }
    };

    private ItemId emptyId() {
        return emptyId;
    }

    private int initCapacity() {
        return initCapacity;
    }

    private InternMap<ItemId> idInterner() {
        return idInterner;
    }

    private InternMap<Map<String, String>> tagsInterner() {
        return tagsInterner;
    }

    private Comparator<Tuple2<String, String>> keyComparator() {
        return keyComparator;
    }

    private void writePair(Tuple2<String, String> p, CharBuffer cbuf, ByteBuffer buf, CharsetEncoder enc, MessageDigest md) {
        cbuf.clear();
        cbuf.put((String)p._1());
        cbuf.flip();
        enc.encode(cbuf, buf, true);
        buf.flip();
        md.update(buf);
        buf.clear();
        md.update((byte)61);
        cbuf.clear();
        cbuf.put((String)p._2());
        cbuf.flip();
        enc.encode(cbuf, buf, true);
        buf.flip();
        md.update(buf);
        buf.clear();
    }

    public ItemId computeId(Map<String, String> tags) {
        ItemId itemId;
        if (tags.isEmpty()) {
            itemId = this.emptyId();
        } else {
            Tuple2[] pairs = new Tuple2[tags.size()];
            Iterator it = tags.iterator();
            int pos = 0;
            int maxLength = 0;
            while (it.hasNext()) {
                Tuple2 t;
                pairs[pos] = t = (Tuple2)it.next();
                ++pos;
                maxLength = package$.MODULE$.max(((String)t._1()).length(), maxLength);
                maxLength = package$.MODULE$.max(((String)t._2()).length(), maxLength);
            }
            Arrays.sort((Object[])pairs, this.keyComparator());
            MessageDigest md = Hash$.MODULE$.get("SHA1");
            CharsetEncoder enc = Charset.forName("UTF-8").newEncoder();
            CharBuffer cbuf = CharBuffer.allocate(maxLength);
            ByteBuffer buf = ByteBuffer.allocate(maxLength * 2);
            this.writePair((Tuple2<String, String>)pairs[0], cbuf, buf, enc, md);
            for (pos = 1; pos < pairs.length; ++pos) {
                md.update((byte)44);
                this.writePair((Tuple2<String, String>)pairs[pos], cbuf, buf, enc, md);
            }
            itemId = ItemId$.MODULE$.apply(md.digest());
        }
        return itemId;
    }

    public ItemId createId(Map<String, String> tags) {
        ItemId id = this.computeId(tags);
        return this.idInterner().intern(id);
    }

    public ItemId internId(ItemId id) {
        return this.idInterner().intern(id);
    }

    public Map<String, String> internTags(Map<String, String> tags) {
        Interner<String> strInterner = Interner$.MODULE$.forStrings();
        Iterator iter = tags.iterator().map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(strInterner.intern((String)t._1())), strInterner.intern((String)t._2())));
        SmallHashMap smallMap = SmallHashMap$.MODULE$.apply(tags.size(), iter);
        return this.tagsInterner().intern(smallMap);
    }

    public Map<String, String> internTagsShallow(Map<String, String> tags) {
        return this.tagsInterner().intern(tags);
    }

    public void retain(Function1<Object, Object> keep) {
        this.idInterner().retain(keep);
        this.tagsInterner().retain(keep);
    }

    public Map<String, String> aggrTags(Map<String, String> t1, Map<String, String> t2) {
        return t1.toSet().intersect((Set)t2.toSet()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private TaggedItem$() {
    }
}

