/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.model;

import com.netflix.atlas.core.model.ArrayBlock;
import com.netflix.atlas.core.model.Block;
import com.netflix.atlas.core.model.Block$;
import com.netflix.atlas.core.model.MutableBlock;
import com.netflix.atlas.core.model.RollupBlock$;
import com.netflix.atlas.core.util.Math$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t%q!B\u0017/\u0011\u0003Id!B\u001e/\u0011\u0003a\u0004\"B&\u0002\t\u0003a\u0005\"B'\u0002\t\u0003q\u0005\"CAp\u0003\u0005\u0005I\u0011QAq\u0011%\tY/AA\u0001\n\u0003\u000bi\u000fC\u0005\u0002\u0000\u0006\t\t\u0011\"\u0003\u0003\u0002\u0019!1H\f!Q\u0011!\u0011wA!f\u0001\n\u0003\u0019\u0007\u0002C4\b\u0005#\u0005\u000b\u0011\u00023\t\u0011!<!Q3A\u0005\u0002\rD\u0001\"[\u0004\u0003\u0012\u0003\u0006I\u0001\u001a\u0005\tU\u001e\u0011)\u001a!C\u0001G\"A1n\u0002B\tB\u0003%A\r\u0003\u0005m\u000f\tU\r\u0011\"\u0001d\u0011!iwA!E!\u0002\u0013!\u0007\"B&\b\t\u0003q\u0007\"B:\b\t\u0003!\b\"\u0002=\b\t\u0003I\b\"B?\b\t\u0003q\bBBA\u0003\u000f\u0011\u0005a\u0010C\u0004\u0002\b\u001d!\t!!\u0003\t\u000f\u0005\u001dq\u0001\"\u0011\u0002\u0016!9\u0011QD\u0004\u0005\u0002\u0005}\u0001bBA\u0016\u000f\u0011\u0005\u0011Q\u0006\u0005\b\u0003k9A\u0011BA\u001c\u0011\u001d\tid\u0002C\u0005\u0003\u007fAq!!\u0012\b\t\u0013\t9\u0005C\u0004\u0002N\u001d!I!a\u0014\t\u000f\u0005Us\u0001\"\u0001\u0002X!9\u0011QL\u0004\u0005\u0002\u0005}\u0003\"CA1\u000f\u0005\u0005I\u0011AA2\u0011%\tigBI\u0001\n\u0003\ty\u0007C\u0005\u0002\u0006\u001e\t\n\u0011\"\u0001\u0002p!I\u0011qQ\u0004\u0012\u0002\u0013\u0005\u0011q\u000e\u0005\n\u0003\u0013;\u0011\u0013!C\u0001\u0003_B\u0011\"a#\b\u0003\u0003%\t%!$\t\u0011\u0005mu!!A\u0005\u0002yD\u0011\"!(\b\u0003\u0003%\t!a(\t\u0013\u0005-v!!A\u0005B\u00055\u0006\"CA^\u000f\u0005\u0005I\u0011AA_\u0011%\t9mBA\u0001\n\u0003\nI\rC\u0005\u0002N\u001e\t\t\u0011\"\u0011\u0002P\"I\u0011\u0011[\u0004\u0002\u0002\u0013\u0005\u00131\u001b\u0005\n\u0003+<\u0011\u0011!C!\u0003/\f1BU8mYV\u0004(\t\\8dW*\u0011q\u0006M\u0001\u0006[>$W\r\u001c\u0006\u0003cI\nAaY8sK*\u00111\u0007N\u0001\u0006CRd\u0017m\u001d\u0006\u0003kY\nqA\\3uM2L\u0007PC\u00018\u0003\r\u0019w.\\\u0002\u0001!\tQ\u0014!D\u0001/\u0005-\u0011v\u000e\u001c7va\ncwnY6\u0014\u0007\u0005i4\t\u0005\u0002?\u00036\tqHC\u0001A\u0003\u0015\u00198-\u00197b\u0013\t\u0011uH\u0001\u0004B]f\u0014VM\u001a\t\u0003\t&k\u0011!\u0012\u0006\u0003\r\u001e\u000b!![8\u000b\u0003!\u000bAA[1wC&\u0011!*\u0012\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\nQ!Z7qif$RaTAn\u0003;\u0004\"AO\u0004\u0014\u000b\u001di\u0014\u000bV,\u0011\u0005i\u0012\u0016BA*/\u00051iU\u000f^1cY\u0016\u0014En\\2l!\tqT+\u0003\u0002W\u007f\t9\u0001K]8ek\u000e$\bC\u0001-a\u001d\tIfL\u0004\u0002[;6\t1L\u0003\u0002]q\u00051AH]8pizJ\u0011\u0001Q\u0005\u0003?~\nq\u0001]1dW\u0006<W-\u0003\u0002KC*\u0011qlP\u0001\u0004gVlW#\u00013\u0011\u0005i*\u0017B\u00014/\u0005\u0015\u0011En\\2l\u0003\u0011\u0019X/\u001c\u0011\u0002\u000b\r|WO\u001c;\u0002\r\r|WO\u001c;!\u0003\ri\u0017N\\\u0001\u0005[&t\u0007%A\u0002nCb\fA!\\1yAQ)qj\u001c9re\")!\r\u0005a\u0001I\")\u0001\u000e\u0005a\u0001I\")!\u000e\u0005a\u0001I\")A\u000e\u0005a\u0001I\u00061!\r\\8dWN,\u0012!\u001e\t\u00041Z$\u0017BA<b\u0005\u0011a\u0015n\u001d;\u0002\u000bM$\u0018M\u001d;\u0016\u0003i\u0004\"AP>\n\u0005q|$\u0001\u0002'p]\u001e\fAa]5{KV\tq\u0010E\u0002?\u0003\u0003I1!a\u0001@\u0005\rIe\u000e^\u0001\nEf$XmQ8v]R\f1aZ3u)\u0011\tY!!\u0005\u0011\u0007y\ni!C\u0002\u0002\u0010}\u0012a\u0001R8vE2,\u0007BBA\n+\u0001\u0007q0A\u0002q_N$b!a\u0003\u0002\u0018\u0005e\u0001BBA\n-\u0001\u0007q\u0010\u0003\u0005\u0002\u001cY\u0001\n\u00111\u0001\u0000\u0003\u0011\twm\u001a:\u0002\rI|G\u000e\\;q)\u0011\t\t#a\n\u0011\u0007y\n\u0019#C\u0002\u0002&}\u0012A!\u00168ji\"1\u0011\u0011F\fA\u0002\u0011\fQA\u00197pG.\fa!\u001e9eCR,GCBA\u0011\u0003_\t\t\u0004\u0003\u0004\u0002\u0014a\u0001\ra \u0005\b\u0003gA\u0002\u0019AA\u0006\u0003\u00151\u0018\r\\;f\u0003%)\b\u000fZ1uKN+X\u000e\u0006\u0004\u0002\"\u0005e\u00121\b\u0005\u0007\u0003'I\u0002\u0019A@\t\u000f\u0005M\u0012\u00041\u0001\u0002\f\u0005YQ\u000f\u001d3bi\u0016\u001cu.\u001e8u)\u0019\t\t#!\u0011\u0002D!1\u00111\u0003\u000eA\u0002}Dq!a\r\u001b\u0001\u0004\tY!A\u0005va\u0012\fG/Z'j]R1\u0011\u0011EA%\u0003\u0017Ba!a\u0005\u001c\u0001\u0004y\bbBA\u001a7\u0001\u0007\u00111B\u0001\nkB$\u0017\r^3NCb$b!!\t\u0002R\u0005M\u0003BBA\n9\u0001\u0007q\u0010C\u0004\u00024q\u0001\r!a\u0003\u0002\u000bI,7/\u001a;\u0015\t\u0005\u0005\u0012\u0011\f\u0005\u0007\u00037j\u0002\u0019\u0001>\u0002\u0003Q\f\u0001bY8naJ,7o]\u000b\u0002\u001f\u0006!1m\u001c9z)%y\u0015QMA4\u0003S\nY\u0007C\u0004c?A\u0005\t\u0019\u00013\t\u000f!|\u0002\u0013!a\u0001I\"9!n\bI\u0001\u0002\u0004!\u0007b\u00027 !\u0003\u0005\r\u0001Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tHK\u0002e\u0003gZ#!!\u001e\u0011\t\u0005]\u0014\u0011Q\u0007\u0003\u0003sRA!a\u001f\u0002~\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u007fz\u0014AC1o]>$\u0018\r^5p]&!\u00111QA=\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u001f\u0003B!!%\u0002\u00186\u0011\u00111\u0013\u0006\u0004\u0003+;\u0015\u0001\u00027b]\u001eLA!!'\u0002\u0014\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\"\u0006\u001d\u0006c\u0001 \u0002$&\u0019\u0011QU \u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002*\u001a\n\t\u00111\u0001\u0000\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0016\t\u0007\u0003c\u000b9,!)\u000e\u0005\u0005M&bAA[\u007f\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005e\u00161\u0017\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002@\u0006\u0015\u0007c\u0001 \u0002B&\u0019\u00111Y \u0003\u000f\t{w\u000e\\3b]\"I\u0011\u0011\u0016\u0015\u0002\u0002\u0003\u0007\u0011\u0011U\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\u0010\u0006-\u0007\u0002CAUS\u0005\u0005\t\u0019A@\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012a`\u0001\ti>\u001cFO]5oOR\u0011\u0011qR\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005}\u0016\u0011\u001c\u0005\n\u0003Sc\u0013\u0011!a\u0001\u0003CCQ\u0001_\u0002A\u0002iDQ!`\u0002A\u0002}\fQ!\u00199qYf$\u0012bTAr\u0003K\f9/!;\t\u000b\t$\u0001\u0019\u00013\t\u000b!$\u0001\u0019\u00013\t\u000b)$\u0001\u0019\u00013\t\u000b1$\u0001\u0019\u00013\u0002\u000fUt\u0017\r\u001d9msR!\u0011q^A~!\u0015q\u0014\u0011_A{\u0013\r\t\u0019p\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000fy\n9\u0010\u001a3eI&\u0019\u0011\u0011` \u0003\rQ+\b\u000f\\35\u0011!\ti0BA\u0001\u0002\u0004y\u0015a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!1\u0001\t\u0005\u0003#\u0013)!\u0003\u0003\u0003\b\u0005M%AB(cU\u0016\u001cG\u000f")
public class RollupBlock
implements MutableBlock,
Product,
Serializable {
    private final Block sum;
    private final Block count;
    private final Block min;
    private final Block max;

    public static Option<Tuple4<Block, Block, Block, Block>> unapply(RollupBlock rollupBlock) {
        return RollupBlock$.MODULE$.unapply(rollupBlock);
    }

    public static RollupBlock apply(Block block, Block block2, Block block3, Block block4) {
        return RollupBlock$.MODULE$.apply(block, block2, block3, block4);
    }

    public static RollupBlock empty(long l, int n) {
        return RollupBlock$.MODULE$.empty(l, n);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public int get$default$2() {
        return Block.get$default$2$(this);
    }

    @Override
    public ArrayBlock toArrayBlock() {
        return Block.toArrayBlock$(this);
    }

    @Override
    public int sizeOf(Object value) {
        return Block.sizeOf$(this, value);
    }

    public Block sum() {
        return this.sum;
    }

    public Block count() {
        return this.count;
    }

    public Block min() {
        return this.min;
    }

    public Block max() {
        return this.max;
    }

    public List<Block> blocks() {
        return (List)new .colon.colon((Object)this.sum(), (List)new .colon.colon((Object)this.count(), (List)new .colon.colon((Object)this.min(), (List)new .colon.colon((Object)this.max(), (List)Nil$.MODULE$))));
    }

    @Override
    public long start() {
        return this.sum().start();
    }

    @Override
    public int size() {
        return this.sum().size();
    }

    @Override
    public int byteCount() {
        return 2 + this.sum().byteCount() + this.count().byteCount() + this.min().byteCount() + this.max().byteCount();
    }

    @Override
    public double get(int pos) {
        return this.sum().get(pos);
    }

    @Override
    public double get(int pos, int aggr) {
        double d;
        int n = aggr;
        switch (n) {
            case 0: {
                d = this.sum().get(pos);
                break;
            }
            case 1: {
                d = this.count().get(pos);
                break;
            }
            case 2: {
                d = this.min().get(pos);
                break;
            }
            case 3: {
                d = this.max().get(pos);
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return d;
    }

    public void rollup(Block block) {
        Predef$.MODULE$.require(this.sum().start() == block.start(), (Function0 & Serializable)() -> new StringBuilder(24).append("invalid start time: ").append(this.sum().start()).append(" != ").append(block.start()).toString());
        Predef$.MODULE$.require(this.sum().size() == block.size(), (Function0 & Serializable)() -> new StringBuilder(18).append("invalid size: ").append(this.sum().size()).append(" != ").append(block.size()).toString());
        ((ArrayBlock)this.sum()).add(block, 0);
        ((ArrayBlock)this.count()).add(block, 1);
        ((ArrayBlock)this.min()).min(block, 2);
        ((ArrayBlock)this.max()).max(block, 3);
    }

    @Override
    public void update(int pos, double value) {
        block0: {
            if (Predef$.MODULE$.double2Double(value).isNaN()) break block0;
            this.updateSum(pos, value);
            this.updateCount(pos, value);
            this.updateMin(pos, value);
            this.updateMax(pos, value);
        }
    }

    private void updateSum(int pos, double value) {
        double[] buffer = ((ArrayBlock)this.sum()).buffer();
        buffer[pos] = Math$.MODULE$.addNaN(buffer[pos], value);
    }

    private void updateCount(int pos, double value) {
        double[] buffer = ((ArrayBlock)this.count()).buffer();
        buffer[pos] = Math$.MODULE$.addNaN(buffer[pos], 1.0);
    }

    private void updateMin(int pos, double value) {
        double[] buffer = ((ArrayBlock)this.min()).buffer();
        buffer[pos] = Math$.MODULE$.minNaN(buffer[pos], value);
    }

    private void updateMax(int pos, double value) {
        double[] buffer = ((ArrayBlock)this.max()).buffer();
        buffer[pos] = Math$.MODULE$.maxNaN(buffer[pos], value);
    }

    @Override
    public void reset(long t) {
        ((ArrayBlock)this.sum()).reset(t);
        ((ArrayBlock)this.count()).reset(t);
        ((ArrayBlock)this.min()).reset(t);
        ((ArrayBlock)this.max()).reset(t);
    }

    public RollupBlock compress() {
        Block s = Block$.MODULE$.compressIfNeeded(this.sum());
        Block c = Block$.MODULE$.compressIfNeeded(this.count());
        Block mn = Block$.MODULE$.compressIfNeeded(this.min());
        Block mx = Block$.MODULE$.compressIfNeeded(this.max());
        return new RollupBlock(s, c, mn, mx);
    }

    public RollupBlock copy(Block sum, Block count, Block min, Block max) {
        return new RollupBlock(sum, count, min, max);
    }

    public Block copy$default$1() {
        return this.sum();
    }

    public Block copy$default$2() {
        return this.count();
    }

    public Block copy$default$3() {
        return this.min();
    }

    public Block copy$default$4() {
        return this.max();
    }

    public String productPrefix() {
        return "RollupBlock";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.sum();
                break;
            }
            case 1: {
                object = this.count();
                break;
            }
            case 2: {
                object = this.min();
                break;
            }
            case 3: {
                object = this.max();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RollupBlock;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "sum";
                break;
            }
            case 1: {
                string = "count";
                break;
            }
            case 2: {
                string = "min";
                break;
            }
            case 3: {
                string = "max";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RollupBlock)) return false;
        boolean bl = true;
        if (!bl) return false;
        RollupBlock rollupBlock = (RollupBlock)x$1;
        Block block = this.sum();
        Block block2 = rollupBlock.sum();
        if (block == null) {
            if (block2 != null) {
                return false;
            }
        } else if (!block.equals(block2)) return false;
        Block block3 = this.count();
        Block block4 = rollupBlock.count();
        if (block3 == null) {
            if (block4 != null) {
                return false;
            }
        } else if (!block3.equals(block4)) return false;
        Block block5 = this.min();
        Block block6 = rollupBlock.min();
        if (block5 == null) {
            if (block6 != null) {
                return false;
            }
        } else if (!block5.equals(block6)) return false;
        Block block7 = this.max();
        Block block8 = rollupBlock.max();
        if (block7 == null) {
            if (block8 != null) {
                return false;
            }
        } else if (!block7.equals(block8)) return false;
        if (!rollupBlock.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$new$2(RollupBlock $this, Block x$1) {
        return x$1.size() == $this.sum().size();
    }

    public static final /* synthetic */ boolean $anonfun$new$4(RollupBlock $this, Block x$2) {
        return x$2.start() == $this.sum().start();
    }

    public RollupBlock(Block sum, Block count, Block min, Block max) {
        this.sum = sum;
        this.count = count;
        this.min = min;
        this.max = max;
        Block.$init$(this);
        Product.$init$((Product)this);
        Predef$.MODULE$.require(((List)new .colon.colon((Object)count, (List)new .colon.colon((Object)min, (List)new .colon.colon((Object)max, (List)Nil$.MODULE$)))).forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RollupBlock.$anonfun$new$2(this, x$1))), (Function0 & Serializable)() -> "all blocks must have the same size");
        Predef$.MODULE$.require(((List)new .colon.colon((Object)count, (List)new .colon.colon((Object)min, (List)new .colon.colon((Object)max, (List)Nil$.MODULE$)))).forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)RollupBlock.$anonfun$new$4(this, x$2))), (Function0 & Serializable)() -> "all blocks must have the same start");
    }
}

