/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.model;

import com.netflix.atlas.core.model.ArrayBlock;
import com.netflix.atlas.core.model.Block;
import com.netflix.atlas.core.model.ConstantBlock;
import com.netflix.atlas.core.model.FloatArrayBlock$;
import com.netflix.atlas.core.model.RollupBlock;
import com.netflix.atlas.core.model.SparseBlock;
import com.netflix.atlas.core.model.SparseBlock$;
import com.netflix.atlas.core.util.DoubleIntHashMap;
import com.netflix.atlas.core.util.DoubleIntHashMap$;
import java.io.Serializable;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction2;

public final class Block$ {
    public static final Block$ MODULE$ = new Block$();
    private static final int MAX_SIZE = 120;

    public final int Sum() {
        return 0;
    }

    public final int Count() {
        return 1;
    }

    public final int Min() {
        return 2;
    }

    public final int Max() {
        return 3;
    }

    public int MAX_SIZE() {
        return MAX_SIZE;
    }

    public Block compress(ArrayBlock block) {
        Product product;
        if (block.size() < 10) {
            product = block;
        } else {
            DoubleIntHashMap idxMap = new DoubleIntHashMap(DoubleIntHashMap$.MODULE$.$lessinit$greater$default$1(), DoubleIntHashMap$.MODULE$.$lessinit$greater$default$2());
            int nextIdx = 0;
            byte[] indexes = new byte[block.size()];
            boolean isConstant = true;
            byte prev = 0;
            for (int i = 0; i < block.size(); ++i) {
                int idx;
                double v2 = block.buffer()[i];
                int predefIdx = SparseBlock$.MODULE$.predefinedIndex(v2);
                int n = idx = predefIdx == 0 ? idxMap.get(v2, -4) : predefIdx;
                if (idx == -4) {
                    if (nextIdx == this.MAX_SIZE()) {
                        return block;
                    }
                    idx = nextIdx++;
                    idxMap.put(v2, idx);
                }
                indexes[i] = (byte)idx;
                if (i > 0) {
                    isConstant = isConstant && prev == idx;
                }
                prev = (byte)idx;
            }
            double[] values = new double[idxMap.size()];
            idxMap.foreach((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVDI.sp & Serializable)(k, v) -> {
                values$1[v] = k;
            });
            product = isConstant ? new ConstantBlock(block.start(), block.size(), SparseBlock$.MODULE$.get(indexes[0], values)) : (idxMap.size() < block.size() / 2 ? new SparseBlock(block.start(), indexes, values) : block);
        }
        return product;
    }

    public Block lossyCompress(ArrayBlock block) {
        Block block2;
        Block block3 = this.compress(block);
        if (block3 instanceof ArrayBlock) {
            ArrayBlock arrayBlock = (ArrayBlock)block3;
            block2 = FloatArrayBlock$.MODULE$.apply(arrayBlock);
        } else if (block3 != null) {
            Block block4 = block3;
            block2 = block4;
        } else {
            throw new MatchError((Object)block3);
        }
        return block2;
    }

    public Block compressIfNeeded(Block block) {
        Block block2;
        Block block3 = block;
        if (block3 instanceof ArrayBlock) {
            ArrayBlock arrayBlock = (ArrayBlock)block3;
            block2 = this.lossyCompress(arrayBlock);
        } else if (block3 instanceof RollupBlock) {
            RollupBlock rollupBlock = (RollupBlock)block3;
            block2 = rollupBlock.compress();
        } else if (block3 != null) {
            Block block4;
            block2 = block4 = block3;
        } else {
            throw new MatchError((Object)block3);
        }
        return block2;
    }

    public Block add(Block block1, Block block2) {
        Block b2;
        ArrayBlock arrayBlock;
        Block b1;
        Predef$.MODULE$.require(block1.size() == block2.size(), (Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("block sizes: %d != %d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)block1.size()), BoxesRunTime.boxToInteger((int)block2.size())})));
        Tuple2 tuple2 = new Tuple2((Object)block1, (Object)block2);
        if (tuple2 != null && (b1 = (Block)tuple2._1()) instanceof ArrayBlock) {
            ArrayBlock arrayBlock2 = (ArrayBlock)b1;
            arrayBlock2.add(block2, arrayBlock2.add$default$2());
            arrayBlock = arrayBlock2;
        } else if (tuple2 != null && (b2 = (Block)tuple2._2()) instanceof ArrayBlock) {
            ArrayBlock arrayBlock3 = (ArrayBlock)b2;
            arrayBlock3.add(block1, arrayBlock3.add$default$2());
            arrayBlock = arrayBlock3;
        } else {
            ArrayBlock b12 = block1.toArrayBlock();
            b12.add(block2, b12.add$default$2());
            arrayBlock = b12;
        }
        return arrayBlock;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Block merge(Block block1, Block block2) {
        Block b2;
        Block b1;
        Block b22;
        Block b12;
        void var3_14;
        Predef$.MODULE$.require(block1.size() == block2.size(), (Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("block sizes: %d != %d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)block1.size()), BoxesRunTime.boxToInteger((int)block2.size())})));
        Tuple2 tuple2 = new Tuple2((Object)block1, (Object)block2);
        if (tuple2 != null) {
            Block b13 = (Block)tuple2._1();
            Block b23 = (Block)tuple2._2();
            if (b13 instanceof RollupBlock) {
                RollupBlock rollupBlock = (RollupBlock)b13;
                if (b23 instanceof RollupBlock) {
                    RollupBlock rollupBlock2 = (RollupBlock)b23;
                    Block block = this.rollupMerge(rollupBlock, rollupBlock2);
                    return var3_14;
                }
            }
        }
        if (tuple2 != null && (b12 = (Block)tuple2._1()) instanceof RollupBlock) {
            RollupBlock rollupBlock = (RollupBlock)b12;
            RollupBlock rollupBlock3 = rollupBlock.compress();
            return var3_14;
        }
        if (tuple2 != null && (b22 = (Block)tuple2._2()) instanceof RollupBlock) {
            RollupBlock rollupBlock = (RollupBlock)b22;
            RollupBlock rollupBlock4 = rollupBlock.compress();
            return var3_14;
        }
        if (tuple2 != null && (b1 = (Block)tuple2._1()) instanceof ArrayBlock) {
            ArrayBlock arrayBlock = (ArrayBlock)b1;
            arrayBlock.merge(block2);
            Block block = this.compress(arrayBlock);
            return var3_14;
        }
        if (tuple2 != null && (b2 = (Block)tuple2._2()) instanceof ArrayBlock) {
            ArrayBlock arrayBlock = (ArrayBlock)b2;
            arrayBlock.merge(block1);
            Block block = this.compress(arrayBlock);
            return var3_14;
        }
        Block block = this.arrayMerge(block1, block2);
        return var3_14;
    }

    private Block rollupMerge(RollupBlock b1, RollupBlock b2) {
        Block x$1 = this.merge(b1.min(), b2.min());
        Block x$2 = this.merge(b1.max(), b2.max());
        Block x$3 = this.merge(b1.sum(), b2.sum());
        Block x$4 = this.merge(b1.count(), b2.count());
        RollupBlock merged = new RollupBlock(x$3, x$4, x$1, x$2);
        return merged.compress();
    }

    private Block arrayMerge(Block block1, Block block2) {
        ArrayBlock b1 = block1.toArrayBlock();
        b1.merge(block2);
        return this.compress(b1);
    }

    private Block$() {
    }
}

