/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.index;

import com.netflix.atlas.core.index.IndexStats;
import com.netflix.atlas.core.index.RoaringTagIndex$;
import com.netflix.atlas.core.index.TagIndex;
import com.netflix.atlas.core.index.TagQuery;
import com.netflix.atlas.core.model.ItemId;
import com.netflix.atlas.core.model.ItemId$;
import com.netflix.atlas.core.model.Query;
import com.netflix.atlas.core.model.Query$False$;
import com.netflix.atlas.core.model.Query$True$;
import com.netflix.atlas.core.model.Tag;
import com.netflix.atlas.core.model.Tag$;
import com.netflix.atlas.core.model.TaggedItem;
import com.netflix.atlas.core.util.IntIntHashMap;
import com.netflix.atlas.core.util.IntRefHashMap;
import com.netflix.atlas.core.util.IntRefHashMap$;
import com.netflix.atlas.core.util.LongHashSet;
import com.netflix.atlas.core.util.RefIntHashMap;
import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.RoaringBitmap;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\r]s!B!C\u0011\u0003ie!B(C\u0011\u0003\u0001\u0006\"B,\u0002\t\u0003A\u0006bB-\u0002\u0005\u0004%IA\u0017\u0005\u0007G\u0006\u0001\u000b\u0011B.\t\u000b\u0011\fA\u0011A3\u0007\t=\u0013\u0005\u0001\u001b\u0005\tw\u001a\u0011\t\u0011)A\u0005y\"IqP\u0002B\u0001B\u0003%\u0011\u0011\u0001\u0005\u0007/\u001a!\t!a\u0002\u0006\r\u0005=a\u0001AA\t\u000b\u0019\tIC\u0002\u0001\u0002,!I\u0011\u0011\u0007\u0004C\u0002\u0013%\u00111\u0007\u0005\t\u0003w1\u0001\u0015!\u0003\u00026!I\u0011q\u000b\u0004C\u0002\u0013%\u0011\u0011\f\u0005\t\u000372\u0001\u0015!\u0003\u0002\u001e!a\u0011Q\f\u0004\u0011\u0002\u0003\r\t\u0015!\u0003\u0002`!I\u0011q\u0011\u0004C\u0002\u0013%\u0011\u0011\u0012\u0005\t\u0003\u00173\u0001\u0015!\u0003\u0002f!I\u0011Q\u0012\u0004C\u0002\u0013%\u0011q\u0012\u0005\t\u0003#3\u0001\u0015!\u0003\u0002\u0002\"I\u00111\u0013\u0004C\u0002\u0013%\u0011Q\u0013\u0005\t\u0003;3\u0001\u0015!\u0003\u0002\u0018\"I\u0011q\u0014\u0004C\u0002\u0013%\u0011Q\u0013\u0005\t\u0003C3\u0001\u0015!\u0003\u0002\u0018\"a\u00111\u0015\u0004\u0011\u0002\u0003\r\t\u0015!\u0003\u0002&\"I\u0011Q\u0019\u0004C\u0002\u0013%\u0011q\u0019\u0005\t\u0003\u00134\u0001\u0015!\u0003\u0002,\"I\u00111\u001a\u0004C\u0002\u0013%\u0011Q\u001a\u0005\t\u0003\u001f4\u0001\u0015!\u0003\u00024\"I\u0011\u0011\u001b\u0004C\u0002\u0013%\u00111\u001b\u0005\t\u0003+4\u0001\u0015!\u0003\u0002.!I\u0011q\u001b\u0004C\u0002\u0013%\u0011\u0011\u001c\u0005\t\u000374\u0001\u0015!\u0003\u00026\"I\u0011Q\u001c\u0004C\u0002\u0013%\u0011q\u001c\u0005\t\u0003C4\u0001\u0015!\u0003\u0002>\"9\u00111\u001d\u0004\u0005\n\u0005\u0015\bbBAw\r\u0011%\u0011q\u001e\u0005\b\u0003o4A\u0011BA}\u0011\u001d\tYP\u0002C\u0005\u0003{DqA!\u0004\u0007\t\u0013\u0011y\u0001C\u0004\u0003\u0016\u0019!IAa\u0006\t\u0011\tma\u0001\"\u0001C\u0005;AqA!\f\u0007\t\u0013\u0011y\u0003C\u0004\u0003:\u0019!IAa\u000f\t\u000f\t\rc\u0001\"\u0003\u0003F!9!\u0011\u000b\u0004\u0005\n\tM\u0003b\u0002B.\r\u0011%!Q\f\u0005\b\u0005K2A\u0011\u0002B4\u0011\u001d\u00119H\u0002C\u0005\u0005sBqA!!\u0007\t\u0013\u0011\u0019\tC\u0004\u0003\u001a\u001a!IAa'\t\u000f\t\u0005f\u0001\"\u0003\u0003$\"9!q\u0015\u0004\u0005\n\t%\u0006b\u0002BW\r\u0011%!q\u0016\u0005\n\u0005w3\u0011\u0013!C\u0005\u0005{CqAa5\u0007\t\u0003\u0011)\u000eC\u0004\u0003x\u001a!\tA!?\t\u000f\t}h\u0001\"\u0001\u0004\u0002!9!1\f\u0004\u0005\n\r\u0015\u0001bBB\u0006\r\u0011\u00051Q\u0002\u0005\b\u0007'1A\u0011BB\u000b\u0011\u001d\u0019\u0019B\u0002C\u0005\u0007OA\u0011ba\u0011\u0007\u0005\u0004%\ta!\u0012\t\u0011\r\u001dc\u0001)A\u0005\u0005\u0007\tqBU8be&tw\rV1h\u0013:$W\r\u001f\u0006\u0003\u0007\u0012\u000bQ!\u001b8eKbT!!\u0012$\u0002\t\r|'/\u001a\u0006\u0003\u000f\"\u000bQ!\u0019;mCNT!!\u0013&\u0002\u000f9,GO\u001a7jq*\t1*A\u0002d_6\u001c\u0001\u0001\u0005\u0002O\u00035\t!IA\bS_\u0006\u0014\u0018N\\4UC\u001eLe\u000eZ3y'\t\t\u0011\u000b\u0005\u0002S+6\t1KC\u0001U\u0003\u0015\u00198-\u00197b\u0013\t16K\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035\u000ba\u0001\\8hO\u0016\u0014X#A.\u0011\u0005q\u000bW\"A/\u000b\u0005y{\u0016!B:mMRR'\"\u00011\u0002\u0007=\u0014x-\u0003\u0002c;\n1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%A\u0003f[B$\u00180F\u0002g\u0007\u0017\"2aZB'!\u0011qea!\u0013\u0016\u0005%|7c\u0001\u0004RUB\u0019aj[7\n\u00051\u0014%\u0001\u0003+bO&sG-\u001a=\u0011\u00059|G\u0002\u0001\u0003\u0006a\u001a\u0011\r!\u001d\u0002\u0002)F\u0011!/\u001e\t\u0003%NL!\u0001^*\u0003\u000f9{G\u000f[5oOB\u0011a/_\u0007\u0002o*\u0011\u0001\u0010R\u0001\u0006[>$W\r\\\u0005\u0003u^\u0014!\u0002V1hO\u0016$\u0017\n^3n\u0003\u0015IG/Z7t!\r\u0011V0\\\u0005\u0003}N\u0013Q!\u0011:sCf\fQa\u001d;biN\u00042ATA\u0002\u0013\r\t)A\u0011\u0002\u000b\u0013:$W\r_*uCR\u001cHCBA\u0005\u0003\u0017\ti\u0001E\u0002O\r5DQa_\u0005A\u0002qDaa`\u0005A\u0002\u0005\u0005!a\u0004*pCJLgn\u001a,bYV,W*\u00199\u0011\r\u0005M\u0011\u0011DA\u000f\u001b\t\t)BC\u0002\u0002\u0018\u0011\u000bA!\u001e;jY&!\u00111DA\u000b\u00055Ie\u000e\u001e*fM\"\u000b7\u000f['baB!\u0011qDA\u0013\u001b\t\t\tCC\u0002\u0002$}\u000bQB]8be&twMY5u[\u0006\u0004\u0018\u0002BA\u0014\u0003C\u0011QBU8be&twMQ5u[\u0006\u0004(!\u0004*pCJLgnZ&fs6\u000b\u0007\u000f\u0005\u0004\u0002\u0014\u0005e\u0011Q\u0006\t\u0004\u0003_QQ\"\u0001\u0004\u0002\u0019%$7i\\7qCJ\fGo\u001c:\u0016\u0005\u0005U\"CBA\u001c\u0003{\tiE\u0002\u0004\u0002:5\u0001\u0011Q\u0007\u0002\ryI,g-\u001b8f[\u0016tGOP\u0001\u000eS\u0012\u001cu.\u001c9be\u0006$xN\u001d\u0011\u0011\t\u0005}\u0012\u0011J\u0007\u0003\u0003\u0003RA!a\u0011\u0002F\u0005!A.\u00198h\u0015\t\t9%\u0001\u0003kCZ\f\u0017\u0002BA&\u0003\u0003\u0012aa\u00142kK\u000e$\b#BA(\u0003'jWBAA)\u0015\u0011\t9\"!\u0012\n\t\u0005U\u0013\u0011\u000b\u0002\u000b\u0007>l\u0007/\u0019:bi>\u0014\u0018aA1mYV\u0011\u0011QD\u0001\u0005C2d\u0007%A\u0002yIE\u0002rAUA1\u0003K\n\t)C\u0002\u0002dM\u0013a\u0001V;qY\u0016\u0014\u0004\u0003\u0002*~\u0003O\u0012b!!\u001b\u0002l\u0005ubABA\u001d\u0001\u0001\t9\u0007\u0005\u0003\u0002n\u0005md\u0002BA8\u0003o\u00022!!\u001dT\u001b\t\t\u0019HC\u0002\u0002v1\u000ba\u0001\u0010:p_Rt\u0014bAA='\u00061\u0001K]3eK\u001aLA!! \u0002\u0000\t11\u000b\u001e:j]\u001eT1!!\u001fT!\u0011\u0011V0a!\u0013\r\u0005\u0015\u00151NA\u001f\r\u0019\tI\u0004\u0001\u0001\u0002\u0004\u0006!1.Z=t+\t\t)'A\u0003lKf\u001c\b%\u0001\u0004wC2,Xm]\u000b\u0003\u0003\u0003\u000bqA^1mk\u0016\u001c\b%\u0001\u0004lKfl\u0015\r]\u000b\u0003\u0003/\u0003b!a\u0005\u0002\u001a\u0006-\u0014\u0002BAN\u0003+\u0011QBU3g\u0013:$\b*Y:i\u001b\u0006\u0004\u0018aB6fs6\u000b\u0007\u000fI\u0001\tm\u0006dW/Z'ba\u0006Ia/\u00197vK6\u000b\u0007\u000fI\u0001\u0004q\u0012\u0012\u0004#\u0004*\u0002(\u0006-\u00161WA\u0017\u0003k\u000bi,C\u0002\u0002*N\u0013a\u0001V;qY\u0016,\u0004\u0003\u0002*~\u0003[\u00032A^AX\u0013\r\t\tl\u001e\u0002\u0007\u0013R,W.\u00133\u0011\u0007\u0005=2\u0002\u0005\u0003S{\u0006]\u0006c\u0001*\u0002:&\u0019\u00111X*\u0003\t1{gn\u001a\t\u0005%v\fy\f\u0005\u0003\u0002\u0014\u0005\u0005\u0017\u0002BAb\u0003+\u0011Q\"\u00138u\u0013:$\b*Y:i\u001b\u0006\u0004\u0018aB5uK6LEm]\u000b\u0003\u0003W\u000b\u0001\"\u001b;f[&#7\u000fI\u0001\nSR,W.\u00138eKb,\"!a-\u0002\u0015%$X-\\%oI\u0016D\b%\u0001\u0005lKfLe\u000eZ3y+\t\ti#A\u0005lKfLe\u000eZ3yA\u0005AA/Y4J]\u0012,\u00070\u0006\u0002\u00026\u0006IA/Y4J]\u0012,\u0007\u0010I\u0001\tSR,W\u000eV1hgV\u0011\u0011QX\u0001\nSR,W\u000eV1hg\u0002\nAbY8mY\u0016\u001cGo\u0015;biN$\"!a:\u0011\u0007I\u000bI/C\u0002\u0002lN\u0013A!\u00168ji\u0006\t2M]3bi\u0016\u0004vn]5uS>tW*\u00199\u0015\t\u0005]\u0015\u0011\u001f\u0005\b\u0003g,\u0003\u0019AA{\u0003\u0011!\u0017\r^1\u0011\tIk\u00181N\u0001\u000fEVLG\u000eZ%uK6Le\u000eZ3y)\t\t)+A\u0002uC\u001e$b!a.\u0002\u0000\n%\u0001b\u0002B\u0001O\u0001\u0007!1A\u0001\u0002WB\u0019!K!\u0002\n\u0007\t\u001d1KA\u0002J]RDqAa\u0003(\u0001\u0004\u0011\u0019!A\u0001w\u0003\u0019!\u0018mZ&fsR!!1\u0001B\t\u0011\u001d\u0011\u0019\u0002\u000ba\u0001\u0003o\u000b\u0011\u0001^\u0001\ti\u0006<g+\u00197vKR!!1\u0001B\r\u0011\u001d\u0011\u0019\"\u000ba\u0001\u0003o\u000b\u0001BZ5oI&k\u0007\u000f\u001c\u000b\u0007\u0003;\u0011yB!\u000b\t\u000f\t\u0005\"\u00061\u0001\u0003$\u0005)\u0011/^3ssB\u0019aO!\n\n\u0007\t\u001drOA\u0003Rk\u0016\u0014\u0018\u0010C\u0004\u0003,)\u0002\rAa\u0001\u0002\r=4gm]3u\u0003\u0011!\u0017N\u001a4\u0015\r\u0005u!\u0011\u0007B\u001b\u0011\u001d\u0011\u0019d\u000ba\u0001\u0003;\t!a]\u0019\t\u000f\t]2\u00061\u0001\u0002\u001e\u0005\u00111OM\u0001\u000bo&$\bn\u00144gg\u0016$HCBA\u000f\u0005{\u0011\t\u0005C\u0004\u0003@1\u0002\r!!\b\u0002\u0007M,G\u000fC\u0004\u0003,1\u0002\rAa\u0001\u0002\u0007\u0005tG\r\u0006\u0005\u0002\u001e\t\u001d#1\nB(\u0011\u001d\u0011I%\fa\u0001\u0005G\t!!]\u0019\t\u000f\t5S\u00061\u0001\u0003$\u0005\u0011\u0011O\r\u0005\b\u0005Wi\u0003\u0019\u0001B\u0002\u0003\ty'\u000f\u0006\u0005\u0002\u001e\tU#q\u000bB-\u0011\u001d\u0011IE\fa\u0001\u0005GAqA!\u0014/\u0001\u0004\u0011\u0019\u0003C\u0004\u0003,9\u0002\rAa\u0001\u0002\u000b\u0015\fX/\u00197\u0015\u0011\u0005u!q\fB1\u0005GBqA!\u00010\u0001\u0004\tY\u0007C\u0004\u0003\f=\u0002\r!a\u001b\t\u000f\t-r\u00061\u0001\u0003\u0004\u0005YqM]3bi\u0016\u0014H\u000b[1o)!\tiB!\u001b\u0003l\t5\u0004b\u0002B\u0001a\u0001\u0007\u00111\u000e\u0005\b\u0005\u0017\u0001\u0004\u0019AA6\u0011\u001d\u0011y\u0007\ra\u0001\u0005c\nqa\u001c:FcV\fG\u000eE\u0002S\u0005gJ1A!\u001eT\u0005\u001d\u0011un\u001c7fC:\f\u0001\u0002\\3tgRC\u0017M\u001c\u000b\t\u0003;\u0011YH! \u0003\u0000!9!\u0011A\u0019A\u0002\u0005-\u0004b\u0002B\u0006c\u0001\u0007\u00111\u000e\u0005\b\u0005_\n\u0004\u0019\u0001B9\u0003)\u0019HO\u001d)biR,'O\u001c\u000b\u0007\u0003;\u0011)Ia&\t\u000f\t\u001d%\u00071\u0001\u0003\n\u0006\t\u0011\u000f\u0005\u0003\u0003\f\nEeb\u0001<\u0003\u000e&\u0019!qR<\u0002\u000bE+XM]=\n\t\tM%Q\u0013\u0002\r!\u0006$H/\u001a:o#V,'/\u001f\u0006\u0004\u0005\u001f;\bb\u0002B\u0016e\u0001\u0007!1A\u0001\u0007Q\u0006\u001c8*Z=\u0015\r\u0005u!Q\u0014BP\u0011\u001d\u0011\ta\ra\u0001\u0003WBqAa\u000b4\u0001\u0004\u0011\u0019!\u0001\u0006ji\u0016lwJ\u001a4tKR$BAa\u0001\u0003&\"9!1\u0002\u001bA\u0002\u0005-\u0014!\u0003;bO>3gm]3u)\u0011\u0011\u0019Aa+\t\u000f\t-Q\u00071\u0001\u00028\u0006Qa-\u001b8e\u001f\u001a47/\u001a;\u0015\u0011\t\r!\u0011\u0017B[\u0005oCqAa-7\u0001\u0004\t)0\u0001\u0002wg\"9!1\u0002\u001cA\u0002\u0005-\u0004\"\u0003B]mA\u0005\t\u0019\u0001B\u0002\u0003\u0005q\u0017\u0001\u00064j]\u0012|eMZ:fi\u0012\"WMZ1vYR$3'\u0006\u0002\u0003@*\"!1\u0001BaW\t\u0011\u0019\r\u0005\u0003\u0003F\n=WB\u0001Bd\u0015\u0011\u0011IMa3\u0002\u0013Ut7\r[3dW\u0016$'b\u0001Bg'\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tE'q\u0019\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001\u00034j]\u0012$\u0016mZ:\u0015\t\t]'q\u001e\t\u0007\u00053\u0014\u0019O!;\u000f\t\tm'q\u001c\b\u0005\u0003c\u0012i.C\u0001U\u0013\r\u0011\toU\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011)Oa:\u0003\t1K7\u000f\u001e\u0006\u0004\u0005C\u001c\u0006c\u0001<\u0003l&\u0019!Q^<\u0003\u0007Q\u000bw\rC\u0004\u0003\"a\u0002\rA!=\u0011\u00079\u0013\u00190C\u0002\u0003v\n\u0013\u0001\u0002V1h#V,'/_\u0001\tM&tGmS3zgR!!1 B\u007f!\u0019\u0011INa9\u0002l!9!\u0011E\u001dA\u0002\tE\u0018A\u00034j]\u00124\u0016\r\\;fgR!!1`B\u0002\u0011\u001d\u0011\tC\u000fa\u0001\u0005c$b!!\b\u0004\b\r%\u0001b\u0002B\u0001w\u0001\u0007!1\u0001\u0005\b\u0005\u0017Y\u0004\u0019\u0001B\u0002\u0003%1\u0017N\u001c3Ji\u0016l7\u000f\u0006\u0003\u0004\u0010\rE\u0001#\u0002Bm\u0005Gl\u0007b\u0002B\u0011y\u0001\u0007!\u0011_\u0001\u0011GJ,\u0017\r^3SKN,H\u000e\u001e'jgR$\u0002Ba?\u0004\u0018\re11\u0005\u0005\b\u0005gk\u0004\u0019AA{\u0011\u001d\u0019Y\"\u0010a\u0001\u0007;\tq!\\1uG\",7\u000f\u0005\u0003\u0002P\r}\u0011\u0002BB\u0011\u0003#\u0012aAQ5u'\u0016$\bbBB\u0013{\u0001\u0007!1A\u0001\u0006Y&l\u0017\u000e^\u000b\u0005\u0007S\u0019y\u0003\u0006\u0005\u0004,\rm2qHB!!\u0019\u0011INa9\u0004.A\u0019ana\f\u0005\u000f\rEbH1\u0001\u00044\t\ta+E\u0002s\u0007k\u00012AUB\u001c\u0013\r\u0019Id\u0015\u0002\u0004\u0003:L\bb\u0002BZ}\u0001\u00071Q\b\t\u0005%v\u001ci\u0003C\u0004\u0004\u001cy\u0002\r!!\b\t\u000f\r\u0015b\b1\u0001\u0003\u0004\u0005!1/\u001b>f+\t\u0011\u0019!A\u0003tSj,\u0007\u0005E\u0002o\u0007\u0017\"Q\u0001]\u0003C\u0002ED\u0011ba\u0014\u0006\u0003\u0003\u0005\u001da!\u0015\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007\u0005\u0004\u0002n\rM3\u0011J\u0005\u0005\u0007+\nyH\u0001\u0005NC:Lg-Z:u\u0001")
public class RoaringTagIndex<T extends TaggedItem>
implements TagIndex<T> {
    private final T[] items;
    private final IndexStats stats;
    private final Comparator<T> idComparator;
    private final RoaringBitmap all;
    private final /* synthetic */ Tuple2 x$1;
    private final String[] keys;
    private final String[] values;
    private final RefIntHashMap<String> keyMap;
    private final RefIntHashMap<String> valueMap;
    private final /* synthetic */ Tuple5 x$2;
    private final ItemId[] itemIds;
    private final IntRefHashMap<IntRefHashMap<RoaringBitmap>> itemIndex;
    private final IntRefHashMap<RoaringBitmap> keyIndex;
    private final long[] tagIndex;
    private final IntIntHashMap[] itemTags;
    private final int size;

    public static <T extends TaggedItem> RoaringTagIndex<T> empty(Manifest<T> manifest) {
        return RoaringTagIndex$.MODULE$.empty(manifest);
    }

    private Comparator<T> idComparator() {
        return this.idComparator;
    }

    private RoaringBitmap all() {
        return this.all;
    }

    private String[] keys() {
        return this.keys;
    }

    private String[] values() {
        return this.values;
    }

    private RefIntHashMap<String> keyMap() {
        return this.keyMap;
    }

    private RefIntHashMap<String> valueMap() {
        return this.valueMap;
    }

    private ItemId[] itemIds() {
        return this.itemIds;
    }

    private IntRefHashMap<IntRefHashMap<RoaringBitmap>> itemIndex() {
        return this.itemIndex;
    }

    private IntRefHashMap<RoaringBitmap> keyIndex() {
        return this.keyIndex;
    }

    private long[] tagIndex() {
        return this.tagIndex;
    }

    private IntIntHashMap[] itemTags() {
        return this.itemTags;
    }

    private void collectStats() {
        RoaringTagIndex$.MODULE$.com$netflix$atlas$core$index$RoaringTagIndex$$logger().info(new StringBuilder(28).append("items = ").append(this.items.length).append(", keys = ").append(this.keys().length).append(", values = ").append(this.values().length).toString());
        Builder builder = List$.MODULE$.newBuilder();
        for (int i = 0; i < this.keys().length; ++i) {
            int numValues = this.itemIndex().get(i).size();
            int numItems = this.keyIndex().get(i).getCardinality();
            builder.$plus$eq((Object)new IndexStats.KeyStat(this.keys()[i], numItems, numValues));
        }
        this.stats.updateKeyStats((List<IndexStats.KeyStat>)((List)builder.result()));
        this.stats.updateIndexStats(this.items.length);
    }

    /*
     * WARNING - void declaration
     */
    private RefIntHashMap<String> createPositionMap(String[] data) {
        void var2_2;
        RefIntHashMap<String> m = new RefIntHashMap<String>(2 * data.length);
        for (int i = 0; i < data.length; ++i) {
            m.put(data[i], i);
        }
        return var2_2;
    }

    private Tuple5<ItemId[], IntRefHashMap<IntRefHashMap<RoaringBitmap>>, IntRefHashMap<RoaringBitmap>, long[], IntIntHashMap[]> buildItemIndex() {
        RoaringTagIndex$.MODULE$.com$netflix$atlas$core$index$RoaringTagIndex$$logger().debug(new StringBuilder(41).append("building index with ").append(this.items.length).append(" items, starting sort").toString());
        Arrays.sort(this.items, this.idComparator());
        ItemId[] itemIds = new ItemId[this.items.length];
        RoaringTagIndex$.MODULE$.com$netflix$atlas$core$index$RoaringTagIndex$$logger().debug(new StringBuilder(47).append("building index with ").append(this.items.length).append(" items, create main key map").toString());
        IntRefHashMap kidx = new IntRefHashMap(-1, IntRefHashMap$.MODULE$.$lessinit$greater$default$2(), ManifestFactory$.MODULE$.classType(RoaringBitmap.class));
        IntRefHashMap idx = new IntRefHashMap(-1, IntRefHashMap$.MODULE$.$lessinit$greater$default$2(), ManifestFactory$.MODULE$.classType(IntRefHashMap.class, ManifestFactory$.MODULE$.classType(RoaringBitmap.class), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
        IntIntHashMap[] itemTags = new IntIntHashMap[this.items.length];
        LongHashSet tagsSet = new LongHashSet(-1L, this.items.length);
        IntRef pos = IntRef.create((int)0);
        while (pos.elem < this.items.length) {
            itemIds[pos.elem] = this.items[pos.elem].id();
            itemTags[pos.elem] = new IntIntHashMap(-1, 2 * this.items[pos.elem].tags().size());
            this.items[pos.elem].foreach((Function2<String, String, BoxedUnit>)(Function2 & Serializable)(k, v) -> {
                RoaringTagIndex.$anonfun$buildItemIndex$1(this, idx, pos, kidx, itemTags, tagsSet, k, v);
                return BoxedUnit.UNIT;
            });
            ++pos.elem;
        }
        long[] tagsArray = new long[tagsSet.size()];
        IntRef i = IntRef.create((int)0);
        tagsSet.foreach((Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable)t -> {
            tagsArray$1[i$1.elem] = t;
            ++i$1.elem;
        });
        Arrays.sort(tagsArray);
        return new Tuple5((Object)itemIds, idx, kidx, (Object)tagsArray, (Object)itemTags);
    }

    private long tag(int k, int v) {
        return (long)k << 32 | (long)v;
    }

    private int tagKey(long t) {
        return (int)(t >> 32);
    }

    private int tagValue(long t) {
        return (int)(t & 0xFFFFFFFFL);
    }

    public RoaringBitmap findImpl(Query query, int offset) {
        RoaringBitmap roaringBitmap;
        Query query2 = query;
        if (query2 instanceof Query.And) {
            Query.And and = (Query.And)query2;
            Query q1 = and.q1();
            Query q2 = and.q2();
            roaringBitmap = this.and(q1, q2, offset);
        } else if (query2 instanceof Query.Or) {
            Query.Or or = (Query.Or)query2;
            Query q1 = or.q1();
            Query q2 = or.q2();
            roaringBitmap = this.or(q1, q2, offset);
        } else if (query2 instanceof Query.Not) {
            Query.Not not = (Query.Not)query2;
            Query q = not.q();
            roaringBitmap = this.diff(this.all(), this.findImpl(q, offset));
        } else if (query2 instanceof Query.Equal) {
            Query.Equal equal = (Query.Equal)query2;
            String k = equal.k();
            String v = equal.v();
            roaringBitmap = this.equal(k, v, offset);
        } else if (query2 instanceof Query.GreaterThan) {
            Query.GreaterThan greaterThan = (Query.GreaterThan)query2;
            String k = greaterThan.k();
            String v = greaterThan.v();
            roaringBitmap = this.greaterThan(k, v, false);
        } else if (query2 instanceof Query.GreaterThanEqual) {
            Query.GreaterThanEqual greaterThanEqual = (Query.GreaterThanEqual)query2;
            String k = greaterThanEqual.k();
            String v = greaterThanEqual.v();
            roaringBitmap = this.greaterThan(k, v, true);
        } else if (query2 instanceof Query.LessThan) {
            Query.LessThan lessThan = (Query.LessThan)query2;
            String k = lessThan.k();
            String v = lessThan.v();
            roaringBitmap = this.lessThan(k, v, false);
        } else if (query2 instanceof Query.LessThanEqual) {
            Query.LessThanEqual lessThanEqual = (Query.LessThanEqual)query2;
            String k = lessThanEqual.k();
            String v = lessThanEqual.v();
            roaringBitmap = this.lessThan(k, v, true);
        } else if (query2 instanceof Query.In) {
            Query.In in = (Query.In)query2;
            roaringBitmap = this.findImpl(in.toOrQuery(), offset);
        } else if (query2 instanceof Query.PatternQuery) {
            Query.PatternQuery patternQuery = (Query.PatternQuery)query2;
            roaringBitmap = this.strPattern(patternQuery, offset);
        } else if (query2 instanceof Query.HasKey) {
            Query.HasKey hasKey = (Query.HasKey)query2;
            String k = hasKey.k();
            roaringBitmap = this.hasKey(k, offset);
        } else if (Query$True$.MODULE$.equals(query2)) {
            roaringBitmap = this.all().clone();
        } else if (Query$False$.MODULE$.equals(query2)) {
            roaringBitmap = new RoaringBitmap();
        } else {
            throw new MatchError((Object)query2);
        }
        return roaringBitmap;
    }

    /*
     * WARNING - void declaration
     */
    private RoaringBitmap diff(RoaringBitmap s1, RoaringBitmap s2) {
        void var3_3;
        RoaringBitmap s = s1.clone();
        s.andNot(s2);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private RoaringBitmap withOffset(RoaringBitmap set, int offset) {
        void var3_3;
        block0: {
            RoaringBitmap s = set.clone();
            if (offset <= 0) break block0;
            s.remove(0L, (long)offset + 1L);
        }
        return var3_3;
    }

    private RoaringBitmap and(Query q1, Query q2, int offset) {
        RoaringBitmap roaringBitmap;
        RoaringBitmap s1 = this.findImpl(q1, offset);
        if (s1.isEmpty()) {
            roaringBitmap = s1;
        } else {
            RoaringBitmap s2 = this.findImpl(q2, offset);
            s1.and(s2);
            roaringBitmap = s1;
        }
        return roaringBitmap;
    }

    private RoaringBitmap or(Query q1, Query q2, int offset) {
        RoaringBitmap s1 = this.findImpl(q1, offset);
        RoaringBitmap s2 = this.findImpl(q2, offset);
        s1.or(s2);
        return s1;
    }

    private RoaringBitmap equal(String k, String v, int offset) {
        int vp;
        RoaringBitmap matchSet;
        int kp = this.keyMap().get(k, -1);
        IntRefHashMap<RoaringBitmap> vidx = this.itemIndex().get(kp);
        return vidx == null ? new RoaringBitmap() : ((matchSet = vidx.get(vp = this.valueMap().get(v, -1))) == null ? new RoaringBitmap() : this.withOffset(matchSet, offset));
    }

    private RoaringBitmap greaterThan(String k, String v, boolean orEqual) {
        RoaringBitmap roaringBitmap;
        int kp = this.keyMap().get(k, -1);
        IntRefHashMap<RoaringBitmap> vidx = this.itemIndex().get(kp);
        if (vidx == null) {
            roaringBitmap = new RoaringBitmap();
        } else {
            RoaringBitmap set = new RoaringBitmap();
            int vp = this.findOffset(this.values(), v, orEqual ? 0 : 1);
            long t = this.tag(kp, vp);
            for (int i = this.tagOffset(t); i < this.tagIndex().length && this.tagKey(this.tagIndex()[i]) == kp; ++i) {
                set.or(vidx.get(this.tagValue(this.tagIndex()[i])));
            }
            roaringBitmap = set;
        }
        return roaringBitmap;
    }

    private RoaringBitmap lessThan(String k, String v, boolean orEqual) {
        RoaringBitmap roaringBitmap;
        int kp = this.keyMap().get(k, -1);
        IntRefHashMap<RoaringBitmap> vidx = this.itemIndex().get(kp);
        if (vidx == null) {
            roaringBitmap = new RoaringBitmap();
        } else {
            RoaringBitmap set = new RoaringBitmap();
            int vp = this.findOffset(this.values(), v, orEqual ? 0 : -1);
            long t = this.tag(kp, vp);
            for (int i = this.tagOffset(t); i >= 0 && this.tagKey(this.tagIndex()[i]) == kp; --i) {
                set.or(vidx.get(this.tagValue(this.tagIndex()[i])));
            }
            roaringBitmap = set;
        }
        return roaringBitmap;
    }

    private RoaringBitmap strPattern(Query.PatternQuery q, int offset) {
        RoaringBitmap roaringBitmap;
        int kp = this.keyMap().get(q.k(), -1);
        IntRefHashMap<RoaringBitmap> vidx = this.itemIndex().get(kp);
        if (vidx == null) {
            roaringBitmap = new RoaringBitmap();
        } else {
            RoaringBitmap set = new RoaringBitmap();
            String prefix = q.pattern().prefix();
            if (prefix != null) {
                int vp = this.findOffset(this.values(), prefix, 0);
                long t = this.tag(kp, vp);
                for (int i = this.tagOffset(t); i < this.tagIndex().length && this.tagKey(this.tagIndex()[i]) == kp && this.values()[this.tagValue(this.tagIndex()[i])].startsWith(prefix); ++i) {
                    int v2 = this.tagValue(this.tagIndex()[i]);
                    if (!q.check(this.values()[v2])) continue;
                    set.or(vidx.get(v2));
                }
            } else {
                vidx.foreach((Function2<Object, RoaringBitmap, BoxedUnit>)(Function2 & Serializable)(v, items) -> {
                    RoaringTagIndex.$anonfun$strPattern$1(this, q, set, BoxesRunTime.unboxToInt((Object)v), items);
                    return BoxedUnit.UNIT;
                });
            }
            roaringBitmap = set;
        }
        return roaringBitmap;
    }

    private RoaringBitmap hasKey(String k, int offset) {
        int kp = this.keyMap().get(k, -1);
        RoaringBitmap matchSet = this.keyIndex().get(kp);
        return matchSet == null ? new RoaringBitmap() : this.withOffset(matchSet, offset);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int itemOffset(String v) {
        if (v == null) return 0;
        String string = v;
        String string2 = "";
        if (string == null) {
            if (string2 == null) return 0;
        } else if (string.equals(string2)) {
            return 0;
        }
        ItemId offsetV = ItemId$.MODULE$.apply(v);
        int pos = Arrays.binarySearch(this.itemIds(), offsetV);
        int n = pos < 0 ? -pos - 1 : pos;
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private int tagOffset(long v) {
        void var3_2;
        int pos;
        return v <= 0L ? 0 : ((pos = Arrays.binarySearch(this.tagIndex(), v)) == -1 ? 0 : (pos < -1 ? -pos - 1 : var3_2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int findOffset(String[] vs, String v, int n) {
        if (v == null) return 0;
        String string = v;
        String string2 = "";
        if (string == null) {
            if (string2 == null) return 0;
        } else if (string.equals(string2)) {
            return 0;
        }
        int pos = Arrays.binarySearch(vs, v);
        int n2 = pos >= 0 ? pos + n : -pos - 1;
        return n2;
    }

    private int findOffset$default$3() {
        return 1;
    }

    @Override
    public List<Tag> findTags(TagQuery query) {
        Nil$ nil$;
        Option<String> k = query.key();
        if (k.isDefined()) {
            String x$1 = query.offsetTag().value();
            Option<Query> x$2 = query.copy$default$1();
            Option<String> x$3 = query.copy$default$2();
            int x$4 = query.copy$default$4();
            nil$ = this.findValues(query.copy(x$2, x$3, x$1, x$4)).map((Function1 & Serializable)v -> Tag$.MODULE$.apply((String)k.get(), (String)v));
        } else {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    @Override
    public List<String> findKeys(TagQuery query) {
        List<String> list;
        if (query.query().isEmpty()) {
            int i;
            int end;
            int offset = this.findOffset(this.keys(), query.offset(), this.findOffset$default$3());
            Builder builder = List$.MODULE$.newBuilder();
            int n = end = this.keys().length - i > query.limit() ? i + query.limit() : this.keys().length;
            for (i = offset; i < end; ++i) {
                builder.$plus$eq((Object)this.keys()[i]);
            }
            list = (List<String>)builder.result();
        } else {
            Query q = (Query)query.query().getOrElse((Function0 & Serializable)() -> Query$True$.MODULE$);
            RoaringBitmap itemSet = this.findImpl(q, 0);
            int offset = this.findOffset(this.keys(), query.offset(), this.findOffset$default$3());
            BitSet results = new BitSet(this.keys().length);
            PeekableIntIterator iter = itemSet.getIntIterator();
            while (iter.hasNext()) {
                IntIntHashMap tags = this.itemTags()[iter.next()];
                tags.foreach((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable)(k, x$3) -> {
                    block0: {
                        if (k < offset) break block0;
                        results.set(k);
                    }
                });
            }
            list = this.createResultList(this.keys(), results, query.limit());
        }
        return list;
    }

    @Override
    public List<String> findValues(TagQuery query) {
        Predef$.MODULE$.require(query.key().isDefined());
        String k = (String)query.key().get();
        int kp = this.keyMap().get(k, -1);
        if (kp < 0) {
            return Nil$.MODULE$;
        }
        Query.HasKey has = new Query.HasKey(k);
        Query q2 = (Query)query.query().fold((Function0 & Serializable)() -> has, (Function1 & Serializable)q -> q.and(has));
        RoaringBitmap itemSet = this.findImpl(q2, 0);
        int offset = this.findOffset(this.values(), query.offset(), this.findOffset$default$3());
        BitSet results = new BitSet(this.values().length);
        int keyCardinality = this.itemIndex().get(kp).size();
        boolean attemptPruning = 100.0 * (double)keyCardinality / (double)this.items.length < 5.0;
        PeekableIntIterator iter = itemSet.getIntIterator();
        while (iter.hasNext()) {
            int i = iter.next();
            IntIntHashMap tags = this.itemTags()[i];
            int v = tags.get(kp, -1);
            if (v >= offset && !results.get(v)) {
                results.set(v);
                continue;
            }
            if (v < 0 || !attemptPruning) continue;
            itemSet.andNot(this.equal(kp, v));
            iter = itemSet.getIntIterator();
        }
        return this.createResultList(this.values(), results, query.limit());
    }

    private RoaringBitmap equal(int k, int v) {
        RoaringBitmap matchSet;
        IntRefHashMap<RoaringBitmap> vidx = this.itemIndex().get(k);
        return vidx == null ? new RoaringBitmap() : ((matchSet = vidx.get(v)) == null ? new RoaringBitmap() : matchSet);
    }

    @Override
    public List<T> findItems(TagQuery query) {
        int offset = this.itemOffset(query.offset());
        int limit = query.limit();
        RoaringBitmap intSet = (RoaringBitmap)query.query().fold((Function0 & Serializable)() -> this.withOffset(this.all(), offset), (Function1 & Serializable)q -> this.findImpl((Query)q, offset));
        return this.createResultList(this.items, intSet, limit);
    }

    private List<String> createResultList(String[] vs, BitSet matches, int limit) {
        Builder result = List$.MODULE$.newBuilder();
        int i = matches.nextSetBit(0);
        for (int count = 0; i >= 0 && count < limit; ++count) {
            result.$plus$eq((Object)vs[i]);
            i = matches.nextSetBit(i + 1);
        }
        return (List)result.result();
    }

    private <V> List<V> createResultList(Object vs, RoaringBitmap matches, int limit) {
        Builder result = List$.MODULE$.newBuilder();
        PeekableIntIterator iter = matches.getIntIterator();
        for (int count = 0; iter.hasNext() && count < limit; ++count) {
            result.$plus$eq(ScalaRunTime$.MODULE$.array_apply(vs, iter.next()));
        }
        return (List)result.result();
    }

    @Override
    public int size() {
        return this.size;
    }

    public static final /* synthetic */ void $anonfun$x$1$1(HashSet keySet$1, HashSet valueSet$1, String k, String v) {
        keySet$1.add(k);
        valueSet$1.add(v);
    }

    public static final /* synthetic */ void $anonfun$buildItemIndex$1(RoaringTagIndex $this, IntRefHashMap idx$1, IntRef pos$1, IntRefHashMap kidx$1, IntIntHashMap[] itemTags$1, LongHashSet tagsSet$1, String k, String v) {
        int vp;
        RoaringBitmap matchSet;
        int kp = $this.keyMap().get(k, -1);
        IntRefHashMap<RoaringBitmap> vidx = (IntRefHashMap<RoaringBitmap>)idx$1.get(kp);
        if (vidx == null) {
            vidx = new IntRefHashMap<RoaringBitmap>(-1, IntRefHashMap$.MODULE$.$lessinit$greater$default$2(), ManifestFactory$.MODULE$.classType(RoaringBitmap.class));
            idx$1.put(kp, vidx);
        }
        if ((matchSet = (RoaringBitmap)vidx.get(vp = $this.valueMap().get(v, -1))) == null) {
            matchSet = new RoaringBitmap();
            vidx.put(vp, matchSet);
        }
        matchSet.add(pos$1.elem);
        matchSet = (RoaringBitmap)kidx$1.get(kp);
        if (matchSet == null) {
            matchSet = new RoaringBitmap();
            kidx$1.put(kp, matchSet);
        }
        matchSet.add(pos$1.elem);
        itemTags$1[pos$1.elem].put(kp, vp);
        long t = (long)kp << 32 | (long)vp;
        tagsSet$1.add(t);
    }

    public static final /* synthetic */ void $anonfun$strPattern$1(RoaringTagIndex $this, Query.PatternQuery q$1, RoaringBitmap set$1, int v, RoaringBitmap items) {
        block0: {
            if (!q$1.check($this.values()[v])) break block0;
            set$1.or(items);
        }
    }

    public RoaringTagIndex(T[] items, IndexStats stats) {
        this.items = items;
        this.stats = stats;
        this.idComparator = new Comparator<T>(null){

            public Comparator<T> reversed() {
                return Comparator.super.reversed();
            }

            public Comparator<T> thenComparing(Comparator<? super T> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public <U> Comparator<T> thenComparing(Function<? super T, ? extends U> x$1, Comparator<? super U> x$2) {
                return Comparator.super.thenComparing(x$1, x$2);
            }

            public <U extends Comparable<? super U>> Comparator<T> thenComparing(Function<? super T, ? extends U> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public Comparator<T> thenComparingInt(ToIntFunction<? super T> x$1) {
                return Comparator.super.thenComparingInt(x$1);
            }

            public Comparator<T> thenComparingLong(ToLongFunction<? super T> x$1) {
                return Comparator.super.thenComparingLong(x$1);
            }

            public Comparator<T> thenComparingDouble(ToDoubleFunction<? super T> x$1) {
                return Comparator.super.thenComparingDouble(x$1);
            }

            public int compare(T t1, T t2) {
                return t1.id().compareTo(t2.id());
            }
        };
        RoaringBitmap set = new RoaringBitmap();
        set.add(0L, (long)items.length);
        this.all = set;
        HashSet keySet = new HashSet(items.length);
        HashSet valueSet = new HashSet(items.length);
        for (int pos = 0; pos < items.length; ++pos) {
            items[pos].foreach((Function2<String, String, BoxedUnit>)(Function2 & Serializable)(k, v) -> {
                RoaringTagIndex.$anonfun$x$1$1(keySet, valueSet, k, v);
                return BoxedUnit.UNIT;
            });
        }
        String[] ks = (String[])keySet.toArray((Object[])new String[keySet.size()]);
        String[] vs = (String[])valueSet.toArray((Object[])new String[valueSet.size()]);
        Arrays.sort(ks);
        Arrays.sort(vs);
        Tuple2 tuple2 = new Tuple2((Object)ks, (Object)vs);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String[] keys = (String[])tuple2._1();
        String[] values = (String[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)keys, (Object)values);
        this.x$1 = tuple22;
        this.keys = (String[])this.x$1._1();
        this.values = (String[])this.x$1._2();
        this.keyMap = this.createPositionMap(this.keys());
        this.valueMap = this.createPositionMap(this.values());
        Tuple5<ItemId[], IntRefHashMap<IntRefHashMap<RoaringBitmap>>, IntRefHashMap<RoaringBitmap>, long[], IntIntHashMap[]> tuple5 = this.buildItemIndex();
        if (tuple5 == null) {
            throw new MatchError(tuple5);
        }
        ItemId[] itemIds = (ItemId[])tuple5._1();
        IntRefHashMap itemIndex = (IntRefHashMap)tuple5._2();
        IntRefHashMap keyIndex = (IntRefHashMap)tuple5._3();
        long[] tagIndex = (long[])tuple5._4();
        IntIntHashMap[] itemTags = (IntIntHashMap[])tuple5._5();
        Tuple5 tuple52 = new Tuple5((Object)itemIds, (Object)itemIndex, (Object)keyIndex, (Object)tagIndex, (Object)itemTags);
        this.x$2 = tuple52;
        this.itemIds = (ItemId[])this.x$2._1();
        this.itemIndex = (IntRefHashMap)this.x$2._2();
        this.keyIndex = (IntRefHashMap)this.x$2._3();
        this.tagIndex = (long[])this.x$2._4();
        this.itemTags = (IntIntHashMap[])this.x$2._5();
        this.collectStats();
        this.size = items.length;
    }
}

