/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.db;

import com.netflix.atlas.core.db.AggregateCollector;
import com.netflix.atlas.core.db.AggregateCollector$;
import com.netflix.atlas.core.db.BlockStore;
import com.netflix.atlas.core.db.BlockStoreItem;
import com.netflix.atlas.core.db.BlockStoreItem$;
import com.netflix.atlas.core.db.Database;
import com.netflix.atlas.core.db.MemoryBlockStore;
import com.netflix.atlas.core.db.MemoryDatabase$;
import com.netflix.atlas.core.db.TimeSeriesBuffer;
import com.netflix.atlas.core.db.TimeSeriesBuffer$;
import com.netflix.atlas.core.index.BatchUpdateTagIndex;
import com.netflix.atlas.core.index.CachingTagIndex;
import com.netflix.atlas.core.index.IndexStats;
import com.netflix.atlas.core.index.RoaringTagIndex;
import com.netflix.atlas.core.index.TagQuery;
import com.netflix.atlas.core.index.TagQuery$;
import com.netflix.atlas.core.model.Block;
import com.netflix.atlas.core.model.CollectorStats;
import com.netflix.atlas.core.model.DataExpr;
import com.netflix.atlas.core.model.DataExpr$;
import com.netflix.atlas.core.model.Datapoint;
import com.netflix.atlas.core.model.DefaultSettings$;
import com.netflix.atlas.core.model.EvalContext;
import com.netflix.atlas.core.model.Query;
import com.netflix.atlas.core.model.Query$;
import com.netflix.atlas.core.model.TaggedItem;
import com.netflix.atlas.core.model.TimeSeries;
import com.netflix.atlas.core.model.TimeSeries$;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u0015c\u0001\u0002\u001c8\u0001\tC\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t-\u0002\u0011\t\u0011)A\u0005/\")a\f\u0001C\u0001?\"91\r\u0001b\u0001\n\u0013!\u0007B\u00025\u0001A\u0003%Q\rC\u0004j\u0001\t\u0007I\u0011\u00023\t\r)\u0004\u0001\u0015!\u0003f\u0011\u001dY\u0007A1A\u0005\n\u0011Da\u0001\u001c\u0001!\u0002\u0013)\u0007bB7\u0001\u0005\u0004%I\u0001\u001a\u0005\u0007]\u0002\u0001\u000b\u0011B3\t\u000f=\u0004!\u0019!C\u0005I\"1\u0001\u000f\u0001Q\u0001\n\u0015Dq!\u001d\u0001C\u0002\u0013%A\r\u0003\u0004s\u0001\u0001\u0006I!\u001a\u0005\bg\u0002\u0011\r\u0011\"\u0003u\u0011\u0019A\b\u0001)A\u0005k\"9\u0011\u0010\u0001b\u0001\n\u0013Q\bB\u0002@\u0001A\u0003%1\u0010C\u0004\u0000\u0001\t\u0007I\u0011\u0002>\t\u000f\u0005\u0005\u0001\u0001)A\u0005w\"I\u00111\u0001\u0001C\u0002\u0013%\u0011Q\u0001\u0005\t\u0003\u001b\u0001\u0001\u0015!\u0003\u0002\b!I\u0011q\u0002\u0001C\u0002\u0013%\u0011\u0011\u0003\u0005\t\u0003G\u0001\u0001\u0015!\u0003\u0002\u0014!I\u0011Q\u0005\u0001C\u0002\u0013%\u0011q\u0005\u0005\t\u0003k\u0001\u0001\u0015!\u0003\u0002*!I\u0011q\u0006\u0001C\u0002\u0013\u0005\u0011q\u0007\u0005\t\u0003\u000b\u0002\u0001\u0015!\u0003\u0002:!A\u0011q\t\u0001C\u0002\u0013%A\u000fC\u0004\u0002J\u0001\u0001\u000b\u0011B;\u0006\r\u0005-\u0003\u0001AA'\u0011%\tI\u0007\u0001b\u0001\n\u0013\tY\u0007\u0003\u0005\u0002\f\u0002\u0001\u000b\u0011BA7\u0011%\ti\t\u0001b\u0001\n\u0013\ty\t\u0003\u0005\u0002\u001e\u0002\u0001\u000b\u0011BAI\r\u0019\ty\n\u0001\u0004\u0002\"\"1a,\nC\u0001\u0003_Cq!a-&\t\u0003\t)\f\u0003\u0004\u0002>\u0002!I\u0001\u001e\u0005\b\u0003\u007f\u0003A\u0011AA[\u0011\u001d\t\t\r\u0001C\u0005\u0003\u0007Dq!!3\u0001\t\u0003\tY\rC\u0004\u0002J\u0002!\t!!8\t\u000f\u0005U\b\u0001\"\u0001\u0002x\"9\u00111 \u0001\u0005\n\u0005u\bb\u0002B\u0005\u0001\u0011%!1\u0002\u0005\b\u0005C\u0001A\u0011\u0002B\u0012\u0011\u001d\u0011i\u0003\u0001C\u0001\u0005_9qA!\u000e8\u0011\u0003\u00119D\u0002\u00047o!\u0005!\u0011\b\u0005\u0007=N\"\tAa\u000f\t\u000f\tu2\u0007\"\u0001\u0003@\tqQ*Z7pef$\u0015\r^1cCN,'B\u0001\u001d:\u0003\t!'M\u0003\u0002;w\u0005!1m\u001c:f\u0015\taT(A\u0003bi2\f7O\u0003\u0002?\u007f\u00059a.\u001a;gY&D(\"\u0001!\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001\u0019\u0015\n\u0005\u0002E\u000f6\tQIC\u0001G\u0003\u0015\u00198-\u00197b\u0013\tAUI\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0015.k\u0011aN\u0005\u0003\u0019^\u0012\u0001\u0002R1uC\n\f7/Z\u0001\te\u0016<\u0017n\u001d;ssB\u0011q\nV\u0007\u0002!*\u0011\u0011KU\u0001\u0004CBL'BA*>\u0003%\u0019\b/Z2uCR|'/\u0003\u0002V!\nA!+Z4jgR\u0014\u00180\u0001\u0004d_:4\u0017n\u001a\t\u00031rk\u0011!\u0017\u0006\u0003-jS!aW \u0002\u0011QL\b/Z:bM\u0016L!!X-\u0003\r\r{gNZ5h\u0003\u0019a\u0014N\\5u}Q\u0019\u0001-\u00192\u0011\u0005)\u0003\u0001\"B'\u0004\u0001\u0004q\u0005\"\u0002,\u0004\u0001\u00049\u0016\u0001D9vKJLX*\u001a;sS\u000e\u001cX#A3\u0011\u0005=3\u0017BA4Q\u0005\u001d\u0019u.\u001e8uKJ\fQ\"];feflU\r\u001e:jGN\u0004\u0013aC9vKJL(\t\\8dWN\fA\"];fef\u0014En\\2lg\u0002\n!\"Y4he\ncwnY6t\u0003-\twm\u001a:CY>\u001c7n\u001d\u0011\u0002\u0015E,XM]=MS:,7/A\u0006rk\u0016\u0014\u0018\u0010T5oKN\u0004\u0013\u0001F9vKJL\u0018J\u001c9vi\u0012\u000bG/\u00199pS:$8/A\u000brk\u0016\u0014\u00180\u00138qkR$\u0015\r^1q_&tGo\u001d\u0011\u0002+E,XM]=PkR\u0004X\u000f\u001e#bi\u0006\u0004x.\u001b8ug\u00061\u0012/^3ss>+H\u000f];u\t\u0006$\u0018\r]8j]R\u001c\b%\u0001\u0003ti\u0016\u0004X#A;\u0011\u0005\u00113\u0018BA<F\u0005\u0011auN\\4\u0002\u000bM$X\r\u001d\u0011\u0002\u0013\tdwnY6TSj,W#A>\u0011\u0005\u0011c\u0018BA?F\u0005\rIe\u000e^\u0001\u000bE2|7m[*ju\u0016\u0004\u0013!\u00038v[\ncwnY6t\u0003)qW/\u001c\"m_\u000e\\7\u000fI\u0001\ti\u0016\u001cH/T8eKV\u0011\u0011q\u0001\t\u0004\t\u0006%\u0011bAA\u0006\u000b\n9!i\\8mK\u0006t\u0017!\u0003;fgRlu\u000eZ3!\u0003\u0019awnZ4feV\u0011\u00111\u0003\t\u0005\u0003+\ty\"\u0004\u0002\u0002\u0018)!\u0011\u0011DA\u000e\u0003\u0015\u0019HN\u001a\u001bk\u0015\t\ti\"A\u0002pe\u001eLA!!\t\u0002\u0018\t1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%A\u0003ti\u0006$8/\u0006\u0002\u0002*A!\u00111FA\u0019\u001b\t\tiCC\u0002\u00020e\nQ!\u001b8eKbLA!a\r\u0002.\tQ\u0011J\u001c3fqN#\u0018\r^:\u0002\rM$\u0018\r^:!+\t\tI\u0004\u0005\u0004\u0002,\u0005m\u0012qH\u0005\u0005\u0003{\tiCA\nCCR\u001c\u0007.\u00169eCR,G+Y4J]\u0012,\u0007\u0010E\u0002K\u0003\u0003J1!a\u00118\u00059\u0011En\\2l'R|'/Z%uK6\fa!\u001b8eKb\u0004\u0013A\u0003:fEVLG\u000eZ!hK\u0006Y!/\u001a2vS2$\u0017iZ3!\u0005\u0019IE/Z7JIBA\u0011qJA/\u0003G\n\u0019G\u0004\u0003\u0002R\u0005e\u0003cAA*\u000b6\u0011\u0011Q\u000b\u0006\u0004\u0003/\n\u0015A\u0002\u001fs_>$h(C\u0002\u0002\\\u0015\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA0\u0003C\u00121!T1q\u0015\r\tY&\u0012\t\u0005\u0003\u001f\n)'\u0003\u0003\u0002h\u0005\u0005$AB*ue&tw-\u0001\u0003eCR\fWCAA7!!\ty'! \u0002\u0002\u0006\u0015UBAA9\u0015\u0011\t\u0019(!\u001e\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002x\u0005e\u0014\u0001B;uS2T!!a\u001f\u0002\t)\fg/Y\u0005\u0005\u0003\u007f\n\tHA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u00042!a!!\u001b\u0005\u0001\u0001c\u0001&\u0002\b&\u0019\u0011\u0011R\u001c\u0003\u0015\tcwnY6Ti>\u0014X-A\u0003eCR\f\u0007%A\u0007sK\n,\u0018\u000e\u001c3UQJ,\u0017\rZ\u000b\u0003\u0003#\u0003B!a%\u0002\u001a6\u0011\u0011Q\u0013\u0006\u0005\u0003/\u000bI(\u0001\u0003mC:<\u0017\u0002BAN\u0003+\u0013a\u0001\u00165sK\u0006$\u0017A\u0004:fEVLG\u000e\u001a+ie\u0016\fG\r\t\u0002\f%\u0016\u0014W/\u001b7e)\u0006\u001c8nE\u0003&\u0003G\u000bI\u000b\u0005\u0003\u0002\u0014\u0006\u0015\u0016\u0002BAT\u0003+\u0013aa\u00142kK\u000e$\b\u0003BAJ\u0003WKA!!,\u0002\u0016\nA!+\u001e8oC\ndW\r\u0006\u0002\u00022B\u0019\u00111Q\u0013\u0002\u0007I,h\u000e\u0006\u0002\u00028B\u0019A)!/\n\u0007\u0005mVI\u0001\u0003V]&$\u0018a\u00018po\u00069!/\u001a2vS2$\u0017!F4fi>\u00138I]3bi\u0016\u0014En\\2l'R|'/\u001a\u000b\u0005\u0003\u000b\u000b)\rC\u0004\u0002H*\u0002\r!!!\u0002\u0005%$\u0017AB;qI\u0006$X\r\u0006\u0003\u00028\u00065\u0007bBAhW\u0001\u0007\u0011\u0011[\u0001\u0003IB\u0004B!a5\u0002Z6\u0011\u0011Q\u001b\u0006\u0004\u0003/L\u0014!B7pI\u0016d\u0017\u0002BAn\u0003+\u0014\u0011\u0002R1uCB|\u0017N\u001c;\u0015\t\u0005]\u0016q\u001c\u0005\b\u0003Cd\u0003\u0019AAr\u0003\t!7\u000f\u0005\u0004\u0002f\u0006=\u0018\u0011\u001b\b\u0005\u0003O\fYO\u0004\u0003\u0002T\u0005%\u0018\"\u0001$\n\u0007\u00055X)A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E\u00181\u001f\u0002\u0005\u0019&\u001cHOC\u0002\u0002n\u0016\u000baA]8mYV\u0004H\u0003BA\\\u0003sDq!a4.\u0001\u0004\t\t.A\u0005cY>\u001c7.Q4heR\u001910a@\t\u000f\t\u0005a\u00061\u0001\u0003\u0004\u0005!Q\r\u001f9s!\u0011\t\u0019N!\u0002\n\t\t\u001d\u0011Q\u001b\u0002\t\t\u0006$\u0018-\u0012=qe\u0006YQ\r_3dkR,\u0017*\u001c9m)\u0019\u0011iA!\u0006\u0003 A1\u0011Q]Ax\u0005\u001f\u0001B!a5\u0003\u0012%!!1CAk\u0005)!\u0016.\\3TKJLWm\u001d\u0005\b\u0005/y\u0003\u0019\u0001B\r\u0003\u001d\u0019wN\u001c;fqR\u0004B!a5\u0003\u001c%!!QDAk\u0005-)e/\u00197D_:$X\r\u001f;\t\u000f\t\u0005q\u00061\u0001\u0003\u0004\u0005Ya-\u001b8bYZ\u000bG.^3t)!\u0011iA!\n\u0003(\t%\u0002b\u0002B\fa\u0001\u0007!\u0011\u0004\u0005\b\u0005\u0003\u0001\u0004\u0019\u0001B\u0002\u0011\u001d\u0011Y\u0003\ra\u0001\u0005\u001b\t!A^:\u0002\u000f\u0015DXmY;uKR1!Q\u0002B\u0019\u0005gAqAa\u00062\u0001\u0004\u0011I\u0002C\u0004\u0003\u0002E\u0002\rAa\u0001\u0002\u001d5+Wn\u001c:z\t\u0006$\u0018MY1tKB\u0011!jM\n\u0003g\r#\"Aa\u000e\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007\u0001\u0014\t\u0005\u0003\u0004\u0003DU\u0002\raV\u0001\u0004G\u001a<\u0007")
public class MemoryDatabase
implements Database {
    private final Registry registry;
    private final Counter queryMetrics;
    private final Counter queryBlocks;
    private final Counter aggrBlocks;
    private final Counter queryLines;
    private final Counter queryInputDatapoints;
    private final Counter queryOutputDatapoints;
    private final long step;
    private final int blockSize;
    private final int numBlocks;
    private final boolean testMode;
    private final Logger com$netflix$atlas$core$db$MemoryDatabase$$logger;
    private final IndexStats stats;
    private final BatchUpdateTagIndex<BlockStoreItem> index;
    private final long rebuildAge;
    private final ConcurrentHashMap<Map<String, String>, BlockStore> data;
    private final Thread rebuildThread;

    public static MemoryDatabase apply(Config config) {
        return MemoryDatabase$.MODULE$.apply(config);
    }

    private Counter queryMetrics() {
        return this.queryMetrics;
    }

    private Counter queryBlocks() {
        return this.queryBlocks;
    }

    private Counter aggrBlocks() {
        return this.aggrBlocks;
    }

    private Counter queryLines() {
        return this.queryLines;
    }

    private Counter queryInputDatapoints() {
        return this.queryInputDatapoints;
    }

    private Counter queryOutputDatapoints() {
        return this.queryOutputDatapoints;
    }

    private long step() {
        return this.step;
    }

    private int blockSize() {
        return this.blockSize;
    }

    private int numBlocks() {
        return this.numBlocks;
    }

    private boolean testMode() {
        return this.testMode;
    }

    public Logger com$netflix$atlas$core$db$MemoryDatabase$$logger() {
        return this.com$netflix$atlas$core$db$MemoryDatabase$$logger;
    }

    private IndexStats stats() {
        return this.stats;
    }

    public BatchUpdateTagIndex<BlockStoreItem> index() {
        return this.index;
    }

    private long rebuildAge() {
        return this.rebuildAge;
    }

    private ConcurrentHashMap<Map<String, String>, BlockStore> data() {
        return this.data;
    }

    private Thread rebuildThread() {
        return this.rebuildThread;
    }

    private long now() {
        return this.registry.clock().wallTime();
    }

    public void rebuild() {
        block1: {
            if (this.testMode() || this.now() - ((BatchUpdateTagIndex)this.index()).buildTime() <= this.rebuildAge()) break block1;
            this.com$netflix$atlas$core$db$MemoryDatabase$$logger().info("rebuilding metadata index");
            ((BatchUpdateTagIndex)this.index()).rebuildIndex();
            long windowSize = (long)(this.numBlocks() * this.blockSize()) * this.step();
            long cutoff = this.now() - windowSize;
            Iterator<Map.Entry<Map<String, String>, BlockStore>> iter = this.data().entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Map<String, String>, BlockStore> entry = iter.next();
                entry.getValue().cleanup(cutoff);
                if (entry.getValue().hasData()) continue;
                iter.remove();
            }
            this.com$netflix$atlas$core$db$MemoryDatabase$$logger().info(new StringBuilder(40).append("done rebuilding metadata index, ").append(((BatchUpdateTagIndex)this.index()).size()).append(" metrics").toString());
            BlockStoreItem$.MODULE$.retain((Function1<Object, Object>)(JFunction1.mcZJ.sp & Serializable)x$1 -> x$1 > cutoff);
        }
    }

    private BlockStore getOrCreateBlockStore(Map<String, String> id) {
        return this.data().computeIfAbsent(id, x$2 -> new MemoryBlockStore(this.step(), this.blockSize(), this.numBlocks()));
    }

    public void update(Datapoint dp) {
        BlockStore blkStore = this.getOrCreateBlockStore(dp.tags());
        blkStore.update(dp.timestamp(), dp.value(), blkStore.update$default$3());
        ((BatchUpdateTagIndex)this.index()).update(BlockStoreItem$.MODULE$.create(dp.tags(), blkStore));
    }

    public void update(List<Datapoint> ds) {
        ds.foreach((Function1 & Serializable)dp -> {
            this.update(dp);
            return BoxedUnit.UNIT;
        });
    }

    public void rollup(Datapoint dp) {
        BlockStore blkStore = this.getOrCreateBlockStore(dp.tags());
        blkStore.update(dp.timestamp(), dp.value(), true);
        ((BatchUpdateTagIndex)this.index()).update(BlockStoreItem$.MODULE$.create(dp.tags(), blkStore));
    }

    private int blockAggr(DataExpr expr) {
        int n;
        block7: {
            DataExpr dataExpr;
            while (true) {
                if ((dataExpr = expr) instanceof DataExpr.GroupBy) {
                    DataExpr.GroupBy groupBy = (DataExpr.GroupBy)dataExpr;
                    expr = groupBy.af();
                    continue;
                }
                if (dataExpr instanceof DataExpr.All) {
                    n = 0;
                    break block7;
                }
                if (dataExpr instanceof DataExpr.Sum) {
                    n = 0;
                    break block7;
                }
                if (dataExpr instanceof DataExpr.Count) {
                    n = 1;
                    break block7;
                }
                if (dataExpr instanceof DataExpr.Min) {
                    n = 2;
                    break block7;
                }
                if (dataExpr instanceof DataExpr.Max) {
                    n = 3;
                    break block7;
                }
                if (!(dataExpr instanceof DataExpr.Consolidation)) break;
                DataExpr.Consolidation consolidation = (DataExpr.Consolidation)dataExpr;
                DataExpr.AggregateFunction af = consolidation.af();
                expr = af;
            }
            throw new MatchError((Object)dataExpr);
        }
        return n;
    }

    private List<TimeSeries> executeImpl(EvalContext context, DataExpr expr) {
        long cfStep = context.step();
        Predef$.MODULE$.require(cfStep >= this.step(), (Function0 & Serializable)() -> "step for query must be >= step for the database");
        Predef$.MODULE$.require(cfStep % this.step() == 0L, (Function0 & Serializable)() -> "consolidated step must be multiple of db step");
        TagQuery query = new TagQuery((Option<Query>)new Some((Object)expr.query()), TagQuery$.MODULE$.apply$default$2(), TagQuery$.MODULE$.apply$default$3(), TagQuery$.MODULE$.apply$default$4());
        int aggr = this.blockAggr(expr);
        AggregateCollector collector = AggregateCollector$.MODULE$.apply(expr);
        long end = context.end();
        int multiple = (int)(cfStep / this.step());
        long s = context.start() / cfStep;
        long e = end / cfStep;
        long bs = s * (long)multiple;
        long be = e * (long)multiple;
        long stepLength = be - bs + 1L;
        long cfStepLength = stepLength / (long)multiple;
        long bufStart = bs * this.step();
        long bufEnd = bufStart + cfStepLength * cfStep - cfStep;
        ((BatchUpdateTagIndex)this.index()).findItems(query).foreach((Function1 & Serializable)item -> {
            MemoryDatabase.$anonfun$executeImpl$4(this, be, bs, collector, aggr, expr, multiple, cfStep, bufStart, bufEnd, item);
            return BoxedUnit.UNIT;
        });
        CollectorStats stats = collector.stats();
        this.queryMetrics().increment(stats.inputLines());
        this.queryLines().increment(stats.outputLines());
        this.queryInputDatapoints().increment(stats.inputDatapoints());
        this.queryOutputDatapoints().increment(stats.outputDatapoints());
        List vs = (List)collector.result().map((Function1 & Serializable)t -> DataExpr$.MODULE$.withDefaultLabel(expr, (TimeSeries)t)).sortWith((Function2 & Serializable)(x$3, x$4) -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.$less$extension(Predef$.MODULE$.augmentString(x$3.label()), x$4.label())));
        return this.finalValues(context, expr, (List<TimeSeries>)vs);
    }

    private List<TimeSeries> finalValues(EvalContext context, DataExpr expr, List<TimeSeries> vs) {
        DataExpr dataExpr = expr;
        List list = dataExpr instanceof DataExpr.AggregateFunction && vs.isEmpty() ? (List)new .colon.colon((Object)TimeSeries$.MODULE$.noData(context.step()), (List)Nil$.MODULE$) : vs;
        return list;
    }

    @Override
    public List<TimeSeries> execute(EvalContext context, DataExpr expr) {
        List list;
        long offset = expr.offset().toMillis();
        if (offset == 0L) {
            list = this.executeImpl(context, expr);
        } else {
            EvalContext offsetContext = context.withOffset(expr.offset().toMillis());
            list = this.executeImpl(offsetContext, expr).map((Function1 & Serializable)t -> t.offset(offset));
        }
        return list;
    }

    private static final TimeSeriesBuffer newBuffer$1(Map tags, DataExpr expr$1, long cfStep$1, long bufStart$1, long bufEnd$1) {
        Map map;
        DataExpr dataExpr = expr$1;
        if (dataExpr instanceof DataExpr.All) {
            map = tags;
        } else {
            Set resultKeys = (Set)Query$.MODULE$.exactKeys(expr$1.query()).$plus$plus(expr$1.finalGrouping());
            map = tags.filterKeys((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)resultKeys.contains((Object)elem))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        Map resultTags = map;
        return TimeSeriesBuffer$.MODULE$.apply((Map<String, String>)resultTags, cfStep$1, bufStart$1, bufEnd$1);
    }

    public static final /* synthetic */ void $anonfun$executeImpl$4(MemoryDatabase $this, long be$1, long bs$1, AggregateCollector collector$1, int aggr$1, DataExpr expr$1, int multiple$1, long cfStep$1, long bufStart$1, long bufEnd$1, BlockStoreItem item) {
        item.blocks().blockList().foreach((Function1 & Serializable)b -> {
            Object object;
            $this.queryBlocks().increment();
            long blockEnd = b.start() + (long)(b.size() + 1) * $this.step();
            if (b.start() <= be$1 * $this.step() && blockEnd >= bs$1 * $this.step()) {
                $this.aggrBlocks().increment();
                object = BoxesRunTime.boxToInteger((int)collector$1.add(item.tags(), (List<Block>)((List)new .colon.colon(b, (List)Nil$.MODULE$)), aggr$1, expr$1.cf(), multiple$1, (Function1<Map<String, String>, TimeSeriesBuffer>)(Function1 & Serializable)tags -> MemoryDatabase.newBuffer$1(tags, expr$1, cfStep$1, bufStart$1, bufEnd$1)));
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
    }

    public MemoryDatabase(Registry registry, Config config) {
        block0: {
            this.registry = registry;
            this.queryMetrics = registry.counter("atlas.db.queryMetrics");
            this.queryBlocks = registry.counter("atlas.db.queryBlocks");
            this.aggrBlocks = registry.counter("atlas.db.aggrBlocks");
            this.queryLines = registry.counter("atlas.db.queryLines");
            this.queryInputDatapoints = registry.counter("atlas.db.queryInputDatapoints");
            this.queryOutputDatapoints = registry.counter("atlas.db.queryOutputDatapoints");
            this.step = DefaultSettings$.MODULE$.stepSize();
            this.blockSize = config.getInt("block-size");
            this.numBlocks = config.getInt("num-blocks");
            this.testMode = config.getBoolean("test-mode");
            this.com$netflix$atlas$core$db$MemoryDatabase$$logger = LoggerFactory.getLogger(this.getClass());
            this.stats = new IndexStats(registry);
            this.index = new BatchUpdateTagIndex(registry, (Function1 & Serializable)items -> new CachingTagIndex(new RoaringTagIndex((TaggedItem[])items, this.stats())), ClassTag$.MODULE$.apply(BlockStoreItem.class));
            this.rebuildAge = config.getDuration("rebuild-frequency", TimeUnit.MILLISECONDS);
            this.data = new ConcurrentHashMap();
            this.rebuildThread = new Thread((Runnable)new RebuildTask(), "MemoryDatabaseRebuildIndex");
            if (this.testMode()) break block0;
            this.rebuildThread().start();
        }
    }

    public final class RebuildTask
    implements Runnable {
        @Override
        public void run() {
            while (true) {
                try {
                    MemoryDatabase.this.rebuild();
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception e) {
                    MemoryDatabase.this.com$netflix$atlas$core$db$MemoryDatabase$$logger().warn("failed to rebuild index", (Throwable)e);
                    continue;
                }
                break;
            }
        }

        public RebuildTask() {
            if (MemoryDatabase.this == null) {
                throw null;
            }
        }
    }
}

