/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.db;

import com.netflix.atlas.core.db.BlockStats$;
import com.netflix.atlas.core.db.BlockStore;
import com.netflix.atlas.core.db.MemoryBlockStore$;
import com.netflix.atlas.core.model.ArrayBlock;
import com.netflix.atlas.core.model.Block;
import com.netflix.atlas.core.model.Block$;
import com.netflix.atlas.core.model.MutableBlock;
import com.netflix.atlas.core.model.RollupBlock;
import com.netflix.atlas.core.util.ArrayHelper$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Builder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tMq!B\u0017/\u0011\u0003Id!B\u001e/\u0011\u0003a\u0004\"B\"\u0002\t\u0003!\u0005bB#\u0002\u0005\u0004%IA\u0012\u0005\u0007\u001f\u0006\u0001\u000b\u0011B$\t\u000fA\u000b!\u0019!C\u0005#\"1Q+\u0001Q\u0001\nICqAV\u0001C\u0002\u0013%\u0011\u000b\u0003\u0004X\u0003\u0001\u0006IA\u0015\u0005\b1\u0006\u0011\r\u0011\"\u0003Z\u0011\u0019Q\u0017\u0001)A\u00055\")1.\u0001C\u0001Y\")!/\u0001C\u0001g\")a0\u0001C\u0001\u007f\"9\u0011\u0011B\u0001\u0005\u0002\u0005-a!B\u001e/\u0001\u0005E\u0001\"CA\r\u001f\t\u0005\t\u0015!\u0003w\u0011%\tYb\u0004B\u0001B\u0003%1\u0010C\u0005\u0002\u001e=\u0011\t\u0011)A\u0005w\"11i\u0004C\u0001\u0003?A\u0011\"!\u000b\u0010\u0005\u0004%I!a\u000b\t\u000f\u00055r\u0002)A\u0005m\"Q\u0011qF\bC\u0002\u0013\u0005a&!\r\t\u0011\u0005}r\u0002)A\u0005\u0003gA!\"!\u0011\u0010\u0001\u0004%\tALA\"\u0011)\t)e\u0004a\u0001\n\u0003q\u0013q\t\u0005\b\u0003\u001bz\u0001\u0015)\u0003|\u00111\tye\u0004a\u0001\u0002\u0004%\tALA)\u00111\tIf\u0004a\u0001\u0002\u0004%\tALA.\u0011-\tyf\u0004a\u0001\u0002\u0003\u0006K!a\u0015\t\u000f\u0005\u0005t\u0002\"\u0003\u0002d!9\u0011\u0011N\b\u0005\n\u0005-\u0004bBA8\u001f\u0011%\u0011\u0011\u000f\u0005\n\u0003\u007fz\u0001\u0019!C\u0001\u0003\u0003C\u0011\"a!\u0010\u0001\u0004%\t!!\"\t\u0011\u0005%u\u0002)Q\u0005\u0003sBq!a#\u0010\t\u0003\ti\tC\u0004\u0002\u0014>!\t!!&\t\u000f\u0005Mu\u0002\"\u0001\u0002(\"9\u00111S\b\u0005\u0002\u0005-\u0006bBAf\u001f\u0011%\u0011Q\u001a\u0005\b\u0003G|A\u0011AAs\u0011\u001d\tIo\u0004C\u0001\u0003WDq!a=\u0010\t\u0003\t)\u0010C\u0004\u0002\u0000>!\tE!\u0001\u0002!5+Wn\u001c:z\u00052|7m[*u_J,'BA\u00181\u0003\t!'M\u0003\u00022e\u0005!1m\u001c:f\u0015\t\u0019D'A\u0003bi2\f7O\u0003\u00026m\u00059a.\u001a;gY&D(\"A\u001c\u0002\u0007\r|Wn\u0001\u0001\u0011\u0005i\nQ\"\u0001\u0018\u0003!5+Wn\u001c:z\u00052|7m[*u_J,7CA\u0001>!\tq\u0014)D\u0001@\u0015\u0005\u0001\u0015!B:dC2\f\u0017B\u0001\"@\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!O\u0001\te\u0016<\u0017n\u001d;ssV\tq\t\u0005\u0002I\u001b6\t\u0011J\u0003\u0002K\u0017\u0006\u0019\u0011\r]5\u000b\u00051#\u0014!C:qK\u000e$\u0018\r^8s\u0013\tq\u0015JA\tD_6\u0004xn]5uKJ+w-[:uef\f\u0011B]3hSN$(/\u001f\u0011\u0002\r\u0005dGn\\2t+\u0005\u0011\u0006C\u0001%T\u0013\t!\u0016JA\u0004D_VtG/\u001a:\u0002\u000f\u0005dGn\\2tA\u00051!/Z;tK\u0012\fqA]3vg\u0016$\u0007%A\bge\u0016,\u0017I\u001d:bs\ncwnY6t+\u0005Q\u0006cA.cI6\tAL\u0003\u0002^=\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005}\u0003\u0017\u0001B;uS2T\u0011!Y\u0001\u0005U\u00064\u0018-\u0003\u0002d9\n\u0011\u0012I\u001d:bs\ncwnY6j]\u001e\fV/Z;f!\t)\u0007.D\u0001g\u0015\t9\u0007'A\u0003n_\u0012,G.\u0003\u0002jM\nQ\u0011I\u001d:bs\ncwnY6\u0002!\u0019\u0014X-Z!se\u0006L(\t\\8dWN\u0004\u0013A\u00044sK\u0016\f%O]1z\u00052|7m\u001b\u000b\u0003[B\u0004\"A\u00108\n\u0005=|$\u0001B+oSRDQ!]\u0006A\u0002\u0011\f\u0011AY\u0001\u000e]\u0016<\u0018I\u001d:bs\ncwnY6\u0015\u0007\u0011$\u0018\u0010C\u0003v\u0019\u0001\u0007a/A\u0003ti\u0006\u0014H\u000f\u0005\u0002?o&\u0011\u0001p\u0010\u0002\u0005\u0019>tw\rC\u0003{\u0019\u0001\u000710\u0001\u0003tSj,\u0007C\u0001 }\u0013\tixHA\u0002J]R\fqB\u001a:fKJ{G\u000e\\;q\u00052|7m\u001b\u000b\u0004[\u0006\u0005\u0001BB9\u000e\u0001\u0004\t\u0019\u0001E\u0002f\u0003\u000bI1!a\u0002g\u0005-\u0011v\u000e\u001c7va\ncwnY6\u0002\u001d9,wOU8mYV\u0004(\t\\8dWR1\u00111AA\u0007\u0003\u001fAQ!\u001e\bA\u0002YDQA\u001f\bA\u0002m\u001cBaD\u001f\u0002\u0014A\u0019!(!\u0006\n\u0007\u0005]aF\u0001\u0006CY>\u001c7n\u0015;pe\u0016\fAa\u001d;fa\u0006I!\r\\8dWNK'0Z\u0001\n]Vl'\t\\8dWN$\u0002\"!\t\u0002$\u0005\u0015\u0012q\u0005\t\u0003u=Aa!!\u0007\u0014\u0001\u00041\bBBA\u000e'\u0001\u00071\u0010\u0003\u0004\u0002\u001eM\u0001\ra_\u0001\nE2|7m[*uKB,\u0012A^\u0001\u000bE2|7m[*uKB\u0004\u0013A\u00022m_\u000e\\7/\u0006\u0002\u00024A)a(!\u000e\u0002:%\u0019\u0011qG \u0003\u000b\u0005\u0013(/Y=\u0011\u0007\u0015\fY$C\u0002\u0002>\u0019\u0014QA\u00117pG.\fqA\u00197pG.\u001c\b%\u0001\u0006dkJ\u0014XM\u001c;Q_N,\u0012a_\u0001\u000fGV\u0014(/\u001a8u!>\u001cx\fJ3r)\ri\u0017\u0011\n\u0005\t\u0003\u0017J\u0012\u0011!a\u0001w\u0006\u0019\u0001\u0010J\u0019\u0002\u0017\r,(O]3oiB{7\u000fI\u0001\rGV\u0014(/\u001a8u\u00052|7m[\u000b\u0003\u0003'\u00022!ZA+\u0013\r\t9F\u001a\u0002\r\u001bV$\u0018M\u00197f\u00052|7m[\u0001\u0011GV\u0014(/\u001a8u\u00052|7m[0%KF$2!\\A/\u0011%\tY\u0005HA\u0001\u0002\u0004\t\u0019&A\u0007dkJ\u0014XM\u001c;CY>\u001c7\u000eI\u0001\u0005]\u0016DH\u000fF\u0002|\u0003KBa!a\u001a\u001f\u0001\u0004Y\u0018a\u00019pg\u0006Q\u0011\r\\5h]N#\u0018M\u001d;\u0015\u0007Y\fi\u0007C\u0003v?\u0001\u0007a/\u0001\u0005oK^\u0014En\\2l)\u0015i\u00171OA;\u0011\u0015)\b\u00051\u0001w\u0011\u001d\t9\b\ta\u0001\u0003s\naA]8mYV\u0004\bc\u0001 \u0002|%\u0019\u0011QP \u0003\u000f\t{w\u000e\\3b]\u00069\u0001.Y:ECR\fWCAA=\u0003-A\u0017m\u001d#bi\u0006|F%Z9\u0015\u00075\f9\tC\u0005\u0002L\t\n\t\u00111\u0001\u0002z\u0005A\u0001.Y:ECR\f\u0007%A\u0004dY\u0016\fg.\u001e9\u0015\u00075\fy\t\u0003\u0004\u0002\u0012\u0012\u0002\rA^\u0001\u0007GV$xN\u001a4\u0002\rU\u0004H-\u0019;f)\u001di\u0017qSAN\u0003KCa!!'&\u0001\u00041\u0018!\u0003;j[\u0016\u001cH/Y7q\u0011\u001d\ti*\na\u0001\u0003?\u000bQA^1mk\u0016\u00042APAQ\u0013\r\t\u0019k\u0010\u0002\u0007\t>,(\r\\3\t\u0013\u0005]T\u0005%AA\u0002\u0005eDcA7\u0002*\"1\u0011\u0011\u0014\u0014A\u0002Y$R!\\AW\u0003_CQ!^\u0014A\u0002YDq!!-(\u0001\u0004\t\u0019,\u0001\u0004wC2,Xm\u001d\t\u0007\u0003k\u000b)-a(\u000f\t\u0005]\u0016\u0011\u0019\b\u0005\u0003s\u000by,\u0004\u0002\u0002<*\u0019\u0011Q\u0018\u001d\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0015bAAb\u007f\u00059\u0001/Y2lC\u001e,\u0017\u0002BAd\u0003\u0013\u0014A\u0001T5ti*\u0019\u00111Y \u0002\t\u0019LG\u000e\u001c\u000b\f[\u0006=\u00171[Am\u00037\fy\u000eC\u0004\u0002R\"\u0002\r!!\u000f\u0002\u0007\td7\u000eC\u0004\u0002V\"\u0002\r!a6\u0002\u0007\t,h\rE\u0003?\u0003k\ty\nC\u0003vQ\u0001\u0007a\u000f\u0003\u0004\u0002^\"\u0002\rA^\u0001\u0004K:$\u0007BBAqQ\u0001\u000710\u0001\u0003bO\u001e\u0014\u0018!\u00032m_\u000e\\G*[:u+\t\t9\u000f\u0005\u0004\u00026\u0006\u0015\u0017\u0011H\u0001\u0006M\u0016$8\r\u001b\u000b\t\u0003/\fi/a<\u0002r\")QO\u000ba\u0001m\"1\u0011Q\u001c\u0016A\u0002YDa!!9+\u0001\u0004Y\u0018aA4fiR!\u0011q_A\u007f!\u0015q\u0014\u0011`A\u001d\u0013\r\tYp\u0010\u0002\u0007\u001fB$\u0018n\u001c8\t\u000bU\\\u0003\u0019\u0001<\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"Aa\u0001\u0011\t\t\u0015!Q\u0002\b\u0005\u0005\u000f\u0011I\u0001E\u0002\u0002:~J1Aa\u0003@\u0003\u0019\u0001&/\u001a3fM&!!q\u0002B\t\u0005\u0019\u0019FO]5oO*\u0019!1B ")
public class MemoryBlockStore
implements BlockStore {
    private final long step;
    private final int blockSize;
    private final int numBlocks;
    private final long blockStep;
    private final Block[] blocks;
    private int currentPos;
    private MutableBlock currentBlock;
    private boolean hasData;

    public static RollupBlock newRollupBlock(long l, int n) {
        return MemoryBlockStore$.MODULE$.newRollupBlock(l, n);
    }

    public static void freeRollupBlock(RollupBlock rollupBlock) {
        MemoryBlockStore$.MODULE$.freeRollupBlock(rollupBlock);
    }

    public static ArrayBlock newArrayBlock(long l, int n) {
        return MemoryBlockStore$.MODULE$.newArrayBlock(l, n);
    }

    public static void freeArrayBlock(ArrayBlock arrayBlock) {
        MemoryBlockStore$.MODULE$.freeArrayBlock(arrayBlock);
    }

    @Override
    public boolean update$default$3() {
        return BlockStore.update$default$3$(this);
    }

    private long blockStep() {
        return this.blockStep;
    }

    public Block[] blocks() {
        return this.blocks;
    }

    public int currentPos() {
        return this.currentPos;
    }

    public void currentPos_$eq(int x$1) {
        this.currentPos = x$1;
    }

    public MutableBlock currentBlock() {
        return this.currentBlock;
    }

    public void currentBlock_$eq(MutableBlock x$1) {
        this.currentBlock = x$1;
    }

    private int next(int pos) {
        return (pos + 1) % this.numBlocks;
    }

    private long alignStart(long start) {
        return start - start % this.blockStep();
    }

    private void newBlock(long start, boolean rollup) {
        MutableBlock mutableBlock;
        Block block;
        Predef$.MODULE$.require(start % this.blockStep() == 0L, (Function0 & Serializable)() -> new StringBuilder(36).append("start time ").append(start).append(" is not on block boundary").toString());
        MutableBlock mutableBlock2 = this.currentBlock();
        if (mutableBlock2 instanceof ArrayBlock) {
            ArrayBlock arrayBlock = (ArrayBlock)mutableBlock2;
            block = Block$.MODULE$.compress(arrayBlock);
        } else if (mutableBlock2 instanceof RollupBlock) {
            RollupBlock rollupBlock = (RollupBlock)mutableBlock2;
            block = rollupBlock.compress();
        } else {
            throw new MatchError((Object)mutableBlock2);
        }
        Block oldBlock = block;
        if (oldBlock == this.currentBlock()) {
            mutableBlock = rollup ? MemoryBlockStore$.MODULE$.newRollupBlock(start, this.blockSize) : MemoryBlockStore$.MODULE$.newArrayBlock(start, this.blockSize);
        } else {
            MemoryBlockStore$.MODULE$.com$netflix$atlas$core$db$MemoryBlockStore$$reused().increment();
            this.currentBlock().reset(start);
            mutableBlock = this.currentBlock();
        }
        MutableBlock newBlock = mutableBlock;
        BlockStats$.MODULE$.update(this.currentBlock(), oldBlock);
        BlockStats$.MODULE$.inc(newBlock);
        this.blocks()[this.currentPos()] = oldBlock;
        this.currentBlock_$eq(newBlock);
        this.currentPos_$eq(this.next(this.currentPos()));
        if (this.blocks()[this.currentPos()] != null) {
            BlockStats$.MODULE$.dec(this.blocks()[this.currentPos()]);
        }
        this.blocks()[this.currentPos()] = this.currentBlock();
        this.hasData_$eq(true);
    }

    @Override
    public boolean hasData() {
        return this.hasData;
    }

    public void hasData_$eq(boolean x$1) {
        this.hasData = x$1;
    }

    @Override
    public void cleanup(long cutoff) {
        boolean nonEmpty = false;
        for (int pos = 0; pos < this.numBlocks; ++pos) {
            Block block = this.blocks()[pos];
            if (block != null && block.start() < cutoff) {
                BoxedUnit boxedUnit;
                Block block2;
                this.blocks()[pos] = null;
                BlockStats$.MODULE$.dec(block);
                if (block == this.currentBlock()) {
                    this.currentBlock_$eq(null);
                }
                if ((block2 = block) instanceof ArrayBlock) {
                    ArrayBlock arrayBlock = (ArrayBlock)block2;
                    MemoryBlockStore$.MODULE$.freeArrayBlock(arrayBlock);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (block2 instanceof RollupBlock) {
                    RollupBlock rollupBlock = (RollupBlock)block2;
                    MemoryBlockStore$.MODULE$.freeRollupBlock(rollupBlock);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            nonEmpty = nonEmpty || block != null;
        }
        this.hasData_$eq(nonEmpty);
    }

    @Override
    public void update(long timestamp, double value, boolean rollup) {
        int pos;
        if (this.currentBlock() == null) {
            this.currentBlock_$eq(rollup ? MemoryBlockStore$.MODULE$.newRollupBlock(this.alignStart(timestamp), this.blockSize) : MemoryBlockStore$.MODULE$.newArrayBlock(this.alignStart(timestamp), this.blockSize));
            this.currentPos_$eq(this.next(this.currentPos()));
            this.blocks()[this.currentPos()] = this.currentBlock();
            BlockStats$.MODULE$.inc(this.currentBlock());
            this.hasData_$eq(true);
        }
        Predef$.MODULE$.require((pos = (int)((timestamp - this.currentBlock().start()) / this.step)) >= 0, (Function0 & Serializable)() -> "data is too old");
        if (pos >= this.blockSize) {
            this.newBlock(this.alignStart(timestamp), rollup);
            pos = (int)((timestamp - this.currentBlock().start()) / this.step);
        }
        this.currentBlock().update(pos, value);
    }

    @Override
    public void update(long timestamp) {
        block5: {
            Block block;
            if (this.currentBlock() == null || this.currentBlock().start() != timestamp) break block5;
            MutableBlock mutableBlock = this.currentBlock();
            if (mutableBlock instanceof ArrayBlock) {
                ArrayBlock arrayBlock = (ArrayBlock)mutableBlock;
                block = Block$.MODULE$.compress(arrayBlock);
            } else if (mutableBlock instanceof RollupBlock) {
                RollupBlock rollupBlock = (RollupBlock)mutableBlock;
                block = rollupBlock.compress();
            } else {
                throw new MatchError((Object)mutableBlock);
            }
            Block oldBlock = block;
            BlockStats$.MODULE$.update(this.currentBlock(), oldBlock);
            this.blocks()[this.currentPos()] = oldBlock;
            this.currentBlock_$eq(null);
            this.currentPos_$eq(this.next(this.currentPos()));
            if (this.blocks()[this.currentPos()] != null) {
                BlockStats$.MODULE$.dec(this.blocks()[this.currentPos()]);
            }
            this.blocks()[this.currentPos()] = this.currentBlock();
        }
    }

    public void update(long start, List<Object> values) {
        LongRef t = LongRef.create((long)start);
        values.foreach((Function1)(JFunction1.mcVD.sp & Serializable)v -> {
            this.update(t$1.elem, v, this.update$default$3());
            t$1.elem += $this.step;
        });
    }

    private void fill(Block blk, double[] buf, long start, long end, int aggr) {
        long s = start / this.step;
        long e = end / this.step;
        long bs = blk.start();
        long be = bs + (long)this.blockSize - 1L;
        if (e >= bs && s <= be) {
            long spos = s > bs ? s : bs;
            long epos = e < be ? e : be;
            for (long i = spos; i <= epos; ++i) {
                buf[(int)(i - s)] = blk.get((int)(i - bs));
            }
        }
    }

    @Override
    public List<Block> blockList() {
        Builder bs = List$.MODULE$.newBuilder();
        for (int pos = 0; pos < this.numBlocks; ++pos) {
            Block b = this.blocks()[pos];
            Object object = b != null ? bs.$plus$eq((Object)b) : BoxedUnit.UNIT;
        }
        return (List)bs.result();
    }

    @Override
    public double[] fetch(long start, long end, int aggr) {
        int size = (int)(end / this.step - start / this.step) + 1;
        double[] buffer = ArrayHelper$.MODULE$.fill(size, Double.NaN);
        for (int pos = 0; pos < this.numBlocks; ++pos) {
            if (this.blocks()[pos] == null) continue;
            this.fill(this.blocks()[pos], buffer, start, end, aggr);
        }
        return buffer;
    }

    @Override
    public Option<Block> get(long start) {
        Block block = null;
        for (int pos = 0; block == null && pos < this.numBlocks; ++pos) {
            Block b = this.blocks()[pos];
            if (b == null || b.start() != start) continue;
            block = b;
        }
        return Option$.MODULE$.apply(block);
    }

    public String toString() {
        scala.collection.mutable.StringBuilder buf = new scala.collection.mutable.StringBuilder();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numBlocks).foreach((Function1 & Serializable)i -> MemoryBlockStore.$anonfun$toString$1(this, buf, BoxesRunTime.unboxToInt((Object)i)));
        return buf.toString();
    }

    public static final /* synthetic */ scala.collection.mutable.StringBuilder $anonfun$toString$1(MemoryBlockStore $this, scala.collection.mutable.StringBuilder buf$1, int i) {
        buf$1.append(((Object)BoxesRunTime.boxToInteger((int)i)).toString()).append(" => ").append((Object)$this.blocks()[i]);
        Object object = i == $this.currentPos() ? buf$1.append(" (current)") : BoxedUnit.UNIT;
        return buf$1.append("\n");
    }

    public MemoryBlockStore(long step, int blockSize, int numBlocks) {
        this.step = step;
        this.blockSize = blockSize;
        this.numBlocks = numBlocks;
        this.blockStep = step * (long)blockSize;
        this.blocks = new Block[numBlocks];
        this.currentPos = 0;
        this.hasData = false;
    }
}

