/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.algorithm;

import com.netflix.atlas.core.algorithm.AlgoState;
import com.netflix.atlas.core.algorithm.AlgoState$;
import com.netflix.atlas.core.algorithm.RollingBuffer$;
import com.netflix.atlas.core.util.Math$;
import java.io.Serializable;
import java.util.Arrays;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001da\u0001B\r\u001b\u0001\u0015B\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!\f\u0005\ti\u0001\u0011\t\u0011)A\u0005]!AQ\u0007\u0001B\u0001B\u0003%a\u0007C\u0003:\u0001\u0011\u0005!\b\u0003\u0004@\u0001\u0001\u0006KA\u000e\u0005\b\u0001\u0002\u0001\r\u0011\"\u0001B\u0011\u001d\u0011\u0005\u00011A\u0005\u0002\rCa!\u0013\u0001!B\u00131\u0004\"\u0002&\u0001\t\u0013Y\u0005\"\u0002'\u0001\t\u0003i\u0005\"\u0002)\u0001\t\u0003\t\u0006\"\u0002*\u0001\t\u0003\t\u0006\"B*\u0001\t\u0003\t\u0006\"\u0002+\u0001\t\u0003\t\u0006\"B+\u0001\t\u0003Y\u0005\"\u0002,\u0001\t\u00039\u0006\"B.\u0001\t\u0003a\u0006\"\u00021\u0001\t\u0003\nw!B7\u001b\u0011\u0003qg!B\r\u001b\u0011\u0003y\u0007\"B\u001d\u0015\t\u0003\u0001\b\"B9\u0015\t\u0003\u0011\b\"B9\u0015\t\u0003)\bbB<\u0015#\u0003%\t\u0001\u001f\u0002\u000e%>dG.\u001b8h\u0005V4g-\u001a:\u000b\u0005ma\u0012!C1mO>\u0014\u0018\u000e\u001e5n\u0015\tib$\u0001\u0003d_J,'BA\u0010!\u0003\u0015\tG\u000f\\1t\u0015\t\t#%A\u0004oKR4G.\u001b=\u000b\u0003\r\n1aY8n\u0007\u0001\u0019\"\u0001\u0001\u0014\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\r\u0005s\u0017PU3g\u0003\u00191\u0018\r\\;fgV\ta\u0006E\u0002(_EJ!\u0001\r\u0015\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u001d\u0012\u0014BA\u001a)\u0005\u0019!u.\u001e2mK\u00069a/\u00197vKN\u0004\u0013!B:uCJ$\bCA\u00148\u0013\tA\u0004FA\u0002J]R\fa\u0001P5oSRtDcA\u001e>}A\u0011A\bA\u0007\u00025!)A\u0006\u0002a\u0001]!9Q\u0007\u0002I\u0001\u0002\u00041\u0014a\u00019pg\u0006!1/\u001b>f+\u00051\u0014\u0001C:ju\u0016|F%Z9\u0015\u0005\u0011;\u0005CA\u0014F\u0013\t1\u0005F\u0001\u0003V]&$\bb\u0002%\b\u0003\u0003\u0005\rAN\u0001\u0004q\u0012\n\u0014!B:ju\u0016\u0004\u0013\u0001\u00028fqR$\u0012\u0001R\u0001\u0004C\u0012$GCA\u0019O\u0011\u0015y%\u00021\u00012\u0003\u00051\u0018!B2pk:$X#A\u0019\u0002\u0007M,X.A\u0002nS:\f1!\\1y\u0003\u0015\u0019G.Z1s\u0003\u001dI7/R7qif,\u0012\u0001\u0017\t\u0003OeK!A\u0017\u0015\u0003\u000f\t{w\u000e\\3b]\u0006)1\u000f^1uKV\tQ\f\u0005\u0002==&\u0011qL\u0007\u0002\n\u00032<wn\u0015;bi\u0016\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002EB\u00111M\u001b\b\u0003I\"\u0004\"!\u001a\u0015\u000e\u0003\u0019T!a\u001a\u0013\u0002\rq\u0012xn\u001c;?\u0013\tI\u0007&\u0001\u0004Qe\u0016$WMZ\u0005\u0003W2\u0014aa\u0015;sS:<'BA5)\u00035\u0011v\u000e\u001c7j]\u001e\u0014UO\u001a4feB\u0011A\bF\n\u0003)\u0019\"\u0012A\\\u0001\u0006CB\u0004H.\u001f\u000b\u0003wMDQ\u0001\u001e\fA\u0002Y\n\u0011A\u001c\u000b\u0003wYDQaW\fA\u0002u\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012T#A=+\u0005YR8&A>\u0011\u0007q\f\u0019!D\u0001~\u0015\tqx0A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0001\u0015\u0002\u0015\u0005tgn\u001c;bi&|g.C\u0002\u0002\u0006u\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class RollingBuffer {
    private final double[] values;
    private final int start;
    private int pos;
    private int size;

    public static int $lessinit$greater$default$2() {
        return RollingBuffer$.MODULE$.$lessinit$greater$default$2();
    }

    public static RollingBuffer apply(AlgoState algoState) {
        return RollingBuffer$.MODULE$.apply(algoState);
    }

    public static RollingBuffer apply(int n) {
        return RollingBuffer$.MODULE$.apply(n);
    }

    public double[] values() {
        return this.values;
    }

    public int size() {
        return this.size;
    }

    public void size_$eq(int x$1) {
        this.size = x$1;
    }

    private void next() {
        this.pos = (this.pos + 1) % this.values().length;
    }

    /*
     * WARNING - void declaration
     */
    public double add(double v) {
        void var3_2;
        block1: {
            double previous = this.values()[this.pos];
            this.values()[this.pos] = v;
            this.next();
            if (!Predef$.MODULE$.double2Double(v).isNaN()) {
                this.size_$eq(this.size() + 1);
            }
            if (Predef$.MODULE$.double2Double(previous).isNaN()) break block1;
            this.size_$eq(this.size() - 1);
        }
        return (double)var3_2;
    }

    /*
     * WARNING - void declaration
     */
    public double count() {
        void var1_1;
        double result = 0.0;
        for (int i = 0; i < this.values().length; ++i) {
            result += Math$.MODULE$.toBooleanDouble(this.values()[i]);
        }
        return (double)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public double sum() {
        void var1_1;
        double result = Double.NaN;
        for (int i = 0; i < this.values().length; ++i) {
            result = Math$.MODULE$.addNaN(result, this.values()[i]);
        }
        return (double)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public double min() {
        void var1_1;
        double result = Double.NaN;
        for (int i = 0; i < this.values().length; ++i) {
            result = Math$.MODULE$.minNaN(result, this.values()[i]);
        }
        return (double)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public double max() {
        void var1_1;
        double result = Double.NaN;
        for (int i = 0; i < this.values().length; ++i) {
            result = Math$.MODULE$.maxNaN(result, this.values()[i]);
        }
        return (double)var1_1;
    }

    public void clear() {
        for (int i = 0; i < this.values().length; ++i) {
            this.values()[i] = Double.NaN;
        }
        this.pos = 0;
        this.size_$eq(0);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public AlgoState state() {
        double[] vs = Arrays.copyOf(this.values(), this.values().length);
        return AlgoState$.MODULE$.apply("rolling-buffer", (Seq<Tuple2<String, Object>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"values"), (Object)vs), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pos"), (Object)BoxesRunTime.boxToInteger((int)this.pos))}));
    }

    public String toString() {
        return new StringBuilder(31).append("RollingBuffer([").append(Predef$.MODULE$.wrapDoubleArray(this.values()).mkString(",")).append("], start=").append(this.start).append(", pos=").append(this.pos).append(")").toString();
    }

    public RollingBuffer(double[] values, int start) {
        this.values = values;
        this.start = start;
        Predef$.MODULE$.require(values.length > 0, (Function0 & Serializable)() -> "values array cannot be empty");
        Predef$.MODULE$.require(start >= 0, (Function0 & Serializable)() -> new StringBuilder(40).append("starting position is out of bounds: ").append($this.start).append(" < 0").toString());
        Predef$.MODULE$.require(start < values.length, (Function0 & Serializable)() -> new StringBuilder(40).append("starting position is out of bounds: ").append($this.start).append(" >= ").append(this.values().length).toString());
        this.pos = start;
        this.size = ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.doubleArrayOps(values), (Function1)(JFunction1.mcZD.sp & Serializable)x$1 -> !Predef$.MODULE$.double2Double(x$1).isNaN());
    }
}

