/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.algorithm;

import com.netflix.atlas.core.algorithm.AlgoState;
import com.netflix.atlas.core.algorithm.AlgoState$;
import com.netflix.atlas.core.algorithm.OnlineAlgorithm;
import com.netflix.atlas.core.algorithm.OnlineRollingSum$;
import com.netflix.atlas.core.algorithm.RollingBuffer;
import com.netflix.atlas.core.util.Math$;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005ed\u0001B\u000f\u001f\u0001&B\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t\u0011\u0002\u0011\t\u0012)A\u0005\u000b\")\u0011\n\u0001C\u0001\u0015\"1Q\n\u0001Q!\n9Ca!\u0015\u0001!B\u0013\u0011\u0006\"B+\u0001\t\u00032\u0006\"B-\u0001\t\u0003R\u0006\"\u00020\u0001\t\u0003z\u0006\"B2\u0001\t\u0003\"\u0007b\u00025\u0001\u0003\u0003%\t!\u001b\u0005\bW\u0002\t\n\u0011\"\u0001m\u0011\u001d9\b!!A\u0005BaD\u0011\"a\u0001\u0001\u0003\u0003%\t!!\u0002\t\u0013\u0005\u001d\u0001!!A\u0005\u0002\u0005%\u0001\"CA\u000b\u0001\u0005\u0005I\u0011IA\f\u0011%\t)\u0003AA\u0001\n\u0003\t9\u0003C\u0005\u0002,\u0001\t\t\u0011\"\u0011\u0002.!I\u0011\u0011\u0007\u0001\u0002\u0002\u0013\u0005\u00131\u0007\u0005\n\u0003k\u0001\u0011\u0011!C!\u0003oA\u0011\"!\u000f\u0001\u0003\u0003%\t%a\u000f\b\u000f\u0005}b\u0004#\u0001\u0002B\u00191QD\bE\u0001\u0003\u0007Ba!\u0013\f\u0005\u0002\u0005=\u0003bBA)-\u0011\u0005\u00111\u000b\u0005\b\u0003#2B\u0011AA-\u0011%\t\tFFA\u0001\n\u0003\u000bi\u0006C\u0005\u0002bY\t\t\u0011\"!\u0002d!I\u0011q\u000e\f\u0002\u0002\u0013%\u0011\u0011\u000f\u0002\u0011\u001f:d\u0017N\\3S_2d\u0017N\\4Tk6T!a\b\u0011\u0002\u0013\u0005dwm\u001c:ji\"l'BA\u0011#\u0003\u0011\u0019wN]3\u000b\u0005\r\"\u0013!B1uY\u0006\u001c(BA\u0013'\u0003\u001dqW\r\u001e4mSbT\u0011aJ\u0001\u0004G>l7\u0001A\n\u0006\u0001)\u0002Dg\u000e\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005E\u0012T\"\u0001\u0010\n\u0005Mr\"aD(oY&tW-\u00117h_JLG\u000f[7\u0011\u0005-*\u0014B\u0001\u001c-\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u000f!\u000f\u0005erdB\u0001\u001e>\u001b\u0005Y$B\u0001\u001f)\u0003\u0019a$o\\8u}%\tQ&\u0003\u0002@Y\u00059\u0001/Y2lC\u001e,\u0017BA!C\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tyD&A\u0002ck\u001a,\u0012!\u0012\t\u0003c\u0019K!a\u0012\u0010\u0003\u001bI{G\u000e\\5oO\n+hMZ3s\u0003\u0011\u0011WO\u001a\u0011\u0002\rqJg.\u001b;?)\tYE\n\u0005\u00022\u0001!)1i\u0001a\u0001\u000b\u0006\u00191/^7\u0011\u0005-z\u0015B\u0001)-\u0005\u0019!u.\u001e2mK\u0006)1m\\;oiB\u00111fU\u0005\u0003)2\u00121!\u00138u\u0003\u0011qW\r\u001f;\u0015\u00059;\u0006\"\u0002-\u0007\u0001\u0004q\u0015!\u0001<\u0002\u000bI,7/\u001a;\u0015\u0003m\u0003\"a\u000b/\n\u0005uc#\u0001B+oSR\fq![:F[B$\u00180F\u0001a!\tY\u0013-\u0003\u0002cY\t9!i\\8mK\u0006t\u0017!B:uCR,W#A3\u0011\u0005E2\u0017BA4\u001f\u0005%\tEnZ8Ti\u0006$X-\u0001\u0003d_BLHCA&k\u0011\u001d\u0019%\u0002%AA\u0002\u0015\u000babY8qs\u0012\"WMZ1vYR$\u0013'F\u0001nU\t)enK\u0001p!\t\u0001X/D\u0001r\u0015\t\u00118/A\u0005v]\u000eDWmY6fI*\u0011A\u000fL\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001<r\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0003e\u0004\"A_@\u000e\u0003mT!\u0001`?\u0002\t1\fgn\u001a\u0006\u0002}\u0006!!.\u0019<b\u0013\r\t\ta\u001f\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0003I\u000ba\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\f\u0005E\u0001cA\u0016\u0002\u000e%\u0019\u0011q\u0002\u0017\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002\u00149\t\t\u00111\u0001S\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u0004\t\u0007\u00037\t\t#a\u0003\u000e\u0005\u0005u!bAA\u0010Y\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\r\u0012Q\u0004\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002a\u0003SA\u0011\"a\u0005\u0011\u0003\u0003\u0005\r!a\u0003\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0004s\u0006=\u0002\u0002CA\n#\u0005\u0005\t\u0019\u0001*\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012AU\u0001\ti>\u001cFO]5oOR\t\u00110\u0001\u0004fcV\fGn\u001d\u000b\u0004A\u0006u\u0002\"CA\n)\u0005\u0005\t\u0019AA\u0006\u0003Aye\u000e\\5oKJ{G\u000e\\5oON+X\u000e\u0005\u00022-M!aCKA#!\u0011\t9%!\u0014\u000e\u0005\u0005%#bAA&{\u0006\u0011\u0011n\\\u0005\u0004\u0003\u0006%CCAA!\u0003\u0015\t\u0007\u000f\u001d7z)\rY\u0015Q\u000b\u0005\u0007\u0003/B\u0002\u0019\u0001*\u0002\u00039$2aSA.\u0011\u0015\u0019\u0017\u00041\u0001f)\rY\u0015q\f\u0005\u0006\u0007j\u0001\r!R\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t)'a\u001b\u0011\t-\n9'R\u0005\u0004\u0003Sb#AB(qi&|g\u000e\u0003\u0005\u0002nm\t\t\u00111\u0001L\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003g\u00022A_A;\u0013\r\t9h\u001f\u0002\u0007\u001f\nTWm\u0019;")
public class OnlineRollingSum
implements OnlineAlgorithm,
Product,
Serializable {
    private final RollingBuffer buf;
    private double sum;
    private int count;

    public static Option<RollingBuffer> unapply(OnlineRollingSum onlineRollingSum) {
        return OnlineRollingSum$.MODULE$.unapply(onlineRollingSum);
    }

    public static OnlineRollingSum apply(RollingBuffer rollingBuffer) {
        return OnlineRollingSum$.MODULE$.apply(rollingBuffer);
    }

    public static OnlineRollingSum apply(AlgoState algoState) {
        return OnlineRollingSum$.MODULE$.apply(algoState);
    }

    public static OnlineRollingSum apply(int n) {
        return OnlineRollingSum$.MODULE$.apply(n);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public RollingBuffer buf() {
        return this.buf;
    }

    @Override
    public double next(double v) {
        double removed = this.buf().add(v);
        if (!Double.isNaN(removed)) {
            this.sum -= removed;
            --this.count;
        }
        if (!Double.isNaN(v)) {
            this.sum += v;
            ++this.count;
        }
        return this.count > 0 ? this.sum : Double.NaN;
    }

    @Override
    public void reset() {
        this.buf().clear();
        this.sum = 0.0;
        this.count = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.buf().isEmpty();
    }

    @Override
    public AlgoState state() {
        return AlgoState$.MODULE$.apply("rolling-sum", (Seq<Tuple2<String, Object>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"buffer"), (Object)this.buf().state())}));
    }

    public OnlineRollingSum copy(RollingBuffer buf) {
        return new OnlineRollingSum(buf);
    }

    public RollingBuffer copy$default$1() {
        return this.buf();
    }

    public String productPrefix() {
        return "OnlineRollingSum";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.buf();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof OnlineRollingSum;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "buf";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof OnlineRollingSum)) return false;
        boolean bl = true;
        if (!bl) return false;
        OnlineRollingSum onlineRollingSum = (OnlineRollingSum)x$1;
        RollingBuffer rollingBuffer = this.buf();
        RollingBuffer rollingBuffer2 = onlineRollingSum.buf();
        if (rollingBuffer == null) {
            if (rollingBuffer2 != null) {
                return false;
            }
        } else if (!rollingBuffer.equals(rollingBuffer2)) return false;
        if (!onlineRollingSum.canEqual(this)) return false;
        return true;
    }

    public OnlineRollingSum(RollingBuffer buf) {
        this.buf = buf;
        Product.$init$((Product)this);
        this.sum = Math$.MODULE$.addNaN(0.0, buf.sum());
        this.count = ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.doubleArrayOps(buf.values()), (Function1)(JFunction1.mcZD.sp & Serializable)v -> !Double.isNaN(v));
    }
}

