/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.algorithm;

import com.netflix.atlas.core.algorithm.AlgoState;
import com.netflix.atlas.core.algorithm.AlgoState$;
import com.netflix.atlas.core.algorithm.OnlineAlgorithm;
import com.netflix.atlas.core.algorithm.OnlineRollingMean$;
import com.netflix.atlas.core.algorithm.RollingBuffer;
import com.netflix.atlas.core.util.Math$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005]e\u0001\u0002\u0011\"\u00012B\u0001B\u0012\u0001\u0003\u0016\u0004%\ta\u0012\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005\u0011\"AA\n\u0001BK\u0002\u0013\u0005Q\n\u0003\u0005R\u0001\tE\t\u0015!\u0003O\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u00199\u0006\u0001)Q\u00051\"11\f\u0001Q!\n9CQ\u0001\u0018\u0001\u0005BuCQ\u0001\u0019\u0001\u0005B\u0005DQ!\u001a\u0001\u0005B\u0019DQA\u001b\u0001\u0005B-Dqa\u001c\u0001\u0002\u0002\u0013\u0005\u0001\u000fC\u0004t\u0001E\u0005I\u0011\u0001;\t\u0011}\u0004\u0011\u0013!C\u0001\u0003\u0003A\u0011\"!\u0002\u0001\u0003\u0003%\t%a\u0002\t\u0011\u0005e\u0001!!A\u0005\u00025C\u0011\"a\u0007\u0001\u0003\u0003%\t!!\b\t\u0013\u0005%\u0002!!A\u0005B\u0005-\u0002\"CA\u001d\u0001\u0005\u0005I\u0011AA\u001e\u0011%\ty\u0004AA\u0001\n\u0003\n\t\u0005C\u0005\u0002F\u0001\t\t\u0011\"\u0011\u0002H!I\u0011\u0011\n\u0001\u0002\u0002\u0013\u0005\u00131\n\u0005\n\u0003\u001b\u0002\u0011\u0011!C!\u0003\u001f:q!a\u0015\"\u0011\u0003\t)F\u0002\u0004!C!\u0005\u0011q\u000b\u0005\u0007%f!\t!a\u0019\t\u000f\u0005\u0015\u0014\u0004\"\u0001\u0002h!9\u0011QM\r\u0005\u0002\u0005=\u0004\"CA33\u0005\u0005I\u0011QA:\u0011%\tI(GA\u0001\n\u0003\u000bY\bC\u0005\u0002\u000ef\t\t\u0011\"\u0003\u0002\u0010\n\trJ\u001c7j]\u0016\u0014v\u000e\u001c7j]\u001elU-\u00198\u000b\u0005\t\u001a\u0013!C1mO>\u0014\u0018\u000e\u001e5n\u0015\t!S%\u0001\u0003d_J,'B\u0001\u0014(\u0003\u0015\tG\u000f\\1t\u0015\tA\u0013&A\u0004oKR4G.\u001b=\u000b\u0003)\n1aY8n\u0007\u0001\u0019R\u0001A\u00174oi\u0002\"AL\u0019\u000e\u0003=R\u0011\u0001M\u0001\u0006g\u000e\fG.Y\u0005\u0003e=\u0012a!\u00118z%\u00164\u0007C\u0001\u001b6\u001b\u0005\t\u0013B\u0001\u001c\"\u0005=ye\u000e\\5oK\u0006cwm\u001c:ji\"l\u0007C\u0001\u00189\u0013\tItFA\u0004Qe>$Wo\u0019;\u0011\u0005m\u001aeB\u0001\u001fB\u001d\ti\u0004)D\u0001?\u0015\ty4&\u0001\u0004=e>|GOP\u0005\u0002a%\u0011!iL\u0001\ba\u0006\u001c7.Y4f\u0013\t!UI\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002C_\u0005\u0019!-\u001e4\u0016\u0003!\u0003\"\u0001N%\n\u0005)\u000b#!\u0004*pY2Lgn\u001a\"vM\u001a,'/\u0001\u0003ck\u001a\u0004\u0013\u0001D7j]:+XNV1mk\u0016\u001cX#\u0001(\u0011\u00059z\u0015B\u0001)0\u0005\rIe\u000e^\u0001\u000e[&tg*^7WC2,Xm\u001d\u0011\u0002\rqJg.\u001b;?)\r!VK\u0016\t\u0003i\u0001AQAR\u0003A\u0002!CQ\u0001T\u0003A\u00029\u000b1a];n!\tq\u0013,\u0003\u0002[_\t1Ai\\;cY\u0016\fQaY8v]R\fAA\\3yiR\u0011\u0001L\u0018\u0005\u0006?\"\u0001\r\u0001W\u0001\u0002m\u0006)!/Z:fiR\t!\r\u0005\u0002/G&\u0011Am\f\u0002\u0005+:LG/A\u0004jg\u0016k\u0007\u000f^=\u0016\u0003\u001d\u0004\"A\f5\n\u0005%|#a\u0002\"p_2,\u0017M\\\u0001\u0006gR\fG/Z\u000b\u0002YB\u0011A'\\\u0005\u0003]\u0006\u0012\u0011\"\u00117h_N#\u0018\r^3\u0002\t\r|\u0007/\u001f\u000b\u0004)F\u0014\bb\u0002$\r!\u0003\u0005\r\u0001\u0013\u0005\b\u00192\u0001\n\u00111\u0001O\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012!\u001e\u0016\u0003\u0011Z\\\u0013a\u001e\t\u0003qvl\u0011!\u001f\u0006\u0003un\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005q|\u0013AC1o]>$\u0018\r^5p]&\u0011a0\u001f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003\u0007Q#A\u0014<\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\u0001\u0005\u0003\u0002\f\u0005UQBAA\u0007\u0015\u0011\ty!!\u0005\u0002\t1\fgn\u001a\u0006\u0003\u0003'\tAA[1wC&!\u0011qCA\u0007\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0010\u0003K\u00012ALA\u0011\u0013\r\t\u0019c\f\u0002\u0004\u0003:L\b\u0002CA\u0014#\u0005\u0005\t\u0019\u0001(\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\u0003\u0005\u0004\u00020\u0005U\u0012qD\u0007\u0003\u0003cQ1!a\r0\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003o\t\tD\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA4\u0002>!I\u0011qE\n\u0002\u0002\u0003\u0007\u0011qD\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\n\u0005\r\u0003\u0002CA\u0014)\u0005\u0005\t\u0019\u0001(\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012AT\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011B\u0001\u0007KF,\u0018\r\\:\u0015\u0007\u001d\f\t\u0006C\u0005\u0002(]\t\t\u00111\u0001\u0002 \u0005\trJ\u001c7j]\u0016\u0014v\u000e\u001c7j]\u001elU-\u00198\u0011\u0005QJ2\u0003B\r.\u00033\u0002B!a\u0017\u0002b5\u0011\u0011Q\f\u0006\u0005\u0003?\n\t\"\u0001\u0002j_&\u0019A)!\u0018\u0015\u0005\u0005U\u0013!B1qa2LH#\u0002+\u0002j\u00055\u0004BBA67\u0001\u0007a*A\u0001o\u0011\u0015a5\u00041\u0001O)\r!\u0016\u0011\u000f\u0005\u0006Ur\u0001\r\u0001\u001c\u000b\u0006)\u0006U\u0014q\u000f\u0005\u0006\rv\u0001\r\u0001\u0013\u0005\u0006\u0019v\u0001\rAT\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ti(!#\u0011\u000b9\ny(a!\n\u0007\u0005\u0005uF\u0001\u0004PaRLwN\u001c\t\u0006]\u0005\u0015\u0005JT\u0005\u0004\u0003\u000f{#A\u0002+va2,'\u0007\u0003\u0005\u0002\fz\t\t\u00111\u0001U\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003#\u0003B!a\u0003\u0002\u0014&!\u0011QSA\u0007\u0005\u0019y%M[3di\u0002")
public class OnlineRollingMean
implements OnlineAlgorithm,
Product,
Serializable {
    private final RollingBuffer buf;
    private final int minNumValues;
    private double sum;
    private int count;

    public static Option<Tuple2<RollingBuffer, Object>> unapply(OnlineRollingMean onlineRollingMean) {
        return OnlineRollingMean$.MODULE$.unapply(onlineRollingMean);
    }

    public static OnlineRollingMean apply(RollingBuffer rollingBuffer, int n) {
        return OnlineRollingMean$.MODULE$.apply(rollingBuffer, n);
    }

    public static OnlineRollingMean apply(AlgoState algoState) {
        return OnlineRollingMean$.MODULE$.apply(algoState);
    }

    public static OnlineRollingMean apply(int n, int n2) {
        return OnlineRollingMean$.MODULE$.apply(n, n2);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public RollingBuffer buf() {
        return this.buf;
    }

    public int minNumValues() {
        return this.minNumValues;
    }

    @Override
    public double next(double v) {
        double removed = this.buf().add(v);
        if (!Double.isNaN(removed)) {
            this.sum -= removed;
            --this.count;
        }
        if (!Double.isNaN(v)) {
            this.sum += v;
            ++this.count;
        }
        return this.count >= this.minNumValues() ? this.sum / (double)this.count : Double.NaN;
    }

    @Override
    public void reset() {
        this.buf().clear();
        this.sum = 0.0;
        this.count = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.buf().isEmpty();
    }

    @Override
    public AlgoState state() {
        return AlgoState$.MODULE$.apply("rolling-mean", (Seq<Tuple2<String, Object>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"buffer"), (Object)this.buf().state()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"minNumValues"), (Object)BoxesRunTime.boxToInteger((int)this.minNumValues()))}));
    }

    public OnlineRollingMean copy(RollingBuffer buf, int minNumValues) {
        return new OnlineRollingMean(buf, minNumValues);
    }

    public RollingBuffer copy$default$1() {
        return this.buf();
    }

    public int copy$default$2() {
        return this.minNumValues();
    }

    public String productPrefix() {
        return "OnlineRollingMean";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.buf();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this.minNumValues());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof OnlineRollingMean;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "buf";
                break;
            }
            case 1: {
                string = "minNumValues";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.buf()));
        n = Statics.mix((int)n, (int)this.minNumValues());
        return Statics.finalizeHash((int)n, (int)2);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof OnlineRollingMean)) return false;
        boolean bl = true;
        if (!bl) return false;
        OnlineRollingMean onlineRollingMean = (OnlineRollingMean)x$1;
        if (this.minNumValues() != onlineRollingMean.minNumValues()) return false;
        RollingBuffer rollingBuffer = this.buf();
        RollingBuffer rollingBuffer2 = onlineRollingMean.buf();
        if (rollingBuffer == null) {
            if (rollingBuffer2 != null) {
                return false;
            }
        } else if (!rollingBuffer.equals(rollingBuffer2)) return false;
        if (!onlineRollingMean.canEqual(this)) return false;
        return true;
    }

    public OnlineRollingMean(RollingBuffer buf, int minNumValues) {
        this.buf = buf;
        this.minNumValues = minNumValues;
        Product.$init$((Product)this);
        Predef$.MODULE$.require(minNumValues > 0, (Function0 & Serializable)() -> "minimum number of values must be >= 1");
        Predef$.MODULE$.require(buf.values().length >= minNumValues, (Function0 & Serializable)() -> "minimum number of values must be <= window size");
        this.sum = Math$.MODULE$.addNaN(0.0, buf.sum());
        this.count = ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.doubleArrayOps(buf.values()), (Function1)(JFunction1.mcZD.sp & Serializable)v -> !Double.isNaN(v));
    }
}

